/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.parser;

import java.util.Hashtable;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.idl.util.tools;
import org.openorb.compiler.object.IdlArray;
import org.openorb.compiler.object.IdlAttribute;
import org.openorb.compiler.object.IdlConst;
import org.openorb.compiler.object.IdlContext;
import org.openorb.compiler.object.IdlEnum;
import org.openorb.compiler.object.IdlEnumMember;
import org.openorb.compiler.object.IdlExcept;
import org.openorb.compiler.object.IdlFactory;
import org.openorb.compiler.object.IdlFactoryMember;
import org.openorb.compiler.object.IdlFixed;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlImport;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlModule;
import org.openorb.compiler.object.IdlNative;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlSequence;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.object.IdlStateMember;
import org.openorb.compiler.object.IdlString;
import org.openorb.compiler.object.IdlStruct;
import org.openorb.compiler.object.IdlStructMember;
import org.openorb.compiler.object.IdlTypeDef;
import org.openorb.compiler.object.IdlUnion;
import org.openorb.compiler.object.IdlUnionMember;
import org.openorb.compiler.object.IdlValue;
import org.openorb.compiler.object.IdlValueBox;
import org.openorb.compiler.object.IdlValueInheritance;
import org.openorb.compiler.object.IdlWString;
import org.openorb.compiler.parser.BooleanContainer;
import org.openorb.compiler.parser.DoubleContainer;
import org.openorb.compiler.parser.IdlParser;
import org.openorb.compiler.parser.StringContainer;

public class IdlGrammar {
    public IdlParser parser = null;

    public IdlGrammar(IdlParser idlParser2) {
        this.parser = idlParser2;
    }

    public int hexaToDec(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public void convertToDecimal() {
        String string = this.parser.ctx.value.substring(this.parser.ctx.value.indexOf(120) + 1);
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            n *= 16;
            n += this.hexaToDec(string.charAt(n2));
            ++n2;
        }
        this.parser.ctx.value = new Integer(n).toString();
    }

    public String inversedPrefix(String string) {
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        String string2 = new String("");
        try {
            while (n != -1) {
                n = string.indexOf(46, n2);
                if (n == -1) continue;
                vector.addElement(new String(string.substring(n2, n)));
                n2 = n + 1;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        vector.addElement(new String(string.substring(n2, string.length())));
        int n3 = vector.size() - 1;
        while (n3 >= 0) {
            if (!string2.equals("")) {
                string2 = string2 + ".";
            }
            string2 = string2 + (String)vector.elementAt(n3);
            --n3;
        }
        return string2;
    }

    public String fullname(IdlObject idlObject2) {
        Vector<String> vector = new Vector<String>();
        IdlObject idlObject3 = idlObject2;
        String string = new String("");
        boolean bl = false;
        while (idlObject3 != null) {
            if (bl) {
                if (idlObject3.kind() == 15) {
                    if (idlObject2.kind() != 7) {
                        vector.addElement(idlObject3.name() + "Package");
                    } else {
                        vector.addElement(idlObject3.name());
                    }
                } else {
                    vector.addElement(idlObject3.name());
                }
            } else {
                vector.addElement(idlObject3.name());
            }
            if (idlObject3.upper() != null && idlObject3.upper().kind() == 0) break;
            idlObject3 = idlObject3.upper();
            bl = true;
        }
        if (!(IdlCompiler.packageName == null || IdlCompiler.packageName.equals("") || IdlCompiler.packageName.equals("generated") && !IdlCompiler.use_package)) {
            string = tools.adaptToDot(IdlCompiler.packageName);
        }
        if (idlObject2.getPrefix() != null && IdlCompiler.usePrefix) {
            if (!string.equals("")) {
                string = string + ".";
            }
            string = string + this.inversedPrefix(idlObject2.getPrefix());
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            String string2 = (String)vector.elementAt(n);
            if (string2 != null) {
                if (!string.equals("")) {
                    string = string + ".";
                }
                string = string + string2;
            }
            --n;
        }
        return string;
    }

    private String removePrefix(String string) {
        if (string.charAt(0) == '_') {
            return string.substring(1);
        }
        return string;
    }

    public String scoped_name() {
        String string = new String();
        boolean bl = false;
        while (!bl) {
            if (this.parser.ctx.symb == 56) {
                string = string + "::";
                this.parser.symbole();
            }
            if (this.parser.ctx.symb != 21) {
                this.parser.show_error("Bad identifier");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return string;
            }
            string = string + this.removePrefix(this.parser.ctx.value);
            this.parser.symbole();
            if (this.parser.ctx.symb == 56) continue;
            bl = true;
        }
        return string;
    }

    public long primary_exp(StringContainer stringContainer, IdlObject idlObject2, DoubleContainer doubleContainer) {
        long l = 0L;
        switch (this.parser.ctx.symb) {
            case 21: 
            case 56: {
                String string = this.scoped_name();
                if (!idlObject2.isVisible(string, false)) {
                    this.parser.show_error("Undefined identifier : " + string);
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                    break;
                }
                IdlObject idlObject3 = idlObject2.returnVisibleObject(string, false);
                if (idlObject3.kind() == 7) {
                    l = ((IdlConst)idlObject3).intValue();
                    doubleContainer.value = l;
                    stringContainer.value = stringContainer.value + this.fullname(idlObject3) + " ";
                    break;
                }
                if (idlObject3.kind() == 22) {
                    l = ((IdlEnumMember)idlObject3).getValue();
                    doubleContainer.value = l;
                    stringContainer.value = stringContainer.value + this.fullname(idlObject3) + "@ ";
                    break;
                }
                this.parser.show_error("This identifier " + string + " doesn't correspond to a constant");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
            case 8: {
                this.parser.symbole();
                stringContainer.value = stringContainer.value + "( ";
                l = this.const_exp(stringContainer, idlObject2, doubleContainer);
                if (this.parser.ctx.symb != 9) {
                    this.parser.show_error("')' expected");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                }
                stringContainer.value = stringContainer.value + ") ";
                this.parser.symbole();
                break;
            }
            case 63: {
                stringContainer.value = stringContainer.value + "\"" + this.parser.ctx.value + "\" ";
                this.parser.symbole();
                break;
            }
            case 64: {
                stringContainer.value = stringContainer.value + "'" + this.parser.ctx.value + "' ";
                this.parser.symbole();
                break;
            }
            case 61: {
                stringContainer.value = stringContainer.value + this.parser.ctx.value;
                if (this.parser.ctx.base == 1) {
                    this.convertToDecimal();
                }
                Long l2 = new Long(this.parser.ctx.value);
                l = l2;
                doubleContainer.value = l;
                this.parser.symbole();
                break;
            }
            case 62: {
                stringContainer.value = stringContainer.value + this.parser.ctx.value + " ";
                Double d = new Double(this.parser.ctx.value);
                doubleContainer.value = d;
                this.parser.symbole();
                break;
            }
            case 51: {
                stringContainer.value = stringContainer.value + "true ";
                l = 1L;
                this.parser.symbole();
                break;
            }
            case 33: {
                stringContainer.value = stringContainer.value + "false ";
                this.parser.symbole();
                l = 0L;
                break;
            }
            default: {
                this.parser.show_error("Incorrect expression");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
        }
        return l;
    }

    public long unary_exp(StringContainer stringContainer, IdlObject idlObject2, DoubleContainer doubleContainer) {
        switch (this.parser.ctx.symb) {
            case 1: {
                this.parser.symbole();
                stringContainer.value = stringContainer.value + "- ";
                return this.primary_exp(stringContainer, idlObject2, doubleContainer);
            }
            case 0: {
                this.parser.symbole();
                stringContainer.value = stringContainer.value + "+ ";
                return this.primary_exp(stringContainer, idlObject2, doubleContainer);
            }
            case 3: {
                this.parser.symbole();
                stringContainer.value = stringContainer.value + "/ ";
                return this.primary_exp(stringContainer, idlObject2, doubleContainer);
            }
            case 60: {
                this.parser.symbole();
                stringContainer.value = stringContainer.value + "% ";
                return this.primary_exp(stringContainer, idlObject2, doubleContainer);
            }
            case 2: {
                this.parser.symbole();
                stringContainer.value = stringContainer.value + "* ";
                return this.primary_exp(stringContainer, idlObject2, doubleContainer);
            }
            case 58: {
                this.parser.symbole();
                stringContainer.value = stringContainer.value + "~ ";
                return this.primary_exp(stringContainer, idlObject2, doubleContainer);
            }
            case 19: {
                this.parser.symbole();
                stringContainer.value = stringContainer.value + "& ";
                return this.primary_exp(stringContainer, idlObject2, doubleContainer);
            }
            case 85: {
                this.parser.symbole();
                stringContainer.value = stringContainer.value + "| ";
                return this.primary_exp(stringContainer, idlObject2, doubleContainer);
            }
        }
        return this.primary_exp(stringContainer, idlObject2, doubleContainer);
    }

    protected boolean isIntoInterface(IdlObject idlObject2) {
        IdlObject idlObject3 = this.final_type(idlObject2.upper());
        return idlObject3.kind() == 15 || idlObject3.kind() == 28;
    }

    public long const_exp(StringContainer stringContainer, IdlObject idlObject2, DoubleContainer doubleContainer) {
        long l = 0L;
        boolean bl = true;
        DoubleContainer doubleContainer2 = new DoubleContainer();
        while (bl) {
            switch (this.parser.ctx.symb) {
                case 1: {
                    l -= this.unary_exp(stringContainer, idlObject2, doubleContainer2);
                    doubleContainer.value -= doubleContainer2.value;
                    break;
                }
                case 0: {
                    l += this.unary_exp(stringContainer, idlObject2, doubleContainer2);
                    doubleContainer.value += doubleContainer2.value;
                    break;
                }
                case 3: {
                    l /= this.unary_exp(stringContainer, idlObject2, doubleContainer2);
                    doubleContainer.value /= doubleContainer2.value;
                    break;
                }
                case 60: {
                    l %= this.unary_exp(stringContainer, idlObject2, doubleContainer2);
                    break;
                }
                case 2: {
                    l *= this.unary_exp(stringContainer, idlObject2, doubleContainer2);
                    doubleContainer.value *= doubleContainer2.value;
                    break;
                }
                case 58: {
                    l = this.unary_exp(stringContainer, idlObject2, doubleContainer);
                    break;
                }
                case 19: {
                    l &= this.unary_exp(stringContainer, idlObject2, doubleContainer2);
                    break;
                }
                case 85: {
                    l |= this.unary_exp(stringContainer, idlObject2, doubleContainer2);
                    break;
                }
                case 21: 
                case 56: {
                    String string = this.scoped_name();
                    if (!idlObject2.isVisible(string, false)) {
                        this.parser.show_error("Undefined identifier : " + string);
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(13));
                        this.parser.stopAt(this.parser.StopList);
                        break;
                    }
                    IdlObject idlObject3 = idlObject2.returnVisibleObject(string, false);
                    if (idlObject3.kind() == 7) {
                        l = ((IdlConst)idlObject3).intValue();
                        doubleContainer.value = ((IdlConst)idlObject3).floatValue();
                        if (!this.isIntoInterface(idlObject3)) {
                            stringContainer.value = stringContainer.value + this.fullname(idlObject3) + ".value ";
                            break;
                        }
                        stringContainer.value = stringContainer.value + this.fullname(idlObject3) + " ";
                        break;
                    }
                    if (idlObject3.kind() == 22) {
                        l = ((IdlEnumMember)idlObject3).getValue();
                        doubleContainer.value = l;
                        stringContainer.value = stringContainer.value + this.fullname(idlObject3) + "@ ";
                        break;
                    }
                    this.parser.show_error("This identifier " + string + " doesn't correspond to a constant value");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                    break;
                }
                case 8: {
                    l = this.primary_exp(stringContainer, idlObject2, doubleContainer);
                    break;
                }
                case 63: {
                    stringContainer.value = stringContainer.value + "\"" + this.parser.ctx.value + "\" ";
                    this.parser.symbole();
                    break;
                }
                case 64: {
                    stringContainer.value = stringContainer.value + "'" + this.parser.ctx.value + "' ";
                    this.parser.symbole();
                    break;
                }
                case 61: {
                    stringContainer.value = stringContainer.value + this.parser.ctx.value;
                    if (this.parser.ctx.base == 1) {
                        this.convertToDecimal();
                    }
                    l = Long.valueOf(this.parser.ctx.value);
                    doubleContainer.value = l;
                    this.parser.symbole();
                    break;
                }
                case 62: {
                    stringContainer.value = stringContainer.value + this.parser.ctx.value + " ";
                    doubleContainer.value = Double.valueOf(this.parser.ctx.value);
                    this.parser.symbole();
                    break;
                }
                case 51: {
                    stringContainer.value = stringContainer.value + "true ";
                    l = 1L;
                    this.parser.symbole();
                    break;
                }
                case 33: {
                    stringContainer.value = stringContainer.value + "false ";
                    l = 0L;
                    this.parser.symbole();
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return l;
    }

    public int positive_int_const(IdlObject idlObject2) {
        StringContainer stringContainer = new StringContainer();
        DoubleContainer doubleContainer = new DoubleContainer();
        int n = (int)this.const_exp(stringContainer, idlObject2, doubleContainer);
        if (n < 0) {
            this.parser.show_error("Positive interger constant expected");
        }
        return n;
    }

    public void fixed_dcl(IdlObject idlObject2) {
        if (this.parser.ctx.symb != 86) {
            this.parser.show_error("'fixed' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 15) {
            this.parser.show_error("'<' expected after 'fixed'");
        }
        this.parser.symbole();
        int n = this.positive_int_const(idlObject2);
        if (this.parser.ctx.symb != 11) {
            this.parser.show_error("',' expected");
        }
        this.parser.symbole();
        int n2 = this.positive_int_const(idlObject2);
        if (this.parser.ctx.symb != 16) {
            this.parser.show_error("'>' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.StopList.addElement(new Integer(16));
            this.parser.stopAt(this.parser.StopList);
        }
        this.parser.symbole();
        idlObject2.addIdlObject(new IdlFixed(n, n2, idlObject2));
    }

    public void fixed_const_dcl(IdlObject idlObject2) {
        if (this.parser.ctx.symb != 86) {
            this.parser.show_error("'fixed' expected");
        }
        this.parser.symbole();
        idlObject2.addIdlObject(new IdlFixed(0, 0, idlObject2));
    }

    public void wstring_dcl(IdlObject idlObject2) {
        int n = 0;
        if (this.parser.ctx.symb != 72) {
            this.parser.show_error("'wstring' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb == 15) {
            this.parser.symbole();
            n = this.positive_int_const(idlObject2);
            if (this.parser.ctx.symb != 16) {
                this.parser.show_error("'>' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.StopList.addElement(new Integer(16));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
        }
        idlObject2.addIdlObject(new IdlWString(n, idlObject2));
    }

    public void string_dcl(IdlObject idlObject2) {
        int n = 0;
        if (this.parser.ctx.symb != 48) {
            this.parser.show_error("'string' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb == 15) {
            this.parser.symbole();
            n = this.positive_int_const(idlObject2);
            if (this.parser.ctx.symb != 16) {
                this.parser.show_error("'>' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.StopList.addElement(new Integer(16));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
        }
        idlObject2.addIdlObject(new IdlString(n, idlObject2));
    }

    public void sequence_dcl(IdlObject idlObject2) {
        int n = 0;
        IdlSequence idlSequence2 = new IdlSequence(idlObject2);
        idlSequence2.attach_comment();
        if (this.parser.ctx.symb != 46) {
            this.parser.show_error("'sequence' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb == 15) {
            this.parser.symbole();
            this.simple_type_spec(idlSequence2);
            if (this.parser.ctx.symb == 11) {
                this.parser.symbole();
                n = this.positive_int_const(idlObject2);
            }
            idlSequence2.setSize(n);
            if (this.parser.ctx.symb != 16) {
                this.parser.show_error("'>' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            idlObject2.addIdlObject(idlSequence2);
        }
        idlObject2.addIdlObject(new IdlString(n, idlObject2));
    }

    public void const_type(IdlObject idlObject2) {
        switch (this.parser.ctx.symb) {
            case 41: {
                idlObject2.addIdlObject(IdlSimple.octet_type);
                break;
            }
            case 24: {
                idlObject2.addIdlObject(IdlSimple.boolean_type);
                break;
            }
            case 34: {
                idlObject2.addIdlObject(IdlSimple.float_type);
                break;
            }
            case 30: {
                idlObject2.addIdlObject(IdlSimple.double_type);
                break;
            }
            case 75: {
                idlObject2.addIdlObject(IdlSimple.longdouble_type);
                break;
            }
            case 47: {
                idlObject2.addIdlObject(IdlSimple.short_type);
                break;
            }
            case 66: {
                idlObject2.addIdlObject(IdlSimple.ushort_type);
                break;
            }
            case 38: {
                idlObject2.addIdlObject(IdlSimple.long_type);
                break;
            }
            case 65: {
                idlObject2.addIdlObject(IdlSimple.ulong_type);
                break;
            }
            case 73: {
                idlObject2.addIdlObject(IdlSimple.longlong_type);
                break;
            }
            case 74: {
                idlObject2.addIdlObject(IdlSimple.ulonglong_type);
                break;
            }
            case 26: {
                idlObject2.addIdlObject(IdlSimple.char_type);
                break;
            }
            case 71: {
                idlObject2.addIdlObject(IdlSimple.wchar_type);
                break;
            }
            case 72: {
                this.wstring_dcl(idlObject2);
                return;
            }
            case 48: {
                this.string_dcl(idlObject2);
                return;
            }
            case 86: {
                this.fixed_const_dcl(idlObject2);
                return;
            }
            case 21: 
            case 56: {
                String string = this.scoped_name();
                if (!idlObject2.isVisible(string, false)) {
                    this.parser.show_error("Undefined idenfitier : " + string);
                } else {
                    idlObject2.addIdlObject(new IdlIdent(string, idlObject2, idlObject2.returnVisibleObject(string, false)));
                }
                return;
            }
        }
        this.parser.symbole();
    }

    public void const_dcl(IdlObject idlObject2) {
        StringContainer stringContainer = new StringContainer("");
        IdlConst idlConst2 = new IdlConst(idlObject2);
        idlConst2.attach_comment();
        if (this.parser.ctx.symb != 27) {
            this.parser.show_error("'const' expected");
        }
        this.parser.symbole();
        this.const_type(idlConst2);
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected");
        } else {
            idlConst2.name(this.parser.ctx.value);
            if (idlObject2.isVisible(this.parser.ctx.value, true)) {
                this.parser.show_error("Identifier already used : " + this.parser.ctx.value);
            }
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 10) {
            this.parser.show_error("'=' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            this.parser.symbole();
            DoubleContainer doubleContainer = new DoubleContainer(0.0);
            long l = this.const_exp(stringContainer, idlObject2, doubleContainer);
            idlConst2.expression(stringContainer.value);
            idlConst2.intValue(l);
            idlConst2.floatValue(doubleContainer.value);
            idlObject2.addIdlObject(idlConst2);
            this.parser.ctx.one = this.parser.ctx.symb;
        }
    }

    public void constr_type_spec(IdlObject idlObject2) {
        switch (this.parser.ctx.symb) {
            case 49: {
                this.struct_dcl(idlObject2);
                break;
            }
            case 54: {
                this.union_dcl(idlObject2);
                break;
            }
            case 31: {
                this.enum_dcl(idlObject2);
            }
        }
        this.parser.symbole();
    }

    public void simple_type_spec(IdlObject idlObject2) {
        switch (this.parser.ctx.symb) {
            case 34: {
                idlObject2.addIdlObject(IdlSimple.float_type);
                break;
            }
            case 30: {
                idlObject2.addIdlObject(IdlSimple.double_type);
                break;
            }
            case 75: {
                idlObject2.addIdlObject(IdlSimple.longdouble_type);
                break;
            }
            case 47: {
                idlObject2.addIdlObject(IdlSimple.short_type);
                break;
            }
            case 66: {
                idlObject2.addIdlObject(IdlSimple.ushort_type);
                break;
            }
            case 38: {
                idlObject2.addIdlObject(IdlSimple.long_type);
                break;
            }
            case 65: {
                idlObject2.addIdlObject(IdlSimple.ulong_type);
                break;
            }
            case 73: {
                idlObject2.addIdlObject(IdlSimple.longlong_type);
                break;
            }
            case 74: {
                idlObject2.addIdlObject(IdlSimple.ulonglong_type);
                break;
            }
            case 26: {
                idlObject2.addIdlObject(IdlSimple.char_type);
                break;
            }
            case 71: {
                idlObject2.addIdlObject(IdlSimple.wchar_type);
                break;
            }
            case 86: {
                this.fixed_dcl(idlObject2);
                return;
            }
            case 72: {
                this.wstring_dcl(idlObject2);
                return;
            }
            case 48: {
                this.string_dcl(idlObject2);
                return;
            }
            case 21: 
            case 56: {
                String string = this.scoped_name();
                if (!idlObject2.isVisible(string, false)) {
                    this.parser.show_error("Undefined identifier : " + string);
                } else {
                    idlObject2.addIdlObject(new IdlIdent(string, idlObject2, idlObject2.returnVisibleObject(string, false)));
                }
                return;
            }
            case 24: {
                idlObject2.addIdlObject(IdlSimple.boolean_type);
                break;
            }
            case 41: {
                idlObject2.addIdlObject(IdlSimple.octet_type);
                break;
            }
            case 22: {
                idlObject2.addIdlObject(IdlSimple.any_type);
                break;
            }
            case 40: {
                idlObject2.addIdlObject(IdlSimple.object_type);
                break;
            }
            case 46: {
                this.sequence_dcl(idlObject2);
                break;
            }
            case 88: {
                idlObject2.addIdlObject(IdlSimple.valuebase_type);
            }
        }
        this.parser.symbole();
    }

    public void type_spec(IdlObject idlObject2) {
        switch (this.parser.ctx.symb) {
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 56: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 86: 
            case 88: {
                this.simple_type_spec(idlObject2);
                break;
            }
            case 31: 
            case 49: 
            case 54: {
                this.constr_type_spec(idlObject2);
            }
        }
    }

    public void declarators(IdlObject idlObject2) {
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            if (idlObject2.upper().isVisible(this.parser.ctx.value, true)) {
                this.parser.show_error("Identifier already used : " + this.parser.ctx.value);
            }
            idlObject2.name(this.parser.ctx.value);
            this.parser.symbole();
            if (this.parser.ctx.symb == 6) {
                Vector<Integer> vector = new Vector<Integer>();
                do {
                    this.parser.symbole();
                    int n = this.positive_int_const(idlObject2);
                    vector.addElement(new Integer(n));
                    if (this.parser.ctx.symb != 7) {
                        this.parser.show_error("']' expected");
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(13));
                        this.parser.stopAt(this.parser.StopList);
                    }
                    this.parser.symbole();
                } while (this.parser.ctx.symb == 6);
                IdlArray idlArray2 = new IdlArray(idlObject2);
                idlArray2.setDimension((Integer)vector.elementAt(0));
                IdlArray idlArray3 = idlArray2;
                if (vector.size() > 1) {
                    int n = 1;
                    while (n < vector.size()) {
                        IdlArray idlArray4 = new IdlArray(idlArray3);
                        idlArray4.setDimension((Integer)vector.elementAt(n));
                        idlArray3.addIdlObject(idlArray4);
                        idlArray3 = idlArray4;
                        ++n;
                    }
                }
                idlArray3.addIdlObject(idlObject2.type());
                idlObject2.type(idlArray2);
            }
        }
    }

    public void member(IdlObject idlObject2, Hashtable hashtable) {
        IdlStructMember idlStructMember2 = new IdlStructMember(idlObject2);
        idlStructMember2.attach_comment();
        this.type_spec(idlStructMember2);
        idlStructMember2.reset();
        while (true) {
            IdlStructMember idlStructMember3 = new IdlStructMember(idlObject2);
            idlStructMember3.type(idlStructMember2.type());
            idlStructMember3.attach_comment(idlStructMember2.getComment());
            this.declarators(idlStructMember3);
            switch (idlStructMember3.type().kind()) {
                case 9: 
                case 24: {
                    this.parser.warning("Anonymous sequences and arrays are deprecated");
                    break;
                }
                case 5: {
                    if (((IdlString)idlStructMember3.type()).max() == 0) break;
                    this.parser.warning("Anonymous unbounded string are deprecated");
                    break;
                }
                case 6: {
                    if (((IdlWString)idlStructMember3.type()).max() == 0) break;
                    this.parser.warning("Anonymous unbounded string are deprecated");
                    break;
                }
                case 26: {
                    this.parser.warning("Anonymous fixed are deprecated");
                }
            }
            idlObject2.addIdlObject(idlStructMember3);
            if (hashtable.get(idlStructMember3.name()) != null) {
                this.parser.show_error("This identifier is already used : " + idlStructMember3.name());
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            hashtable.put(idlStructMember3.name(), idlStructMember3);
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
    }

    public void member_list(IdlObject idlObject2) {
        Hashtable hashtable = new Hashtable();
        do {
            this.member(idlObject2, hashtable);
            if (this.parser.ctx.symb != 13) {
                this.parser.show_error("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.block_symbole(idlObject2);
        } while (this.parser.ctx.symb != 5);
    }

    public void struct_dcl(IdlObject idlObject2) {
        IdlStruct idlStruct2 = new IdlStruct(idlObject2);
        idlStruct2.attach_comment();
        IdlParser.container = idlStruct2;
        if (this.parser.ctx.symb != 49) {
            this.parser.show_error("'struct' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected");
        } else {
            if (idlObject2.isVisible(this.parser.ctx.value, true)) {
                IdlObject idlObject3 = idlObject2.returnVisibleObject(this.parser.ctx.value, true);
                if (idlObject3.kind() == 3) {
                    if (((IdlStruct)idlObject3).isForward()) {
                        ((IdlStruct)idlObject3).setDefinition(idlStruct2);
                    } else {
                        this.parser.show_error("The '" + this.parser.ctx.value + "' structure is already defined...");
                    }
                } else {
                    this.parser.show_error("Identifier already used : " + this.parser.ctx.value);
                }
            }
            idlStruct2.name(this.parser.ctx.value);
            idlObject2.addIdlObject(idlStruct2);
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 4) {
            if (this.parser.ctx.symb != 13) {
                this.parser.show_error("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            idlStruct2.isForward(true);
            this.parser.ctx.one = this.parser.ctx.symb;
            return;
        }
        this.block_symbole(idlObject2);
        this.member_list(idlStruct2);
        if (this.parser.ctx.symb != 5) {
            this.parser.show_error("'}' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
        IdlParser.container = idlObject2;
    }

    public void switch_type_spec(IdlObject idlObject2) {
        switch (this.parser.ctx.symb) {
            case 47: {
                idlObject2.addIdlObject(IdlSimple.short_type);
                break;
            }
            case 66: {
                idlObject2.addIdlObject(IdlSimple.ushort_type);
                break;
            }
            case 38: {
                idlObject2.addIdlObject(IdlSimple.long_type);
                break;
            }
            case 65: {
                idlObject2.addIdlObject(IdlSimple.ulong_type);
                break;
            }
            case 73: {
                idlObject2.addIdlObject(IdlSimple.longlong_type);
                break;
            }
            case 74: {
                idlObject2.addIdlObject(IdlSimple.ulonglong_type);
                break;
            }
            case 26: {
                idlObject2.addIdlObject(IdlSimple.char_type);
                break;
            }
            case 71: {
                idlObject2.addIdlObject(IdlSimple.wchar_type);
                break;
            }
            case 21: 
            case 56: {
                String string = this.scoped_name();
                if (!idlObject2.isVisible(string, false)) {
                    this.parser.show_error("Undefined identifier : " + string);
                } else {
                    idlObject2.addIdlObject(new IdlIdent(string, idlObject2, idlObject2.returnVisibleObject(string, false)));
                }
                return;
            }
            case 24: {
                idlObject2.addIdlObject(IdlSimple.boolean_type);
                break;
            }
            case 31: {
                this.enum_dcl(idlObject2);
                break;
            }
            default: {
                this.parser.show_error("Bad type for union discriminant");
            }
        }
        this.parser.symbole();
    }

    public int switch_case(IdlObject idlObject2, BooleanContainer booleanContainer, Hashtable hashtable) {
        int n = -1;
        StringContainer stringContainer = new StringContainer("");
        int n2 = 0;
        DoubleContainer doubleContainer = new DoubleContainer(0.0);
        booleanContainer.value = false;
        switch (this.parser.ctx.symb) {
            case 25: {
                this.parser.symbole();
                n2 = (int)this.const_exp(stringContainer, idlObject2, doubleContainer);
                break;
            }
            case 29: {
                this.parser.symbole();
                n = 0;
                break;
            }
            default: {
                this.parser.show_error("Reserved words 'case' or 'default' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return n;
            }
        }
        if (this.parser.ctx.symb != 14) {
            this.parser.show_error("':' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            IdlUnionMember idlUnionMember2 = new IdlUnionMember(idlObject2);
            this.parser.symbole();
            if (this.parser.ctx.symb != 25) {
                this.type_spec(idlUnionMember2);
                idlUnionMember2.reset();
                this.declarators(idlUnionMember2);
                switch (idlUnionMember2.type().kind()) {
                    case 9: 
                    case 24: {
                        this.parser.warning("Anonymous sequences and arrays are deprecated");
                        break;
                    }
                    case 5: {
                        if (((IdlString)idlUnionMember2.type()).max() == 0) break;
                        this.parser.warning("Anonymous unbounded string are deprecated");
                        break;
                    }
                    case 6: {
                        if (((IdlWString)idlUnionMember2.type()).max() == 0) break;
                        this.parser.warning("Anonymous unbounded string are deprecated");
                        break;
                    }
                    case 26: {
                        this.parser.warning("Anonymous fixed are deprecated");
                    }
                }
            } else {
                idlUnionMember2.setAsNext();
                booleanContainer.value = true;
            }
            if (n == 0) {
                idlUnionMember2.setAsDefault();
            }
            idlUnionMember2.setExpression(stringContainer.value);
            idlUnionMember2.setValue(n2);
            if (idlUnionMember2.name() != null) {
                if (hashtable.get(idlUnionMember2.name()) != null) {
                    this.parser.show_error("This identifier is already used : " + idlUnionMember2.name());
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                } else {
                    hashtable.put(idlUnionMember2.name(), idlUnionMember2);
                }
            }
            idlObject2.addIdlObject(idlUnionMember2);
        }
        return n;
    }

    public void switch_body(IdlObject idlObject2) {
        int n = 0;
        boolean bl = false;
        BooleanContainer booleanContainer = new BooleanContainer();
        Hashtable hashtable = new Hashtable();
        while (true) {
            if (this.switch_case(idlObject2, booleanContainer, hashtable) != -1) {
                ((IdlUnion)idlObject2).index(n);
            }
            ++n;
            if (booleanContainer.value) continue;
            if (this.parser.ctx.symb != 13) {
                this.parser.show_error("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.block_symbole(idlObject2);
            if (this.parser.ctx.symb == 5) break;
        }
        int n2 = idlObject2.pos();
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (((IdlUnionMember)idlObject2.current()).isAsNext()) {
                int n3 = idlObject2.pos();
                boolean bl2 = false;
                bl = false;
                while (!bl2) {
                    if (!((IdlUnionMember)idlObject2.current()).isAsNext()) {
                        bl = true;
                        int n4 = idlObject2.pos();
                        idlObject2.current().reset();
                        IdlObject idlObject3 = idlObject2.current().current();
                        String string = idlObject2.current().name();
                        idlObject2.pos(n3);
                        int n5 = n3;
                        while (n5 < n4) {
                            ((IdlUnionMember)idlObject2.current()).memberTypeAndNameIs(idlObject3, string);
                            idlObject2.next();
                            ++n5;
                        }
                        idlObject2.pos(n4 - 1);
                        bl2 = true;
                    }
                    idlObject2.next();
                    if (!idlObject2.end()) continue;
                    bl2 = true;
                }
                if (!bl) {
                    this.parser.show_error("A type declaration is expected for union members");
                }
            }
            idlObject2.next();
        }
        idlObject2.pos(n2);
    }

    public void union_dcl(IdlObject idlObject2) {
        IdlUnion idlUnion2 = new IdlUnion(idlObject2);
        idlUnion2.attach_comment();
        IdlParser.container = idlUnion2;
        if (this.parser.ctx.symb != 54) {
            this.parser.show_error("'union' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            IdlObject idlObject3;
            if (idlObject2.isVisible(this.parser.ctx.value, true)) {
                idlObject3 = idlObject2.returnVisibleObject(this.parser.ctx.value, true);
                if (idlObject3.kind() == 4) {
                    if (((IdlUnion)idlObject3).isForward()) {
                        ((IdlUnion)idlObject3).setDefinition(idlUnion2);
                    } else {
                        this.parser.show_error("The '" + this.parser.ctx.value + "' union is already defined...");
                    }
                } else {
                    this.parser.show_error("Identifier already used : " + this.parser.ctx.value);
                }
            }
            idlUnion2.name(this.parser.ctx.value);
            idlObject2.addIdlObject(idlUnion2);
            this.parser.symbole();
            if (this.parser.ctx.symb != 50) {
                if (this.parser.ctx.symb != 13) {
                    this.parser.show_error("'switch' or ';' expected");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                idlUnion2.isForward(true);
                this.parser.ctx.one = this.parser.ctx.symb;
                return;
            }
            this.parser.symbole();
            if (this.parser.ctx.symb != 8) {
                this.parser.show_error("'(' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else {
                this.parser.symbole();
                idlObject3 = new IdlUnionMember(idlObject2);
                idlObject3.name("__d");
                this.switch_type_spec(idlObject3);
                idlUnion2.addIdlObject(idlObject3);
                if (this.parser.ctx.symb != 9) {
                    this.parser.show_error("')' expected");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                } else {
                    this.parser.symbole();
                    if (this.parser.ctx.symb != 4) {
                        this.parser.show_error("'{' expected");
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(13));
                        this.parser.stopAt(this.parser.StopList);
                    } else {
                        this.block_symbole(idlObject2);
                        this.switch_body(idlUnion2);
                        if (this.parser.ctx.symb != 5) {
                            this.parser.show_error("'}' expected");
                            this.parser.StopList.removeAllElements();
                            this.parser.StopList.addElement(new Integer(13));
                            this.parser.stopAt(this.parser.StopList);
                        }
                    }
                }
            }
        }
        IdlParser.container = idlObject2;
    }

    public void enum_dcl(IdlObject idlObject2) {
        IdlEnum idlEnum2 = new IdlEnum(idlObject2);
        idlEnum2.attach_comment();
        IdlParser.container = idlEnum2;
        if (this.parser.ctx.symb != 31) {
            this.parser.show_error("'enum' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected");
        } else {
            if (idlObject2.isVisible(this.parser.ctx.value, true)) {
                this.parser.show_error("Identifier already used : " + this.parser.ctx.value);
            }
            idlEnum2.name(this.parser.ctx.value);
            this.parser.symbole();
        }
        idlObject2.addIdlObject(idlEnum2);
        if (this.parser.ctx.symb != 4) {
            this.parser.show_error("'{ expected");
        } else {
            this.block_symbole(idlObject2);
        }
        Hashtable<String, IdlEnumMember> hashtable = new Hashtable<String, IdlEnumMember>();
        int n = 0;
        while (true) {
            if (this.parser.ctx.symb != 21) {
                this.parser.show_error("Identifier expected");
                break;
            }
            IdlEnumMember idlEnumMember = new IdlEnumMember(idlEnum2);
            idlEnumMember.name(this.parser.ctx.value);
            idlEnumMember.setValue(n++);
            if (hashtable.get(idlEnumMember.name()) != null) {
                this.parser.show_error("This identifier is already used : " + idlEnumMember.name());
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            hashtable.put(idlEnumMember.name(), idlEnumMember);
            idlEnum2.addIdlObject(idlEnumMember);
            this.parser.symbole();
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 5) {
            this.parser.show_error("'}' expected");
        }
        IdlParser.container = idlObject2;
    }

    public void type_dcl(IdlObject idlObject2) {
        int n = 0;
        IdlTypeDef idlTypeDef2 = new IdlTypeDef(idlObject2);
        idlTypeDef2.attach_comment();
        if (this.parser.ctx.symb != 52) {
            this.parser.show_error("'typedef' expected");
        }
        this.parser.symbole();
        this.type_spec(idlTypeDef2);
        switch (idlTypeDef2.type().kind()) {
            case 2: 
            case 3: 
            case 4: {
                idlObject2.addIdlObject(idlTypeDef2.type());
                break;
            }
            case 9: {
                if (((IdlSequence)idlTypeDef2.type()).current().kind() != 9) break;
                this.parser.warning("Anonymous sequences and arrays are deprecated");
            }
        }
        while (true) {
            IdlTypeDef idlTypeDef3 = new IdlTypeDef(idlObject2);
            idlTypeDef3.type(idlTypeDef2.type());
            idlTypeDef3.attach_comment(idlTypeDef2.getComment());
            idlTypeDef3.setOrder(n++);
            this.declarators(idlTypeDef3);
            idlObject2.addIdlObject(idlTypeDef3);
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
        this.parser.ctx.one = this.parser.ctx.symb;
    }

    public void except_dcl(IdlObject idlObject2) {
        IdlExcept idlExcept = new IdlExcept(idlObject2);
        idlExcept.attach_comment();
        if (this.parser.ctx.symb != 32) {
            this.parser.show_error("'exception' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected");
        } else {
            if (idlObject2.isVisible(this.parser.ctx.value, true)) {
                this.parser.show_error("Identifier already used : " + this.parser.ctx.value);
            }
            idlExcept.name(this.parser.ctx.value);
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 4) {
            this.parser.show_error("'{' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            this.parser.symbole();
            if (this.parser.ctx.symb != 5) {
                this.member_list(idlExcept);
            }
            if (this.parser.ctx.symb != 5) {
                this.parser.show_error("'}' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
        }
        idlObject2.addIdlObject(idlExcept);
    }

    public void module_dcl(IdlObject idlObject2) {
        block9: {
            IdlModule idlModule2 = new IdlModule(idlObject2);
            idlModule2.attach_comment();
            IdlParser.container = idlModule2;
            if (this.parser.ctx.symb != 39) {
                this.parser.show_error("'module' expected");
            }
            this.parser.symbole();
            if (this.parser.ctx.symb != 21) {
                this.parser.show_error("Identifier expected");
            } else {
                if (idlObject2.isVisible(this.parser.ctx.value, true)) {
                    idlModule2 = (IdlModule)idlObject2.returnVisibleObject(this.parser.ctx.value, true);
                    idlModule2.refreshIncluded();
                    IdlParser.container = idlModule2;
                    if (!idlModule2._import) {
                        this.parser.show_error("This module ( " + this.parser.ctx.value + " ) is exposed but not imported, you cannot re-open it !");
                        return;
                    }
                } else {
                    idlModule2.name(this.parser.ctx.value);
                    idlObject2.addIdlObject(idlModule2);
                }
                this.parser.symbole();
            }
            if (this.parser.ctx.symb != 4) {
                this.parser.show_error("'{' expected");
            } else {
                this.parser.symbole();
            }
            do {
                this.idl_definition(idlModule2);
                if (this.parser.ctx.symb == 5) break block9;
            } while (this.parser.ctx.symb != 254);
            this.parser.show_error("End of module expected for '" + idlModule2.name() + "'");
            return;
        }
        IdlParser.container = idlObject2;
    }

    public IdlObject final_type(IdlObject idlObject2) {
        switch (idlObject2.kind()) {
            case 10: {
                return this.final_type(((IdlIdent)idlObject2).internalObject());
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                return this.final_type(idlObject2.current());
            }
        }
        return idlObject2;
    }

    public void param_type_spec(IdlObject idlObject2) {
        switch (this.parser.ctx.symb) {
            case 34: {
                idlObject2.addIdlObject(IdlSimple.float_type);
                break;
            }
            case 30: {
                idlObject2.addIdlObject(IdlSimple.double_type);
                break;
            }
            case 75: {
                idlObject2.addIdlObject(IdlSimple.longdouble_type);
                break;
            }
            case 47: {
                idlObject2.addIdlObject(IdlSimple.short_type);
                break;
            }
            case 66: {
                idlObject2.addIdlObject(IdlSimple.ushort_type);
                break;
            }
            case 38: {
                idlObject2.addIdlObject(IdlSimple.long_type);
                break;
            }
            case 65: {
                idlObject2.addIdlObject(IdlSimple.ulong_type);
                break;
            }
            case 73: {
                idlObject2.addIdlObject(IdlSimple.longlong_type);
                break;
            }
            case 74: {
                idlObject2.addIdlObject(IdlSimple.ulonglong_type);
                break;
            }
            case 26: {
                idlObject2.addIdlObject(IdlSimple.char_type);
                break;
            }
            case 71: {
                idlObject2.addIdlObject(IdlSimple.wchar_type);
                break;
            }
            case 86: {
                this.fixed_dcl(idlObject2);
                return;
            }
            case 72: {
                this.wstring_dcl(idlObject2);
                return;
            }
            case 48: {
                this.string_dcl(idlObject2);
                return;
            }
            case 21: 
            case 56: {
                String string = this.scoped_name();
                if (!idlObject2.isVisible(string, false)) {
                    this.parser.show_error("Undefined identifier " + string);
                } else {
                    IdlObject idlObject3 = idlObject2.returnVisibleObject(string, false);
                    if (this.final_type(idlObject3).kind() == 14) {
                        this.parser.show_error("Invalid type : " + idlObject3.name());
                    }
                    idlObject2.addIdlObject(new IdlIdent(string, idlObject2, idlObject3));
                }
                return;
            }
            case 24: {
                idlObject2.addIdlObject(IdlSimple.boolean_type);
                break;
            }
            case 41: {
                idlObject2.addIdlObject(IdlSimple.octet_type);
                break;
            }
            case 22: {
                idlObject2.addIdlObject(IdlSimple.any_type);
                break;
            }
            case 40: {
                idlObject2.addIdlObject(IdlSimple.object_type);
                break;
            }
            case 88: {
                idlObject2.addIdlObject(IdlSimple.valuebase_type);
            }
        }
        this.parser.symbole();
    }

    public void attr_dcl(IdlObject idlObject2) {
        boolean bl = false;
        IdlAttribute idlAttribute2 = new IdlAttribute(idlObject2);
        idlAttribute2.attach_comment();
        if (this.parser.ctx.symb == 46) {
            this.parser.symbole();
            bl = true;
        }
        if (this.parser.ctx.symb != 23) {
            this.parser.show_error("'attribute' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
        this.param_type_spec(idlAttribute2);
        switch (idlAttribute2.type().kind()) {
            case 5: {
                if (((IdlString)idlAttribute2.type()).max() == 0) break;
                this.parser.warning("Anonymous unbounded string are deprecated");
                break;
            }
            case 6: {
                if (((IdlWString)idlAttribute2.type()).max() == 0) break;
                this.parser.warning("Anonymous unbounded string are deprecated");
                break;
            }
            case 26: {
                this.parser.warning("Anonymous fixed are deprecated");
            }
        }
        while (true) {
            if (this.parser.ctx.symb != 21) {
                this.parser.show_error("Identifier expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            if (idlObject2.isVisible(this.parser.ctx.value, true)) {
                this.parser.show_error("Identifier already used : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            IdlAttribute idlAttribute3 = new IdlAttribute(idlObject2);
            idlAttribute3.name(this.parser.ctx.value);
            idlAttribute3.readOnly(bl);
            idlAttribute3.type(idlAttribute2.type());
            idlAttribute3.attach_comment(idlAttribute2.getComment());
            idlObject2.addIdlObject(idlAttribute3);
            this.parser.symbole();
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
        this.parser.ctx.one = this.parser.ctx.symb;
    }

    public void op_type_spec(IdlOp idlOp) {
        switch (this.parser.ctx.symb) {
            case 55: {
                idlOp.addIdlObject(IdlSimple.void_type);
                this.parser.symbole();
                break;
            }
            default: {
                this.param_type_spec(idlOp);
            }
        }
    }

    public void param_attribute(IdlParam idlParam) {
        switch (this.parser.ctx.symb) {
            case 35: {
                idlParam.param_attr(0);
                break;
            }
            case 43: {
                idlParam.param_attr(1);
                break;
            }
            case 36: {
                idlParam.param_attr(2);
                break;
            }
            default: {
                this.parser.show_error("Attribute ( in, out, inout ) expected");
                return;
            }
        }
        this.parser.symbole();
    }

    public void param_dcl(IdlOp idlOp) {
        IdlParam idlParam = new IdlParam(idlOp);
        this.param_attribute(idlParam);
        this.param_type_spec(idlParam);
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected for parameter");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(9));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (idlOp.returnVisibleObject(this.parser.ctx.value, true) != null) {
            this.parser.show_error("Identifier already used");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(9));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        idlParam.name(this.parser.ctx.value);
        idlOp.addIdlObject(idlParam);
        this.parser.symbole();
    }

    public void parameter_dcls(IdlOp idlOp) {
        if (this.parser.ctx.symb != 8) {
            this.parser.show_error("'(' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
        while (this.parser.ctx.symb != 9) {
            this.param_dcl(idlOp);
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
            if (this.parser.ctx.symb != 9) continue;
            this.parser.show_error("Parameter definition expected");
            break;
        }
        if (this.parser.ctx.symb != 9) {
            this.parser.show_error("')' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
    }

    public void raises_expr(IdlObject idlObject2) {
        Hashtable<IdlObject, IdlObject> hashtable = new Hashtable<IdlObject, IdlObject>();
        IdlRaises idlRaises = new IdlRaises(idlObject2);
        if (this.parser.ctx.symb != 44) {
            this.parser.show_error("'raises' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 8) {
            this.parser.show_error("'(' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(28));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
        while (true) {
            String string;
            if (!idlObject2.isVisible(string = this.scoped_name(), false)) {
                this.parser.show_error("Undefined identifier : " + string);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(28));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            if (idlObject2.returnVisibleObject(string, false).kind() != 14) {
                this.parser.show_error("This identifier doesn't correspond to an exception : " + string);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(28));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            IdlObject idlObject3 = idlObject2.returnVisibleObject(string, false);
            idlRaises.addIdlObject(idlObject3);
            if (hashtable.get(idlObject3) != null) {
                this.parser.show_error("An exception has been declared more than one time in the 'raise' clause : " + string);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(28));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            hashtable.put(idlObject3, idlObject3);
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
        idlObject2.addIdlObject(idlRaises);
        if (this.parser.ctx.symb != 9) {
            this.parser.show_error("')' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(28));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
    }

    public void context_expr(IdlOp idlOp) {
        IdlContext idlContext = new IdlContext(idlOp);
        if (this.parser.ctx.symb != 28) {
            this.parser.show_error("'context' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 8) {
            this.parser.show_error("'(' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
        while (true) {
            if (this.parser.ctx.symb != 63) {
                this.parser.show_error("String expected after 'context'");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            idlContext.addValue(this.parser.ctx.value);
            this.parser.symbole();
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
        idlOp.addIdlObject(idlContext);
        if (this.parser.ctx.symb != 9) {
            this.parser.show_error("')' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(28));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
    }

    public void op_dcl(IdlObject idlObject2) {
        boolean bl = false;
        IdlOp idlOp = new IdlOp(idlObject2);
        idlOp.attach_comment();
        if (this.parser.ctx.symb == 42) {
            this.parser.symbole();
            bl = true;
        }
        idlOp.oneway(bl);
        this.op_type_spec(idlOp);
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected for operation");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (idlObject2.isVisible(this.parser.ctx.value, true)) {
            this.parser.show_error("Indentifier already used : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(28));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        idlOp.name(this.parser.ctx.value);
        this.parser.symbole();
        this.parameter_dcls(idlOp);
        if (this.parser.ctx.symb == 44) {
            this.raises_expr(idlOp);
        }
        if (this.parser.ctx.symb == 28) {
            this.context_expr(idlOp);
        }
        idlObject2.addIdlObject(idlOp);
        this.parser.ctx.one = this.parser.ctx.symb;
    }

    public void export_dcl(IdlObject idlObject2) {
        switch (this.parser.ctx.symb) {
            case 27: {
                this.const_dcl(idlObject2);
                break;
            }
            case 32: {
                this.except_dcl(idlObject2);
                break;
            }
            case 49: {
                this.struct_dcl(idlObject2);
                break;
            }
            case 54: {
                this.union_dcl(idlObject2);
                break;
            }
            case 31: {
                this.enum_dcl(idlObject2);
                break;
            }
            case 52: {
                this.type_dcl(idlObject2);
                break;
            }
            case 76: {
                this.native_dcl(idlObject2);
                break;
            }
            case 68: {
                this.pragma_dcl(idlObject2);
                break;
            }
            case 99: {
                this.type_id_dcl(idlObject2);
                break;
            }
            case 100: {
                this.type_prefix_dcl(idlObject2);
                break;
            }
            case 23: 
            case 46: {
                this.attr_dcl(idlObject2);
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 48: 
            case 55: 
            case 56: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 86: 
            case 88: {
                this.op_dcl(idlObject2);
                break;
            }
            default: {
                this.parser.show_error("Unexpected or undefined key word in the interface or value body of " + idlObject2.name());
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
        }
        this.parser.symbole();
    }

    public void interface_body(IdlInterface idlInterface2) {
        while (this.parser.ctx.symb != 5) {
            this.export_dcl(idlInterface2);
            if (this.parser.ctx.symb != 13) {
                this.parser.show_error("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
        }
    }

    public void inheritance_spec(IdlInterface idlInterface2) {
        if (this.parser.ctx.symb != 14) {
            this.parser.show_error("':' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(4));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
        while (true) {
            String string;
            if (!idlInterface2.isVisible(string = this.scoped_name(), false)) {
                this.parser.show_error("Undeclared interface : " + string);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(4));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            IdlObject idlObject2 = idlInterface2.returnVisibleObject(string, false);
            if (idlObject2.final_kind() != 18 && idlObject2.final_kind() != 15) {
                this.parser.show_error("This identifier is not an interface : " + string);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(4));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
            if (idlObject2.final_kind() == 18 && ((IdlInterface)idlObject2.final_object()).getInterface() == null) {
                this.parser.show_error("It is not legal to inherit from a forward interface which is not defined : " + string);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(4));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
            if (idlInterface2.abstract_interface() && !((IdlInterface)idlObject2.final_object()).abstract_interface()) {
                this.parser.show_error("An abstract interface can only inherit from an abstract interface : " + string);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(4));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
            idlInterface2.addInheritance(idlObject2.final_object());
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
    }

    public void interface_dcl(IdlInterface idlInterface2) {
        if (this.parser.ctx.symb == 14) {
            this.inheritance_spec(idlInterface2);
        }
        if (this.parser.ctx.symb != 4) {
            this.parser.show_error("'{' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.stopAt(this.parser.StopList);
        } else {
            this.parser.symbole();
            this.interface_body(idlInterface2);
        }
        if (this.parser.ctx.symb != 5) {
            this.parser.show_error("'}' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
    }

    public void forward_dcl(IdlInterface idlInterface2) {
        idlInterface2.forward();
    }

    public void interface_type(IdlObject idlObject2) {
        IdlInterface idlInterface2 = null;
        int n = 0;
        IdlInterface idlInterface3 = new IdlInterface(idlObject2);
        idlInterface3.attach_comment();
        IdlParser.container = idlInterface3;
        if (this.parser.ctx.symb == 87) {
            idlInterface3.abstract_interface(true);
            this.parser.symbole();
        }
        if (this.parser.ctx.symb == 98) {
            if (idlInterface3.abstract_interface()) {
                this.parser.show_error("An abstract interface cannot be mark as 'local'");
            }
            idlInterface3.local_interface(true);
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 37) {
            this.parser.show_error("'interface' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected for interface");
        } else {
            idlInterface3.name(this.parser.ctx.value);
            if (idlObject2.isVisible(this.parser.ctx.value, true)) {
                IdlObject idlObject3 = idlObject2.returnVisibleObject(this.parser.ctx.value, true);
                if (idlObject3.kind() != 15 && idlObject3.kind() != 18) {
                    this.parser.show_error("Identifier already used : " + this.parser.ctx.value);
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(14));
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                } else {
                    idlInterface2 = (IdlInterface)idlObject3;
                    n = idlInterface2.isForward() ? 1 : 2;
                }
            }
        }
        idlObject2.addIdlObject(idlInterface3);
        this.parser.symbole();
        switch (this.parser.ctx.symb) {
            case 13: {
                if (n == 1) {
                    this.parser.show_error("This interface is already declared : " + idlInterface3.name());
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(5));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                this.forward_dcl(idlInterface3);
                this.parser.ctx.one = this.parser.ctx.symb;
                IdlParser.container = idlObject2;
                break;
            }
            case 4: 
            case 14: {
                if (n == 1) {
                    if (idlInterface2.abstract_interface() != idlInterface3.abstract_interface()) {
                        this.parser.show_error("This interface is not defined as specified in forward declaraton : " + idlInterface3.name());
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(5));
                        this.parser.stopAt(this.parser.StopList);
                        IdlParser.container = idlObject2;
                        return;
                    }
                    idlInterface3.defined(idlInterface2);
                }
                if (n == 2) {
                    this.parser.show_error("This interface is already declared : " + idlInterface3.name());
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(5));
                    this.parser.stopAt(this.parser.StopList);
                    IdlParser.container = idlObject2;
                    return;
                }
                this.interface_dcl(idlInterface3);
                IdlParser.container = idlObject2;
                break;
            }
            default: {
                this.parser.show_error("':' or  '{' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.stopAt(this.parser.StopList);
            }
        }
    }

    public void native_dcl(IdlObject idlObject2) {
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected after 'native'");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (idlObject2.isVisible(this.parser.ctx.value, false)) {
            this.parser.show_error("Identifier is already used : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlNative idlNative2 = new IdlNative(idlObject2);
        idlNative2.attach_comment();
        idlNative2.name(this.parser.ctx.value);
        idlObject2.addIdlObject(idlNative2);
    }

    public void value_forward_dcl(IdlObject idlObject2, String string, boolean bl) {
        IdlValue idlValue2 = new IdlValue(idlObject2);
        if (idlObject2.isVisible(string, false)) {
            this.parser.show_error("Identifier already used");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
        idlValue2.abstract_value(bl);
        idlValue2.name(string);
        idlValue2.forward(true);
        idlObject2.addIdlObject(idlValue2);
        this.parser.ctx.one = this.parser.ctx.symb;
        this.parser.ctx.symb = 13;
    }

    public void value_box_dcl(IdlObject idlObject2, String string) {
        if (idlObject2.isVisible(string, false)) {
            this.parser.show_error("Identifier already used");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
        IdlValueBox idlValueBox2 = new IdlValueBox(idlObject2);
        idlValueBox2.attach_comment();
        idlValueBox2.name(string);
        this.type_spec(idlValueBox2);
        idlObject2.addIdlObject(idlValueBox2);
        this.parser.ctx.one = this.parser.ctx.symb;
        this.parser.ctx.symb = 13;
    }

    public void value_inheritance(IdlObject idlObject2, boolean bl, boolean bl2) {
        String string = null;
        boolean bl3 = true;
        IdlObject idlObject3 = null;
        do {
            boolean bl4;
            this.parser.symbole();
            IdlValueInheritance idlValueInheritance = new IdlValueInheritance(idlObject2);
            if (this.parser.ctx.symb == 92) {
                if (!bl2) {
                    this.parser.show_error("'truncatable' cannot be used for an abstract valuetype");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (bl) {
                    this.parser.show_error("'truncatable' cannot be used if a valuetype is specified with 'custom'");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                bl4 = true;
                this.parser.symbole();
            } else {
                bl4 = false;
            }
            string = this.scoped_name();
            if (idlObject2.isVisible(string, false)) {
                IdlObject idlObject4 = idlObject2.returnVisibleObject(string, false);
                idlValueInheritance.truncatable_member(bl4);
                if (idlObject4.final_kind() == 33) {
                    if (((IdlValue)idlObject4).definedValue() == null) {
                        this.parser.show_error("Unable to inherit from a forward valuetype which has not been yet defined");
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(4));
                        this.parser.stopAt(this.parser.StopList);
                        return;
                    }
                    idlObject3 = ((IdlValue)idlObject4.final_object()).definedValue();
                } else {
                    idlObject3 = idlObject4.final_object();
                }
                if (idlObject3.kind() != 28) {
                    this.parser.show_error("Unable to inherit from a non-valuetype : " + string);
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (!bl && ((IdlValue)idlObject3).custom_value()) {
                    this.parser.show_error("A non-custom valuetype cannot inherit from a custom value type");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (bl3 && bl4 && ((IdlValue)idlObject3).abstract_value()) {
                    this.parser.show_error("An abstract valuetype cannot be specified with 'truncatable'");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (!bl2 && !((IdlValue)idlObject3).abstract_value()) {
                    this.parser.show_error("An abstract valuetype may only inherit from abstract valuetype");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (!bl3 && !((IdlValue)idlObject3).abstract_value()) {
                    this.parser.show_error("The second and others inheritances must be abstract valuetype");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                idlValueInheritance.addIdlObject(idlObject3);
                ((IdlValue)idlObject2).addInheritance(idlValueInheritance);
                if (!bl3) continue;
                bl3 = false;
                continue;
            }
            this.parser.show_error("Undefined identifier : " + string);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } while (this.parser.ctx.symb == 11);
    }

    public void value_inheritance_spec(IdlObject idlObject2, boolean bl, boolean bl2) {
        Vector<IdlObject> vector = new Vector<IdlObject>();
        if (this.parser.ctx.symb == 14) {
            this.value_inheritance(idlObject2, bl, bl2);
        }
        if (this.parser.ctx.symb == 90) {
            do {
                this.parser.symbole();
                String string = this.scoped_name();
                if (idlObject2.isVisible(string, false)) {
                    IdlObject idlObject3 = idlObject2.returnVisibleObject(string, false);
                    if (idlObject3.kind() == 18) {
                        if (((IdlInterface)idlObject3).getInterface() == null) {
                            this.parser.show_error("Unable to inherit from an interface which has not been yet defined : " + this.parser.ctx.value);
                            this.parser.StopList.removeAllElements();
                            this.parser.StopList.addElement(new Integer(5));
                            this.parser.StopList.addElement(new Integer(13));
                            this.parser.stopAt(this.parser.StopList);
                            return;
                        }
                        idlObject3 = ((IdlInterface)idlObject3).getInterface();
                    }
                    if (idlObject3.kind() != 15) {
                        this.parser.show_error("This identifier is not an interface : " + this.parser.ctx.value);
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(5));
                        this.parser.StopList.addElement(new Integer(13));
                        this.parser.stopAt(this.parser.StopList);
                        return;
                    }
                    vector.addElement(idlObject3);
                    continue;
                }
                this.parser.show_error("Undefined interface : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } while (this.parser.ctx.symb == 11);
            int n = 0;
            int n2 = 0;
            while (n2 < vector.size()) {
                if (!((IdlInterface)vector.elementAt(n2)).abstract_interface()) {
                    ++n;
                }
                ++n2;
            }
            if (n > 1) {
                this.parser.show_error("A valuetype can only support one non abstract interface");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            ((IdlValue)idlObject2).supports(vector);
        }
    }

    public void value_abs_dcl(IdlObject idlObject2, String string) {
        IdlValue idlValue2 = new IdlValue(idlObject2);
        idlValue2.attach_comment();
        if (idlObject2.isVisible(string, false)) {
            IdlObject idlObject3 = idlObject2.returnVisibleObject(string, false);
            if (idlObject3.kind() == 28) {
                this.parser.show_error("This valuetype is already defined : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (idlObject3.kind() != 33) {
                this.parser.show_error("This identifier is not a forward valuetype : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (!((IdlValue)idlObject3).abstract_value()) {
                this.parser.show_error("The previous definition of this identifier was not for an abstract valuetype : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (((IdlValue)idlObject3).definedValue() != null) {
                this.parser.show_error("Abstract valuetype already defined : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else {
                ((IdlValue)idlObject3).definedValue(idlValue2);
            }
        }
        idlValue2.name(string);
        idlValue2.abstract_value(true);
        this.value_inheritance_spec(idlValue2, false, false);
        idlObject2.addIdlObject(idlValue2);
        this.parser.symbole();
        while (this.parser.ctx.symb != 5) {
            this.export_dcl(idlValue2);
            if (this.parser.ctx.symb != 13) {
                this.parser.show_error("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
        }
    }

    public void state_member_dcl(IdlObject idlObject2) {
        IdlStateMember idlStateMember = new IdlStateMember(idlObject2);
        idlStateMember.attach_comment();
        switch (this.parser.ctx.symb) {
            case 94: {
                idlStateMember.public_member(true);
                break;
            }
            case 93: {
                idlStateMember.public_member(false);
            }
        }
        this.parser.symbole();
        this.type_spec(idlStateMember);
        while (true) {
            IdlStateMember idlStateMember2 = new IdlStateMember(idlObject2);
            idlStateMember2.public_member(idlStateMember.public_member());
            idlStateMember2.type(idlStateMember.type());
            idlStateMember2.attach_comment(idlStateMember.getComment());
            this.declarators(idlStateMember2);
            idlObject2.addIdlObject(idlStateMember2);
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
    }

    public void init_param_decls(IdlObject idlObject2) {
        do {
            this.parser.symbole();
            IdlFactoryMember idlFactoryMember = new IdlFactoryMember(idlObject2);
            if (this.parser.ctx.symb != 35) {
                this.parser.show_error("'in' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
            this.param_type_spec(idlFactoryMember);
            if (this.parser.ctx.symb != 21) {
                this.parser.show_error("Identifier expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            idlFactoryMember.name(this.parser.ctx.value);
            idlObject2.addIdlObject(idlFactoryMember);
            this.parser.symbole();
        } while (this.parser.ctx.symb == 11);
    }

    public void init_dcl(IdlObject idlObject2) {
        IdlFactory idlFactory2 = new IdlFactory(idlObject2);
        idlFactory2.attach_comment();
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected after 'factory'");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        idlFactory2.name(this.parser.ctx.value);
        this.parser.symbole();
        this.init_param_decls(idlFactory2);
        if (this.parser.ctx.symb != 9) {
            this.parser.show_error("')' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 13) {
            this.parser.show_error("';' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
        idlObject2.addIdlObject(idlFactory2);
    }

    public void value_dcl(IdlObject idlObject2, String string, boolean bl) {
        IdlValue idlValue2 = new IdlValue(idlObject2);
        idlValue2.attach_comment();
        IdlParser.container = idlValue2;
        if (idlObject2.isVisible(string, false)) {
            IdlObject idlObject3 = idlObject2.returnVisibleObject(string, false);
            if (idlObject3.kind() == 28) {
                this.parser.show_error("This valuetype is already defined : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (idlObject3.kind() != 33) {
                this.parser.show_error("This identifier is not a forward valuetype : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (((IdlValue)idlObject3).abstract_value()) {
                this.parser.show_error("The previous definition of this identifier was for an abstract valuetype : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (((IdlValue)idlObject3).definedValue() != null) {
                this.parser.show_error("Valuetype already defined : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else {
                ((IdlValue)idlObject3).definedValue(idlValue2);
            }
        }
        idlValue2.name(string);
        idlValue2.custom_value(bl);
        this.value_inheritance_spec(idlValue2, bl, true);
        idlObject2.addIdlObject(idlValue2);
        this.parser.symbole();
        while (this.parser.ctx.symb != 5) {
            switch (this.parser.ctx.symb) {
                case 93: 
                case 94: {
                    this.state_member_dcl(idlValue2);
                    break;
                }
                case 95: {
                    this.init_dcl(idlValue2);
                    break;
                }
                default: {
                    this.export_dcl(idlValue2);
                }
            }
            if (this.parser.ctx.symb != 13) {
                this.parser.show_error("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
        }
        IdlParser.container = idlObject2;
    }

    public void full_value_dcl(IdlObject idlObject2) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.parser.ctx.symb == 87) {
            bl = true;
            this.parser.symbole();
        }
        if (this.parser.ctx.symb == 91) {
            if (bl) {
                this.parser.show_error("A 'abstract' value cannot be 'custom'");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            bl2 = true;
            this.parser.symbole();
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected after 'valuetype'");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        String string = this.parser.ctx.value;
        this.parser.symbole();
        switch (this.parser.ctx.symb) {
            case 13: {
                this.value_forward_dcl(idlObject2, string, bl);
                return;
            }
            case 4: 
            case 14: 
            case 90: {
                if (bl) {
                    this.value_abs_dcl(idlObject2, string);
                } else {
                    this.value_dcl(idlObject2, string, bl2);
                }
                return;
            }
        }
        this.value_box_dcl(idlObject2, string);
    }

    public void changeId(IdlObject idlObject2) {
        IdlInterface idlInterface2;
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected after #pragma ID ");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (!idlObject2.isVisible(this.parser.ctx.value, false)) {
            this.parser.show_error("Undefined Identifier : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlObject idlObject3 = idlObject2.returnVisibleObject(this.parser.ctx.value, false);
        this.parser.symbole();
        if (this.parser.ctx.symb != 63) {
            this.parser.show_error("ID definition expected after #pragma " + idlObject3.name());
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (idlObject3.kind() == 18 && (idlInterface2 = (IdlInterface)idlObject3).isForward() && (idlInterface2 = idlInterface2.getInterface()) != null) {
            idlObject3 = idlInterface2;
        }
        idlObject3.setId(this.parser.ctx.value);
    }

    public void changeVersion(IdlObject idlObject2) {
        IdlInterface idlInterface2;
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected after #pragma VERSION ");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (!idlObject2.isVisible(this.parser.ctx.value, false)) {
            this.parser.show_error("Undefined identifier : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlObject idlObject3 = idlObject2.returnVisibleObject(this.parser.ctx.value, false);
        this.parser.symbole();
        if (this.parser.ctx.symb != 62) {
            this.parser.show_error("Bad version number for  : #pragma " + idlObject3.name());
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        String string = idlObject3.getId();
        int n = string.lastIndexOf(58);
        string = n != -1 ? new String(string.substring(0, n + 1)) : string + ":";
        String string2 = new String(string + this.parser.ctx.value);
        if (idlObject3.kind() == 18 && (idlInterface2 = (IdlInterface)idlObject3).isForward() && (idlInterface2 = idlInterface2.getInterface()) != null) {
            idlObject3.setId(string2);
            idlObject3 = idlInterface2;
        }
        idlObject3.setId(string2);
    }

    public void changePrefix() {
        this.parser.symbole();
        if (this.parser.ctx.symb != 63) {
            this.parser.show_error("String expected after #pragma PREFIX ");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (this.parser.ctx.value.equals("")) {
            IdlObject.idlPrefix = null;
        } else if (this.checkPrefix(this.parser.ctx.value)) {
            IdlObject.idlPrefix = new String(this.parser.ctx.value);
        }
    }

    public boolean checkPrefix(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '.') {
                this.parser.show_error("The character '" + c + "' is not allowed in a pragma prefix.");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(255));
                this.parser.stopAt(this.parser.StopList);
                return false;
            }
            ++n;
        }
        return true;
    }

    public void echo() {
        this.parser.symbole();
        if (this.parser.ctx.symb != 63) {
            this.parser.show_error("String expected after #pragma echo ");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        System.out.println(this.parser.ctx.value);
    }

    public void changePackage() {
        this.parser.symbole();
        if (this.parser.ctx.symb != 63) {
            this.parser.show_error("String expected after #pragma javaPackage ");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlCompiler.use_package = true;
        IdlCompiler.packageName = new String(this.parser.ctx.value);
    }

    public void addNativeMap(IdlObject idlObject2) {
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Identifier expected after #pragma javaNativeMap ");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (!idlObject2.isVisible(this.parser.ctx.value, false)) {
            this.parser.show_error("Undefined identifier : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlObject idlObject3 = idlObject2.returnVisibleObject(this.parser.ctx.value, false);
        if (!(idlObject3 instanceof IdlNative)) {
            this.parser.show_error("Attempted to apply native mapping to " + this.parser.ctx.value + " which is not of native type.");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        String string = this.parser.ctx.value;
        this.parser.symbole();
        if (this.parser.ctx.symb != 63) {
            this.parser.show_error("String expected after #pragma javaNativeMap " + string);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlCompiler.nativeDefinition.addElement(string + ":" + this.parser.ctx.value);
    }

    public void pragma_dcl(IdlObject idlObject2) {
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.show_error("Undefined pragma option : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
        } else if (this.parser.ctx.value.toUpperCase().equals("ID")) {
            this.changeId(idlObject2);
        } else if (this.parser.ctx.value.toUpperCase().equals("VERSION")) {
            this.changeVersion(idlObject2);
        } else if (this.parser.ctx.value.toUpperCase().equals("PREFIX")) {
            this.changePrefix();
        } else if (this.parser.ctx.value.toUpperCase().equals("JAVAPACKAGE")) {
            this.changePackage();
        } else if (this.parser.ctx.value.toUpperCase().equals("ECHO")) {
            this.echo();
        } else if (this.parser.ctx.value.toUpperCase().equals("JAVANATIVEMAP")) {
            this.addNativeMap(idlObject2);
        } else {
            this.parser.warning("Unknown pragma directive : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
        }
        this.parser.ctx.one = 13;
    }

    public void type_id_dcl(IdlObject idlObject2) {
        IdlInterface idlInterface2;
        this.parser.symbole();
        String string = this.scoped_name();
        if (!idlObject2.isVisible(string, false)) {
            this.parser.show_error("Unknown identifier : " + string);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlObject idlObject3 = idlObject2.returnVisibleObject(string, false);
        if (this.parser.ctx.symb != 63) {
            this.parser.show_error("ID definition expected after typeId " + string);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (idlObject3.kind() == 18 && (idlInterface2 = (IdlInterface)idlObject3).isForward() && (idlInterface2 = idlInterface2.getInterface()) != null) {
            idlObject3 = idlInterface2;
        }
        idlObject3.setId(this.parser.ctx.value);
    }

    public void type_prefix_dcl(IdlObject idlObject2) {
        IdlInterface idlInterface2;
        this.parser.symbole();
        String string = this.scoped_name();
        if (!idlObject2.isVisible(string, false)) {
            this.parser.show_error("Unknown identifier : " + string);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlObject idlObject3 = idlObject2.returnVisibleObject(string, false);
        if (this.parser.ctx.symb != 63) {
            this.parser.show_error("ID definition expected after typeId " + string);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (idlObject3.kind() == 18 && (idlInterface2 = (IdlInterface)idlObject3).isForward() && (idlInterface2 = idlInterface2.getInterface()) != null) {
            idlObject3 = idlInterface2;
        }
        if (idlObject3.equals(idlObject2)) {
            IdlObject.idlPrefix = this.parser.ctx.value;
        }
        idlObject3.applyPrefix(this.parser.ctx.value);
    }

    public void idl_definition(IdlObject idlObject2) {
        this.verbose("<idl_definition> : " + this.parser.ctx.symb);
        block0 : switch (this.parser.ctx.symb) {
            case 37: {
                this.interface_type(idlObject2);
                break;
            }
            case 39: {
                this.module_dcl(idlObject2);
                break;
            }
            case 27: {
                this.const_dcl(idlObject2);
                break;
            }
            case 32: {
                this.except_dcl(idlObject2);
                break;
            }
            case 49: {
                this.struct_dcl(idlObject2);
                break;
            }
            case 54: {
                this.union_dcl(idlObject2);
                break;
            }
            case 31: {
                this.enum_dcl(idlObject2);
                break;
            }
            case 52: {
                this.type_dcl(idlObject2);
                break;
            }
            case 68: {
                this.pragma_dcl(idlObject2);
                break;
            }
            case 76: {
                this.native_dcl(idlObject2);
                break;
            }
            case 98: {
                this.parser.symbole();
                if (this.parser.ctx.symb != 37) {
                    this.parser.show_error("'interface' key work expected after 'local'");
                    break;
                }
                this.parser.ctx.one = this.parser.ctx.symb;
                this.parser.ctx.symb = 98;
                this.interface_type(idlObject2);
                break;
            }
            case 87: {
                this.parser.symbole();
                switch (this.parser.ctx.symb) {
                    case 89: {
                        this.parser.ctx.one = this.parser.ctx.symb;
                        this.parser.ctx.symb = 87;
                        this.full_value_dcl(idlObject2);
                        break block0;
                    }
                    case 37: {
                        this.parser.ctx.one = this.parser.ctx.symb;
                        this.parser.ctx.symb = 87;
                        this.interface_type(idlObject2);
                        break block0;
                    }
                }
                this.parser.show_error("Bad definition after 'abstract'");
                break;
            }
            case 89: 
            case 91: {
                this.full_value_dcl(idlObject2);
                break;
            }
            case 99: {
                this.type_id_dcl(idlObject2);
                break;
            }
            case 100: {
                this.type_prefix_dcl(idlObject2);
                break;
            }
            case 254: {
                return;
            }
            default: {
                this.parser.show_error("Definition expected");
            }
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 13) {
            this.parser.show_error("';' expected");
        }
        this.parser.symbole();
    }

    private void block_symbole(IdlObject idlObject2) {
        this.verbose("<block_symbole>");
        this.parser.symbole();
        if (this.parser.ctx.symb == 68) {
            this.pragma_dcl(idlObject2);
            this.parser.symbole();
            this.block_symbole(idlObject2);
        }
    }

    public void import_dcl(IdlObject idlObject2) {
        this.verbose("<import_dcl>");
        String string = null;
        while (this.parser.ctx.symb == 97) {
            this.parser.symbole();
            string = this.scoped_name();
            idlObject2.addIdlObject(new IdlImport(idlObject2, string));
            if (this.parser.ctx.symb != 13) {
                this.parser.show_error("';' expected");
            }
            this.parser.symbole();
        }
    }

    public void idl_specification(IdlObject idlObject2) {
        this.verbose("<idl_speficication>");
        try {
            this.parser.symbole();
            do {
                if (this.parser.ctx.symb == 97) {
                    this.import_dcl(idlObject2);
                }
                this.idl_definition(idlObject2);
            } while (this.parser.ctx.symb != 254);
        }
        catch (Exception exception) {
            if (IdlCompiler.verbose) {
                System.out.println("--------------------");
                exception.printStackTrace();
                System.out.println("--------------------");
                System.out.println("");
            }
            this.parser.show_internal_error();
        }
    }

    private void verbose(String string) {
        if (IdlCompiler.verbose) {
            System.out.println(string);
        }
    }
}

