/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.dynamic;

import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_CONTEXT;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.Context;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.openorb.test.ORBTestCase;
import org.openorb.test.dynamic.DIITarget;
import org.openorb.test.dynamic.DIITargetPOA;
import org.openorb.test.dynamic.DIITargetPackage.DivideByZero;
import org.openorb.test.dynamic.Person;

public class DIITest
extends ORBTestCase {
    private ORB m_orb;
    private Object m_cltRef;
    private Any m_any;
    private Request m_crossThreadReq;
    private RuntimeException m_crossThreadException;
    static /* synthetic */ Class class$org$openorb$test$dynamic$DIITest;

    public DIITest(String string) {
        super(string);
    }

    public void setUp() {
        super.setUp();
        try {
            this.m_orb = this.getORB();
            POA pOA = (POA)this.m_orb.resolve_initial_references("RootPOA");
            DIITarget dIITarget = new DIITargetImpl(pOA)._this(this.m_orb);
            pOA.the_POAManager().activate();
            this.m_cltRef = this.forceMarshal(dIITarget);
            this.m_any = this.m_orb.create_any();
        }
        catch (UserException userException) {
            Assert.fail("exception during setup:" + ((java.lang.Object)userException).toString());
        }
    }

    public void testSimpleInvocation() {
        Request request = this.m_cltRef._request("hello");
        request.invoke();
        Exception exception = request.env().exception();
        request.env().clear();
        if (exception != null) {
            Assert.fail(exception.getMessage());
        }
    }

    public void testReturnInvocation() {
        Request request = this.m_cltRef._request("message");
        TypeCode typeCode = this.m_orb.get_primitive_tc(TCKind.tk_string);
        request.set_return_type(typeCode);
        request.invoke();
        Exception exception = request.env().exception();
        if (exception != null) {
            Assert.fail(exception.getMessage());
        }
        Any any = request.return_value();
        String string = any.extract_string();
        request.operation();
        request.arguments();
        request.result();
        request.target();
        request.ctx();
    }

    public void testParamInvocation() {
        Request request = this.m_cltRef._request("add");
        Any any = request.add_in_arg();
        Any any2 = request.add_in_arg();
        any.insert_float(5.0f);
        any2.insert_float(3.14f);
        TypeCode typeCode = this.m_orb.get_primitive_tc(TCKind.tk_float);
        request.set_return_type(typeCode);
        request.invoke();
        Exception exception = request.env().exception();
        if (exception != null) {
            Assert.fail(exception.getMessage());
        }
        Any any3 = request.return_value();
        float f = any3.extract_float();
    }

    public void testExceptionInvocation() throws BadKind {
        Request request = this.m_cltRef._request("divide");
        Any any = request.add_in_arg();
        Any any2 = request.add_in_arg();
        any.insert_float(5.0f);
        any2.insert_float(0.0f);
        TypeCode typeCode = this.m_orb.get_primitive_tc(TCKind.tk_float);
        request.set_return_type(typeCode);
        StructMember[] structMemberArray = new StructMember[]{};
        TypeCode typeCode2 = this.m_orb.create_exception_tc("IDL:openorb.org/test/dynamic/DIITarget/DivideByZero:1.0", "DivideByZero", structMemberArray);
        request.exceptions().add(typeCode2);
        request.invoke();
        Any any3 = request.return_value();
        Exception exception = request.env().exception();
        Assert.assertNotNull("Expected exception return", exception);
        if (!(exception instanceof UnknownUserException)) {
            throw (SystemException)exception;
        }
        UnknownUserException unknownUserException = (UnknownUserException)exception;
        Assert.assertTrue("Unknown exception instead of DivideByZero exception", unknownUserException.except.type().id().equals("IDL:openorb.org/test/dynamic/DIITarget/DivideByZero:1.0"));
    }

    public void testContextInvocation() {
        Request request = this.m_cltRef._request("clauseContext");
        request.contexts().add("Testing");
        Context context = this.m_orb.get_default_context();
        Any any = this.m_orb.create_any();
        any.insert_string("Context value for context 'Testing'. ");
        context.set_one_value("Testing", any);
        context.set_values(this.m_orb.create_list(2));
        context.context_name();
        Context context2 = context.parent();
        Context context3 = context.create_child("ChildContext");
        context.delete_values("None");
        request.ctx(context);
        request.invoke();
        Exception exception = request.env().exception();
        if (exception != null) {
            Assert.fail(exception.getMessage());
        }
    }

    public void testAttributeInvocation() {
        Request request = this.m_cltRef._request("_get_name");
        Request request2 = this.m_cltRef._request("_set_name");
        TypeCode typeCode = this.m_orb.get_primitive_tc(TCKind.tk_string);
        request.set_return_type(typeCode);
        request.invoke();
        Any any = request.return_value();
        any.extract_string();
        Any any2 = request2.add_in_arg();
        any2.insert_string("NewName");
        request2.invoke();
    }

    public void testOnewayInvocation() {
        Request request = this.m_cltRef._request("hello_oneway");
        request.send_oneway();
        Exception exception = request.env().exception();
        request.env().clear();
        if (exception != null) {
            Assert.fail(exception.getMessage());
        }
    }

    public void testMultipleOnewayInvocation() {
        Request[] requestArray = new Request[5];
        int n = 0;
        while (n < requestArray.length) {
            requestArray[n] = this.m_cltRef._request("hello_oneway");
            ++n;
        }
        this.m_orb.send_multiple_requests_oneway(requestArray);
        int n2 = 0;
        while (n2 < requestArray.length) {
            Exception exception = requestArray[n2].env().exception();
            requestArray[n2].env().clear();
            if (exception != null) {
                Assert.fail(exception.getMessage());
            }
            ++n2;
        }
    }

    public void testDeferredInvocation() throws UserException {
        Request request = this.m_cltRef._request("message");
        TypeCode typeCode = this.m_orb.get_primitive_tc(TCKind.tk_string);
        request.set_return_type(typeCode);
        request.send_deferred();
        request.get_response();
        Any any = request.return_value();
        String string = any.extract_string();
    }

    public void testPollingInvocation() throws UserException {
        Request request = this.m_cltRef._request("message");
        TypeCode typeCode = this.m_orb.get_primitive_tc(TCKind.tk_string);
        request.set_return_type(typeCode);
        request.send_deferred();
        try {
            while (!request.poll_response()) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        request.get_response();
        Any any = request.return_value();
        String string = any.extract_string();
    }

    public void testDeferredCrossThreadInvocation() throws UserException {
        this.m_crossThreadReq = this.m_cltRef._request("message");
        TypeCode typeCode = this.m_orb.get_primitive_tc(TCKind.tk_string);
        this.m_crossThreadReq.set_return_type(typeCode);
        this.m_crossThreadReq.send_deferred();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (!DIITest.this.m_crossThreadReq.poll_response()) {
                        Thread.sleep(500L);
                    }
                }
                catch (RuntimeException runtimeException) {
                    DIITest.this.m_crossThreadException = runtimeException;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.m_crossThreadException != null) {
            throw this.m_crossThreadException;
        }
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                try {
                    DIITest.this.m_crossThreadReq.get_response();
                }
                catch (RuntimeException runtimeException) {
                    DIITest.this.m_crossThreadException = runtimeException;
                }
                catch (Exception exception) {
                    Assert.fail("Unexpected exception caught: " + exception);
                }
            }
        });
        thread2.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.m_crossThreadException != null) {
            throw this.m_crossThreadException;
        }
        Any any = this.m_crossThreadReq.return_value();
        String string = any.extract_string();
    }

    /*
     * Exception decompiling
     */
    public void testMultipleDeferredInvocations() throws UserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$dynamic$DIITest == null ? (class$org$openorb$test$dynamic$DIITest = DIITest.class$("org.openorb.test.dynamic.DIITest")) : class$org$openorb$test$dynamic$DIITest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DIITargetImpl
    extends DIITargetPOA {
        private String m_name = "TargetRange";

        public DIITargetImpl(POA pOA) {
        }

        public void hello() {
        }

        public void hello_oneway() {
        }

        public String message() {
            return "Hello from the server";
        }

        public String name() {
            return this.m_name;
        }

        public void name(String string) {
            this.m_name = string;
        }

        public float add(float f, float f2) {
            return f + f2;
        }

        public float divide(float f, float f2) throws DivideByZero {
            if (f2 == 0.0f) {
                throw new DivideByZero();
            }
            return f / f2;
        }

        public void clauseContext(Context context) {
            NVList nVList = null;
            try {
                nVList = context.get_values("", 0, "Testing");
            }
            catch (BAD_CONTEXT bAD_CONTEXT) {
                return;
            }
            try {
                NamedValue namedValue = nVList.item(0);
                Any any = namedValue.value();
                any.extract_string();
            }
            catch (Bounds bounds) {
                // empty catch block
            }
        }

        public String[] sequenceTest(String[] stringArray) {
            return stringArray;
        }

        public Person structTest(Person person) {
            return person;
        }
    }
}

