/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.dynamic;

import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.UserException;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynArray;
import org.omg.DynamicAny.DynEnum;
import org.omg.DynamicAny.DynFixed;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynUnion;
import org.omg.DynamicAny.NameDynAnyPair;
import org.omg.DynamicAny.NameValuePair;
import org.omg.GIOP.MessageHeader_1_1;
import org.omg.GIOP.MessageHeader_1_1Helper;
import org.omg.GIOP.MessageHeader_1_2Helper;
import org.omg.GIOP.Version;
import org.openorb.test.CORBA.CORBATestCase;

public class DynAnyTest
extends CORBATestCase {
    private ORB m_orb;
    private Any m_any;
    private DynAnyFactory m_dyn_factory;
    static /* synthetic */ Class class$org$openorb$test$dynamic$DynAnyTest;

    public DynAnyTest(String string) {
        super(string);
    }

    public void setUp() {
        super.setUp();
        try {
            this.m_orb = this.getORB();
            this.m_any = this.m_orb.create_any();
            Object object = this.m_orb.resolve_initial_references("DynAnyFactory");
            this.m_dyn_factory = DynAnyFactoryHelper.narrow(object);
        }
        catch (UserException userException) {
            Assert.fail("exception during setup:" + ((java.lang.Object)userException).toString());
        }
    }

    public void testDynBasic() throws UserException {
        DynAny dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_char));
        dynAny.insert_char('c');
        dynAny.get_char();
        dynAny.type();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_wchar));
        dynAny.insert_wchar('c');
        dynAny.get_wchar();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_boolean));
        dynAny.insert_boolean(true);
        dynAny.get_boolean();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_octet));
        dynAny.insert_octet((byte)111);
        dynAny.get_octet();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_short));
        dynAny.insert_short((short)1);
        dynAny.get_short();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_ushort));
        dynAny.insert_ushort((short)1);
        dynAny.get_ushort();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_long));
        dynAny.insert_long(2);
        dynAny.get_long();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_ulong));
        dynAny.insert_ulong(2);
        dynAny.get_ulong();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_longlong));
        dynAny.insert_longlong(2L);
        dynAny.get_longlong();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_ulonglong));
        dynAny.insert_ulonglong(2L);
        dynAny.get_ulonglong();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_float));
        dynAny.insert_float(3.0f);
        dynAny.get_float();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_double));
        dynAny.insert_double(3.0);
        dynAny.get_double();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_any));
        dynAny.insert_any(this.m_any);
        dynAny.get_any();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_string));
        dynAny.insert_string("str");
        dynAny.get_string();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_wstring));
        dynAny.insert_wstring("str");
        dynAny.get_wstring();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_TypeCode));
        dynAny.insert_typecode(this.m_orb.get_primitive_tc(TCKind.tk_TypeCode));
        dynAny.get_typecode();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_objref));
        dynAny.insert_reference(null);
        dynAny.get_reference();
        dynAny.type();
        dynAny.rewind();
        dynAny.seek(0);
        dynAny.component_count();
        dynAny.next();
        dynAny.current_component();
        dynAny.from_any(dynAny.to_any());
        dynAny.assign(dynAny.copy());
        dynAny.rewind();
        dynAny.seek(0);
        dynAny.component_count();
        dynAny.next();
        dynAny.current_component();
        dynAny.from_any(dynAny.to_any());
        dynAny.assign(dynAny.copy());
        dynAny.equal(dynAny.copy());
        dynAny.destroy();
    }

    public void testDynEnum() throws UserException {
        DynEnum dynEnum = (DynEnum)this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.create_enum_tc("IDL:Dummy:1.0", "Dummy", new String[]{"RED", "GREEN"}));
        dynEnum.set_as_string("RED");
        dynEnum.get_as_string();
        dynEnum.set_as_ulong(0);
        dynEnum.get_as_ulong();
        dynEnum.rewind();
        dynEnum.seek(0);
        dynEnum.component_count();
        dynEnum.next();
        dynEnum.current_component();
        dynEnum.from_any(dynEnum.to_any());
        dynEnum.assign(dynEnum.copy());
        dynEnum.destroy();
    }

    public void testDynStruct() throws UserException {
        TestingDynStructFactory testingDynStructFactory = new NonAliasedDynStructFactory();
        DynStruct dynStruct = testingDynStructFactory.createDynStruct();
        this.dynStruct_basicTests(dynStruct);
        this.dynStruct_iteratorTests(dynStruct);
        this.dynStruct_getMembersTests(dynStruct);
        this.dynStruct_getMembersAsDynAnyTests(dynStruct);
        dynStruct.destroy();
        this.dynStruct_setMembersTests(testingDynStructFactory);
        this.dynStruct_setMembersAsDynAnyTests(testingDynStructFactory);
        testingDynStructFactory = new AliasedDynStructFactory();
        dynStruct = testingDynStructFactory.createDynStruct();
        this.dynStruct_basicTests(dynStruct);
        this.dynStruct_iteratorTests(dynStruct);
        this.dynStruct_getMembersTests(dynStruct);
        this.dynStruct_getMembersAsDynAnyTests(dynStruct);
        dynStruct.destroy();
        this.dynStruct_setMembersTests(testingDynStructFactory);
        this.dynStruct_setMembersAsDynAnyTests(testingDynStructFactory);
    }

    private void dynStruct_basicTests(DynStruct dynStruct) throws UserException {
        Assert.assertEquals("MessageHeader_1_1 has five components", 5, dynStruct.component_count());
    }

    private void dynStruct_iteratorTests(DynStruct dynStruct) throws UserException {
        Assert.assertEquals("member name 0 is 'magic'", "magic", dynStruct.current_member_name());
        Assert.assertTrue("the 'magic' member kind is alias", TCKind.tk_alias.value() == dynStruct.current_member_kind().value());
        DynArray dynArray = (DynArray)dynStruct.current_component();
        Assert.assertTrue("the 'magic' member is an alias", TCKind.tk_alias.value() == dynArray.type().kind().value());
        Assert.assertEquals("the 'magic' member data is an array of 4 char", 4, dynArray.component_count());
        dynStruct.next();
        Assert.assertEquals("member name 1 is 'GIOP_version'", "GIOP_version", dynStruct.current_member_name());
        Assert.assertTrue("the 'GIOP_version' member is an org.omg.GIOP.Version struct", TCKind.tk_struct.value() == dynStruct.current_member_kind().value());
        DynStruct dynStruct2 = (DynStruct)dynStruct.current_component();
        Assert.assertTrue("the 'GIOP_version' member is a struct", TCKind.tk_struct.value() == dynStruct2.type().kind().value());
        Assert.assertEquals("the org.omg.GIOP.Version struct has 2 members", 2, dynStruct2.component_count());
        dynStruct.seek(3);
        Assert.assertEquals("member name 3 is 'message_type'", "message_type", dynStruct.current_member_name());
        Assert.assertTrue("the 'message_type' member is an octet", TCKind.tk_octet.value() == dynStruct.current_member_kind().value());
        dynStruct.rewind();
        Assert.assertEquals("member name 0 is 'magic'", "magic", dynStruct.current_member_name());
        Assert.assertTrue("the 'magic' member is an alias", TCKind.tk_alias.value() == dynStruct.current_member_kind().value());
    }

    private void dynStruct_getMembersTests(DynStruct dynStruct) throws UserException {
        NameValuePair[] nameValuePairArray = dynStruct.get_members();
        Assert.assertEquals("MessageHeader_1_1 has five members", 5, nameValuePairArray.length);
        Assert.assertEquals("member 0 has id 'magic'", "magic", nameValuePairArray[0].id);
        Assert.assertEquals("member 0 is an octet", TCKind.tk_alias.value(), nameValuePairArray[0].value.type().kind().value());
        Assert.assertEquals("member 1 has id 'GIOP_version'", "GIOP_version", nameValuePairArray[1].id);
        Assert.assertEquals("member 1 is an org.omg.GIOP.Version struct", TCKind.tk_struct.value(), nameValuePairArray[1].value.type().kind().value());
        Assert.assertEquals("member 2 has id 'flags'", "flags", nameValuePairArray[2].id);
        Assert.assertEquals("member 2 is an octet", TCKind.tk_octet.value(), nameValuePairArray[2].value.type().kind().value());
        Assert.assertEquals("member 2 has value 0x01", 1, (int)nameValuePairArray[2].value.extract_octet());
        Assert.assertEquals("member 3 has id 'message_type'", "message_type", nameValuePairArray[3].id);
        Assert.assertEquals("member 3 is an octet", TCKind.tk_octet.value(), nameValuePairArray[3].value.type().kind().value());
        Assert.assertEquals("member 3 has value 0x02", 2, (int)nameValuePairArray[3].value.extract_octet());
        Assert.assertEquals("member 4 has id 'message_size'", "message_size", nameValuePairArray[4].id);
        Assert.assertEquals("member 4 is an unsigned long", TCKind.tk_ulong.value(), nameValuePairArray[4].value.type().kind().value());
        Assert.assertEquals("member 4 has value 10", 10, nameValuePairArray[4].value.extract_ulong());
    }

    private void dynStruct_getMembersAsDynAnyTests(DynStruct dynStruct) throws UserException {
        NameDynAnyPair[] nameDynAnyPairArray = dynStruct.get_members_as_dyn_any();
        Assert.assertEquals("MessageHeader_1_1 has five members", 5, nameDynAnyPairArray.length);
        Assert.assertEquals("member 0 has id 'magic'", "magic", nameDynAnyPairArray[0].id);
        Assert.assertEquals("member 0 is an octet", TCKind.tk_alias.value(), nameDynAnyPairArray[0].value.type().kind().value());
        Assert.assertEquals("member 1 has id 'GIOP_version'", "GIOP_version", nameDynAnyPairArray[1].id);
        Assert.assertEquals("member 1 is an org.omg.GIOP.Version struct", TCKind.tk_struct.value(), nameDynAnyPairArray[1].value.type().kind().value());
        Assert.assertEquals("member 2 has id 'flags'", "flags", nameDynAnyPairArray[2].id);
        Assert.assertEquals("member 2 is an octet", TCKind.tk_octet.value(), nameDynAnyPairArray[2].value.type().kind().value());
        Assert.assertEquals("member 2 has value 0x01", 1, (int)nameDynAnyPairArray[2].value.get_octet());
        Assert.assertEquals("member 3 has id 'message_type'", "message_type", nameDynAnyPairArray[3].id);
        Assert.assertEquals("member 3 is an octet", TCKind.tk_octet.value(), nameDynAnyPairArray[3].value.type().kind().value());
        Assert.assertEquals("member 3 has value 0x02", 2, (int)nameDynAnyPairArray[3].value.get_octet());
        Assert.assertEquals("member 4 has id 'message_size'", "message_size", nameDynAnyPairArray[4].id);
        Assert.assertEquals("member 4 is an unsigned long", TCKind.tk_ulong.value(), nameDynAnyPairArray[4].value.type().kind().value());
        Assert.assertEquals("member 4 has value 10", 10, nameDynAnyPairArray[4].value.get_ulong());
    }

    private void dynStruct_setMembersTests(TestingDynStructFactory testingDynStructFactory) throws UserException {
        DynStruct dynStruct = testingDynStructFactory.createDynStruct();
        boolean bl = false;
        try {
            dynStruct.set_members(new NameValuePair[0]);
        }
        catch (InvalidValue invalidValue) {
            bl = true;
        }
        Assert.assertTrue("should have thrown InvalidValue exception", bl);
        dynStruct.destroy();
    }

    private void dynStruct_setMembersAsDynAnyTests(TestingDynStructFactory testingDynStructFactory) throws UserException {
        DynStruct dynStruct = testingDynStructFactory.createDynStruct();
        boolean bl = false;
        try {
            dynStruct.set_members_as_dyn_any(new NameDynAnyPair[0]);
        }
        catch (InvalidValue invalidValue) {
            bl = true;
        }
        Assert.assertTrue("should have thrown InvalidValue exception", bl);
        dynStruct.destroy();
    }

    public void testDynFixed() throws UserException {
        DynFixed dynFixed = (DynFixed)this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.create_fixed_tc((short)5, (short)2));
        dynFixed.set_value("0123.450d");
        dynFixed.get_value();
        dynFixed.rewind();
        dynFixed.seek(0);
        dynFixed.component_count();
        dynFixed.next();
        dynFixed.current_component();
        dynFixed.from_any(dynFixed.to_any());
        dynFixed.assign(dynFixed.copy());
        dynFixed.destroy();
    }

    public void testDynUnion() throws UserException {
        DynUnion dynUnion = (DynUnion)this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.create_union_tc("IDL:Dummy:1.0", "ReallyDummy", this.m_orb.get_primitive_tc(TCKind.tk_short), new UnionMember[0]));
        dynUnion.set_discriminator(this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_short)));
        try {
            dynUnion.get_discriminator();
        }
        catch (Exception exception) {
            Assert.fail("Unexpected exception caught: " + exception);
        }
        dynUnion.has_no_active_member();
        try {
            dynUnion.set_to_no_active_member();
        }
        catch (Exception exception) {
            // empty catch block
        }
        dynUnion.discriminator_kind();
        try {
            dynUnion.set_to_default_member();
        }
        catch (Exception exception) {
            // empty catch block
        }
        dynUnion.member();
        dynUnion.member_name();
        dynUnion.member_kind();
        dynUnion.rewind();
        dynUnion.seek(0);
        dynUnion.component_count();
        dynUnion.next();
        dynUnion.current_component();
        try {
            dynUnion.from_any(dynUnion.to_any());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            dynUnion.assign(dynUnion.copy());
        }
        catch (Exception exception) {
            // empty catch block
        }
        dynUnion.destroy();
    }

    public void testDynSequence() throws UserException {
        DynSequence dynSequence = (DynSequence)this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.create_sequence_tc(2, this.m_orb.get_primitive_tc(TCKind.tk_string)));
        dynSequence.set_length(2);
        dynSequence.get_length();
        try {
            dynSequence.set_elements(new Any[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dynSequence.get_elements();
        try {
            dynSequence.set_elements_as_dyn_any(new DynAny[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dynSequence.get_elements_as_dyn_any();
        dynSequence.rewind();
        dynSequence.seek(0);
        dynSequence.component_count();
        dynSequence.next();
        dynSequence.current_component();
        dynSequence.from_any(dynSequence.to_any());
        dynSequence.assign(dynSequence.copy());
        dynSequence.destroy();
    }

    public void testDynArray() throws UserException {
        DynArray dynArray = (DynArray)this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.create_array_tc(2, this.m_orb.get_primitive_tc(TCKind.tk_string)));
        try {
            dynArray.set_elements(new Any[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dynArray.get_elements();
        try {
            dynArray.set_elements_as_dyn_any(new DynAny[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dynArray.get_elements_as_dyn_any();
        dynArray.rewind();
        dynArray.seek(0);
        dynArray.component_count();
        dynArray.next();
        dynArray.current_component();
        dynArray.from_any(dynArray.to_any());
        dynArray.assign(dynArray.copy());
        dynArray.destroy();
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$dynamic$DynAnyTest == null ? (class$org$openorb$test$dynamic$DynAnyTest = DynAnyTest.class$("org.openorb.test.dynamic.DynAnyTest")) : class$org$openorb$test$dynamic$DynAnyTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AliasedDynStructFactory
    implements TestingDynStructFactory {
        private AliasedDynStructFactory() {
        }

        public DynStruct createDynStruct() throws UserException {
            Any any = DynAnyTest.this.m_orb.create_any();
            MessageHeader_1_1 messageHeader_1_1 = new MessageHeader_1_1(new char[]{'a', 'b', 'c', 'd'}, new Version(-86, -69), 1, 2, 10);
            MessageHeader_1_2Helper.insert(any, messageHeader_1_1);
            return (DynStruct)DynAnyTest.this.m_dyn_factory.create_dyn_any(any);
        }
    }

    private class NonAliasedDynStructFactory
    implements TestingDynStructFactory {
        private NonAliasedDynStructFactory() {
        }

        public DynStruct createDynStruct() throws UserException {
            Any any = DynAnyTest.this.m_orb.create_any();
            MessageHeader_1_1 messageHeader_1_1 = new MessageHeader_1_1(new char[]{'a', 'b', 'c', 'd'}, new Version(-86, -69), 1, 2, 10);
            MessageHeader_1_1Helper.insert(any, messageHeader_1_1);
            return (DynStruct)DynAnyTest.this.m_dyn_factory.create_dyn_any(any);
        }
    }

    private static interface TestingDynStructFactory {
        public DynStruct createDynStruct() throws UserException;
    }
}

