/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.iiop.complex;

import java.math.BigDecimal;
import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.openorb.test.ORBTestCase;
import org.openorb.test.iiop.complex.ComplexStruct;
import org.openorb.test.iiop.complex.ComplexStructHelper;
import org.openorb.test.iiop.complex.EchoComplex;
import org.openorb.test.iiop.complex.EchoComplexHelper;
import org.openorb.test.iiop.complex.EchoComplexPOA;
import org.openorb.test.iiop.complex.EnumUnion;
import org.openorb.test.iiop.complex.Fixed52Helper;
import org.openorb.test.iiop.complex.LongUnion;
import org.openorb.test.iiop.complex.RecursiveStruct;
import org.openorb.test.iiop.complex.RecursiveStructHelper;
import org.openorb.test.iiop.complex.SimpleEnum;
import org.openorb.test.iiop.complex.SimpleStruct;
import org.openorb.test.iiop.complex.SimpleStructHelper;

public class ComplexTest
extends ORBTestCase {
    private EchoComplex m_cltRef;
    private ORB m_orb;
    private Any m_any;
    private Any m_rpl;
    static /* synthetic */ Class class$org$openorb$test$iiop$complex$ComplexTest;

    public ComplexTest(String string) {
        super(string);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.m_orb = this.getORB();
            POA pOA = (POA)this.m_orb.resolve_initial_references("RootPOA");
            EchoComplex echoComplex = new EchoComplexImpl(pOA)._this(this.m_orb);
            pOA.the_POAManager().activate();
            this.m_cltRef = EchoComplexHelper.narrow(this.forceMarshal(echoComplex));
            this.m_any = this.m_orb.create_any();
        }
        catch (UserException userException) {
            Assert.fail("exception during setup:" + ((Object)userException).toString());
        }
    }

    public void testSimpleStruct() {
        SimpleStruct simpleStruct = new SimpleStruct(1);
        SimpleStruct simpleStruct2 = this.m_cltRef.echo_simple_s(simpleStruct);
        Assert.assertEquals("Body of returned struct not equal", simpleStruct.n, simpleStruct2.n);
        SimpleStructHelper.insert(this.m_any, simpleStruct);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue("Returned any is not identical to original", this.m_rpl.equal(this.m_any));
    }

    public void testComplexStruct() {
        ComplexStruct complexStruct = new ComplexStruct(new SimpleStruct(1), "a string");
        ComplexStruct complexStruct2 = this.m_cltRef.echo_complex_s(complexStruct);
        Assert.assertEquals("Body of returned struct not equal", complexStruct.s, complexStruct2.s);
        ComplexStructHelper.insert(this.m_any, complexStruct);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue("Returned any is not identical to original", this.m_rpl.equal(this.m_any));
    }

    public void testRecursiveStruct() {
        RecursiveStruct[] recursiveStructArray = new RecursiveStruct[]{};
        RecursiveStruct[] recursiveStructArray2 = new RecursiveStruct[]{new RecursiveStruct("left", recursiveStructArray, recursiveStructArray)};
        RecursiveStruct[] recursiveStructArray3 = new RecursiveStruct[]{new RecursiveStruct("right", recursiveStructArray, recursiveStructArray)};
        RecursiveStruct recursiveStruct = new RecursiveStruct("top", recursiveStructArray2, recursiveStructArray3);
        RecursiveStruct recursiveStruct2 = this.m_cltRef.echo_recursive_s(recursiveStruct);
        RecursiveStructHelper.insert(this.m_any, recursiveStruct);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue("Returned any is not identical to original", this.m_rpl.equal(this.m_any));
    }

    public void testFixed() {
        BigDecimal bigDecimal = new BigDecimal("132.22");
        BigDecimal bigDecimal2 = this.m_cltRef.echo_fixed(bigDecimal);
        Assert.assertEquals("Body of returned fixed not equal", bigDecimal, bigDecimal2);
        Fixed52Helper.insert(this.m_any, bigDecimal);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue("Returned any is not identical to original", this.m_rpl.equal(this.m_any));
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$iiop$complex$ComplexTest == null ? (class$org$openorb$test$iiop$complex$ComplexTest = ComplexTest.class$("org.openorb.test.iiop.complex.ComplexTest")) : class$org$openorb$test$iiop$complex$ComplexTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class EchoComplexImpl
    extends EchoComplexPOA {
        private POA m_poa;

        EchoComplexImpl(POA pOA) {
            this.m_poa = pOA;
        }

        public POA _default_POA() {
            return this.m_poa;
        }

        public Any echo_any(Any any) {
            return any;
        }

        public SimpleStruct echo_simple_s(SimpleStruct simpleStruct) {
            return simpleStruct;
        }

        public ComplexStruct echo_complex_s(ComplexStruct complexStruct) {
            return complexStruct;
        }

        public RecursiveStruct echo_recursive_s(RecursiveStruct recursiveStruct) {
            return recursiveStruct;
        }

        public SimpleEnum echo_simple_e(SimpleEnum simpleEnum) {
            return simpleEnum;
        }

        public EnumUnion echo_enum_u(EnumUnion enumUnion) {
            return enumUnion;
        }

        public LongUnion echo_long_u(LongUnion longUnion) {
            return longUnion;
        }

        public BigDecimal echo_fixed(BigDecimal bigDecimal) {
            return bigDecimal;
        }
    }
}

