/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.naming;

import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.POA;
import org.openorb.test.ORBTestCase;
import org.openorb.util.MapNamingContext;
import org.openorb.util.NamingUtils;

public class NamingTest
extends ORBTestCase {
    static /* synthetic */ Class class$org$openorb$test$naming$NamingTest;

    public NamingTest(String string) {
        super(string);
    }

    private static boolean compareNames(NameComponent[] nameComponentArray, NameComponent[] nameComponentArray2) {
        if (nameComponentArray.length != nameComponentArray2.length) {
            return false;
        }
        int n = 0;
        while (n < nameComponentArray.length) {
            if (!nameComponentArray[n].id.equals(nameComponentArray2[n].id) || !nameComponentArray[n].kind.equals(nameComponentArray2[n].kind)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void testNameManipulation() throws InvalidName {
        String string = "Empty name";
        NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent("", "")};
        String string2 = NamingUtils.to_string(nameComponentArray);
        Assert.assertEquals(string, string2, ".");
        Assert.assertTrue(string, NamingTest.compareNames(nameComponentArray, NamingUtils.to_name(string2)));
        string = "id only";
        nameComponentArray = new NameComponent[]{new NameComponent("hello", "")};
        string2 = NamingUtils.to_string(nameComponentArray);
        Assert.assertEquals(string, string2, "hello");
        Assert.assertTrue(string, NamingTest.compareNames(nameComponentArray, NamingUtils.to_name(string2)));
        string = "kind only";
        nameComponentArray = new NameComponent[]{new NameComponent("", "world")};
        string2 = NamingUtils.to_string(nameComponentArray);
        Assert.assertEquals(string, string2, ".world");
        Assert.assertTrue(string, NamingTest.compareNames(nameComponentArray, NamingUtils.to_name(string2)));
        string = "both";
        nameComponentArray = new NameComponent[]{new NameComponent("hello", "world")};
        string2 = NamingUtils.to_string(nameComponentArray);
        Assert.assertEquals(string, string2, "hello.world");
        Assert.assertTrue(string, NamingTest.compareNames(nameComponentArray, NamingUtils.to_name(string2)));
        string = "Multiple elements...";
        nameComponentArray = new NameComponent[]{new NameComponent("", ""), new NameComponent("hello", ""), new NameComponent("", "world"), new NameComponent("hello", "world")};
        string2 = NamingUtils.to_string(nameComponentArray);
        Assert.assertEquals(string, string2, "./hello/.world/hello.world");
        Assert.assertTrue(string, NamingTest.compareNames(nameComponentArray, NamingUtils.to_name(string2)));
        string = "names needing escaping";
        nameComponentArray = new NameComponent[]{new NameComponent(".", "")};
        string2 = NamingUtils.to_string(nameComponentArray);
        Assert.assertEquals(string, string2, "\\.");
        Assert.assertTrue(string, NamingTest.compareNames(nameComponentArray, NamingUtils.to_name(string2)));
        nameComponentArray = new NameComponent[]{new NameComponent("/", "")};
        string2 = NamingUtils.to_string(nameComponentArray);
        Assert.assertEquals(string, string2, "\\/");
        Assert.assertTrue(string, NamingTest.compareNames(nameComponentArray, NamingUtils.to_name(string2)));
        nameComponentArray = new NameComponent[]{new NameComponent("\\", "")};
        string2 = NamingUtils.to_string(nameComponentArray);
        Assert.assertEquals(string, string2, "\\\\");
        Assert.assertTrue(string, NamingTest.compareNames(nameComponentArray, NamingUtils.to_name(string2)));
        nameComponentArray = new NameComponent[]{new NameComponent("\\\\\\.../\\.", "/.//.\\"), new NameComponent("m.o.r.e.", "//slashy\\\\")};
        string2 = NamingUtils.to_string(nameComponentArray);
        Assert.assertEquals(string, string2, "\\\\\\\\\\\\\\.\\.\\.\\/\\\\\\..\\/\\.\\/\\/\\.\\\\/m\\.o\\.r\\.e\\..\\/\\/slashy\\\\\\\\");
        Assert.assertTrue(string, NamingTest.compareNames(nameComponentArray, NamingUtils.to_name(string2)));
        string2 = "";
        try {
            NamingUtils.to_name(string2);
            Assert.fail("Exception should be thrown");
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
        string2 = "..";
        try {
            NamingUtils.to_name(string2);
            Assert.fail("Exception should be thrown");
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
        string2 = "hello.world/";
        try {
            NamingUtils.to_name(string2);
            Assert.fail("Exception should be thrown");
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
        string2 = "I.want.blood";
        try {
            NamingUtils.to_name(string2);
            Assert.fail("Exception should be thrown");
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
    }

    public void testNameService() throws UserException {
        ORB oRB = this.getORB();
        POA pOA = (POA)oRB.resolve_initial_references("RootPOA");
        pOA.the_POAManager().activate();
        MapNamingContext mapNamingContext = new MapNamingContext(oRB, null);
        NamingContextExt namingContextExt = mapNamingContext.getRootCtxt();
        mapNamingContext.put("empty", (java.lang.Object)null);
        mapNamingContext.put("submap.context/recurse", namingContextExt);
        mapNamingContext.put("recurse", namingContextExt);
        Object object = null;
        Object object2 = null;
        BindingListHolder bindingListHolder = new BindingListHolder();
        BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
        namingContextExt.list(1, bindingListHolder, bindingIteratorHolder);
        Assert.assertTrue(bindingListHolder.value.length == 1);
        if (bindingIteratorHolder.value != null) {
            BindingHolder bindingHolder = new BindingHolder();
            while (bindingIteratorHolder.value.next_one(bindingHolder)) {
            }
            bindingIteratorHolder.value.destroy();
        }
        NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent("empty", "")};
        object = namingContextExt.resolve(nameComponentArray);
        Assert.assertNull(object);
        nameComponentArray = new NameComponent[]{new NameComponent("recurse", "")};
        object = namingContextExt.resolve(nameComponentArray);
        Assert.assertTrue(object._is_equivalent(namingContextExt));
        object2 = null;
        nameComponentArray[0] = new NameComponent("submap", "context");
        object2 = namingContextExt.resolve(nameComponentArray);
        Assert.assertTrue(!object2._is_equivalent(namingContextExt));
        object = null;
        nameComponentArray[0] = new NameComponent("recurse", "");
        object = NamingContextHelper.narrow(object2).resolve(nameComponentArray);
        Assert.assertTrue(object._is_equivalent(namingContextExt));
        nameComponentArray = new NameComponent[]{new NameComponent("submap", "context"), new NameComponent("recurse", "")};
        object = namingContextExt.resolve(nameComponentArray);
        Assert.assertTrue(object._is_equivalent(namingContextExt));
        object2 = null;
        nameComponentArray[0] = new NameComponent("recurse", "");
        nameComponentArray[1] = new NameComponent("submap", "context");
        object2 = namingContextExt.resolve(nameComponentArray);
        Assert.assertTrue(!object2._is_equivalent(namingContextExt));
        object2 = null;
        nameComponentArray[0] = new NameComponent("recurse", "");
        nameComponentArray[1] = new NameComponent("nonexist", "");
        try {
            object2 = namingContextExt.resolve(nameComponentArray);
            Assert.fail("Able to resolve nonexistent context");
        }
        catch (NotFound notFound) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$naming$NamingTest == null ? (class$org$openorb$test$naming$NamingTest = NamingTest.class$("org.openorb.test.naming.NamingTest")) : class$org$openorb$test$naming$NamingTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

