/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.pi;

import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UNKNOWNHelper;
import org.omg.CORBA.UserException;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.PortableServer.POA;
import org.openorb.test.ORBTestCase;
import org.openorb.test.adapter.poa.Hello;
import org.openorb.test.adapter.poa.HelloHelper;
import org.openorb.test.adapter.poa.HelloPOA;

public class PITest
extends ORBTestCase {
    private Hello m_cltRef = null;
    private static final int SEND_REQ = 1;
    private static final int SEND_POLL = 2;
    private static final int SEND_SC = 8;
    private static final int RECV_REQSC = 16;
    private static final int RECV_REQ = 32;
    private static final int RECV_SC = 128;
    private static final int SEND_REPL = 256;
    private static final int SEND_EXPT = 512;
    private static final int SEND_OTHR = 1024;
    private static final int SEND_REPL_SC = 2048;
    private static final int RECV_REPL = 4096;
    private static final int RECV_EXPT = 8192;
    private static final int RECV_OTHR = 16384;
    private static final int RECV_REPL_SC = 32768;
    private static final int NOR_PATH = 4401;
    private static final int NOR_SC = 34952;
    private static final int TEST_SCID = 1146060545;
    private static int s_throwExcept;
    private static int s_visitMask;
    private static int s_retryCount;
    private static int s_slotID;
    private static Any s_any;
    private ORB m_orb;
    static /* synthetic */ Class class$org$openorb$test$pi$PITest$EmptyInitializer;
    static /* synthetic */ Class class$org$openorb$test$pi$PITest;

    public PITest(String string) {
        super(string);
        s_visitMask = 0;
        s_throwExcept = 0;
        s_retryCount = 0;
    }

    protected void setUp() {
        Properties properties = new Properties();
        properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass." + (class$org$openorb$test$pi$PITest$EmptyInitializer == null ? (class$org$openorb$test$pi$PITest$EmptyInitializer = PITest.class$("org.openorb.test.pi.PITest$EmptyInitializer")) : class$org$openorb$test$pi$PITest$EmptyInitializer).getName(), "");
        this.setUp(properties);
        try {
            this.m_orb = this.getORB();
            POA pOA = (POA)this.m_orb.resolve_initial_references("RootPOA");
            Hello hello = new HelloImpl(pOA)._this(this.m_orb);
            pOA.the_POAManager().activate();
            this.m_cltRef = HelloHelper.narrow(this.forceMarshal(hello));
            s_any = this.m_orb.create_any();
            s_any.insert_boolean(true);
        }
        catch (UserException userException) {
            Assert.fail("exception during setup:" + ((Object)userException).toString());
        }
    }

    public void testCompleteCall() {
        s_throwExcept = 0;
        try {
            this.m_cltRef.hello("A Message from testCompleteCall()...");
        }
        catch (UNKNOWN uNKNOWN) {
            // empty catch block
        }
        Assert.assertEquals("Complete call did not visit all interception points.", s_visitMask, 4401);
    }

    public void testCompleteCallWithSCs() throws UserException {
        s_throwExcept = 0;
        Current current = (Current)this.m_orb.resolve_initial_references("PICurrent");
        current.set_slot(s_slotID, s_any);
        try {
            this.m_cltRef.hello("A message from testCompleteCallWithSCs()...");
        }
        catch (UNKNOWN uNKNOWN) {
            // empty catch block
        }
        Assert.assertEquals("Complete call did not visit all interception points.", s_visitMask, 39353);
    }

    public void testToSendRequest() {
        s_throwExcept = 1;
        try {
            this.m_cltRef.hello("A message from testToSendRequest()...");
        }
        catch (UNKNOWN uNKNOWN) {
            Assert.assertEquals("Complete call did not visit all interception points.", s_visitMask, 1);
            Assert.assertEquals("Exception thrown in wrong place", uNKNOWN.minor, 1);
            return;
        }
        Assert.fail("expected exception");
    }

    public void testToRecvRequestSC() {
        s_throwExcept = 16;
        try {
            this.m_cltRef.hello("A message from testToRecvRequestSC()...");
        }
        catch (UNKNOWN uNKNOWN) {
            Assert.assertEquals("Complete call did not visit all interception points.", s_visitMask, 8209);
            Assert.assertEquals("Exception thrown in wrong place", uNKNOWN.minor, 16);
            return;
        }
        Assert.fail("expected exception");
    }

    public void testToRecvRequestSCReceiveException() {
        s_throwExcept = 8208;
        try {
            this.m_cltRef.hello("A message from testToRecvRequestSCReceiveException()...");
        }
        catch (UNKNOWN uNKNOWN) {
            Assert.assertEquals("Complete call did not visit all interception points.", s_visitMask, 8209);
            Assert.assertEquals("Exception thrown in wrong place", uNKNOWN.minor, 8208);
            return;
        }
        Assert.fail("expected exception");
    }

    public void testToRecvRequest() {
        s_throwExcept = 32;
        try {
            this.m_cltRef.hello("A message from testToRecvRequest()...");
        }
        catch (UNKNOWN uNKNOWN) {
            Assert.assertEquals("Complete call did not visit all interception points.", s_visitMask, 8241);
            Assert.assertEquals("Exception thrown in wrong place", uNKNOWN.minor, 32);
            return;
        }
        Assert.fail("expected exception");
    }

    public void testToRecvRequestRecvExcept() {
        s_throwExcept = 8224;
        try {
            this.m_cltRef.hello("A message from testToRecvRequestRecvExcept()...");
        }
        catch (UNKNOWN uNKNOWN) {
            Assert.assertEquals("Complete call did not visit all interception points.", s_visitMask, 8241);
            Assert.assertEquals("Exception thrown in wrong place", uNKNOWN.minor, 8224);
            return;
        }
        Assert.fail("expected exception");
    }

    public void testToSendReply() {
        s_throwExcept = 256;
        try {
            this.m_cltRef.hello("A message from testToSendReply()...");
        }
        catch (UNKNOWN uNKNOWN) {
            Assert.assertEquals("Complete call did not visit all interception points.", s_visitMask, 8497);
            Assert.assertEquals("Exception thrown in wrong place", uNKNOWN.minor, 256);
            return;
        }
        Assert.fail("expected exception");
    }

    public void testToRecvReply() {
        s_throwExcept = 4096;
        try {
            this.m_cltRef.hello("A message from testToRecvReply()...");
        }
        catch (UNKNOWN uNKNOWN) {
            Assert.assertEquals("Complete call did not visit all interception points.", s_visitMask, 4401);
            Assert.assertEquals("Exception thrown in wrong place", uNKNOWN.minor, 4096);
            return;
        }
        Assert.fail("expected exception");
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$pi$PITest == null ? (class$org$openorb$test$pi$PITest = PITest.class$("org.openorb.test.pi.PITest")) : class$org$openorb$test$pi$PITest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class EmptyServerInterceptor
    extends LocalObject
    implements ServerRequestInterceptor {
        EmptyServerInterceptor() {
        }

        public String name() {
            return "";
        }

        public void destroy() {
        }

        public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
            s_visitMask = s_visitMask | 0x10;
            if (0 != (s_throwExcept & 0x10)) {
                throw new UNKNOWN(16, CompletionStatus.COMPLETED_NO);
            }
            serverRequestInfo.request_id();
            Assert.assertEquals("Operation name not correct", serverRequestInfo.operation(), "hello");
            Assert.assertTrue("No response expected for request with response", serverRequestInfo.response_expected());
            Assert.assertEquals("Incorrect sync scope", (int)serverRequestInfo.sync_scope(), 3);
            try {
                serverRequestInfo.get_request_service_context(1146060545);
                s_visitMask = s_visitMask | 0x80;
                serverRequestInfo.set_slot(s_slotID, s_any);
            }
            catch (BAD_PARAM bAD_PARAM) {
            }
            catch (InvalidSlot invalidSlot) {
                Assert.fail("unexpected exception received: " + invalidSlot);
            }
        }

        public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
            s_visitMask = s_visitMask | 0x20;
            if (0 != (s_throwExcept & 0x20)) {
                throw new UNKNOWN(32, CompletionStatus.COMPLETED_NO);
            }
            serverRequestInfo.object_id();
            serverRequestInfo.adapter_id();
            serverRequestInfo.target_most_derived_interface();
            Assert.assertTrue("target does not implement object", serverRequestInfo.target_is_a("IDL:omg.org/CORBA/Object:1.0"));
            try {
                serverRequestInfo.arguments();
            }
            catch (NO_RESOURCES nO_RESOURCES) {
                // empty catch block
            }
            try {
                serverRequestInfo.exceptions();
            }
            catch (NO_RESOURCES nO_RESOURCES) {
                // empty catch block
            }
            try {
                serverRequestInfo.contexts();
            }
            catch (NO_RESOURCES nO_RESOURCES) {
                // empty catch block
            }
            try {
                serverRequestInfo.operation_context();
            }
            catch (NO_RESOURCES nO_RESOURCES) {
                // empty catch block
            }
        }

        public void send_reply(ServerRequestInfo serverRequestInfo) {
            s_visitMask = s_visitMask | 0x100;
            if (0 != (s_throwExcept & 0x100)) {
                throw new UNKNOWN(256, CompletionStatus.COMPLETED_YES);
            }
            try {
                if (serverRequestInfo.get_slot(s_slotID).type().kind() != TCKind.tk_null) {
                    serverRequestInfo.add_reply_service_context(new ServiceContext(1146060545, new byte[0]), true);
                    s_visitMask = s_visitMask | 0x800;
                }
            }
            catch (InvalidSlot invalidSlot) {
                Assert.fail(((Object)invalidSlot).toString());
            }
        }

        public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
            s_visitMask = s_visitMask | 0x200;
            Any any = serverRequestInfo.sending_exception();
            if (any.type().equals(UNKNOWNHelper.type()) && 0 != (s_throwExcept & 0x200)) {
                UNKNOWN uNKNOWN = UNKNOWNHelper.extract(serverRequestInfo.sending_exception());
                uNKNOWN.minor |= 0x200;
                uNKNOWN.completed = CompletionStatus.COMPLETED_YES;
                throw uNKNOWN;
            }
            try {
                serverRequestInfo.result();
            }
            catch (NO_RESOURCES nO_RESOURCES) {
                // empty catch block
            }
        }

        public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
            s_visitMask = s_visitMask | 0x400;
            if (0 != (s_throwExcept & 0x400)) {
                throw new UNKNOWN(1024, CompletionStatus.COMPLETED_YES);
            }
        }
    }

    static class EmptyClientInterceptor
    extends LocalObject
    implements ClientRequestInterceptor {
        EmptyClientInterceptor() {
        }

        public String name() {
            return "";
        }

        public void destroy() {
        }

        public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
            if ((s_visitMask & 1) != 0) {
                s_retryCount++;
            }
            s_visitMask = 1;
            if (s_throwExcept == 1) {
                throw new UNKNOWN(1, CompletionStatus.COMPLETED_NO);
            }
            try {
                if (clientRequestInfo.get_slot(s_slotID).type().kind() != TCKind.tk_null) {
                    clientRequestInfo.add_request_service_context(new ServiceContext(1146060545, new byte[0]), true);
                    s_visitMask = s_visitMask | 8;
                }
            }
            catch (InvalidSlot invalidSlot) {
                Assert.fail(((Object)invalidSlot).toString());
            }
            clientRequestInfo.request_id();
            Assert.assertEquals("Operation name not correct", clientRequestInfo.operation(), "hello");
            Assert.assertTrue("No response expected for request with response", clientRequestInfo.response_expected());
            Assert.assertEquals("Incorrect sync scope", (int)clientRequestInfo.sync_scope(), 3);
            clientRequestInfo.target();
            clientRequestInfo.effective_target();
            clientRequestInfo.effective_profile();
            clientRequestInfo.get_effective_component(1);
            clientRequestInfo.get_effective_components(1);
            try {
                clientRequestInfo.arguments();
            }
            catch (NO_RESOURCES nO_RESOURCES) {
                // empty catch block
            }
            try {
                clientRequestInfo.exceptions();
            }
            catch (NO_RESOURCES nO_RESOURCES) {
                // empty catch block
            }
            try {
                clientRequestInfo.contexts();
            }
            catch (NO_RESOURCES nO_RESOURCES) {
                // empty catch block
            }
            try {
                clientRequestInfo.operation_context();
            }
            catch (NO_RESOURCES nO_RESOURCES) {
                // empty catch block
            }
        }

        public void send_poll(ClientRequestInfo clientRequestInfo) {
            s_visitMask = s_visitMask | 2;
            if ((s_throwExcept & 2) != 0) {
                throw new UNKNOWN(2, CompletionStatus.COMPLETED_YES);
            }
        }

        public void receive_reply(ClientRequestInfo clientRequestInfo) {
            s_visitMask = s_visitMask | 0x1000;
            if (0 != (s_throwExcept & 0x1000)) {
                throw new UNKNOWN(4096, CompletionStatus.COMPLETED_YES);
            }
            try {
                clientRequestInfo.get_reply_service_context(1146060545);
                s_visitMask = s_visitMask | 0x8000;
            }
            catch (BAD_PARAM bAD_PARAM) {
                // empty catch block
            }
            try {
                clientRequestInfo.result();
            }
            catch (NO_RESOURCES nO_RESOURCES) {
                // empty catch block
            }
        }

        public void receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
            s_visitMask = s_visitMask | 0x4000;
            if (0 != (s_throwExcept & 0x4000)) {
                throw new UNKNOWN(16384, CompletionStatus.COMPLETED_YES);
            }
        }

        public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
            s_visitMask = s_visitMask | 0x2000;
            if (clientRequestInfo.received_exception_id().equals(UNKNOWNHelper.id()) && 0 != (s_throwExcept & 0x2000)) {
                UNKNOWN uNKNOWN = UNKNOWNHelper.extract(clientRequestInfo.received_exception());
                uNKNOWN.minor |= 0x2000;
                throw uNKNOWN;
            }
        }
    }

    static class EmptyIORInterceptor
    extends LocalObject
    implements IORInterceptor {
        EmptyIORInterceptor() {
        }

        public String name() {
            return "";
        }

        public void destroy() {
        }

        public void establish_components(IORInfo iORInfo) {
            iORInfo.add_ior_component(new TaggedComponent(1146060545, new byte[0]));
        }
    }

    public static class EmptyInitializer
    extends LocalObject
    implements ORBInitializer {
        public void pre_init(ORBInitInfo oRBInitInfo) {
            try {
                s_slotID = oRBInitInfo.allocate_slot_id();
                oRBInitInfo.add_server_request_interceptor(new EmptyServerInterceptor());
                oRBInitInfo.add_client_request_interceptor(new EmptyClientInterceptor());
                oRBInitInfo.add_ior_interceptor(new EmptyIORInterceptor());
            }
            catch (DuplicateName duplicateName) {
                Assert.fail("unexpected exception received: " + duplicateName);
            }
        }

        public void post_init(ORBInitInfo oRBInitInfo) {
        }
    }

    static class HelloImpl
    extends HelloPOA {
        private POA m_poa;

        HelloImpl(POA pOA) {
            this.m_poa = pOA;
        }

        public void hello(String string) {
            System.out.println(string);
        }

        public POA _default_POA() {
            return this.m_poa;
        }
    }
}

