/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OctetSeqHolder;
import org.openorb.io.Scrap;

public class StorageBuffer {
    private int m_avail;
    private Scrap m_mark;
    private int m_markavail;
    private Scrap m_head;
    private Scrap m_temp_head = new Scrap();
    private Scrap m_tail;
    private boolean m_read_write_mode;

    public StorageBuffer(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n2 + n > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.m_head = new Scrap();
        this.m_avail = n2;
        this.m_head.fBuffer = byArray;
        this.m_head.fOffset = n;
        this.m_head.fLength = n2;
        this.m_head.fPosition = n2;
        this.m_head.fMode = 3;
    }

    public StorageBuffer(InputStream inputStream, int n) throws IOException {
        this(null, 0, 0, inputStream, n);
    }

    public StorageBuffer(byte[] byArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4;
        int n5;
        Scrap scrap;
        if (byArray != null && (n < 0 || n2 < 0 || n2 + n > byArray.length || inputStream != null && n2 > n3)) {
            throw new IndexOutOfBoundsException();
        }
        Scrap scrap2 = scrap = new Scrap();
        boolean bl = false;
        this.m_avail = n3;
        if (byArray == null || n2 == 0) {
            scrap.fPosition = 0;
            scrap.fBuffer = null;
        } else {
            if (inputStream == null) {
                scrap.fBuffer = new byte[n2];
                scrap.fOffset = 0;
                scrap.fLength = n2;
                scrap.fPosition = n2;
                scrap.fMode = 0;
                System.arraycopy(byArray, n, scrap.fBuffer, 0, n2);
                this.m_head = scrap2;
                this.m_avail = n2;
                return;
            }
            n5 = n3 > 2048 ? 2048 : n3;
            scrap.fBuffer = new byte[n5];
            scrap.fOffset = 0;
            scrap.fLength = n5;
            scrap.fPosition = n5;
            scrap.fMode = 0;
            System.arraycopy(byArray, n, scrap.fBuffer, 0, n2);
            n5 -= n2;
            n3 -= n2;
            int n6 = n2;
            while (n5 > 0) {
                try {
                    n4 = inputStream.read(scrap.fBuffer, n6, n5);
                }
                catch (InterruptedIOException interruptedIOException) {
                    bl = true;
                    n4 = interruptedIOException.bytesTransferred;
                }
                if (n4 >= 0) {
                    n6 += n4;
                    n5 -= n4;
                    n3 -= n4;
                    continue;
                }
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                throw new EOFException("EOF reached when reading message");
            }
        }
        while (n3 > 0) {
            n5 = n3 > 2048 ? 2048 : n3;
            Scrap scrap3 = new Scrap();
            scrap3.fBuffer = new byte[n5];
            scrap3.fOffset = 0;
            scrap3.fLength = n5;
            scrap3.fPosition = scrap.fPosition + n5;
            scrap3.fMode = 0;
            n4 = 0;
            while (n5 > 0) {
                int n7;
                try {
                    n7 = inputStream.read(scrap3.fBuffer, n4, n5);
                }
                catch (InterruptedIOException interruptedIOException) {
                    bl = true;
                    n7 = interruptedIOException.bytesTransferred;
                }
                if (n7 >= 0) {
                    n4 += n7;
                    n5 -= n7;
                    n3 -= n7;
                    continue;
                }
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                throw new EOFException("error: EOF reached when reading message");
            }
            scrap.fNext = scrap3;
            scrap = scrap3;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        this.m_head = scrap2.fBuffer == null ? scrap2.fNext : scrap2;
    }

    StorageBuffer(Scrap scrap, int n) {
        this.m_head = scrap;
        this.m_tail = null;
        this.m_avail = n;
    }

    StorageBuffer(Scrap scrap, Scrap scrap2) {
        this.m_head = scrap;
        this.m_tail = scrap2;
        this.m_avail = scrap2.fPosition - scrap2.fLength - scrap.fPosition + scrap.fLength;
    }

    public int available() {
        return this.m_avail;
    }

    /*
     * Unable to fully structure code
     */
    public void writeTo(OutputStream var1_1) throws IOException {
        block11: {
            if (this.m_head == null) {
                throw new EOFException("Buffer is empty");
            }
            var2_2 = Thread.interrupted();
            if (!this.m_read_write_mode) ** GOTO lbl34
            while (this.m_head != this.m_tail) {
                if (this.m_head.fMode == 3) {
                    var3_4 = new byte[this.m_head.fLength];
                    System.arraycopy(this.m_head.fBuffer, this.m_head.fOffset, var3_4, 0, this.m_head.fLength);
                    this.m_head.fBuffer = var3_4;
                    this.m_head.fOffset = 0;
                    this.m_head.fMode = 0;
                }
                var3_3 = 0;
                while (var3_3 < this.m_head.fLength) {
                    try {
                        var1_1.write(this.m_head.fBuffer, this.m_head.fOffset + var3_3, this.m_head.fLength - var3_3);
                        break;
                    }
                    catch (InterruptedIOException var4_6) {
                        var2_2 = true;
                        var3_3 += var4_6.bytesTransferred;
                    }
                }
                this.m_head = this.m_head.fNext;
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                var3_5 = 0;
                while (var3_5 < this.m_head.fLength) {
                    try {
                        var1_1.write(this.m_head.fBuffer, this.m_head.fOffset + var3_5, this.m_head.fLength - var3_5);
                        break;
                    }
                    catch (InterruptedIOException var4_7) {
                        var2_2 = true;
                        var3_5 += var4_7.bytesTransferred;
                    }
                }
                this.m_head = this.m_head.fNext;
lbl34:
                // 2 sources

                ** while (this.m_head != this.m_tail)
            }
        }
        this.m_head = null;
        this.m_avail = 0;
        if (var2_2) {
            Thread.currentThread().interrupt();
        }
    }

    public int next(OctetSeqHolder octetSeqHolder, IntHolder intHolder, IntHolder intHolder2) {
        if (this.m_head == null) {
            octetSeqHolder.value = null;
            intHolder.value = 0;
            return -1;
        }
        if (intHolder2.value < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.m_read_write_mode && this.m_head.fMode == 3) {
            byte[] byArray = new byte[this.m_head.fLength];
            System.arraycopy(this.m_head.fBuffer, this.m_head.fOffset, byArray, 0, this.m_head.fLength);
            this.m_head.fBuffer = byArray;
            this.m_head.fOffset = 0;
            this.m_head.fMode = 0;
        }
        octetSeqHolder.value = this.m_head.fBuffer;
        intHolder.value = this.m_head.fOffset;
        if (intHolder2.value < this.m_head.fLength) {
            int n = intHolder2.value;
            intHolder2.value = 0;
            if (this.m_mark == null && this.m_tail == null || this.m_head == this.m_temp_head) {
                this.m_head.fOffset += n;
                this.m_head.fLength -= n;
            } else {
                this.m_temp_head.fBuffer = this.m_head.fBuffer;
                this.m_temp_head.fOffset = this.m_head.fOffset + n;
                this.m_temp_head.fLength = this.m_head.fLength - n;
                this.m_temp_head.fMode = this.m_head.fMode | 1;
                this.m_temp_head.fPosition = this.m_head.fPosition;
                this.m_temp_head.fNext = this.m_head.fNext;
                this.m_head = this.m_temp_head;
            }
            this.m_avail -= n;
            return n;
        }
        int n = this.m_head.fLength;
        intHolder2.value -= n;
        this.m_head = this.m_head.fNext;
        if (this.m_head == this.m_tail) {
            this.m_head = null;
        }
        this.m_avail -= n;
        return n;
    }

    public int skip(IntHolder intHolder) {
        if (this.m_head == null) {
            return -1;
        }
        int n = 0;
        while (this.m_head != null && intHolder.value >= this.m_head.fLength) {
            intHolder.value -= this.m_head.fLength;
            this.m_avail -= this.m_head.fLength;
            n += this.m_head.fLength;
            this.m_head = this.m_head.fNext;
            if (this.m_head != this.m_tail) continue;
            this.m_head = null;
        }
        if (this.m_head != null && intHolder.value > 0) {
            if (this.m_mark == null && this.m_tail == null || this.m_head == this.m_temp_head) {
                this.m_head.fOffset += intHolder.value;
                this.m_head.fLength -= intHolder.value;
            } else {
                this.m_temp_head.fBuffer = this.m_head.fBuffer;
                this.m_temp_head.fOffset = this.m_head.fOffset + intHolder.value;
                this.m_temp_head.fLength = this.m_head.fLength - intHolder.value;
                this.m_temp_head.fMode = this.m_head.fMode | 1;
                this.m_temp_head.fPosition = this.m_head.fPosition;
                this.m_temp_head.fNext = this.m_head.fNext;
                this.m_head = this.m_temp_head;
            }
            n += intHolder.value;
            this.m_avail -= intHolder.value;
            intHolder.value = 0;
        }
        return n;
    }

    public byte[] linearize() {
        if (this.m_head == null) {
            return new byte[0];
        }
        if (this.m_head.fLength != this.m_head.fBuffer.length || this.m_head.fNext != this.m_tail || this.m_head.fMode != 0 || this.m_head.fOffset != 0) {
            byte[] byArray = new byte[this.m_avail];
            Scrap scrap = this.m_head;
            int n = this.m_head.fPosition - this.m_head.fLength;
            while (scrap != this.m_tail) {
                try {
                    System.arraycopy(scrap.fBuffer, scrap.fOffset, byArray, n, scrap.fLength);
                }
                catch (Exception exception) {
                    return null;
                }
                n += scrap.fLength;
                scrap = scrap.fNext;
            }
            this.m_head.fBuffer = byArray;
            this.m_head.fOffset = 0;
            this.m_head.fLength = this.m_avail;
            this.m_head.fMode = 0;
            this.m_head.fPosition = this.m_head.fPosition - this.m_head.fLength + this.m_avail;
            this.m_head.fNext = this.m_tail;
        }
        return this.m_head.fBuffer;
    }

    public boolean isReadWriteMode() {
        return this.m_read_write_mode;
    }

    public void setReadWriteMode(boolean bl) {
        this.m_read_write_mode = bl;
    }

    public boolean mark() {
        if (this.m_mark == null) {
            this.m_mark = this.m_head;
            this.m_markavail = this.m_avail;
            return true;
        }
        return false;
    }

    public boolean reset() {
        if (this.m_mark != null) {
            this.m_head = this.m_mark;
            this.m_avail = this.m_markavail;
            this.m_mark = null;
            return true;
        }
        return false;
    }
}

