/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManagerOperations;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.openorb.io.HexPrintStream;
import org.openorb.net.Address;
import org.openorb.net.Transport;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NamingUtils;

public abstract class AbstractAddress
implements Address,
Cloneable {
    private TargetAddress m_key_addr;
    private TargetAddress m_profile_addr;
    private TargetAddress m_reference_addr;
    private PolicyManagerOperations m_policies;
    private TaggedComponent[] m_components;
    private Object[] m_component_data;
    private int m_from_this_profile;
    private Constructor m_ctor = null;
    private Object[] m_args = null;
    private short m_priority = 0;

    protected void set_ior(IOR iOR, int n) {
        if (iOR != null) {
            this.m_reference_addr = new TargetAddress();
            this.m_reference_addr.ior(new IORAddressingInfo(n, iOR));
            this.m_profile_addr = new TargetAddress();
            this.m_profile_addr.profile(iOR.profiles[n]);
        }
    }

    protected void set_oid(byte[] byArray) {
        if (byArray != null) {
            this.m_key_addr = new TargetAddress();
            this.m_key_addr.object_key(byArray);
        }
    }

    protected void set_policies(PolicyManagerOperations policyManagerOperations) {
        this.m_policies = policyManagerOperations;
    }

    protected void set_components(TaggedComponent[] taggedComponentArray, int n) {
        this.m_components = taggedComponentArray;
        this.m_from_this_profile = n;
        this.m_component_data = new Object[taggedComponentArray.length];
    }

    public TargetAddress getTargetAddress(short s) {
        switch (s) {
            case 2: {
                if (this.m_reference_addr == null) break;
                return this.m_reference_addr;
            }
            case 1: {
                if (this.m_profile_addr == null) break;
                return this.m_profile_addr;
            }
            case 0: {
                if (this.m_key_addr == null) break;
                return this.m_key_addr;
            }
        }
        throw new NO_IMPLEMENT(0, CompletionStatus.COMPLETED_NO);
    }

    public Policy[] get_target_policies(int[] nArray) {
        if (this.m_policies == null) {
            return new Policy[0];
        }
        return this.m_policies.get_policy_overrides(nArray);
    }

    public TaggedComponent[] get_components() {
        if (this.m_components == null) {
            return new TaggedComponent[0];
        }
        return this.m_components;
    }

    public int get_profile_components() {
        return this.m_from_this_profile;
    }

    public TaggedComponent[] get_components(int n) {
        if (this.m_components == null) {
            return new TaggedComponent[0];
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_components.length) {
            if (this.m_components[n3].tag == n) {
                ++n2;
            }
            ++n3;
        }
        TaggedComponent[] taggedComponentArray = new TaggedComponent[n2];
        int n4 = this.m_components.length - 1;
        while (n4 >= 0 && n2 > 0) {
            if (this.m_components[n4].tag == n) {
                taggedComponentArray[--n2] = this.m_components[n4];
            }
            --n4;
        }
        return taggedComponentArray;
    }

    public TaggedComponent get_component(int n) {
        if (this.m_components == null || n < 0 || n >= this.m_components.length) {
            throw new IndexOutOfBoundsException("No component at that index");
        }
        return this.m_components[n];
    }

    public Object get_component_data(int n) {
        if (this.m_components == null || n < 0 || n >= this.m_components.length) {
            throw new IndexOutOfBoundsException("No component at that index");
        }
        return this.m_component_data[n];
    }

    public void set_component_data(int n, Object object) {
        if (this.m_components == null || n < 0 || n >= this.m_components.length) {
            throw new IndexOutOfBoundsException("No component at that index");
        }
        this.m_component_data[n] = object;
    }

    public void setTransportConstructor(Constructor constructor, Object[] objectArray) {
        this.m_ctor = constructor;
        this.m_args = objectArray;
    }

    public Transport createTransport() {
        try {
            return (Transport)this.m_ctor.newInstance(this.m_args);
        }
        catch (Exception exception) {
            throw ExceptionTool.initCause(new INTERNAL("AbstractAddress::createTransport: Exception during creation of new Transport instance (" + exception + ")"), (Throwable)exception);
        }
    }

    public short getPriority() {
        return this.m_priority;
    }

    public short getPriority(short s) {
        return (short)(this.m_priority & s);
    }

    public void setPriority(short s) {
        this.m_priority = (short)(s & 0xFFF);
    }

    public short setPriority(short s, short s2) {
        this.m_priority = (short)(this.m_priority & ~s2 | s & 0xFFF & s2);
        return this.m_priority;
    }

    public String getObjectKeyString() {
        byte[] byArray = this.m_key_addr.object_key();
        try {
            String string = new String(byArray, "UTF-8");
            return NamingUtils.encodeRFC2396(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CascadingRuntimeException("Encoding is not supported ", unsupportedEncodingException);
        }
    }

    public String getObjectKeyDescription() {
        String string = this.getObjectKeyString();
        if (string.indexOf("%") < 0) {
            return "Corbaloc Object Key: " + string + "\n";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HexPrintStream hexPrintStream = new HexPrintStream(byteArrayOutputStream, 2);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        byte[] byArray = this.m_key_addr.object_key();
        if (byArray[0] != 0 || byArray[1] != 79 || byArray[2] != 79) {
            printStream.println("Non OpenORB Object Key:");
        } else if ((byArray[3] & 1) == 0) {
            printStream.println("OpenORB Persistent Object Key:");
        } else {
            printStream.println("OpenORB Nonpersistent Object Key:");
        }
        printStream.flush();
        try {
            hexPrintStream.write(byArray);
            hexPrintStream.flush();
        }
        catch (IOException iOException) {
            throw new CascadingRuntimeException("IOException during write or flush", iOException);
        }
        return byteArrayOutputStream.toString();
    }

    public int hashCode() {
        byte[] byArray = this.m_key_addr.object_key();
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n = 311 * n + byArray[n2];
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Address) || this.hashCode() != object.hashCode()) {
            return false;
        }
        if (!(object instanceof AbstractAddress)) {
            return false;
        }
        AbstractAddress abstractAddress = (AbstractAddress)object;
        if (this.m_key_addr != abstractAddress.m_key_addr && !Arrays.equals(this.m_key_addr.object_key(), abstractAddress.m_key_addr.object_key())) {
            return false;
        }
        abstractAddress.m_key_addr = this.m_key_addr;
        if (!this.m_ctor.equals(abstractAddress.m_ctor) || this.m_args.length != abstractAddress.m_args.length) {
            return false;
        }
        int n = 0;
        while (n < this.m_args.length) {
            if ((this.m_args[n] instanceof String || this.m_args[n] instanceof Number) && !this.m_args[n].equals(abstractAddress.m_args[n])) {
                return false;
            }
            ++n;
        }
        if (this.m_components.length != abstractAddress.m_components.length) {
            return false;
        }
        if (this.m_components != abstractAddress.m_components) {
            int n2;
            boolean[] blArray = new boolean[this.m_components.length];
            int n3 = 0;
            while (n3 < this.m_components.length) {
                n2 = 0;
                int n4 = 0;
                while (n4 < this.m_components.length) {
                    if (this.m_components[n3] == this.m_components[n4] || this.m_components[n3].tag == abstractAddress.m_components[n4].tag && Arrays.equals(this.m_components[n3].component_data, abstractAddress.m_components[n4].component_data)) {
                        abstractAddress.m_components[n4] = this.m_components[n3];
                        blArray[n4] = true;
                        n2 = 1;
                        break;
                    }
                    ++n4;
                }
                if (n2 == 0) {
                    return false;
                }
                ++n3;
            }
            n2 = 0;
            while (n2 < blArray.length) {
                if (!blArray[n2]) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public abstract String getEndpointDescription();

    public abstract String getEndpointString();

    public abstract String getProtocol();
}

