/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.adapter.poa;

import java.util.Arrays;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.openorb.test.ORBTestCase;
import org.openorb.test.adapter.poa.Hello;
import org.openorb.test.adapter.poa.HelloHelper;
import org.openorb.test.adapter.poa.HelloPOA;

public class POATest
extends ORBTestCase {
    static /* synthetic */ Class class$org$openorb$test$adapter$poa$POATest;

    public POATest(String string) {
        super(string);
    }

    protected void setUp() {
        Properties properties = new Properties();
        properties.setProperty("iiop.port", "17847");
        properties.setProperty("ssliop.port", "17848");
        this.setUp(properties);
    }

    public void testImplicitActivationRootPOA() throws UserException {
        ORB oRB = this.getORB();
        POA pOA = (POA)oRB.resolve_initial_references("RootPOA");
        Hello hello = new HelloImpl(pOA)._this(oRB);
        pOA.the_POAManager().activate();
        Hello hello2 = HelloHelper.narrow(this.forceMarshal(hello));
        hello2.hello("Test msg");
    }

    public void testDefaultPolicies() throws UserException {
        java.lang.Object object;
        Hello hello;
        ORB oRB = this.getORB();
        POA pOA = (POA)oRB.resolve_initial_references("RootPOA");
        pOA.the_POAManager().activate();
        Policy[] policyArray = new Policy[]{};
        POA pOA2 = pOA.create_POA("default", pOA.the_POAManager(), policyArray);
        HelloImpl helloImpl = new HelloImpl(pOA2);
        try {
            hello = helloImpl._this(oRB);
            Assert.fail("able to implicitly activate reference");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        byte[] byArray = pOA2.activate_object(helloImpl);
        hello = helloImpl._this();
        Hello hello2 = HelloHelper.narrow(this.forceMarshal(hello));
        hello2.hello("Test msg");
        try {
            object = pOA2.activate_object(helloImpl);
            Assert.fail("Able to reactivate servant");
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            // empty catch block
        }
        if (!Arrays.equals(pOA2.servant_to_id(helloImpl), byArray)) {
            Assert.fail("servant_to_id returned wrong id");
        }
        if (pOA2.id_to_servant(byArray) != helloImpl) {
            Assert.fail("id_to_servant returned wrong servant");
        }
        if (!Arrays.equals(pOA2.reference_to_id(hello), byArray)) {
            Assert.fail("reference_to_id returned wrong id for server reference");
        }
        if (!Arrays.equals(pOA2.reference_to_id(hello2), byArray)) {
            Assert.fail("reference_to_id returned wrong id for client reference");
        }
        if (!(object = (java.lang.Object)pOA2.id_to_reference(byArray))._is_equivalent(hello)) {
            Assert.fail("id_to_reference not equivalent to server reference");
        }
        if (!object._is_equivalent(hello2)) {
            Assert.fail("id_to_reference not equivalent to client reference");
        }
        Servant servant = pOA2.reference_to_servant(hello);
        Assert.assertEquals("reference to servant produced wrong servant", helloImpl, servant);
        Object object2 = pOA2.servant_to_reference(servant);
        if (!object2._is_equivalent(hello)) {
            Assert.fail("id_to_reference not equivalent to server reference");
        }
        if (!object2._is_equivalent(hello2)) {
            Assert.fail("id_to_reference not equivalent to client reference");
        }
        pOA2.deactivate_object(byArray);
        try {
            hello2.hello("Deactivated");
            Assert.fail("Able to call deactivated servant");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        pOA2.activate_object_with_id(byArray, helloImpl);
        hello2.hello("Reactivated");
        pOA2.destroy(true, true);
        try {
            hello2.hello("Deactivated POA");
            Assert.fail("Able to call deactivated poa");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        pOA2 = pOA.create_POA("default", pOA.the_POAManager(), policyArray);
        try {
            pOA2.activate_object_with_id(byArray, helloImpl);
            Assert.fail("Able to reactivate reference from recreated POA");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    public void testUserIDPolicy() throws UserException {
        ORB oRB = this.getORB();
        POA pOA = (POA)oRB.resolve_initial_references("RootPOA");
        pOA.the_POAManager().activate();
        Policy[] policyArray = new Policy[]{pOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
        POA pOA2 = pOA.create_POA("UID", pOA.the_POAManager(), policyArray);
        HelloImpl helloImpl = new HelloImpl(pOA2);
        byte[] byArray = "Carwash\u00feMy\u00fdCar".getBytes();
        pOA2.activate_object_with_id(byArray, helloImpl);
        Hello hello = helloImpl._this();
        Object object = pOA2.id_to_reference(byArray);
        if (!object._is_equivalent(hello)) {
            Assert.fail("id_to_reference not equivalent to server reference");
        }
        Hello hello2 = HelloHelper.narrow(this.forceMarshal(hello));
        hello2.hello("Test msg");
    }

    public void testNonRetainDefaultServant() throws UserException {
        ORB oRB = this.getORB();
        POA pOA = (POA)oRB.resolve_initial_references("RootPOA");
        Policy[] policyArray = new Policy[]{pOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), pOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT)};
        POA pOA2 = pOA.create_POA("NR+DS", pOA.the_POAManager(), policyArray);
        HelloImpl helloImpl = new HelloImpl(pOA2);
        pOA2.set_servant(helloImpl);
        Hello hello = HelloHelper.narrow(pOA2.create_reference(HelloHelper.id()));
        Hello hello2 = HelloHelper.narrow(pOA2.create_reference(HelloHelper.id()));
        pOA.the_POAManager().activate();
        Hello hello3 = HelloHelper.narrow(this.forceMarshal(hello));
        Hello hello4 = HelloHelper.narrow(this.forceMarshal(hello2));
        hello3.hello("Test msg");
        hello4.hello("Test msg");
    }

    public void testPersistanceAndActivators() throws UserException {
        ORB oRB = this.getORB();
        POA pOA = (POA)oRB.resolve_initial_references("RootPOA");
        MyAdapterActivator myAdapterActivator = new MyAdapterActivator();
        pOA.the_activator(myAdapterActivator);
        pOA.the_POAManager().activate();
        POA pOA2 = pOA.find_POA("APU", true);
        POA pOA3 = pOA.find_POA("APS", true);
        POA pOA4 = pOA.find_POA("ATU", true);
        POA pOA5 = pOA.find_POA("LTS", true);
        Hello hello = HelloHelper.narrow(pOA2.create_reference_with_id("APU".getBytes(), HelloHelper.id()));
        Hello hello2 = HelloHelper.narrow(pOA3.create_reference(HelloHelper.id()));
        Hello hello3 = HelloHelper.narrow(pOA4.create_reference_with_id("ATU".getBytes(), HelloHelper.id()));
        Hello hello4 = HelloHelper.narrow(pOA5.create_reference(HelloHelper.id()));
        byte[] byArray = pOA2.reference_to_id(hello);
        byte[] byArray2 = pOA3.reference_to_id(hello2);
        byte[] byArray3 = pOA4.reference_to_id(hello3);
        byte[] byArray4 = pOA5.reference_to_id(hello4);
        Properties properties = new Properties();
        properties.setProperty("openorb.useStaticThreadGroup", "true");
        properties.setProperty("openorb.server.enable", "false");
        ORB oRB2 = ORB.init(new String[0], properties);
        Hello hello5 = HelloHelper.narrow(oRB2.string_to_object(oRB.object_to_string(hello)));
        Hello hello6 = HelloHelper.narrow(oRB2.string_to_object(oRB.object_to_string(hello2)));
        Hello hello7 = HelloHelper.narrow(oRB2.string_to_object(oRB.object_to_string(hello3)));
        Hello hello8 = HelloHelper.narrow(oRB2.string_to_object(oRB.object_to_string(hello4)));
        hello5.hello("Test APU");
        hello6.hello("Test APS");
        hello7.hello("Test ATU");
        hello7.hello("Test ATU Again (incarnate not called)");
        hello8.hello("Test LTS");
        hello8.hello("Test LTS Again (preinvoke called)");
        pOA2.destroy(true, true);
        pOA3.destroy(true, true);
        pOA4.destroy(true, true);
        pOA5.destroy(true, true);
        hello5.hello("Test APU POA Restarted by request");
        hello6.hello("Test APS POA Restarted by request");
        hello7.hello("Test ATS POA Restarted by request");
        hello8.hello("Test LTS POA Restarted by request");
        oRB = this.restartORB();
        pOA = (POA)oRB.resolve_initial_references("RootPOA");
        pOA.the_activator(myAdapterActivator);
        pOA.the_POAManager().activate();
        hello5.hello("Test APU ORB Restarted");
        hello6.hello("Test APS ORB Restarted");
        try {
            hello7.hello("Should not work");
            Assert.fail("Able to call reactivated poa");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        try {
            hello8.hello("Should not work");
            Assert.fail("Able to call reactivated poa");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$adapter$poa$POATest == null ? (class$org$openorb$test$adapter$poa$POATest = POATest.class$("org.openorb.test.adapter.poa.POATest")) : class$org$openorb$test$adapter$poa$POATest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class MyServantLocator
    extends LocalObject
    implements ServantLocator {
        public Servant preinvoke(byte[] byArray, POA pOA, String string, CookieHolder cookieHolder) throws ForwardRequest {
            try {
                System.out.println("Preinvoke on target with id:");
                ORBTestCase.writeVerboseHex(System.out, byArray);
            }
            catch (Exception exception) {
                System.out.println("[ERR : MyServantActivator] " + ((java.lang.Object)exception).toString());
            }
            return new HelloImpl(pOA);
        }

        public void postinvoke(byte[] byArray, POA pOA, String string, java.lang.Object object, Servant servant) {
            try {
                System.out.println("Postinvoke on target with id:");
                ORBTestCase.writeVerboseHex(System.out, byArray);
            }
            catch (Exception exception) {
                System.out.println("[ERR : MyServantActivator] " + ((java.lang.Object)exception).toString());
            }
        }
    }

    static class MyServantActivator
    extends LocalObject
    implements ServantActivator {
        MyServantActivator() {
        }

        public Servant incarnate(byte[] byArray, POA pOA) throws ForwardRequest {
            try {
                System.out.println("Incarnate on target with id:");
                ORBTestCase.writeVerboseHex(System.out, byArray);
            }
            catch (Exception exception) {
                System.out.println("[ERR : MyServantActivator] " + ((java.lang.Object)exception).toString());
            }
            return new HelloImpl(pOA);
        }

        public void etherealize(byte[] byArray, POA pOA, Servant servant, boolean bl, boolean bl2) {
            try {
                System.out.println("Etherialize on target with id:");
                ORBTestCase.writeVerboseHex(System.out, byArray);
            }
            catch (Exception exception) {
                System.out.println("[ERR : MyServantActivator] " + ((java.lang.Object)exception).toString());
            }
        }
    }

    static class MyAdapterActivator
    extends LocalObject
    implements AdapterActivator {
        MyAdapterActivator() {
        }

        public boolean unknown_adapter(POA pOA, String string) {
            try {
                boolean bl;
                Policy[] policyArray = new Policy[4];
                policyArray[0] = pOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER);
                switch (string.charAt(0)) {
                    case 'A': {
                        policyArray[1] = pOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN);
                        bl = false;
                        break;
                    }
                    case 'L': {
                        policyArray[1] = pOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN);
                        bl = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                switch (string.charAt(1)) {
                    case 'P': {
                        policyArray[2] = pOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
                        break;
                    }
                    case 'T': {
                        policyArray[2] = pOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                switch (string.charAt(2)) {
                    case 'U': {
                        policyArray[3] = pOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
                        break;
                    }
                    case 'S': {
                        policyArray[3] = pOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                POA pOA2 = pOA.create_POA(string, pOA.the_POAManager(), policyArray);
                if (bl) {
                    pOA2.set_servant_manager(new MyServantLocator());
                } else {
                    pOA2.set_servant_manager(new MyServantActivator());
                }
                System.out.println("Created adapter \"" + string + "\"");
                return true;
            }
            catch (Exception exception) {
                System.out.println("[ERR : MyAdapterActivator] " + ((java.lang.Object)exception).toString());
                return false;
            }
        }
    }

    static class HelloImpl
    extends HelloPOA {
        private POA m_poa;

        HelloImpl(POA pOA) {
            this.m_poa = pOA;
        }

        public void hello(String string) {
            try {
                System.out.println("Hello message: \"" + string + "\" with id:");
                ORBTestCase.writeVerboseHex(System.out, this._object_id());
            }
            catch (Exception exception) {
                System.out.println("[ERR : HelloImpl] " + ((java.lang.Object)exception).toString());
            }
        }

        public POA _default_POA() {
            return this.m_poa;
        }
    }
}

