/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.iiop.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanSeqHelper;
import org.omg.CORBA.CharSeqHelper;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.DoubleSeqHelper;
import org.omg.CORBA.FloatSeqHelper;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.LongLongSeqHelper;
import org.omg.CORBA.LongSeqHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.ShortSeqHelper;
import org.omg.CORBA.StringSeqHelper;
import org.omg.CORBA.StringValueHelper;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ULongLongSeqHelper;
import org.omg.CORBA.ULongSeqHelper;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UShortSeqHelper;
import org.omg.CORBA.UserException;
import org.omg.CORBA.WCharSeqHelper;
import org.omg.CORBA.WStringSeqHelper;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.POA;
import org.openorb.test.ORBTestCase;
import org.openorb.test.iiop.primitive.Echo;
import org.openorb.test.iiop.primitive.EchoHelper;
import org.openorb.test.iiop.primitive.EchoPOA;

public class PrimitiveTest
extends ORBTestCase {
    private Echo m_svrRef;
    private Echo m_cltRef;
    private ORB m_orb;
    private Any m_any;
    private Any m_rpl;
    static /* synthetic */ Class class$org$openorb$test$iiop$primitive$PrimitiveTest;

    public PrimitiveTest(String string) {
        super(string);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.m_orb = this.getORB();
            POA pOA = (POA)this.m_orb.resolve_initial_references("RootPOA");
            this.m_svrRef = new EchoImpl(pOA)._this(this.m_orb);
            pOA.the_POAManager().activate();
            this.m_cltRef = EchoHelper.narrow(this.forceMarshal(this.m_svrRef));
            this.m_any = this.m_orb.create_any();
        }
        catch (UserException userException) {
            Assert.fail("exception during setup:" + ((java.lang.Object)userException).toString());
        }
    }

    public void testBasicOperations() {
        Assert.assertTrue("Object is local", !((ObjectImpl)((java.lang.Object)this.m_cltRef))._is_local());
        Assert.assertTrue("Object does not exist", !this.m_cltRef._non_existent());
        Assert.assertTrue("Object is not a \"IDL:omg.org/CORBA/Object:1.0\"", this.m_cltRef._is_a("IDL:omg.org/CORBA/Object:1.0"));
        String string = EchoHelper.id();
        string = string.substring(0, string.lastIndexOf(46));
        String string2 = string + ".0";
        String string3 = string + ".2";
        Assert.assertTrue("Object is not a \"" + EchoHelper.id() + "\"", this.m_cltRef._is_a(EchoHelper.id()));
        Assert.assertTrue("Object is not a \"" + string2 + "\"", this.m_cltRef._is_a(string2));
        Assert.assertTrue("Object is a \"" + string3 + "\"", !this.m_cltRef._is_a(string3));
        Assert.assertTrue("Object is a \"IDL:com.beezwax/Bumblebee:1.0\"", !this.m_cltRef._is_a("IDL:com.beezwax/Bumblebee:1.0"));
        DomainManager[] domainManagerArray = this.m_cltRef._get_domain_managers();
        try {
            this.m_cltRef._get_interface_def();
        }
        catch (INTF_REPOS iNTF_REPOS) {
            // empty catch block
        }
        this.m_cltRef.toString();
    }

    public void testLocalInvocation() {
        Assert.assertTrue("Object is not local", ((ObjectImpl)((java.lang.Object)this.m_svrRef))._is_local());
        Assert.assertTrue("Object does not exist", !this.m_svrRef._non_existent());
        Assert.assertTrue("Object is not a \"IDL:omg.org/CORBA/Object:1.0\"", this.m_svrRef._is_a("IDL:omg.org/CORBA/Object:1.0"));
        Assert.assertTrue("Object is not a \"" + EchoHelper.id() + "\"", this.m_svrRef._is_a(EchoHelper.id()));
        Assert.assertTrue("Object is a \"IDL:com.beezwax/Bumblebee:1.0\"", !this.m_svrRef._is_a("IDL:com.beezwax/Bumblebee:1.0"));
        DomainManager[] domainManagerArray = this.m_svrRef._get_domain_managers();
        try {
            this.m_svrRef._get_interface_def();
        }
        catch (INTF_REPOS iNTF_REPOS) {
            // empty catch block
        }
        this.m_svrRef.ping();
    }

    public void testInterORBInvocation() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("openorb.useStaticThreadGroup", "true");
        ORB oRB = ORB.init(new String[0], properties);
        Object object = oRB.string_to_object(this.m_orb.object_to_string(this.m_svrRef));
        Assert.assertTrue("Object is local", !((ObjectImpl)object)._is_local());
        Assert.assertTrue("Object does not exist", !object._non_existent());
        EchoHelper.narrow(this.m_svrRef).ping();
        oRB.shutdown(true);
    }

    public void testObject() {
        Assert.assertTrue("Object is not equivalent to self", this.m_cltRef.echo_Object(this.m_cltRef)._is_equivalent(this.m_cltRef));
        this.m_any.insert_Object(this.m_cltRef);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue("failed object reference any contained", this.m_any.equal(this.m_rpl));
        Assert.assertTrue("failed object reference any", this.m_rpl.extract_Object()._is_equivalent(this.m_cltRef));
    }

    public void testValuetypes() {
        String string = "String as Serializable";
        this.m_any.insert_Value((Serializable)((java.lang.Object)string), StringValueHelper.type());
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue("failed valuetype any contained", this.m_any.equal(this.m_rpl));
        Assert.assertTrue("failed valuetype any", ((String)((java.lang.Object)this.m_rpl.extract_Value())).equals(string));
    }

    public void testVoid() {
        this.m_cltRef.ping();
        this.m_any.type(this.m_orb.get_primitive_tc(TCKind.tk_void));
        if (this.m_cltRef.echo_any(this.m_any).type().kind() != TCKind.tk_void) {
            Assert.fail("failed any void");
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed typecode void");
        }
    }

    public void testThrowException() {
        try {
            this.m_cltRef.raise_exception();
            Assert.fail("exception not raised");
        }
        catch (UNKNOWN uNKNOWN) {
            // empty catch block
        }
    }

    public void testBoolean() {
        boolean[] blArray = new boolean[]{true, false};
        int n = 0;
        while (n < blArray.length) {
            if (this.m_cltRef.echo_boolean(blArray[n]) != blArray[n]) {
                Assert.fail("failed boolean " + (blArray[n] ? "true" : "false"));
            }
            this.m_any.insert_boolean(blArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for boolean any " + (blArray[n] ? "true" : "false"));
            }
            if (this.m_rpl.extract_boolean() != blArray[n]) {
                Assert.fail("failed boolean any " + (blArray[n] ? "true" : "false"));
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed boolean typecode");
        }
        if (!Arrays.equals(blArray, this.m_cltRef.echo_boolean_s(blArray))) {
            Assert.fail("Sequence test failed for boolean");
        }
        BooleanSeqHelper.insert(this.m_any, blArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed boolean seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for boolean any sequence");
        }
    }

    public void testOctet() {
        byte[] byArray = new byte[]{0, 1, 7, 31, -128, -1};
        int n = 0;
        while (n < byArray.length) {
            if (this.m_cltRef.echo_octet(byArray[n]) != byArray[n]) {
                Assert.fail("failed octet " + byArray[n]);
            }
            this.m_any.insert_octet(byArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for octet any " + byArray[n]);
            }
            if (this.m_rpl.extract_octet() != byArray[n]) {
                Assert.fail("failed octet any " + byArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed octet typecode");
        }
        if (!Arrays.equals(byArray, this.m_cltRef.echo_octet_s(byArray))) {
            Assert.fail("Sequence test failed for octet");
        }
        OctetSeqHelper.insert(this.m_any, byArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed octet seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for boolean any sequence");
        }
    }

    public void testShort() {
        short[] sArray = new short[]{0, 1, 255, 9029, 26471, -32649, -1};
        int n = 0;
        while (n < sArray.length) {
            if (this.m_cltRef.echo_short(sArray[n]) != sArray[n]) {
                Assert.fail("failed short " + sArray[n]);
            }
            this.m_any.insert_short(sArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for short any " + sArray[n]);
            }
            if (this.m_rpl.extract_short() != sArray[n]) {
                Assert.fail("failed short any " + sArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed short typecode");
        }
        if (!Arrays.equals(sArray, this.m_cltRef.echo_short_s(sArray))) {
            Assert.fail("Sequence test failed for short");
        }
        ShortSeqHelper.insert(this.m_any, sArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed short seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for short any sequence");
        }
    }

    public void testUShort() {
        short[] sArray = new short[]{0, 1, 255, 9029, 26471, -32649, -1};
        int n = 0;
        while (n < sArray.length) {
            if (this.m_cltRef.echo_ushort(sArray[n]) != sArray[n]) {
                Assert.fail("failed ushort " + sArray[n]);
            }
            this.m_any.insert_ushort(sArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for ushort any " + sArray[n]);
            }
            if (this.m_rpl.extract_ushort() != sArray[n]) {
                Assert.fail("failed ushort any " + sArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed ushort typecode");
        }
        if (!Arrays.equals(sArray, this.m_cltRef.echo_ushort_s(sArray))) {
            Assert.fail("Sequence test failed for ushort");
        }
        UShortSeqHelper.insert(this.m_any, sArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed ushort seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for ushort any sequence");
        }
    }

    public void testLong() {
        int[] nArray = new int[]{0, 1, 255, 65535, 16774777, -2146985868, -1, Integer.MAX_VALUE};
        int n = 0;
        while (n < nArray.length) {
            if (this.m_cltRef.echo_long(nArray[n]) != nArray[n]) {
                Assert.fail("failed long " + nArray[n]);
            }
            this.m_any.insert_long(nArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for long any " + nArray[n]);
            }
            if (this.m_rpl.extract_long() != nArray[n]) {
                Assert.fail("failed long any " + nArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed long typecode");
        }
        if (!Arrays.equals(nArray, this.m_cltRef.echo_long_s(nArray))) {
            Assert.fail("Sequence test failed for long");
        }
        LongSeqHelper.insert(this.m_any, nArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed long seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for long any sequence");
        }
    }

    public void testULong() {
        int[] nArray = new int[]{0, 1, 255, 65535, 16774777, -2146985868, -1, Integer.MAX_VALUE};
        int n = 0;
        while (n < nArray.length) {
            if (this.m_cltRef.echo_ulong(nArray[n]) != nArray[n]) {
                Assert.fail("failed ulong " + nArray[n]);
            }
            this.m_any.insert_ulong(nArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for ulong any " + nArray[n]);
            }
            if (this.m_rpl.extract_ulong() != nArray[n]) {
                Assert.fail("failed ulong any " + nArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed ulong typecode");
        }
        if (!Arrays.equals(nArray, this.m_cltRef.echo_ulong_s(nArray))) {
            Assert.fail("Sequence test failed for ulong");
        }
        ULongSeqHelper.insert(this.m_any, nArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed ulong seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for ulong any sequence");
        }
    }

    public void testLongLong() {
        long[] lArray = new long[]{0L, 1L, 255L, 65535L, 16774777L, 2147981428L, 0xFFFFFFFFL, Integer.MAX_VALUE, 17536898320163L, 8113243900342152443L, -1L, Long.MAX_VALUE};
        int n = 0;
        while (n < lArray.length) {
            if (this.m_cltRef.echo_longlong(lArray[n]) != lArray[n]) {
                Assert.fail("failed long long " + lArray[n]);
            }
            this.m_any.insert_longlong(lArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for long long any " + lArray[n]);
            }
            if (this.m_rpl.extract_longlong() != lArray[n]) {
                Assert.fail("failed long long any " + lArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed long long typecode");
        }
        if (!Arrays.equals(lArray, this.m_cltRef.echo_longlong_s(lArray))) {
            Assert.fail("Sequence test failed for long long");
        }
        LongLongSeqHelper.insert(this.m_any, lArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed long long seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for long long any sequence");
        }
    }

    public void testULongLong() {
        long[] lArray = new long[]{0L, 1L, 255L, 65535L, 16774777L, 2147981428L, 0xFFFFFFFFL, Integer.MAX_VALUE, 17536898320163L, 8113243900342152443L, -1L, Long.MAX_VALUE};
        int n = 0;
        while (n < lArray.length) {
            if (this.m_cltRef.echo_ulonglong(lArray[n]) != lArray[n]) {
                Assert.fail("failed ulonglong " + lArray[n]);
            }
            this.m_any.insert_ulonglong(lArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for ulonglong any " + lArray[n]);
            }
            if (this.m_rpl.extract_ulonglong() != lArray[n]) {
                Assert.fail("failed ulonglong any " + lArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed ulonglong typecode");
        }
        if (!Arrays.equals(lArray, this.m_cltRef.echo_ulonglong_s(lArray))) {
            Assert.fail("Sequence test failed for ulonglong");
        }
        ULongLongSeqHelper.insert(this.m_any, lArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed ulonglong seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for ulonglong any sequence");
        }
    }

    public void testFloat() {
        float[] fArray = new float[]{0.0f, -0.0f, Float.MAX_VALUE, Float.MIN_VALUE, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        int n = 0;
        while (n < fArray.length) {
            if (this.m_cltRef.echo_float(fArray[n]) != fArray[n]) {
                Assert.fail("failed float " + fArray[n]);
            }
            this.m_any.insert_float(fArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for float any " + fArray[n]);
            }
            if (this.m_rpl.extract_float() != fArray[n]) {
                Assert.fail("failed float any " + fArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed float typecode");
        }
        if (!Arrays.equals(fArray, this.m_cltRef.echo_float_s(fArray))) {
            Assert.fail("Sequence test failed for float");
        }
        FloatSeqHelper.insert(this.m_any, fArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed float seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for float any sequence");
        }
        if (!Float.isNaN(this.m_cltRef.echo_float(Float.NaN))) {
            Assert.fail("failed float NaN");
        }
        this.m_any.insert_float(Float.NaN);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for float any NaN");
        }
        if (!Float.isNaN(this.m_rpl.extract_float())) {
            Assert.fail("failed float any NaN");
        }
    }

    public void testDoubleEcho() {
        double[] dArray = new double[]{0.0, -0.0, Double.MAX_VALUE, Double.MIN_VALUE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        int n = 0;
        while (n < dArray.length) {
            if (this.m_cltRef.echo_double(dArray[n]) != dArray[n]) {
                Assert.fail("failed double " + dArray[n]);
            }
            this.m_any.insert_double(dArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for double any " + dArray[n]);
            }
            if (this.m_rpl.extract_double() != dArray[n]) {
                Assert.fail("failed double any " + dArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed double typecode");
        }
        if (!Arrays.equals(dArray, this.m_cltRef.echo_double_s(dArray))) {
            Assert.fail("Sequence test failed for double");
        }
        DoubleSeqHelper.insert(this.m_any, dArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed double seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for double any sequence");
        }
        if (!Double.isNaN(this.m_cltRef.echo_double(Double.NaN))) {
            Assert.fail("failed double NaN");
        }
        this.m_any.insert_double(Double.NaN);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for double any NaN");
        }
        if (!Double.isNaN(this.m_rpl.extract_double())) {
            Assert.fail("failed double any NaN");
        }
    }

    public void testChar() {
        char[] cArray;
        char[] cArray2 = cArray = new char[]{'\u0001', ' ', '\u00ff', '\u00e4', '\u00f6', '\u00fc', '\u00c4', '\u00d6', '\u00dc', '\u00df'};
        int n = 0;
        while (n < cArray2.length) {
            try {
                char c = this.m_cltRef.echo_char(cArray2[n]);
                if (c != cArray2[n]) {
                    Assert.fail("Failed char '" + cArray2[n] + "' at pos " + n + " send=" + cArray2[n] + " rcvd=" + c);
                }
                this.m_any.insert_char(cArray2[n]);
                this.m_rpl = this.m_cltRef.echo_any(this.m_any);
                if (!this.m_any.equal(this.m_rpl)) {
                    Assert.fail("Equality test failed for char any '" + cArray2[n] + "'");
                }
                if (this.m_rpl.extract_char() != cArray2[n]) {
                    Assert.fail("Failed char any '" + cArray2[n] + "'");
                }
            }
            catch (DATA_CONVERSION dATA_CONVERSION) {
                char[] cArray3 = cArray2;
                cArray2 = new char[cArray2.length - 1];
                System.arraycopy(cArray3, 0, cArray2, 0, n);
                if (n + 1 < cArray2.length) {
                    System.arraycopy(cArray3, n + 1, cArray2, n, cArray2.length - 1 - n);
                }
                --n;
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("Failed char typecode");
        }
        if (!Arrays.equals(cArray2, this.m_cltRef.echo_char_s(cArray2))) {
            Assert.fail("Sequence test failed for char");
        }
        CharSeqHelper.insert(this.m_any, cArray2);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("Failed char seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for char any sequence");
        }
    }

    public void testWChar() {
        char[] cArray = new char[]{'\u0001', ' ', '\u008d', '\u00ff', '\u0626', '\u7554', '\uf7f5', '\uffff', '\u00e4', '\u00f6', '\u00fc', '\u00c4', '\u00d6', '\u00dc', '\u00df'};
        int n = 0;
        while (n < cArray.length) {
            if (this.m_cltRef.echo_wchar(cArray[n]) != cArray[n]) {
                Assert.fail("failed wchar " + cArray[n]);
            }
            this.m_any.insert_wchar(cArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for wchar any " + cArray[n]);
            }
            if (this.m_rpl.extract_wchar() != cArray[n]) {
                Assert.fail("failed wchar any " + cArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed wchar typecode");
        }
        if (!Arrays.equals(cArray, this.m_cltRef.echo_wchar_s(cArray))) {
            Assert.fail("Sequence test failed for wchar");
        }
        WCharSeqHelper.insert(this.m_any, cArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed wchar seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for wchar any sequence");
        }
    }

    public void testStringEcho() {
        TypeCode typeCode;
        java.lang.Object[] objectArray = new String[]{"", "Mr Jock, T.V. quiz PhD, bags few lynx.", "\u0001\u0010\u007fm\u00ff", "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df"};
        int n = 0;
        while (n < objectArray.length) {
            if (!this.m_cltRef.echo_string(objectArray[n]).equals(objectArray[n])) {
                Assert.fail("Failed string at pos " + n + " '" + (String)objectArray[n] + "'");
            }
            this.m_any.insert_string(objectArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for string any " + (String)objectArray[n]);
            }
            if (!this.m_rpl.extract_string().equals(objectArray[n])) {
                Assert.fail("Failed string any '" + (String)objectArray[n] + "'");
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed string typecode");
        }
        if (!Arrays.equals(objectArray, this.m_cltRef.echo_string_s((String[])objectArray))) {
            Assert.fail("Sequence test failed for string");
        }
        StringSeqHelper.insert(this.m_any, (String[])objectArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("Failed string seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for string any sequence");
        }
        if (!this.m_cltRef.echo_TypeCode(typeCode = this.m_orb.create_string_tc(10)).equal(typeCode)) {
            Assert.fail("Failed string<10> typecode");
        }
    }

    public void testWStringEcho() {
        TypeCode typeCode;
        java.lang.Object[] objectArray = new String[]{"", "Mr Jock, T.V. quiz PhD, bags few lynx.", "\u0001\u0010\u007f\u008d\u00ff\u05dd\u7fde\u8d40\uffff", "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df"};
        int n = 0;
        while (n < objectArray.length) {
            if (!this.m_cltRef.echo_wstring(objectArray[n]).equals(objectArray[n])) {
                Assert.fail("failed wstring " + (String)objectArray[n]);
            }
            this.m_any.insert_wstring(objectArray[n]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail("Equality test failed for wstring any " + (String)objectArray[n]);
            }
            if (!this.m_rpl.extract_wstring().equals(objectArray[n])) {
                Assert.fail("failed wstring any " + (String)objectArray[n]);
            }
            ++n;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed wstring typecode");
        }
        if (!Arrays.equals(objectArray, this.m_cltRef.echo_wstring_s((String[])objectArray))) {
            Assert.fail("Sequence test failed for wstring");
        }
        WStringSeqHelper.insert(this.m_any, (String[])objectArray);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail("failed wstring seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail("Equality test failed for wstring any sequence");
        }
        if (!this.m_cltRef.echo_TypeCode(typeCode = this.m_orb.create_wstring_tc(10)).equal(typeCode)) {
            Assert.fail("failed wstring<10> typecode");
        }
    }

    public void testLargeBufferEcho() {
        byte[] byArray = new byte[0x100000];
        new Random().nextBytes(byArray);
        byte[] byArray2 = this.m_cltRef.echo_octet_s(byArray);
        if (!Arrays.equals(byArray, byArray2)) {
            Assert.fail("failed echo large buffer");
        }
    }

    public void testLargeStringSeqEcho() {
        java.lang.Object[] objectArray = new String[20000];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = new String("" + n);
            ++n;
        }
        java.lang.Object[] objectArray2 = this.m_cltRef.echo_string_s((String[])objectArray);
        if (!Arrays.equals(objectArray, objectArray2)) {
            Assert.fail("failed echo large buffer");
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$iiop$primitive$PrimitiveTest == null ? (class$org$openorb$test$iiop$primitive$PrimitiveTest = PrimitiveTest.class$("org.openorb.test.iiop.primitive.PrimitiveTest")) : class$org$openorb$test$iiop$primitive$PrimitiveTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class EchoImpl
    extends EchoPOA {
        private POA m_poa;

        EchoImpl(POA pOA) {
            this.m_poa = pOA;
        }

        public POA _default_POA() {
            return this.m_poa;
        }

        public void ping() {
        }

        public void raise_exception() {
            throw new UNKNOWN();
        }

        public boolean echo_boolean(boolean bl) {
            return bl;
        }

        public boolean[] echo_boolean_s(boolean[] blArray) {
            return blArray;
        }

        public byte echo_octet(byte by) {
            return by;
        }

        public byte[] echo_octet_s(byte[] byArray) {
            return byArray;
        }

        public short echo_short(short s) {
            return s;
        }

        public short[] echo_short_s(short[] sArray) {
            return sArray;
        }

        public short echo_ushort(short s) {
            return s;
        }

        public short[] echo_ushort_s(short[] sArray) {
            return sArray;
        }

        public int echo_long(int n) {
            return n;
        }

        public int[] echo_long_s(int[] nArray) {
            return nArray;
        }

        public int echo_ulong(int n) {
            return n;
        }

        public int[] echo_ulong_s(int[] nArray) {
            return nArray;
        }

        public long echo_longlong(long l) {
            return l;
        }

        public long[] echo_longlong_s(long[] lArray) {
            return lArray;
        }

        public long echo_ulonglong(long l) {
            return l;
        }

        public long[] echo_ulonglong_s(long[] lArray) {
            return lArray;
        }

        public float echo_float(float f) {
            return f;
        }

        public float[] echo_float_s(float[] fArray) {
            return fArray;
        }

        public double echo_double(double d) {
            return d;
        }

        public double[] echo_double_s(double[] dArray) {
            return dArray;
        }

        public char echo_char(char c) {
            return c;
        }

        public char[] echo_char_s(char[] cArray) {
            return cArray;
        }

        public char echo_wchar(char c) {
            return c;
        }

        public char[] echo_wchar_s(char[] cArray) {
            return cArray;
        }

        public String echo_string(String string) {
            return string;
        }

        public String[] echo_string_s(String[] stringArray) {
            return stringArray;
        }

        public String echo_wstring(String string) {
            return string;
        }

        public String[] echo_wstring_s(String[] stringArray) {
            return stringArray;
        }

        public Object echo_Object(Object object) {
            return object;
        }

        public Any echo_any(Any any) {
            return any;
        }

        public Any[] echo_any_s(Any[] anyArray) {
            return anyArray;
        }

        public TypeCode echo_TypeCode(TypeCode typeCode) {
            return typeCode;
        }
    }
}

