/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.DomainManagersListHelper;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyCurrent;
import org.omg.CORBA.PolicyCurrentHelper;
import org.omg.CORBA.PolicyListHolder;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerOperations;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedProfile;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.ObjectStub;
import org.openorb.CORBA.dii.ContextList;
import org.openorb.CORBA.dii.Environment;
import org.openorb.CORBA.dii.ExceptionList;
import org.openorb.CORBA.dii.Request;
import org.openorb.PI.CurrentImpl;
import org.openorb.io.HexPrintStream;
import org.openorb.net.Address;
import org.openorb.net.ClientBinding;
import org.openorb.net.ClientManager;
import org.openorb.net.ClientRequest;
import org.openorb.policy.ForceMarshalPolicy;
import org.openorb.policy.ORBPolicyManagerImpl;
import org.openorb.policy.PolicyReconciler;
import org.openorb.policy.PolicySetManager;
import org.openorb.util.ExceptionTool;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class Delegate
extends org.omg.CORBA_2_3.portable.Delegate {
    private final org.omg.CORBA.ORB m_orb;
    private final IOR m_ior;
    private final Logger m_logger;
    private final PolicyManagerOperations m_policyOver;
    private final PolicyCurrent m_policyCurr;
    private final PolicyReconciler m_orbReconciler;
    private final PolicyManager m_orbPolicyManager;
    private final PolicySetManager m_policySetManager;
    private final CurrentImpl m_piCurrent;
    private ClientManager m_clientManager;
    private long m_hash = -1L;
    private final java.lang.Object m_bindingSync = new byte[0];
    private IOR m_effectiveIor;
    private final Set m_bindings = new HashSet();
    private int m_bindingVersion = -1;
    private ClientBinding m_selectedBinding;

    public Delegate(org.omg.CORBA.ORB oRB, IOR iOR) {
        this(oRB, iOR, null);
    }

    protected Delegate(org.omg.CORBA.ORB oRB) {
        this.m_orb = oRB;
        this.m_ior = null;
        this.m_policyOver = null;
        this.m_policyCurr = null;
        this.m_orbReconciler = null;
        this.m_orbPolicyManager = null;
        this.m_policySetManager = null;
        this.m_piCurrent = null;
        this.m_logger = null;
    }

    protected Delegate(org.omg.CORBA.ORB oRB, IOR iOR, PolicyManagerOperations policyManagerOperations) {
        if (iOR == null || oRB == null) {
            throw new NullPointerException();
        }
        this.m_ior = iOR;
        this.m_effectiveIor = iOR;
        this.m_orb = oRB;
        this.m_policyOver = policyManagerOperations;
        this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        this.m_piCurrent = ((ORB)this.m_orb).getPICurrent();
        this.m_clientManager = (ClientManager)((ORB)this.m_orb).getFeature("ClientCPCManager");
        if (null == this.m_clientManager) {
            throw Trace.signalIllegalCondition(this.m_logger, "ClientCPCManager unavailable");
        }
        this.m_orbReconciler = (PolicyReconciler)((ORB)this.m_orb).getFeature("PolicyReconciler");
        if (null == this.m_orbReconciler) {
            this.m_logger.warn("PolicyReconciler unavailable");
        }
        this.m_policySetManager = (PolicySetManager)((ORB)this.m_orb).getFeature("PolicySetManager");
        if (null == this.m_policySetManager) {
            this.m_logger.warn("PolicySetManager unavailable");
        }
        PolicyCurrent policyCurrent = null;
        try {
            policyCurrent = PolicyCurrentHelper.narrow(this.m_orb.resolve_initial_references("PolicyCurrent"));
        }
        catch (InvalidName invalidName) {
            this.m_logger.warn("Unable to resolve PolicyCurrent.", invalidName);
        }
        this.m_policyCurr = policyCurrent;
        ORBPolicyManagerImpl oRBPolicyManagerImpl = null;
        try {
            oRBPolicyManagerImpl = (ORBPolicyManagerImpl)this.m_orb.resolve_initial_references("ORBPolicyManager");
        }
        catch (InvalidName invalidName) {
            this.m_logger.warn("Unable to resolve ORBPolicyManager.", invalidName);
        }
        this.m_orbPolicyManager = oRBPolicyManagerImpl;
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    private CurrentImpl getPICurrent() {
        return this.m_piCurrent;
    }

    public final org.omg.CORBA.ORB _getORB() {
        return this.m_orb;
    }

    public final IOR _getIOR() {
        return this.m_ior;
    }

    public final PolicyManagerOperations _getPolicyManagerOperations() {
        return this.m_policyOver;
    }

    public InterfaceDef get_interface(Object object) {
        return InterfaceDefHelper.narrow(this.get_interface_def(object));
    }

    private UNKNOWN createUnexpectedException(ApplicationException applicationException) {
        return (UNKNOWN)ExceptionTool.initCause(new UNKNOWN("Unexpected User Exception: " + applicationException.getId() + " (" + applicationException + ")", 1330446337, CompletionStatus.COMPLETED_YES), (Throwable)applicationException);
    }

    public Object get_interface_def(Object object) {
        RequestState requestState;
        while ((requestState = this.begin_invocation(object, false)).getBinding().getObjectAdapter() == null) {
            try {
                InputStream inputStream = null;
                try {
                    org.omg.CORBA.portable.OutputStream outputStream = this.request(object, "_interface", true);
                    inputStream = this.invoke(object, outputStream);
                    Object object2 = inputStream.read_Object();
                    java.lang.Object var7_14 = null;
                    this.releaseReply(object, inputStream);
                    return object2;
                }
                catch (Throwable throwable) {
                    java.lang.Object var7_15 = null;
                    this.releaseReply(object, inputStream);
                    throw throwable;
                }
            }
            catch (RemarshalException remarshalException) {
            }
            catch (ApplicationException applicationException) {
                this.getLogger().error("Application exception", applicationException);
                throw this.createUnexpectedException(applicationException);
            }
        }
        boolean bl = true;
        requestState.incrementLocalLevel();
        try {
            try {
                Object object3 = requestState.getBinding().get_interface_def();
                bl = false;
                Object object4 = object3;
                java.lang.Object var9_19 = null;
                requestState.completeInvocation(!bl);
                return object4;
            }
            catch (SystemException systemException) {
                requestState.receiveSystemException(object, systemException);
                bl = false;
                Object object5 = null;
                java.lang.Object var9_20 = null;
                requestState.completeInvocation(!bl);
                return object5;
            }
            catch (ForwardRequest forwardRequest) {
                IOR iOR = ((Delegate)((ObjectImpl)forwardRequest.forward)._get_delegate()).ior();
                requestState.receiveRedirect(object, iOR, false);
                bl = false;
                Object object6 = null;
                java.lang.Object var9_21 = null;
                requestState.completeInvocation(!bl);
                return object6;
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var9_22 = null;
            requestState.completeInvocation(!bl);
            throw throwable;
        }
    }

    public Object get_component(Object object) {
        RequestState requestState;
        while ((requestState = this.begin_invocation(object, false)).getBinding().getObjectAdapter() == null) {
            try {
                InputStream inputStream = null;
                try {
                    org.omg.CORBA.portable.OutputStream outputStream = this.request(object, "_component", true);
                    inputStream = this.invoke(object, outputStream);
                    Object object2 = inputStream.read_Object();
                    java.lang.Object var7_14 = null;
                    this.releaseReply(object, inputStream);
                    return object2;
                }
                catch (Throwable throwable) {
                    java.lang.Object var7_15 = null;
                    this.releaseReply(object, inputStream);
                    throw throwable;
                }
            }
            catch (RemarshalException remarshalException) {
            }
            catch (ApplicationException applicationException) {
                this.getLogger().error("Application exception:", applicationException);
                throw this.createUnexpectedException(applicationException);
            }
        }
        boolean bl = true;
        requestState.incrementLocalLevel();
        try {
            try {
                Object object3 = requestState.getBinding().get_component();
                bl = false;
                Object object4 = object3;
                java.lang.Object var9_19 = null;
                requestState.completeInvocation(!bl);
                return object4;
            }
            catch (SystemException systemException) {
                requestState.receiveSystemException(object, systemException);
                bl = false;
                Object object5 = null;
                java.lang.Object var9_20 = null;
                requestState.completeInvocation(!bl);
                return object5;
            }
            catch (ForwardRequest forwardRequest) {
                IOR iOR = ((Delegate)((ObjectImpl)forwardRequest.forward)._get_delegate()).ior();
                requestState.receiveRedirect(object, iOR, false);
                bl = false;
                Object object6 = null;
                java.lang.Object var9_21 = null;
                requestState.completeInvocation(!bl);
                return object6;
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var9_22 = null;
            requestState.completeInvocation(!bl);
            throw throwable;
        }
    }

    public boolean is_a(Object object, String string) {
        RequestState requestState;
        java.lang.Object object2 = RepoIDHelper.createIsATest(string);
        if (object2.equals("IDL:omg.org/CORBA/Object:1.0")) {
            return true;
        }
        if (object2.equals(this.m_ior.type_id)) {
            return true;
        }
        String[] stringArray = ((ObjectImpl)object)._ids();
        int n = 0;
        while (n < stringArray.length) {
            if (object2.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        while ((requestState = this.begin_invocation(object, false)).getBinding().getObjectAdapter() == null) {
            try {
                InputStream inputStream = null;
                try {
                    org.omg.CORBA.portable.OutputStream outputStream = this.request(object, "_is_a", true);
                    outputStream.write_string(string);
                    inputStream = this.invoke(object, outputStream);
                    boolean bl = inputStream.read_boolean();
                    java.lang.Object var11_18 = null;
                    this.releaseReply(object, inputStream);
                    return bl;
                }
                catch (Throwable throwable) {
                    java.lang.Object var11_19 = null;
                    this.releaseReply(object, inputStream);
                    throw throwable;
                }
            }
            catch (RemarshalException remarshalException) {
            }
            catch (ApplicationException applicationException) {
                this.getLogger().error("Application exception:", applicationException);
                throw this.createUnexpectedException(applicationException);
            }
        }
        boolean bl = true;
        requestState.incrementLocalLevel();
        try {
            try {
                boolean bl2 = requestState.getBinding().is_a(string);
                bl = false;
                boolean bl3 = bl2;
                java.lang.Object var13_23 = null;
                requestState.completeInvocation(!bl);
                return bl3;
            }
            catch (SystemException systemException) {
                requestState.receiveSystemException(object, systemException);
                bl = false;
                boolean bl4 = false;
                java.lang.Object var13_24 = null;
                requestState.completeInvocation(!bl);
                return bl4;
            }
            catch (ForwardRequest forwardRequest) {
                IOR iOR = ((Delegate)((ObjectImpl)forwardRequest.forward)._get_delegate()).ior();
                requestState.receiveRedirect(object, iOR, false);
                bl = false;
                boolean bl5 = false;
                java.lang.Object var13_25 = null;
                requestState.completeInvocation(!bl);
                return bl5;
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var13_26 = null;
            requestState.completeInvocation(!bl);
            throw throwable;
        }
    }

    public DomainManager[] get_domain_managers(Object object) {
        return this.get_domain_managers_and_policies(object, null, null);
    }

    private DomainManager[] get_domain_managers_and_policies(Object object, int[] nArray, PolicyListHolder policyListHolder) {
        RequestState requestState;
        while ((requestState = this.begin_invocation(object, false)).getBinding().getObjectAdapter() == null) {
            try {
                InputStream inputStream = null;
                try {
                    org.omg.CORBA.portable.OutputStream outputStream = this.request(object, "_get_domain_managers", true);
                    inputStream = this.invoke(object, outputStream);
                    DomainManager[] domainManagerArray = DomainManagersListHelper.read(inputStream);
                    if (policyListHolder != null) {
                        policyListHolder.value = requestState.getBinding().getAddress().get_target_policies(nArray);
                    }
                    DomainManager[] domainManagerArray2 = domainManagerArray;
                    java.lang.Object var10_18 = null;
                    this.releaseReply(object, inputStream);
                    return domainManagerArray2;
                }
                catch (Throwable throwable) {
                    java.lang.Object var10_19 = null;
                    this.releaseReply(object, inputStream);
                    throw throwable;
                }
            }
            catch (RemarshalException remarshalException) {
            }
            catch (ApplicationException applicationException) {
                this.getLogger().error("Application exception:", applicationException);
                throw this.createUnexpectedException(applicationException);
            }
        }
        boolean bl = true;
        requestState.incrementLocalLevel();
        try {
            try {
                DomainManager[] domainManagerArray = requestState.getBinding().get_domain_managers();
                bl = false;
                DomainManager[] domainManagerArray3 = domainManagerArray;
                java.lang.Object var12_22 = null;
                requestState.completeInvocation(!bl);
                return domainManagerArray3;
            }
            catch (SystemException systemException) {
                requestState.receiveSystemException(object, systemException);
                bl = false;
                DomainManager[] domainManagerArray = null;
                java.lang.Object var12_23 = null;
                requestState.completeInvocation(!bl);
                return domainManagerArray;
            }
            catch (ForwardRequest forwardRequest) {
                IOR iOR = ((Delegate)((ObjectImpl)forwardRequest.forward)._get_delegate()).ior();
                requestState.receiveRedirect(object, iOR, false);
                bl = false;
                DomainManager[] domainManagerArray = null;
                java.lang.Object var12_24 = null;
                requestState.completeInvocation(!bl);
                return domainManagerArray;
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var12_25 = null;
            requestState.completeInvocation(!bl);
            throw throwable;
        }
    }

    public boolean non_existent(Object object) {
        RequestState requestState = this.begin_invocation(object, false);
        return requestState.locateAndGetPolicies(object, null);
    }

    public Object duplicate(Object object) {
        return object;
    }

    public void release(Object object) {
    }

    public boolean is_equivalent(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)object2)._get_delegate();
        if (!(delegate instanceof Delegate)) {
            return false;
        }
        Delegate delegate2 = (Delegate)delegate;
        if (this == delegate2) {
            return true;
        }
        TaggedProfile[] taggedProfileArray = this.m_ior.profiles;
        TaggedProfile[] taggedProfileArray2 = delegate2.m_ior.profiles;
        if (taggedProfileArray2.length != taggedProfileArray2.length) {
            return false;
        }
        int n = 0;
        while (n < taggedProfileArray.length) {
            TaggedProfile taggedProfile = taggedProfileArray[n];
            TaggedProfile taggedProfile2 = taggedProfileArray2[n];
            if (taggedProfile.tag != taggedProfile2.tag || !Arrays.equals(taggedProfile.profile_data, taggedProfile2.profile_data)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object, java.lang.Object object2) {
        if (!(object2 instanceof Object)) {
            return false;
        }
        return this.is_equivalent(object, (Object)object2);
    }

    public int hash(Object object, int n) {
        if (this.m_hash == -1L) {
            this.m_hash = 0L;
            TaggedProfile[] taggedProfileArray = this.m_ior.profiles;
            int n2 = 0;
            while (n2 < taggedProfileArray.length) {
                TaggedProfile taggedProfile = taggedProfileArray[n2];
                byte[] byArray = taggedProfile.profile_data;
                int n3 = 0;
                while (n3 < byArray.length) {
                    this.m_hash = 31L * this.m_hash + (long)byArray[n3];
                    ++n3;
                }
                this.m_hash = 31L * this.m_hash + (long)taggedProfile.tag;
                ++n2;
            }
        }
        return (int)(this.m_hash % (long)(n + 1)) & Integer.MAX_VALUE;
    }

    public int hashCode(Object object) {
        return this.hash(object, Integer.MAX_VALUE);
    }

    public org.omg.CORBA.Request create_request(Object object, Context context, String string, NVList nVList, NamedValue namedValue) {
        return new Request(object, string, nVList, namedValue, new Environment(), new ExceptionList(), new ContextList(), this.m_orb);
    }

    public org.omg.CORBA.Request create_request(Object object, Context context, String string, NVList nVList, NamedValue namedValue, org.omg.CORBA.ExceptionList exceptionList, org.omg.CORBA.ContextList contextList) {
        return new Request(object, string, nVList, namedValue, new Environment(), exceptionList, contextList, this.m_orb);
    }

    public org.omg.CORBA.Request request(Object object, String string) {
        return new Request(object, string, this.m_orb);
    }

    public boolean is_local(Object object) {
        ForceMarshalPolicy forceMarshalPolicy = (ForceMarshalPolicy)this.client_policy(object, 1146057218);
        if (forceMarshalPolicy != null && forceMarshalPolicy.forceMarshal()) {
            return false;
        }
        RequestState requestState = this.begin_invocation(object, false);
        return requestState.getBinding().local_invoke();
    }

    public org.omg.CORBA.portable.OutputStream request(Object object, String string, boolean bl) {
        RequestState requestState = this.begin_invocation(object, false);
        block6: while (true) {
            try {
                if (this.is_local(object)) {
                    requestState.setRequest(requestState.getBinding().create_request_local(this.m_orb, object, string, bl, requestState.getAddresses()));
                } else {
                    requestState.setRequest(requestState.getBinding().create_request(object, string, bl));
                }
            }
            catch (SystemException systemException) {
                requestState.receiveSystemException(object, systemException);
                continue;
            }
            ClientRequest clientRequest = requestState.getRequest();
            org.omg.CORBA.portable.OutputStream outputStream = clientRequest.begin_marshal();
            if (outputStream != null) {
                return outputStream;
            }
            switch (clientRequest.reply_status()) {
                case 1: {
                    requestState.receiveSystemException(object, clientRequest.received_system_exception());
                    continue block6;
                }
                case 3: {
                    requestState.receiveRedirect(object, clientRequest.forward_reference_ior(), false);
                    continue block6;
                }
            }
            Trace.signalIllegalCondition(this.getLogger(), "Invalid reply_status.");
        }
    }

    public void invoke_deferred(Object object, org.omg.CORBA.portable.OutputStream outputStream) {
        if (object == null || outputStream == null) {
            throw new BAD_PARAM();
        }
        RequestState requestState = this.locate_state();
        if (requestState == null || requestState.getRequest() == null) {
            throw new BAD_INV_ORDER(1146056707, CompletionStatus.COMPLETED_NO);
        }
        requestState.getRequest().send_request();
        CurrentImpl currentImpl = this.getPICurrent();
        currentImpl.store_invocation_ctx(outputStream);
        currentImpl.set_invocation_ctx(requestState.getParentState());
        requestState.setParentState(null);
    }

    public boolean poll_response(Object object, org.omg.CORBA.portable.OutputStream outputStream) {
        if (object == null || outputStream == null) {
            throw new BAD_PARAM();
        }
        CurrentImpl currentImpl = this.getPICurrent();
        RequestState requestState = (RequestState)currentImpl.retrieve_invocation_ctx(outputStream, false);
        if (requestState == null) {
            throw new BAD_INV_ORDER("Operation not sent deferred", 1330446349, CompletionStatus.COMPLETED_MAYBE);
        }
        return requestState.pollResponse();
    }

    public InputStream invoke(Object object, org.omg.CORBA.portable.OutputStream outputStream) throws ApplicationException, RemarshalException {
        int n;
        CurrentImpl currentImpl = this.getPICurrent();
        if (object == null || outputStream == null) {
            throw new BAD_PARAM();
        }
        RequestState requestState = (RequestState)currentImpl.retrieve_invocation_ctx(outputStream, true);
        if (requestState != null) {
            requestState.setParentState(this.locate_state());
            currentImpl.set_invocation_ctx(requestState);
            n = requestState.getRequest().state();
        } else {
            requestState = this.locate_state();
            if (requestState == null || requestState.getRequest() == null) {
                throw new BAD_INV_ORDER(1146056707, CompletionStatus.COMPLETED_NO);
            }
            n = requestState.getRequest().send_request();
        }
        switch (n) {
            case 2: {
                n = requestState.waitForResponse();
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw Trace.signalIllegalCondition(this.getLogger(), "Unexpected case");
            }
        }
        switch (n) {
            case 3: {
                switch (requestState.getRequest().reply_status()) {
                    case 0: {
                        return requestState.getRequest().receive_response();
                    }
                    case 2: {
                        throw new ApplicationException(requestState.getRequest().received_exception_id(), requestState.getRequest().receive_response());
                    }
                }
                throw Trace.signalIllegalCondition(this.getLogger(), "Unexpected case");
            }
            case 4: {
                switch (requestState.getRequest().reply_status()) {
                    case 0: {
                        return requestState.getRequest().receive_response();
                    }
                    case 2: {
                        throw new ApplicationException(requestState.getRequest().received_exception_id(), requestState.getRequest().receive_response());
                    }
                    case 1: {
                        requestState.receiveSystemException(object, requestState.getRequest().received_system_exception());
                        throw new RemarshalException();
                    }
                    case 3: {
                        requestState.receiveRedirect(object, requestState.getRequest().forward_reference_ior(), false);
                        throw new RemarshalException();
                    }
                    case 4: {
                        requestState.failoverTransient(object, true);
                        throw new RemarshalException();
                    }
                }
                throw Trace.signalIllegalCondition(this.getLogger(), "Unexpected case");
            }
            case 2: {
                TIMEOUT tIMEOUT = new TIMEOUT(0, CompletionStatus.COMPLETED_MAYBE);
                requestState.getRequest().cancel(tIMEOUT);
                requestState.completeInvocation(false);
                throw tIMEOUT;
            }
        }
        throw Trace.signalIllegalCondition(this.getLogger(), "Unexpected case");
    }

    public void releaseReply(Object object, InputStream inputStream) {
        RequestState requestState = this.locate_state();
        if (null == requestState) {
            return;
        }
        ClientRequest clientRequest = requestState.getRequest();
        if (null == clientRequest) {
            return;
        }
        switch (clientRequest.state()) {
            case 1: {
                requestState.completeInvocation(false);
                MARSHAL mARSHAL = new MARSHAL("Exception thrown during marshal", 1146056732, CompletionStatus.COMPLETED_NO);
                clientRequest.cancel(mARSHAL);
                break;
            }
            case 3: {
                requestState.completeInvocation(false);
                MARSHAL mARSHAL = new MARSHAL("Buffer Underread", 1146056733, CompletionStatus.COMPLETED_YES);
                clientRequest.cancel(mARSHAL);
                throw mARSHAL;
            }
            case 2: {
                TIMEOUT tIMEOUT = new TIMEOUT(0, CompletionStatus.COMPLETED_MAYBE);
                clientRequest.cancel(tIMEOUT);
                requestState.completeInvocation(false);
                break;
            }
            case 4: {
                requestState.completeInvocation(true);
            }
        }
    }

    public ServantObject servant_preinvoke(Object object, String string, Class clazz) {
        return this.begin_invocation(object, false).servantPreInvoke(object, string, clazz);
    }

    public void servant_postinvoke(Object object, ServantObject servantObject) {
        this.locate_state().servantPostInvoke(object, servantObject);
    }

    public Policy get_policy(Object object, int n) {
        Policy policy;
        Policy policy2 = this.client_policy(object, n);
        int[] nArray = new int[]{n};
        PolicyListHolder policyListHolder = new PolicyListHolder();
        DomainManager[] domainManagerArray = this.get_domain_managers_and_policies(object, nArray, policyListHolder);
        Policy policy3 = policy = policyListHolder.value.length == 0 ? null : policyListHolder.value[0];
        if (null == this.m_orbReconciler) {
            INTERNAL iNTERNAL = new INTERNAL("PolicyReconciler unavailable");
            this.getLogger().error(iNTERNAL.getMessage(), iNTERNAL);
            throw iNTERNAL;
        }
        return this.m_orbReconciler.reconcile_policies(n, policy2, policy, domainManagerArray);
    }

    public Policy get_client_policy(Object object, int n) {
        Policy policy = this.client_policy(object, n);
        return policy;
    }

    private Policy client_policy(Object object, int n) {
        java.lang.Object object2;
        RequestState requestState = this.locate_state();
        if (null == requestState || !requestState.isInIgnoreRebindMode() || n == 23) {
            // empty if block
        }
        int[] nArray = new int[]{n};
        if (null != this.m_policyOver && ((Policy[])(object2 = this.m_policyOver.get_policy_overrides(nArray))).length > 0) {
            return object2[0];
        }
        if (null == this.m_policyCurr) {
            object2 = new INTERNAL("Unable to resolve PolicyCurrent (" + null + ")");
            this.getLogger().error("Unable to resolve PolicyCurrent.", (Throwable)object2);
            throw object2;
        }
        object2 = this.m_policyCurr.get_policy_overrides(nArray);
        if (((Policy[])object2).length > 0) {
            return object2[0];
        }
        if (null == this.m_orbPolicyManager) {
            object2 = new INTERNAL("Unable to resolve ORBPolicyManager (" + null + ")");
            this.getLogger().error("Unable to resolve ORBPolicyManager.", (Throwable)object2);
            throw object2;
        }
        object2 = this.m_orbPolicyManager.get_policy_overrides(nArray);
        if (((Policy[])object2).length > 0) {
            return object2[0];
        }
        return null;
    }

    public Object set_policy_override(Object object, Policy[] policyArray, SetOverrideType setOverrideType) {
        try {
            return this.set_policy_overrides(object, policyArray, setOverrideType);
        }
        catch (InvalidPolicies invalidPolicies) {
            this.getLogger().error("Invalid policy passed to set_policy_overrides().", invalidPolicies);
            throw ExceptionTool.initCause(new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO), (Throwable)invalidPolicies);
        }
    }

    public Object set_policy_overrides(Object object, Policy[] policyArray, SetOverrideType setOverrideType) throws InvalidPolicies {
        PolicyManagerOperations policyManagerOperations;
        if (null == this.m_policySetManager) {
            INTERNAL iNTERNAL = new INTERNAL("PolicySetManager unavailable");
            this.getLogger().error(iNTERNAL.getMessage(), iNTERNAL);
            throw iNTERNAL;
        }
        if (policyArray.length == 0) {
            if (this.m_policyOver == null || setOverrideType == SetOverrideType.SET_OVERRIDE) {
                policyManagerOperations = null;
            } else {
                policyManagerOperations = this.m_policySetManager.create_policy_set(0);
                policyManagerOperations.set_policy_overrides(this.m_policyOver.get_policy_overrides(new int[0]), SetOverrideType.SET_OVERRIDE);
            }
        } else if (this.m_policyOver == null || setOverrideType == SetOverrideType.SET_OVERRIDE) {
            policyManagerOperations = this.m_policySetManager.create_policy_set(0);
            policyManagerOperations.set_policy_overrides(policyArray, setOverrideType);
        } else {
            policyManagerOperations = this.m_policySetManager.create_policy_set(0);
            policyManagerOperations.set_policy_overrides(this.m_policyOver.get_policy_overrides(new int[0]), SetOverrideType.SET_OVERRIDE);
            policyManagerOperations.set_policy_overrides(policyArray, setOverrideType);
        }
        ObjectImpl objectImpl = null;
        if (!(object instanceof ObjectStub)) {
            try {
                objectImpl = (ObjectImpl)object.getClass().newInstance();
            }
            catch (Exception exception) {
                this.getLogger().error("Failed to create instance of ObjectImpl class.", exception);
            }
        }
        if (null == objectImpl) {
            objectImpl = new ObjectStub();
        }
        Delegate delegate = new Delegate(this.m_orb, this.ior(), policyManagerOperations);
        objectImpl._set_delegate(delegate);
        return objectImpl;
    }

    public Policy[] get_policy_overrides(int[] nArray) {
        if (this.m_policyOver == null) {
            return new Policy[0];
        }
        return this.m_policyOver.get_policy_overrides(nArray);
    }

    public boolean validate_connection(Object object, PolicyListHolder policyListHolder) {
        PolicyListHolder policyListHolder2 = new PolicyListHolder();
        RequestState requestState = this.begin_invocation(object, true);
        try {
            boolean bl = requestState.locateAndGetPolicies(object, policyListHolder2);
            policyListHolder.value = new Policy[0];
            return bl;
        }
        catch (INV_POLICY iNV_POLICY) {
            policyListHolder.value = new Policy[0];
            return false;
        }
    }

    public org.omg.CORBA.ORB orb(Object object) {
        return this.m_orb;
    }

    private boolean compareIORs(IOR iOR, IOR iOR2) {
        if (iOR == iOR2) {
            return true;
        }
        if (!iOR.type_id.equals(iOR2.type_id) || iOR.profiles.length != iOR2.profiles.length) {
            return false;
        }
        int n = 0;
        while (n < iOR.profiles.length) {
            if (iOR.profiles[n].tag != iOR2.profiles[n].tag || !Arrays.equals(iOR.profiles[n].profile_data, iOR2.profiles[n].profile_data)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String get_codebase(Object object) {
        return null;
    }

    public IOR ior() {
        java.lang.Object object = this.m_bindingSync;
        synchronized (object) {
            IOR iOR = this.m_effectiveIor;
            return iOR;
        }
    }

    public Address[] getAddresses(Object object) {
        CurrentImpl currentImpl = this.getPICurrent();
        java.lang.Object object2 = currentImpl.get_invocation_ctx();
        currentImpl.set_invocation_ctx(null);
        try {
            Address[] addressArray = this.begin_invocation(object, false).getAddresses();
            java.lang.Object var6_5 = null;
            currentImpl.set_invocation_ctx(object2);
            return addressArray;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            currentImpl.set_invocation_ctx(object2);
            throw throwable;
        }
    }

    private RequestState begin_invocation(Object object, boolean bl) {
        CurrentImpl currentImpl = this.getPICurrent();
        RequestState requestState = (RequestState)currentImpl.get_invocation_ctx();
        if (requestState == null) {
            requestState = this.createRequestState(null);
        } else {
            if (requestState.isTargetDelegate(this)) {
                if (requestState.getRequest() != null) {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state at begin_invocation");
                }
                if (bl) {
                    requestState.setIgnoreRebindMode(true);
                }
                return requestState;
            }
            requestState = requestState.getRequest() == null && requestState.isLocalLevelZero() ? this.createRequestState(null) : this.createRequestState(requestState);
        }
        requestState.beginInvocation(this, currentImpl, object, bl);
        return requestState;
    }

    private RequestState locate_state() {
        CurrentImpl currentImpl = this.getPICurrent();
        RequestState requestState = (RequestState)currentImpl.get_invocation_ctx();
        while (requestState != null && !requestState.isTargetDelegate(this)) {
            if (requestState.getRequest() != null || requestState.isLocalLevelGreaterThanZero()) {
                return null;
            }
            requestState = requestState.getParentState();
        }
        return requestState;
    }

    private RequestState createRequestState(RequestState requestState) {
        boolean bl = ((ORB)this.m_orb).getLoader().getBooleanProperty("openorb.client.bindings.discard_old", false);
        RequestState requestState2 = new RequestState(this.getLogger(), requestState);
        if (bl) {
            requestState2.discardOldBindings();
        }
        return requestState2;
    }

    private static void mergeSort(ClientBinding[] clientBindingArray, boolean[] blArray, ClientBinding[] clientBindingArray2, boolean[] blArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            int n4 = n;
            while (n4 < n2) {
                int n5 = n4;
                while (n5 > n && Delegate.statecomp(clientBindingArray2[n5 - 1], blArray2[n5 - 1], clientBindingArray2[n5], blArray2[n5]) > 0) {
                    ClientBinding clientBinding = clientBindingArray2[n5];
                    boolean bl = blArray2[n5];
                    clientBindingArray2[n5] = clientBindingArray2[n5 - 1];
                    blArray2[n5] = blArray2[n5 - 1];
                    clientBindingArray2[n5 - 1] = clientBinding;
                    blArray2[n5 - 1] = bl;
                    --n5;
                }
                ++n4;
            }
            return;
        }
        int n6 = (n + n2) / 2;
        Delegate.mergeSort(clientBindingArray, blArray, clientBindingArray2, blArray2, n, n6);
        Delegate.mergeSort(clientBindingArray, blArray, clientBindingArray2, blArray2, n6, n2);
        if (Delegate.statecomp(clientBindingArray[n6 - 1], blArray[n6 - 1], clientBindingArray[n6], blArray[n6]) <= 0) {
            System.arraycopy(clientBindingArray, n, clientBindingArray2, n, n3);
            System.arraycopy(blArray, n, blArray2, n, n3);
            return;
        }
        int n7 = n;
        int n8 = n;
        int n9 = n6;
        while (n7 < n2) {
            if (n9 >= n2 || n8 < n6 && Delegate.statecomp(clientBindingArray[n8], blArray[n8], clientBindingArray[n9], blArray[n9]) <= 0) {
                clientBindingArray2[n7] = clientBindingArray[n8];
                blArray2[n7] = blArray[n8];
                ++n8;
            } else {
                clientBindingArray2[n7] = clientBindingArray[n9];
                blArray2[n7] = blArray[n9];
                ++n9;
            }
            ++n7;
        }
    }

    private static int statecomp(ClientBinding clientBinding, boolean bl, ClientBinding clientBinding2, boolean bl2) {
        return bl ? (bl2 ? 0 : 1) : (bl2 ? -1 : ClientBinding.PRIORITY_COMP.compare(clientBinding, clientBinding2));
    }

    public String toString(Object object) {
        try {
            ArrayList arrayList;
            ArrayList[] arrayListArray;
            java.lang.Object object2;
            Address[] addressArray = this.getAddresses(object);
            ArrayList<ArrayList[]> arrayList2 = new ArrayList<ArrayList[]>();
            int n = 0;
            while (n < addressArray.length) {
                if (addressArray[n] != null) {
                    object2 = addressArray[n].getTargetAddress((short)2).ior();
                    arrayListArray = new ArrayList[((IORAddressingInfo)object2).ior.profiles.length];
                    arrayList2.add(arrayListArray);
                    arrayListArray[((IORAddressingInfo)object2).selected_profile_index] = new ArrayList();
                    arrayList = arrayListArray[((IORAddressingInfo)object2).selected_profile_index];
                    arrayList.add(addressArray[n]);
                    int n2 = n + 1;
                    while (n2 < addressArray.length) {
                        if (addressArray[n2] != null) {
                            IORAddressingInfo iORAddressingInfo = addressArray[n2].getTargetAddress((short)2).ior();
                            if (this.compareIORs(((IORAddressingInfo)object2).ior, iORAddressingInfo.ior)) {
                                arrayList = arrayListArray[iORAddressingInfo.selected_profile_index];
                                if (arrayList == null) {
                                    arrayList = arrayListArray[iORAddressingInfo.selected_profile_index] = new ArrayList();
                                }
                                arrayList.add(addressArray[n2]);
                                addressArray[n2] = null;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            object2 = new ByteArrayOutputStream();
            arrayListArray = new HexPrintStream((OutputStream)object2, 2);
            arrayList = new PrintStream((OutputStream)object2);
            ((PrintStream)((java.lang.Object)arrayList)).println("Binding information for object " + object.getClass() + ":" + Integer.toHexString(System.identityHashCode(object)));
            String[] stringArray = ((ObjectImpl)object)._ids();
            if (stringArray.length != 0) {
                ((PrintStream)((java.lang.Object)arrayList)).println("Repository IDs from Object: ");
                int n3 = 0;
                while (n3 < stringArray.length) {
                    ((PrintStream)((java.lang.Object)arrayList)).println("    " + stringArray[n3]);
                    ++n3;
                }
            }
            if (arrayList2.size() > 1) {
                ((PrintStream)((java.lang.Object)arrayList)).println("There have been " + (arrayList2.size() - 1) + " redirections of this object");
            }
            int n4 = 0;
            while (n4 < arrayList2.size()) {
                ArrayList[] arrayListArray2 = (ArrayList[])arrayList2.get(n4);
                int n5 = 0;
                int n6 = -1;
                int n7 = arrayListArray2.length - 1;
                while (n7 >= 0) {
                    if (arrayListArray2[n7] != null) {
                        ++n5;
                        n6 = n7;
                    }
                    --n7;
                }
                if (n5 != 0) {
                    java.lang.Object object3;
                    int n8;
                    int n9;
                    int n10;
                    IOR iOR = ((Address)arrayListArray2[n6].get((int)0)).getTargetAddress((short)2).ior().ior;
                    ((PrintStream)((java.lang.Object)arrayList)).print("IOR #" + n4);
                    if (this.compareIORs(iOR, this.m_ior)) {
                        ((PrintStream)((java.lang.Object)arrayList)).println(" (orginal IOR)");
                    } else if (this.compareIORs(iOR, this.ior())) {
                        ((PrintStream)((java.lang.Object)arrayList)).println(" (from latest permanent redirect)");
                    } else {
                        ((PrintStream)((java.lang.Object)arrayList)).println(" (from redirect)");
                    }
                    ((PrintStream)((java.lang.Object)arrayList)).println("Published RepoID: " + iOR.type_id);
                    ((PrintStream)((java.lang.Object)arrayList)).println("Bound profiles: " + n5);
                    Address address = null;
                    int n11 = 0;
                    while (n11 < arrayListArray2.length) {
                        if (arrayListArray2[n11] != null) {
                            ((PrintStream)((java.lang.Object)arrayList)).print("Profile #" + n11);
                            address = (Address)arrayListArray2[n11].get(0);
                            switch (arrayListArray2[n11].size()) {
                                case 0: {
                                    ((PrintStream)((java.lang.Object)arrayList)).println(" no endpoints found");
                                    break;
                                }
                                case 1: {
                                    ((PrintStream)((java.lang.Object)arrayList)).println(" endpoint: " + address.getEndpointDescription());
                                    break;
                                }
                                default: {
                                    ((PrintStream)((java.lang.Object)arrayList)).println(" endpoints:");
                                    n10 = 0;
                                    while (n10 < arrayListArray2[n11].size()) {
                                        ((PrintStream)((java.lang.Object)arrayList)).println("    " + ((Address)arrayListArray2[n11].get(n10)).getEndpointDescription());
                                        ++n10;
                                    }
                                    break block1;
                                }
                            }
                            ((PrintStream)((java.lang.Object)arrayList)).print(address.getObjectKeyDescription());
                            n9 = address.get_profile_components();
                            if (n9 > 0) {
                                ((PrintStream)((java.lang.Object)arrayList)).println("Components:");
                                n8 = 0;
                                while (n8 < n9) {
                                    object3 = address.get_component_data(n8);
                                    if (object3 == null) {
                                        ((PrintStream)((java.lang.Object)arrayList)).println("Unknown Component. Tag: " + address.get_component((int)n8).tag + " Data:");
                                        ((PrintStream)((java.lang.Object)arrayList)).flush();
                                        arrayListArray.write(address.get_component((int)n8).component_data);
                                        arrayListArray.flush();
                                        ((PrintStream)((java.lang.Object)arrayList)).println();
                                    } else {
                                        ((PrintStream)((java.lang.Object)arrayList)).println(object3.toString());
                                    }
                                    ++n8;
                                }
                            }
                        }
                        ++n11;
                    }
                    n10 = address.get_profile_components();
                    if (n10 < (n9 = address.get_components().length)) {
                        ((PrintStream)((java.lang.Object)arrayList)).println("Components from Multi-Component Profile:");
                        n8 = n10;
                        while (n8 < n9) {
                            object3 = address.get_component_data(n8);
                            if (object3 == null) {
                                ((PrintStream)((java.lang.Object)arrayList)).println("Unknown Component. Tag: " + address.get_component((int)n8).tag + " Data:");
                                ((PrintStream)((java.lang.Object)arrayList)).flush();
                                arrayListArray.write(address.get_component((int)n8).component_data);
                                arrayListArray.flush();
                                ((PrintStream)((java.lang.Object)arrayList)).println();
                            } else {
                                ((PrintStream)((java.lang.Object)arrayList)).println(object3.toString());
                            }
                            ++n8;
                        }
                    }
                }
                ++n4;
            }
            return ((ByteArrayOutputStream)object2).toString();
        }
        catch (IOException iOException) {
            this.getLogger().error("Unexpected IOException.", iOException);
            throw ExceptionTool.initCause(new RuntimeException("Unexpected Exception (" + iOException + ")"), (Throwable)iOException);
        }
    }

    private static class RequestState {
        private static final long NO_DEADLINE = -1L;
        private boolean m_discard_old = false;
        private final Logger m_logger;
        private ClientBinding m_binding;
        private ClientRequest m_request;
        private boolean m_ignoreRebindMode;
        private int m_version;
        private int m_idx;
        private ClientBinding[] m_bindings;
        private boolean[] m_used;
        private int m_unusedBindingsCount;
        private int m_exceptionLevel = -1;
        private SystemException m_exception;
        private long m_roundtripDeadline = -1L;
        private Delegate m_targetDelegate;
        private int m_localLevel = 0;
        private RequestState m_parentState;

        protected RequestState(Logger logger, RequestState requestState) {
            if (logger == null) {
                throw new NullPointerException("RequestState requires a logger");
            }
            this.m_logger = logger;
            this.m_parentState = requestState;
        }

        public Logger getLogger() {
            return this.m_logger;
        }

        public void incrementLocalLevel() {
            ++this.m_localLevel;
        }

        public void decrementLocalLevel() {
            --this.m_localLevel;
        }

        public boolean isLocalLevelZero() {
            return this.m_localLevel == 0;
        }

        public boolean isLocalLevelGreaterThanZero() {
            return 0 > this.m_localLevel;
        }

        public boolean isLocalStateLessThanOrEqualToZero() {
            return this.m_localLevel <= 0;
        }

        public int getExceptionLevel() {
            return this.m_exceptionLevel;
        }

        public void setExceptionLevel(int n) {
            this.m_exceptionLevel = n;
        }

        public SystemException getException() {
            return this.m_exception;
        }

        public void setException(SystemException systemException) {
            this.m_exception = systemException;
        }

        public void discardOldBindings() {
            this.m_discard_old = true;
        }

        public boolean isTargetDelegate(Delegate delegate) {
            return this.m_targetDelegate == delegate;
        }

        public void setTargetDelegate(Delegate delegate) {
            this.m_targetDelegate = delegate;
        }

        public int getVersion() {
            return this.m_version;
        }

        public void setVersion(int n) {
            this.m_version = n;
        }

        public int getIdx() {
            return this.m_idx;
        }

        public void setIdx(int n) {
            this.m_idx = n;
        }

        public ClientBinding[] getBindings() {
            return this.m_bindings;
        }

        public void setBindings(ClientBinding[] clientBindingArray) {
            this.m_bindings = clientBindingArray;
        }

        public boolean isMoreThanOneUnusedBinding() {
            return 1 < this.m_unusedBindingsCount;
        }

        public void setUnusedBindingsCount(int n) {
            this.m_unusedBindingsCount = n;
        }

        public void decrementUnusedBindingsCount() {
            --this.m_unusedBindingsCount;
        }

        public boolean areUnusedBindings() {
            return 0 != this.m_unusedBindingsCount;
        }

        public boolean[] getUsed() {
            return this.m_used;
        }

        public void setUsed(boolean[] blArray) {
            this.m_used = blArray;
        }

        public void setRelativeRoundtripTimeout(long l) {
            this.setRelativeRoundtripTimeout(l, System.currentTimeMillis());
        }

        public void setRelativeRoundtripTimeout(long l, long l2) {
            if (l < 0L) {
                this.m_roundtripDeadline = -1L;
                if (Trace.isHigh()) {
                    this.m_logger.debug("RoundtripDeadline=[NO_DEADLINE]");
                }
            } else {
                this.m_roundtripDeadline = l2 + l / 10000L;
                if (Trace.isHigh() && this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("RoundtripDeadline=[" + this.m_roundtripDeadline + "]");
                }
            }
        }

        public boolean isRoundtripDeadlineSet() {
            return -1L != this.m_roundtripDeadline;
        }

        public long calculateTimeToDeadline() {
            return this.m_roundtripDeadline - System.currentTimeMillis();
        }

        public int waitForResponse() {
            if (this.isRoundtripDeadlineSet()) {
                long l = this.calculateTimeToDeadline();
                return l < 1L ? 2 : this.m_request.wait_for_response(l);
            }
            return this.m_request.wait_for_response(0L);
        }

        public boolean pollResponse() {
            return this.isRoundtripDeadlineSet() ? this.calculateTimeToDeadline() <= 0L : this.m_request.poll_response();
        }

        public ClientBinding getBinding() {
            return this.m_binding;
        }

        public void setBinding(ClientBinding clientBinding) {
            this.m_binding = clientBinding;
        }

        public ClientRequest getRequest() {
            return this.m_request;
        }

        public void setRequest(ClientRequest clientRequest) {
            this.m_request = clientRequest;
        }

        public boolean isInIgnoreRebindMode() {
            return this.m_ignoreRebindMode;
        }

        public void setIgnoreRebindMode(boolean bl) {
            this.m_ignoreRebindMode = bl;
        }

        public RequestState getParentState() {
            return this.m_parentState;
        }

        public void setParentState(RequestState requestState) {
            this.m_parentState = requestState;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ServantObject servantPreInvoke(Object object, String string, Class clazz) {
            this.incrementLocalLevel();
            boolean bl = true;
            try {
                ServantObject servantObject;
                try {
                    ServantObject servantObject2 = this.getBinding().servant_preinvoke(string, clazz);
                    bl = false;
                    servantObject = servantObject2;
                    java.lang.Object var10_10 = null;
                    if (!bl) return servantObject;
                }
                catch (SystemException systemException) {
                    this.receiveSystemException(object, systemException);
                    bl = false;
                    ServantObject servantObject3 = null;
                    java.lang.Object var10_11 = null;
                    if (!bl) return servantObject3;
                    this.completeInvocation(false);
                    return servantObject3;
                }
                catch (ForwardRequest forwardRequest) {
                    IOR iOR = ((Delegate)((ObjectImpl)forwardRequest.forward)._get_delegate()).ior();
                    this.receiveRedirect(object, iOR, false);
                    bl = false;
                    ServantObject servantObject4 = null;
                    java.lang.Object var10_12 = null;
                    if (!bl) return servantObject4;
                    this.completeInvocation(false);
                    return servantObject4;
                }
                this.completeInvocation(false);
                return servantObject;
            }
            catch (Throwable throwable) {
                java.lang.Object var10_13 = null;
                if (!bl) throw throwable;
                this.completeInvocation(false);
                throw throwable;
            }
        }

        public void servantPostInvoke(Object object, ServantObject servantObject) {
            try {
                block4: {
                    try {
                        if (null == this.getBinding()) break block4;
                        this.getBinding().servant_postinvoke(servantObject);
                    }
                    catch (Exception exception) {
                        this.m_logger.error("Delegate.servant_postinvoke()", exception);
                        java.lang.Object var5_4 = null;
                        this.completeInvocation(true);
                    }
                }
                java.lang.Object var5_3 = null;
                this.completeInvocation(true);
            }
            catch (Throwable throwable) {
                java.lang.Object var5_5 = null;
                this.completeInvocation(true);
                throw throwable;
            }
        }

        public void completeInvocation(boolean bl) {
            java.lang.Object object = this.m_targetDelegate.m_bindingSync;
            synchronized (object) {
                if (bl == (this.m_targetDelegate.m_selectedBinding == null)) {
                    if (bl) {
                        if (this.m_targetDelegate.m_selectedBinding == null) {
                            this.m_targetDelegate.m_selectedBinding = this.getBinding();
                        }
                    } else if (this.m_targetDelegate.m_selectedBinding == this.getBinding()) {
                        this.m_targetDelegate.m_selectedBinding = null;
                    }
                }
            }
            this.decrementLocalLevel();
            if (this.isLocalStateLessThanOrEqualToZero()) {
                this.m_targetDelegate.getPICurrent().set_invocation_ctx(this.getParentState());
            }
        }

        public void beginInvocation(Delegate delegate, CurrentImpl currentImpl, Object object, boolean bl) {
            ClientBinding[] clientBindingArray;
            this.setTargetDelegate(delegate);
            RelativeRoundtripTimeoutPolicy relativeRoundtripTimeoutPolicy = (RelativeRoundtripTimeoutPolicy)this.m_targetDelegate.get_client_policy(object, 32);
            if (relativeRoundtripTimeoutPolicy != null) {
                this.setRelativeRoundtripTimeout(relativeRoundtripTimeoutPolicy.relative_expiry());
            }
            currentImpl.set_invocation_ctx(this);
            java.lang.Object object2 = this.m_targetDelegate.m_bindingSync;
            synchronized (object2) {
                this.setIgnoreRebindMode(bl);
                this.setVersion(this.m_targetDelegate.m_bindingVersion);
                this.setIdx(-1);
                if (this.m_targetDelegate.m_bindingVersion < 0) {
                    this.setIgnoreRebindMode(true);
                    this.receiveRedirect(object, this.m_targetDelegate.m_ior, true);
                    return;
                }
                if (this.m_targetDelegate.m_selectedBinding != null) {
                    this.setBinding(this.m_targetDelegate.m_selectedBinding);
                    if (this.m_targetDelegate.m_selectedBinding.local_invoke() || this.m_targetDelegate.m_selectedBinding.getClientChannel().state() != 0x13000000) {
                        return;
                    }
                    this.m_targetDelegate.m_selectedBinding = null;
                }
                clientBindingArray = this.m_targetDelegate.m_bindings.toArray(new ClientBinding[this.m_targetDelegate.m_bindings.size()]);
            }
            this.refreshBindingList(clientBindingArray);
            this.findNextBinding();
        }

        public boolean locateAndGetPolicies(Object object, PolicyListHolder policyListHolder) {
            int[] nArray = new int[]{};
            try {
                block17: while (true) {
                    Serializable serializable;
                    if (policyListHolder != null) {
                        policyListHolder.value = this.getBinding().getAddress().get_target_policies(nArray);
                    }
                    if (this.getBinding().getObjectAdapter() == null) {
                        try {
                            this.setRequest(this.getBinding().create_locate_request(object));
                        }
                        catch (SystemException systemException) {
                            this.receiveSystemException(object, systemException);
                            continue;
                        }
                        this.m_request.begin_marshal();
                        int n = this.m_request.state();
                        if (n == 1 && (n = this.m_request.send_request()) == 2 && (n = this.waitForResponse()) == 2) {
                            serializable = new TIMEOUT(0, CompletionStatus.COMPLETED_MAYBE);
                            this.m_request.cancel((SystemException)serializable);
                            throw serializable;
                        }
                        if (n != 4) {
                            Trace.signalIllegalCondition(this.m_logger, "Unexpected request_state");
                        }
                        switch (this.m_request.reply_status()) {
                            case -1: {
                                this.completeInvocation(true);
                                return false;
                            }
                            case -2: {
                                this.failoverPermanent(object, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                                continue block17;
                            }
                            case 1: {
                                this.receiveSystemException(object, this.m_request.received_system_exception());
                                continue block17;
                            }
                            case 3: {
                                this.receiveRedirect(object, this.m_request.forward_reference_ior(), false);
                                continue block17;
                            }
                            case 4: {
                                this.failoverTransient(object, true);
                                continue block17;
                            }
                        }
                        throw Trace.signalIllegalCondition(this.m_logger, "Unexpected reply_status");
                    }
                    try {
                        if (this.getBinding().locate()) {
                            this.completeInvocation(true);
                            return false;
                        }
                        this.failoverPermanent(object, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                    }
                    catch (ForwardRequest forwardRequest) {
                        serializable = ((Delegate)((ObjectImpl)forwardRequest.forward)._get_delegate()).ior();
                        this.receiveRedirect(object, (IOR)serializable, false);
                    }
                }
            }
            catch (NO_RESPONSE nO_RESPONSE) {
                return true;
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                return true;
            }
            catch (NO_IMPLEMENT nO_IMPLEMENT) {
                return true;
            }
            catch (OBJ_ADAPTER oBJ_ADAPTER) {
                return true;
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                return true;
            }
        }

        public Address[] getAddresses() {
            if (null == this.m_bindings) {
                this.setBinding(null);
                this.refreshBindingList(null);
            }
            Address[] addressArray = new Address[this.m_bindings.length];
            int n = 0;
            while (n < addressArray.length) {
                addressArray[n] = this.m_bindings[n].getAddress();
                ++n;
            }
            return addressArray;
        }

        public void refreshBindingList(ClientBinding[] clientBindingArray) {
            int n;
            ClientBinding[] clientBindingArray2;
            java.lang.Object object;
            if (clientBindingArray == null) {
                object = this.m_targetDelegate.m_bindingSync;
                synchronized (object) {
                    if (this.getBindings() != null && this.getVersion() >= this.m_targetDelegate.m_bindingVersion) {
                        return;
                    }
                    clientBindingArray2 = this.m_targetDelegate.m_bindings.toArray(new ClientBinding[this.m_targetDelegate.m_bindings.size()]);
                    this.setVersion(this.m_targetDelegate.m_bindingVersion);
                }
            } else {
                clientBindingArray2 = clientBindingArray;
            }
            object = new boolean[clientBindingArray2.length];
            this.setUnusedBindingsCount(clientBindingArray2.length);
            if (this.m_bindings != null) {
                n = 0;
                while (n < this.m_bindings.length) {
                    if (this.m_used[n]) {
                        int n2 = 0;
                        while (n2 < clientBindingArray2.length) {
                            if (clientBindingArray2[n2].equals(this.m_bindings[n])) {
                                object[n2] = true;
                                this.decrementUnusedBindingsCount();
                                break;
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            } else if (null != this.m_binding) {
                n = 0;
                while (n < clientBindingArray2.length) {
                    if (clientBindingArray2[n].equals(this.m_binding)) {
                        object[n] = true;
                        this.decrementUnusedBindingsCount();
                        break;
                    }
                    ++n;
                }
            }
            this.setBindings(clientBindingArray2);
            this.setUsed((boolean[])object);
            if (this.isMoreThanOneUnusedBinding()) {
                ClientBinding[] clientBindingArray3 = (ClientBinding[])clientBindingArray2.clone();
                boolean[] blArray = (boolean[])this.m_used.clone();
                Delegate.mergeSort(clientBindingArray3, blArray, clientBindingArray2, this.m_used, 0, clientBindingArray2.length);
            }
            this.setIdx(0);
        }

        public void findNextBinding() {
            int n = 0;
            int n2 = this.getIdx();
            while (n < this.m_used.length) {
                if (!this.m_used[n2] && (this.m_bindings[n2].local_invoke() || this.m_bindings[n2].getClientChannel().state() == 0x11000000)) {
                    this.setBinding(this.m_bindings[n2]);
                    this.setIdx(n2);
                    return;
                }
                ++n;
                n2 = (n2 + 1) % this.m_used.length;
            }
            int n3 = 0;
            int n4 = this.getIdx();
            while (n3 < this.m_used.length) {
                if (!this.m_used[n4]) {
                    if (this.m_bindings[n4].getClientChannel().state() != 0x13000000) {
                        this.setBinding(this.m_bindings[n4]);
                        this.setIdx(n4);
                        return;
                    }
                    this.m_used[n4] = true;
                    this.decrementUnusedBindingsCount();
                }
                ++n3;
                n4 = (n4 + 1) % this.m_used.length;
            }
            if (this.areUnusedBindings()) {
                Trace.signalIllegalCondition(this.m_logger, "There are still bindings available.");
            }
            this.completeInvocation(false);
            if (this.getExceptionLevel() < 0) {
                throw ExceptionTool.initCause(new TRANSIENT(2, CompletionStatus.COMPLETED_NO), (Throwable)this.getException());
            }
            try {
                throw this.getException();
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                throw this.isConnectException(cOMM_FAILURE) ? ExceptionTool.initCause(new TRANSIENT(2, CompletionStatus.COMPLETED_NO), (Throwable)cOMM_FAILURE) : cOMM_FAILURE;
            }
        }

        private boolean isConnectException(COMM_FAILURE cOMM_FAILURE) {
            return CompletionStatus.COMPLETED_NO.equals(cOMM_FAILURE.completed) && (1146056972 == cOMM_FAILURE.minor || 1146056969 == cOMM_FAILURE.minor || 1146056970 == cOMM_FAILURE.minor);
        }

        public void failoverTransient(Object object, boolean bl) {
            this.setRequest(null);
            ClientBinding clientBinding = this.getBinding();
            if (this.m_bindings == null) {
                this.setBinding(null);
            }
            this.refreshBindingList(null);
            this.setIdx(1);
            if (bl) {
                this.setBinding(clientBinding);
                int n = 0;
                while (n < this.m_bindings.length) {
                    if (clientBinding == this.m_bindings[n]) {
                        this.setIdx(n);
                        return;
                    }
                    ++n;
                }
                Trace.signalIllegalCondition(this.m_logger, "Old binding not found.");
            } else {
                this.setIdx((this.getIdx() + 1) % this.m_bindings.length);
                this.findNextBinding();
            }
        }

        public void failoverFatal(Object object, SystemException systemException) {
            this.setRequest(null);
            if (!this.isInIgnoreRebindMode()) {
                // empty if block
            }
            if (this.m_bindings != null) {
                this.m_used[this.getIdx()] = true;
                this.decrementUnusedBindingsCount();
            }
            this.refreshBindingList(null);
            if (this.getExceptionLevel() <= 1) {
                this.setExceptionLevel(1);
                this.setException(systemException);
            }
            this.findNextBinding();
        }

        public void failoverPermanent(Object object, SystemException systemException) {
            this.setRequest(null);
            if (!this.isInIgnoreRebindMode()) {
                // empty if block
            }
            this.getBinding().setPriority(this.getBinding().getPriority() & 0xFFFF | 0xFB0000);
            if (this.m_bindings != null) {
                this.m_used[this.getIdx()] = true;
                this.decrementUnusedBindingsCount();
            }
            this.refreshBindingList(null);
            if (this.getExceptionLevel() <= 3) {
                this.setExceptionLevel(3);
                this.setException(systemException);
            }
            this.findNextBinding();
        }

        private void receiveSystemException(Object object, SystemException systemException) {
            if (systemException.completed == CompletionStatus.COMPLETED_NO) {
                if (systemException instanceof TRANSIENT) {
                    this.failoverTransient(object, false);
                    return;
                }
                if (systemException instanceof NO_RESPONSE || systemException instanceof COMM_FAILURE || systemException instanceof NO_IMPLEMENT || systemException instanceof INV_POLICY || systemException instanceof NO_PERMISSION) {
                    this.failoverFatal(object, systemException);
                    return;
                }
                if (systemException instanceof OBJ_ADAPTER) {
                    this.failoverPermanent(object, systemException);
                    return;
                }
            }
            this.completeInvocation(systemException.completed == CompletionStatus.COMPLETED_YES);
            throw systemException;
        }

        private void receiveRedirect(Object object, IOR iOR, boolean bl) {
            if (this.m_discard_old) {
                this.receiveRedirectNew(object, iOR, bl);
            } else {
                this.receiveRedirectOld(object, iOR, bl);
            }
        }

        private void receiveRedirectNew(Object object, IOR iOR, boolean bl) {
            this.setRequest(null);
            if (!this.isInIgnoreRebindMode()) {
                // empty if block
            }
            if (this.m_bindings != null) {
                this.setUnusedBindingsCount(0);
                this.m_bindings = null;
            }
            ClientBinding[] clientBindingArray = this.m_targetDelegate.m_clientManager.create_bindings(object, iOR);
            this.m_targetDelegate.m_bindings.clear();
            this.m_targetDelegate.m_bindingVersion = 1;
            this.m_targetDelegate.m_effectiveIor = iOR;
            this.setVersion(this.m_targetDelegate.m_bindingVersion);
            boolean[] blArray = new boolean[clientBindingArray.length];
            int n = 0;
            while (n < blArray.length) {
                blArray[n] = false;
                this.m_targetDelegate.m_bindings.add(clientBindingArray[n]);
                ++n;
            }
            this.setBindings(clientBindingArray);
            this.setUsed(blArray);
            this.setUnusedBindingsCount(this.m_bindings.length);
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Delegate<" + this + ">: " + "Set new bindings (" + this.m_targetDelegate.m_bindings.size() + "):");
                Iterator iterator = this.m_targetDelegate.m_bindings.iterator();
                while (iterator.hasNext()) {
                    ClientBinding clientBinding = (ClientBinding)iterator.next();
                    Address address = clientBinding.getAddress();
                    this.getLogger().debug("Delegate<" + this + ">: " + "New binding : " + address.getEndpointString());
                }
            }
            this.setBinding(this.m_bindings[0]);
            this.setIdx(0);
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Delegate<" + this + ">: " + "Use binding with index " + this.getIdx());
            }
        }

        private void receiveRedirectOld(Object object, IOR iOR, boolean bl) {
            this.setRequest(null);
            if (!this.isInIgnoreRebindMode()) {
                // empty if block
            }
            if (this.m_bindings != null) {
                this.m_used[this.getIdx()] = true;
                this.decrementUnusedBindingsCount();
            }
            ClientBinding[] clientBindingArray = this.m_targetDelegate.m_clientManager.create_bindings(object, iOR);
            java.lang.Object object2 = this.m_targetDelegate.m_bindingSync;
            synchronized (object2) {
                if (bl) {
                    this.m_targetDelegate.m_effectiveIor = iOR;
                }
                int n = clientBindingArray.length;
                int n2 = 0;
                while (n2 < clientBindingArray.length) {
                    if (this.m_targetDelegate.m_bindings.contains(clientBindingArray[n2])) {
                        clientBindingArray[n2] = null;
                        --n;
                    }
                    ++n2;
                }
                if (n > 0) {
                    this.m_targetDelegate.m_bindingVersion++;
                    if (this.m_targetDelegate.m_bindingVersion < 250) {
                        int n3 = 0;
                        while (n3 < clientBindingArray.length) {
                            int n4;
                            if (clientBindingArray[n3] != null && (n4 = clientBindingArray[n3].getPriority()) >= 0) {
                                int n5 = 250 - this.m_targetDelegate.m_bindingVersion << 16;
                                n4 = n4 & 0xFFFF | n5;
                                clientBindingArray[n3].setPriority(n4);
                                this.m_targetDelegate.m_bindings.add(clientBindingArray[n3]);
                            }
                            ++n3;
                        }
                    } else {
                        Iterator iterator = this.m_targetDelegate.m_bindings.iterator();
                        while (iterator.hasNext()) {
                            ClientBinding clientBinding = (ClientBinding)iterator.next();
                            int n6 = clientBinding.getPriority();
                            if (n6 < 0) continue;
                            int n7 = (n6 & 0xFF0000) + 65536;
                            n6 = n6 & 0xFFFF | (n7 > 0xFA0000 ? 0xFA0000 : n7);
                            clientBinding.setPriority(n6);
                        }
                        int n8 = 0;
                        while (n8 < clientBindingArray.length) {
                            this.m_targetDelegate.m_bindings.add(clientBindingArray[n8]);
                            ++n8;
                        }
                    }
                    clientBindingArray = this.m_targetDelegate.m_bindings.toArray(new ClientBinding[this.m_targetDelegate.m_bindings.size()]);
                }
            }
            if (this.m_targetDelegate.m_bindingVersion >= 0) {
                this.refreshBindingList(clientBindingArray);
                this.setVersion(this.m_targetDelegate.m_bindingVersion);
            }
            this.findNextBinding();
        }
    }
}

