/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter;

import java.util.HashSet;
import java.util.Iterator;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHelper;
import org.omg.IOP.TaggedProfile;
import org.openorb.PI.ComponentSet;
import org.openorb.net.ServerProtocol;
import org.openorb.util.ExceptionTool;

public class IORUtil {
    private static Codec s_component_codec;

    public static IOR construct_ior(String string, byte[] byArray, ComponentSet componentSet, Object[] objectArray, ORB oRB) {
        Object object;
        Object object2;
        IOR iOR = new IOR();
        iOR.type_id = string;
        int n = 0;
        TaggedComponent[] taggedComponentArray = componentSet.getComponents(1);
        if (taggedComponentArray != null && taggedComponentArray.length > 0) {
            iOR.profiles = new TaggedProfile[objectArray.length / 2 + 1];
        } else {
            taggedComponentArray = null;
            iOR.profiles = new TaggedProfile[objectArray.length / 2];
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            object2 = (ServerProtocol)objectArray[n2];
            int n3 = (Integer)objectArray[n2 + 1];
            object = object2.create_profile(n3, componentSet, byArray);
            if (object != null) {
                iOR.profiles[n++] = object;
            }
            n2 += 2;
        }
        if (n == 0) {
            return null;
        }
        if (taggedComponentArray != null) {
            object2 = oRB.create_any();
            TaggedComponentSeqHelper.insert((Any)object2, taggedComponentArray);
            Codec codec = IORUtil.getComponentCodec(oRB);
            try {
                object = codec.encode_value((Any)object2);
            }
            catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                throw ExceptionTool.initCause(new INTERNAL("Invalid encoding type"), (Throwable)invalidTypeForEncoding);
            }
            if (object != null) {
                iOR.profiles[n++] = new TaggedProfile(1, (byte[])object);
            }
        }
        if (n < iOR.profiles.length) {
            object2 = new TaggedProfile[n];
            System.arraycopy(iOR.profiles, 0, object2, 0, n);
            iOR.profiles = object2;
        }
        return iOR;
    }

    private static Codec getComponentCodec(ORB oRB) {
        if (s_component_codec == null) {
            try {
                CodecFactory codecFactory = (CodecFactory)oRB.resolve_initial_references("CodecFactory");
                s_component_codec = codecFactory.create_codec(new Encoding(0, 1, 0));
            }
            catch (UserException userException) {
                throw ExceptionTool.initCause(new INTERNAL("Either resolve of CodecFactory failed or create_codec returned with an exception (" + userException + ")"), (Throwable)userException);
            }
        }
        return s_component_codec;
    }

    public static IOR merge_iors(String string, IOR[] iORArray) {
        HashSet<ProfileMember> hashSet = new HashSet<ProfileMember>();
        int n = 0;
        while (n < iORArray.length) {
            int n2 = 0;
            while (n2 < iORArray[n].profiles.length) {
                hashSet.add(new ProfileMember(iORArray[n].profiles[n2]));
                ++n2;
            }
            ++n;
        }
        IOR iOR = new IOR(string, new TaggedProfile[hashSet.size()]);
        int n3 = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            iOR.profiles[n3++] = ((ProfileMember)iterator.next()).profile();
        }
        return iOR;
    }

    private static class ProfileMember {
        private int m_hash;
        private TaggedProfile m_profile;

        public ProfileMember(TaggedProfile taggedProfile) {
            this.m_profile = taggedProfile;
            this.m_hash = this.m_profile.tag;
            int n = 0;
            while (n < this.m_profile.profile_data.length) {
                this.m_hash = 31 * this.m_hash + this.m_profile.profile_data[n];
                ++n;
            }
        }

        public int hashCode() {
            return this.m_hash;
        }

        public TaggedProfile profile() {
            return this.m_profile;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ProfileMember)) {
                return false;
            }
            ProfileMember profileMember = (ProfileMember)object;
            if (this.m_hash != profileMember.hashCode() || this.m_profile.tag != profileMember.profile().tag || this.m_profile.profile_data.length != profileMember.m_profile.profile_data.length) {
                return false;
            }
            int n = 0;
            while (n < this.m_profile.profile_data.length) {
                if (this.m_profile.profile_data[n] != profileMember.m_profile.profile_data[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

