/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractList;
import java.util.ArrayList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class IORDump {
    private static void printUsage() {
        System.out.println("Usage: java org.openorb.util.IORDump [Options]");
        System.out.println("Options:");
        System.out.println("  -bind             Giving it a chance to be redirected.");
        System.out.println("  -f <filename|IOR> File containing IORs or explicit IOR.");
    }

    private static String readString(FileReader fileReader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(256);
        while ((n = fileReader.read()) != -1) {
            if (n == 13 || n == 10) {
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        java.lang.Object object;
        java.lang.Object object2;
        boolean bl = false;
        ArrayList<java.lang.Object> arrayList = new ArrayList<java.lang.Object>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-bind") || stringArray[n].equals("--bind")) {
                bl = true;
            } else if (stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                IORDump.printUsage();
                System.exit(0);
            } else if (stringArray[n].startsWith("-ORB")) {
                if (stringArray.length < n + 1 && !stringArray[n + 1].startsWith("-")) {
                    ++n;
                } else if (stringArray[n].startsWith("-")) {
                    IORDump.printUsage();
                    System.exit(1);
                }
            } else if (stringArray[n].equals("-f")) {
                if (n < stringArray.length) {
                    ++n;
                    try {
                        object2 = new FileReader(new File(stringArray[n]));
                        while (((InputStreamReader)object2).ready()) {
                            object = IORDump.readString((FileReader)object2);
                            if (!((String)object).startsWith("IOR:")) continue;
                            arrayList.add(object);
                        }
                        ((InputStreamReader)object2).close();
                    }
                    catch (Exception exception) {
                        System.err.println("Exception: " + ((java.lang.Object)exception).toString());
                        System.exit(2);
                    }
                } else {
                    IORDump.printUsage();
                    System.exit(1);
                }
            } else if (stringArray[n].startsWith("IOR:")) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            IORDump.printUsage();
            System.exit(1);
        }
        try {
            object2 = ORB.init(stringArray, null);
            object = ((AbstractList)arrayList).iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Object object3 = ((ORB)object2).string_to_object(string);
                if (bl && object3._non_existent()) {
                    System.err.println("Target is non_existent.");
                }
                System.out.println(object3);
            }
        }
        catch (SystemException systemException) {
            System.err.println("SystemException: " + ((java.lang.Object)systemException).toString());
            System.exit(2);
        }
    }
}

