#include "CosNaming_c.hh"
#include "Convertisseur_c.hh"
#include <string>
#include <iostream>

// USE_STD_NS is a define setup by VisiBroker to use the std namespace
USE_STD_NS

int main(int argc, char* const* argv)
{
  try {
    // Initialisation de l'ORB
    CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);

    // Recuperation de l'IOR du service de nommage
		CORBA::Object_var rootContextObj = orb->resolve_initial_references("NameService");
    CosNaming::NamingContext_var rootContext = 
			CosNaming::NamingContext::_narrow(rootContextObj);
        
	// On demande le nom de l'objet CORBA a contacter
	cout << "Quel objet Corba voulez-vous contacter ?" << endl;
	string nom;
	cin >> nom;

    // Recherche de l'IOR du convertisseur
    CosNaming::Name name;
    name.length(1);
    name[0].id = (const char *) nom.c_str();
    name[0].kind = (const char *) "";
	CORBA::Object_var euroObj = rootContext->resolve(name);
    Convertisseur::Euro_var convertisseur = 
		Convertisseur::Euro::_narrow(euroObj);

	int choix = 0;
	CORBA::Double francs = 0.0;
	CORBA::Double euros = 0.0;
	do {
		cout << "0 - quitter" << endl;
		cout << "1 - francs -> euros" << endl;
		cout << "2 - euros -> francs" << endl;
		cout << "Votre choix : ";

		cin >> choix;

		if (choix == 1) {
			cout << "Valeur en francs : ";
			cin >> francs;
			euros = convertisseur->toEuro(francs);
			cout << francs << " F = " << euros << " Euros" << endl;
		} else if (choix == 2) {
			cout << "Valeur en euros : ";
			cin >> euros;
			francs = convertisseur->toDevise(euros);
			cout << euros << " Euros = " << francs << " F" << endl;
		}

	} while(choix != 0);
  }
  catch(const CORBA::Exception& e) {
    cerr << e << endl;
    return 1;
  }

  return 0;
}
