import java.awt.event.*;
import java.io.BufferedReader;
import java.io.InputStreamReader;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.text.*;

/**
 * Convertisseur Euro - Partie Client
 * @author Yann Steff & Emmanuel Lavinal
 */

/********************************
* Interface Graphique du Client *
********************************/
class InterfaceFrame extends JFrame implements DocumentListener, ActionListener {

	private DoubleTextField taux;
	private JTextField devise;
	private java.awt.Container contentPane;
	private FonctionnementPanel p2;
	private AProposDialogue dialogue;
	private JMenuItem itemQuitter, itemAPropos;

	// Constructeur
	public InterfaceFrame() {
		setTitle("Convertisseur Euro");
		setSize(350, 250);
		addWindowListener(new WindowAdapter() {  public void windowClosing(WindowEvent e) {
			System.exit(0); } } );

		this.setResizable(false);

		contentPane = getContentPane();

      	// Insertion d'un menu
		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);
		JMenu menu = new JMenu("Fichier");
		menu.setMnemonic('F');
		itemQuitter = new JMenuItem("Quitter");
		itemQuitter.addActionListener(this);
		menu.add(itemQuitter);
		menuBar.add(menu);

		JMenu aide = new JMenu("Aide");
		aide.setMnemonic('A');
		itemAPropos = new JMenuItem("A Propos");
		itemAPropos.addActionListener(this);
		aide.add(itemAPropos);
		menuBar.add(aide);

		// Insertion d'un cadre
		Border bordureParam = BorderFactory.createEtchedBorder();
		Border titreBordureParam = BorderFactory.createTitledBorder(bordureParam,"Parametres");

		JPanel p = new JPanel();
		devise = new JTextField(ClientConvertisseurEuro.monEuro.devise(), 10);
		p.add(new JLabel("Devise"));
		p.add(devise);
		devise.getDocument().addDocumentListener(this);

		taux = new DoubleTextField(ClientConvertisseurEuro.monEuro.taux(), 8);
		p.add(new JLabel("Taux"));
		p.add(taux);
		taux.getDocument().addDocumentListener(this);
		p.setBorder(titreBordureParam);
		contentPane.add(p, "South");

		p2 = new FonctionnementPanel();
      	contentPane.add(p2,"Center");
   } // constructeur InterfaceFrame

   public void actionPerformed(ActionEvent evt) {

   	java.lang.Object source = evt.getSource();
   	if (source==itemQuitter)
   		System.exit(0);
    else if (source==itemAPropos) {
    		if (dialogue==null)
          dialogue= new AProposDialogue(this);
         dialogue.show();
         repaint();
    }
   } // method actionPerformed


   public void insertUpdate(DocumentEvent e) {
   	ClientConvertisseurEuro.monEuro.devise(devise.getText());
   	ClientConvertisseurEuro.monEuro.taux(taux.getValue());
   	p2.toDevise.setText("Vers "+ClientConvertisseurEuro.monEuro.devise());
   }

   public void removeUpdate(DocumentEvent e) {
   	ClientConvertisseurEuro.monEuro.devise(devise.getText());
   	ClientConvertisseurEuro.monEuro.taux(taux.getValue());
   	p2.toDevise.setText("Vers "+ClientConvertisseurEuro.monEuro.devise());
   }

   public void changedUpdate(DocumentEvent e) {
   }

} // class InterfaceFrame

class AProposDialogue extends JDialog {

	// Constructeur
	public AProposDialogue(JFrame parent) {

		super(parent, "A propos du convertisseur Euro",true);
		Box b = Box.createVerticalBox();
		b.add(Box.createGlue());
		b.add(new JLabel("Convertisseur Euro 1.1"));
		b.add(new JLabel("Par Yann STEFF Copyright 2000"));
		b.add(new JLabel("Mise  jour Emmanuel Lavinal 2003"));
		b.add(Box.createGlue());
		getContentPane().add(b, "Center");

		JPanel p2 = new JPanel();
		JButton ok = new JButton("Ok");
		p2.add(ok);
		getContentPane().add(p2, "South");

		ok.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				setVisible(false);
			}
         } );

		setSize(250, 150);
   } // constructeur AproposDialogue
} // class AproposDialogue



class FonctionnementPanel extends JPanel implements ActionListener, DocumentListener {

	private JButton toEuro;
	public JButton toDevise;
	private DoubleTextField somme;
	//private DoubleTextField resultat;
	private JTextField resultat;

	// Constructeur
	public FonctionnementPanel() {
	 somme = new DoubleTextField(0, 8);
      add(new JLabel("Somme"));
      add(somme);
      somme.getDocument().addDocumentListener(this);

      toEuro=new JButton("Vers Euro");
      toDevise=new JButton("Vers "+ClientConvertisseurEuro.monEuro.devise());

      //resultat = new DoubleTextField(0, 8);
      resultat = new JTextField(8);
	  add(new JLabel("Resultat"));
      add(resultat);
      resultat.getDocument().addDocumentListener(this);

      add(toEuro);
      add(toDevise);

      toEuro.addActionListener(this);
      toDevise.addActionListener(this);
   }


   public void insertUpdate(DocumentEvent e) {
   }
   public void removeUpdate(DocumentEvent e) {
   }
   public void changedUpdate(DocumentEvent e) {
   }

   public void actionPerformed(ActionEvent evt) {

   	java.lang.Object source = evt.getSource();
   	Double temp = new Double(0);

   	if (source == toEuro)
   		temp = new Double(ClientConvertisseurEuro.monEuro.toEuro(somme.getValue()));
   	else if (source == toDevise)
   		temp = new Double(ClientConvertisseurEuro.monEuro.toDevise(somme.getValue()));

   	java.text.NumberFormat nf = java.text.NumberFormat.getNumberInstance();
   	nf.setMaximumFractionDigits(4);
   	String tempf = nf.format(temp);
   	resultat.setText(tempf);
   	} // actionPerformed

} // class FonctionnementPanel


class DoubleTextDocument extends PlainDocument {
	public void insertString(int offs, String str, AttributeSet a)
      throws BadLocationException {
		if (str == null) return;
		String oldString = getText(0, getLength());
		String newString = oldString.substring(0, offs) + str + oldString.substring(offs);
      try {
      	Double.parseDouble(newString + "0");
         super.insertString(offs, str, a);
      }
      catch(NumberFormatException e){
      }
   }
} // class DoubleTextDocument

class DoubleTextField extends JTextField {
	public DoubleTextField(double defval, int size) {
		super("" + defval, size);
   }

   protected Document createDefaultModel() {
   	return new DoubleTextDocument();
   }

   public boolean isValid() {
   	try {
   		Double.parseDouble(getText());
         return true;
      }
   	catch(NumberFormatException e) {
      	return false;
      }
   }

   public double getValue() {
   	try {
   		return Double.parseDouble(getText());
     }
     catch(NumberFormatException e) {
     	return 0;
      }
   }
} // DoubleTextField


/*******************************
* Client CORBA de l'objet Euro *
*******************************/
public class ClientConvertisseurEuro {

	public static Convertisseur.Euro monEuro;

	public static void main(String args[]) {

		try {

		// Intialisation de l'orb
		org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args,null);



/*
        // Saisie du nom de l'objet (si utilisation du service de nommage)
        System.out.println("Quel objet Corba voulez-vous contacter ?");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String idObj = in.readLine();

        // Recuperation du naming service
        org.omg.CosNaming.NamingContext nameRoot =
        		org.omg.CosNaming.NamingContextHelper.narrow(orb.resolve_initial_references("NameService"));

        // Construction du nom a rechercher
        org.omg.CosNaming.NameComponent[] nameToFind = new org.omg.CosNaming.NameComponent[1];
         nameToFind[0] = new org.omg.CosNaming.NameComponent(idObj,"");

        // Recherche aupres du naming service
        org.omg.CORBA.Object distantEuro = nameRoot.resolve(nameToFind);
        System.out.println("Objet '" + idObj + "' trouve aupres du service de noms. IOR de l'objet :");
        System.out.println(orb.object_to_string(distantEuro));
*/
        // Utilisation directe de l'IOR (SAUF utilisation du service de nommage)
        org.omg.CORBA.Object distantEuro = orb.string_to_object("IOR:000...");

        // Casting de l'objet CORBA au type convertisseur euro
        monEuro = Convertisseur.EuroHelper.narrow(distantEuro);

        // Appel de l'interface graphique
        JFrame frame = new InterfaceFrame();
        frame.show();
	}
	catch (Exception e) {
		e.printStackTrace();
	}

} // main
} // class ClientConvertisseurEuro

