/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.iiop.value;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.CORBA_2_3.ORB;
import org.omg.PortableServer.POA;
import org.openorb.test.ORBTestCase;
import org.openorb.test.iiop.value.AbstractA;
import org.openorb.test.iiop.value.AbstractA1Impl;
import org.openorb.test.iiop.value.AbstractA1POATie;
import org.openorb.test.iiop.value.AbstractA2Impl;
import org.openorb.test.iiop.value.AbstractA3Impl;
import org.openorb.test.iiop.value.AbstractAHelper;
import org.openorb.test.iiop.value.LongBox;
import org.openorb.test.iiop.value.TestTC01;
import org.openorb.test.iiop.value.TestTC01Helper;
import org.openorb.test.iiop.value.TestTC01POA;
import org.openorb.test.iiop.value.ValueA;
import org.openorb.test.iiop.value.ValueAHelper;
import org.openorb.test.iiop.value.ValueAImpl;
import org.openorb.test.iiop.value.ValueB;
import org.openorb.test.iiop.value.ValueBHelper;
import org.openorb.test.iiop.value.ValueBValueFactory;
import org.openorb.test.iiop.value.ValueC;
import org.openorb.test.iiop.value.ValueCFactory;
import org.openorb.test.iiop.value.ValueCHelper;
import org.openorb.test.iiop.value.ValueCImpl;
import org.openorb.test.iiop.value.ValueD;
import org.openorb.test.iiop.value.ValueDFactory;
import org.openorb.test.iiop.value.ValueDHelper;
import org.openorb.test.iiop.value.ValueDImpl;
import org.openorb.test.iiop.value.ValueE;
import org.openorb.test.iiop.value.ValueEImpl;
import org.openorb.test.iiop.value.ValueERemote;
import org.openorb.test.iiop.value.ValueERemoteOperations;
import org.openorb.test.iiop.value.ValueERemotePOATie;
import org.openorb.test.iiop.value.ValueF;
import org.openorb.test.iiop.value.ValueFImpl;
import org.openorb.test.iiop.value.ValueG;
import org.openorb.test.iiop.value.ValueGImpl;

public class ValuetypeTest
extends ORBTestCase {
    private ORB m_orb;
    private TestTC01 m_cltRef;
    private Any m_any;
    private static final int F_L = 49875;
    static /* synthetic */ Class class$org$openorb$test$iiop$value$ValuetypeTest;

    public ValuetypeTest(String string) {
        super(string);
    }

    protected void setUp() {
        super.setUp();
        try {
            org.omg.CORBA.ORB oRB = this.getORB();
            this.m_orb = (ORB)oRB;
            POA pOA = (POA)oRB.resolve_initial_references("RootPOA");
            pOA.the_POAManager().activate();
            TestTC01 testTC01 = new TestTC01Impl(pOA)._this(oRB);
            this.m_cltRef = TestTC01Helper.narrow(this.forceMarshal(testTC01));
            this.m_any = this.m_orb.create_any();
        }
        catch (UserException userException) {
            Assert.fail("exception during setup:" + ((java.lang.Object)userException).toString());
        }
    }

    public void testBasicValuetype() {
        java.lang.Object object = this.m_cltRef.get_value_a(0);
        Assert.assertTrue("Value returned from get_value_a(0) is not a ValueA", object instanceof ValueA);
        object = this.m_cltRef.get_value(0);
        Assert.assertTrue("Value returned from get_value(0) is not a ValueA", object instanceof ValueA);
        object = this.m_cltRef.get_abstract(0);
        Assert.assertTrue("Value returned from get_abstract(0) is not a ValueA", object instanceof ValueA);
        ValueAHelper.insert(this.m_any, (ValueA)object);
        this.m_cltRef.echo_any(this.m_any);
    }

    public void testPMValuetype() {
        java.lang.Object object = this.m_cltRef.get_value_b();
        Assert.assertTrue("Value returned from get_value_b() is not a ValueB", object instanceof ValueB);
        object = this.m_cltRef.get_value(1);
        Assert.assertTrue("Value returned from get_value(1) is not a ValueB", object instanceof ValueB);
        object = this.m_cltRef.get_abstract(1);
        Assert.assertTrue("Value returned from get_abstract(1) is not a ValueB", object instanceof ValueB);
    }

    public void testNontruncatableValuetype() {
        try {
            this.m_cltRef.get_value_c();
            Assert.fail("Read a ValueC without factory (should fail)");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        try {
            this.m_cltRef.get_value_a(2);
            Assert.fail("Read a ValueC as ValueA without factory (should fail)");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        try {
            this.m_cltRef.get_value(2);
            Assert.fail("Read a ValueC as ValueBase without factory (should fail)");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        this.m_orb.register_value_factory(ValueCHelper.id(), new ValueCFactory());
        java.lang.Object object = this.m_cltRef.get_value_c();
        Assert.assertTrue("Value returned from get_value_c() is not a ValueC", object instanceof ValueC);
        object = this.m_cltRef.get_value_a(2);
        Assert.assertTrue("Value returned from get_value_a(2) is not a ValueC", object instanceof ValueC);
        object = this.m_cltRef.get_value(2);
        Assert.assertTrue("Value returned from get_value(2) is not a ValueC", object instanceof ValueC);
        object = this.m_cltRef.get_abstract(2);
        Assert.assertTrue("Value returned from get_abstract(2) is not a ValueC", object instanceof ValueC);
    }

    public void testTruncatableValuetype() {
        try {
            this.m_cltRef.get_value_d();
            Assert.fail("Read a ValueD without factory (should fail)");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        java.lang.Object object = this.m_cltRef.get_value_a(3);
        Assert.assertTrue("Truncated value returned from get_value_a(3) is not a ValueA", object instanceof ValueA);
        Assert.assertTrue("Truncated value returned from get_value_a(3) is a ValueD", !(object instanceof ValueD));
        object = this.m_cltRef.get_value(3);
        Assert.assertTrue("Truncated value returned from get_value(3) is not a ValueA", object instanceof ValueA);
        Assert.assertTrue("Truncated value returned from get_value(3) is a ValueD", !(object instanceof ValueD));
        this.m_orb.register_value_factory(ValueDHelper.id(), new ValueDFactory());
        object = this.m_cltRef.get_value_d();
        Assert.assertTrue("Value returned from get_value_d() is not a ValueD", object instanceof ValueD);
        object = this.m_cltRef.get_value_a(3);
        Assert.assertTrue("Value returned from get_value_a(3) is not a ValueD", object instanceof ValueD);
        object = this.m_cltRef.get_value(3);
        Assert.assertTrue("Value returned from get_value(3) is not a ValueD", object instanceof ValueD);
        object = this.m_cltRef.get_abstract(3);
        Assert.assertTrue("Value returned from get_abstract(3) is not a ValueC", object instanceof ValueD);
    }

    public void testSupportsValuetype() {
        java.lang.Object object = this.m_cltRef.get_value_e();
        Assert.assertTrue("Value returned from get_value_e() is not a ValueERemoteOperations", object instanceof ValueERemoteOperations);
        Assert.assertTrue("Value returned from get_value_e() is not a ValueE", object instanceof ValueE);
        Assert.assertTrue("Value returned from get_value_e() is an object reference", !(object instanceof Object));
        object = this.m_cltRef.get_value_e_remote();
        Assert.assertTrue("Value returned from get_value_e_remote() is not a ValueERemote", object instanceof ValueERemote);
        Assert.assertTrue("Value returned from get_value_e_remote() is not an object reference", object instanceof Object);
        object = this.m_cltRef.get_value(4);
        Assert.assertTrue("Value returned from get_value(4) is not a ValueE", object instanceof ValueE);
        object = this.m_cltRef.get_abstract(4);
        Assert.assertTrue("Value returned from get_abstract(4) is not a ValueE", object instanceof ValueE);
    }

    public void testCustomMarshalValuetype() {
        java.lang.Object object = this.m_cltRef.get_value_f();
        Assert.assertTrue("Value returned from get_value_f() is not a ValueF", object instanceof ValueF);
        object = this.m_cltRef.get_value(5);
        Assert.assertTrue("Value returned from get_value(5) is not a ValueF", object instanceof ValueF);
        object = this.m_cltRef.get_abstract(5);
        Assert.assertTrue("Value returned from get_abstract(5) is not a ValueF", object instanceof ValueF);
    }

    public void testNestedValuetype() {
        java.lang.Object object = this.m_cltRef.get_value_g();
        Assert.assertTrue("Value returned from get_value_g() is not a ValueG", object instanceof ValueG);
        object = this.m_cltRef.get_value(6);
        Assert.assertTrue("Value returned from get_value(6) is not a ValueG", object instanceof ValueG);
        object = this.m_cltRef.get_abstract(6);
        Assert.assertTrue("Value returned from get_abstract(6) is not a ValueG", object instanceof ValueG);
        ValueG valueG = (ValueG)object;
        Assert.assertTrue("Valuetype cycle has not transmitted properly", valueG == valueG.left.parent && valueG == valueG.right.parent);
    }

    public void testAbstract() {
        AbstractA abstractA = this.m_cltRef.get_abstract_a(0);
        Assert.assertTrue("Value returned from get_abstract_a(0) is not an AbstractA", abstractA instanceof AbstractA);
        Assert.assertTrue("Value returned from get_abstract_a(0) is not an Object", abstractA instanceof Object);
        abstractA = this.m_cltRef.get_abstract_a(1);
        Assert.assertTrue("Value returned from get_abstract_a(1) is not an AbstractA", abstractA instanceof AbstractA);
        Assert.assertTrue("Value returned from get_abstract_a(1) is an Object", !(abstractA instanceof Object));
        abstractA = this.m_cltRef.get_abstract_a(2);
        Assert.assertTrue("Value returned from get_abstract_a(2) is not an AbstractA", abstractA instanceof AbstractA);
        Assert.assertTrue("Value returned from get_abstract_a(2) is an Object", !(abstractA instanceof Object));
        abstractA = this.m_cltRef.get_abstract_a(3);
        Assert.assertTrue("Value returned from get_abstract_a(3) is not an AbstractA", abstractA instanceof AbstractA);
        Assert.assertTrue("Value returned from get_abstract_a(3) is not an Object", abstractA instanceof Object);
        AbstractAHelper.insert(this.m_any, abstractA);
        this.m_cltRef.echo_any(this.m_any);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$iiop$value$ValuetypeTest == null ? (class$org$openorb$test$iiop$value$ValuetypeTest = ValuetypeTest.class$("org.openorb.test.iiop.value.ValuetypeTest")) : class$org$openorb$test$iiop$value$ValuetypeTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TestTC01Impl
    extends TestTC01POA {
        private POA m_poa;

        TestTC01Impl(POA pOA) {
            this.m_poa = pOA;
        }

        public POA _default_POA() {
            return this.m_poa;
        }

        public Any echo_any(Any any) {
            return any;
        }

        public TypeCode echo_TypeCode(TypeCode typeCode) {
            return typeCode;
        }

        public LongBox echo_longBox(LongBox longBox) {
            return longBox;
        }

        public int[] echo_longBoxSeq(int[] nArray) {
            return nArray;
        }

        public Serializable get_value(int n) {
            switch (n) {
                case 0: {
                    return this.get_value_a(0);
                }
                case 1: {
                    return this.get_value_b();
                }
                case 2: {
                    return this.get_value_c();
                }
                case 3: {
                    return this.get_value_d();
                }
                case 4: {
                    return this.get_value_e();
                }
                case 5: {
                    return this.get_value_f();
                }
                case 6: {
                    return this.get_value_g();
                }
            }
            return null;
        }

        public ValueA get_value_a(int n) {
            switch (n) {
                case 0: {
                    ValueAImpl valueAImpl = new ValueAImpl();
                    valueAImpl.l = 1;
                    valueAImpl.str = "ValueA";
                    return valueAImpl;
                }
                case 2: {
                    return this.get_value_c();
                }
                case 3: {
                    return this.get_value_d();
                }
            }
            return null;
        }

        public ValueB get_value_b() {
            ORB oRB = (ORB)this._orb();
            ValueBValueFactory valueBValueFactory = (ValueBValueFactory)oRB.lookup_value_factory(ValueBHelper.id());
            ValueB valueB = valueBValueFactory.init(1);
            valueB.str = "ValueB";
            return valueB;
        }

        public ValueC get_value_c() {
            ValueCImpl valueCImpl = new ValueCImpl();
            valueCImpl.l = 1;
            valueCImpl.n = 0;
            valueCImpl.str = "ValueC";
            return valueCImpl;
        }

        public ValueD get_value_d() {
            ValueDImpl valueDImpl = new ValueDImpl();
            valueDImpl.l = 1;
            valueDImpl.n = 0;
            valueDImpl.str = "ValueD";
            return valueDImpl;
        }

        public ValueERemote get_value_e_remote() {
            return new ValueERemotePOATie(this.get_value_e(), this._poa())._this(this._orb());
        }

        public ValueE get_value_e() {
            ValueEImpl valueEImpl = new ValueEImpl("remote");
            valueEImpl.prefix = "ValueE";
            return valueEImpl;
        }

        public ValueF get_value_f() {
            ValueFImpl valueFImpl = new ValueFImpl();
            valueFImpl.l = 49875;
            return valueFImpl;
        }

        public ValueG get_value_g() {
            ValueGImpl valueGImpl = new ValueGImpl();
            valueGImpl.idx = 0;
            valueGImpl.name = "root";
            valueGImpl.left = new ValueGImpl();
            valueGImpl.left.idx = 1;
            valueGImpl.left.name = "left";
            valueGImpl.left.parent = valueGImpl;
            valueGImpl.right = new ValueGImpl();
            valueGImpl.right.idx = 1;
            valueGImpl.right.name = "right";
            valueGImpl.right.parent = valueGImpl;
            return valueGImpl;
        }

        public java.lang.Object get_abstract(int n) {
            if (n < 7) {
                return this.get_value(n);
            }
            return this.get_abstract_a(n - 7);
        }

        public AbstractA get_abstract_a(int n) {
            switch (n) {
                case 0: {
                    return new AbstractA1Impl(this._poa())._this(this._orb());
                }
                case 1: {
                    return new AbstractA2Impl();
                }
                case 2: {
                    return new AbstractA3Impl("remote");
                }
                case 3: {
                    return new AbstractA1POATie(new AbstractA3Impl("remote"), this._poa())._this(this._orb());
                }
            }
            return null;
        }
    }
}

