/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.dynany;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynEnum;
import org.openorb.CORBA.dynany.DynAnyImpl;
import org.openorb.CORBA.typecode.TypeCodeBase;

class DynEnumImpl
extends DynAnyImpl
implements DynEnum {
    private int m_enumValue;

    public DynEnumImpl(DynAnyFactory dynAnyFactory, ORB oRB, TypeCode typeCode, int n) {
        super(dynAnyFactory, oRB);
        this.m_type = typeCode;
        this.m_enumValue = n;
    }

    public void assign(DynAny dynAny) throws TypeMismatch {
        if (!dynAny.type().equivalent(this.m_type)) {
            throw new TypeMismatch();
        }
        this.m_enumValue = ((DynEnumImpl)dynAny).m_enumValue;
    }

    public void from_any(Any any) throws InvalidValue, TypeMismatch {
        if (!any.type().equal(this.m_type)) {
            throw new TypeMismatch();
        }
        InputStream inputStream = any.create_input_stream();
        this.m_enumValue = inputStream.read_ulong();
    }

    public Any to_any() {
        Any any = this.m_orb.create_any();
        any.type(this.m_type);
        OutputStream outputStream = any.create_output_stream();
        outputStream.write_ulong(this.m_enumValue);
        return any;
    }

    public void destroy() {
    }

    public DynAny copy() {
        return new DynEnumImpl(this.m_factory, this.m_orb, this.m_type, this.m_enumValue);
    }

    public DynAny current_component() {
        return this;
    }

    public boolean next() {
        return false;
    }

    public boolean seek(int n) {
        return n == 0;
    }

    public void rewind() {
    }

    public int component_count() {
        return 0;
    }

    public String get_as_string() {
        String string = null;
        try {
            string = TypeCodeBase._base_type(this.m_type).member_name(this.m_enumValue);
        }
        catch (BadKind badKind) {
        }
        catch (Bounds bounds) {
            // empty catch block
        }
        return string;
    }

    public void set_as_string(String string) throws InvalidValue {
        block6: {
            try {
                TypeCode typeCode = TypeCodeBase._base_type(this.m_type);
                int n = 0;
                while (n < typeCode.member_count()) {
                    if (typeCode.member_name(n).equals(string)) {
                        this.m_enumValue = n;
                        return;
                    }
                    ++n;
                }
            }
            catch (BadKind badKind) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Trying to overwrite any value with String failed.", badKind);
                }
            }
            catch (Bounds bounds) {
                if (!this.getLogger().isErrorEnabled()) break block6;
                this.getLogger().error("Any Bounds exception.", bounds);
            }
        }
        throw new InvalidValue();
    }

    public int get_as_ulong() {
        return this.m_enumValue;
    }

    public void set_as_ulong(int n) throws InvalidValue {
        this.m_enumValue = n;
    }
}

