/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.PI;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.CurrentImpl;
import org.openorb.PI.RequestCallback;
import org.openorb.PI.ServerManager;
import org.openorb.util.ExceptionTool;

public class SimpleServerManager
implements ServerManager {
    private ServerRequestInterceptor[] m_list;
    private CurrentImpl m_current;
    public static final int BAD_INTERCEPTOR_RESPONSE = 0;
    private Logger m_logger = null;

    public SimpleServerManager(ServerRequestInterceptor[] serverRequestInterceptorArray, CurrentImpl currentImpl) {
        this.m_list = serverRequestInterceptorArray;
        this.m_current = currentImpl;
        this.m_logger = ((ORB)currentImpl._orb()).getLogger();
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        int n = 0;
        CurrentOperations currentOperations = this.m_current.remove();
        try {
            while (n < this.m_list.length) {
                this.m_list[n].receive_request_service_contexts(serverRequestInfo);
                this.m_current.remove();
                ++n;
            }
        }
        catch (SystemException systemException) {
            SystemException systemException2;
            this.m_current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                systemException2 = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)systemException);
            }
            requestCallback.reply_system_exception(systemException2);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (ForwardRequest forwardRequest) {
            this.m_current.remove();
            requestCallback.reply_location_forward(forwardRequest.forward, false);
            this.send_other_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", runtimeException);
            }
            requestCallback.reply_runtime_exception(runtimeException);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (Error error) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", error);
            }
            requestCallback.reply_error(error);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        this.m_current.set(currentOperations);
    }

    public void receive_request(ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        int n = 0;
        CurrentOperations currentOperations = this.m_current.remove();
        try {
            while (n < this.m_list.length) {
                this.m_list[n].receive_request(serverRequestInfo);
                this.m_current.remove();
                ++n;
            }
        }
        catch (SystemException systemException) {
            SystemException systemException2;
            this.m_current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                systemException2 = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)systemException);
            }
            requestCallback.reply_system_exception(systemException2);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (ForwardRequest forwardRequest) {
            this.m_current.remove();
            requestCallback.reply_location_forward(forwardRequest.forward, false);
            this.send_other_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", runtimeException);
            }
            requestCallback.reply_runtime_exception(runtimeException);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (Error error) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", error);
            }
            requestCallback.reply_error(error);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        this.m_current.set(currentOperations);
    }

    public void send_reply(ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        int n = this.m_list.length - 1;
        CurrentOperations currentOperations = this.m_current.remove();
        try {
            while (n >= 0) {
                this.m_list[n].send_reply(serverRequestInfo);
                this.m_current.remove();
                --n;
            }
        }
        catch (SystemException systemException) {
            SystemException systemException2;
            this.m_current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_YES) {
                systemException2 = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_YES), (Throwable)systemException);
            }
            requestCallback.reply_system_exception(systemException2);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", runtimeException);
            }
            requestCallback.reply_runtime_exception(runtimeException);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (Error error) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", error);
            }
            requestCallback.reply_error(error);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        this.m_current.set(currentOperations);
    }

    public void send_exception(ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        CurrentOperations currentOperations = this.m_current.remove();
        this.send_exception_point(this.m_list.length - 1, serverRequestInfo, requestCallback);
        this.m_current.set(currentOperations);
    }

    private void send_exception_point(int n, ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        if (n < 0) {
            return;
        }
        CompletionStatus completionStatus = serverRequestInfo.reply_status() == 1 ? SystemExceptionHelper.extract((Any)serverRequestInfo.sending_exception()).completed : CompletionStatus.COMPLETED_YES;
        while (n >= 0) {
            try {
                this.m_list[n].send_exception(serverRequestInfo);
                this.m_current.remove();
            }
            catch (SystemException systemException) {
                SystemException systemException2;
                this.m_current.remove();
                if (systemException.completed != completionStatus) {
                    systemException2 = ExceptionTool.initCause(new INTERNAL(0, completionStatus), (Throwable)systemException);
                }
                requestCallback.reply_system_exception(systemException2);
            }
            catch (RuntimeException runtimeException) {
                this.m_current.remove();
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Received an unexcepted exception : ", runtimeException);
                }
                requestCallback.reply_runtime_exception(runtimeException);
            }
            catch (Error error) {
                this.m_current.remove();
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Received an unexcepted exception : ", error);
                }
                requestCallback.reply_error(error);
            }
            catch (ForwardRequest forwardRequest) {
                this.m_current.remove();
                if (completionStatus != CompletionStatus.COMPLETED_YES) {
                    requestCallback.reply_system_exception(ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_YES), (Throwable)forwardRequest));
                }
                requestCallback.reply_location_forward(forwardRequest.forward, false);
                this.send_other_point(n - 1, serverRequestInfo, requestCallback);
                return;
            }
            --n;
        }
    }

    public void send_other(ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        CurrentOperations currentOperations = this.m_current.remove();
        this.send_other_point(this.m_list.length - 1, serverRequestInfo, requestCallback);
        this.m_current.set(currentOperations);
    }

    private void send_other_point(int n, ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        if (n < 0) {
            return;
        }
        try {
            try {
                while (n >= 0) {
                    this.m_list[n].send_other(serverRequestInfo);
                    this.m_current.remove();
                    --n;
                }
            }
            catch (ForwardRequest forwardRequest) {
                this.m_current.remove();
                requestCallback.reply_location_forward(forwardRequest.forward, false);
            }
        }
        catch (SystemException systemException) {
            SystemException systemException2;
            this.m_current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                systemException2 = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)systemException);
            }
            requestCallback.reply_system_exception(systemException2);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", runtimeException);
            }
            requestCallback.reply_runtime_exception(runtimeException);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (Error error) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", error);
            }
            requestCallback.reply_error(error);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

