/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.boa;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Contained;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.DomainManagersListHelper;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.ServantObject;
import org.omg.IOP.IOR;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.PI.ComponentSet;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.IORUtil;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.adapter.TargetInfo;
import org.openorb.corbaloc.CorbalocService;
import org.openorb.corbaloc.CorbalocServiceHelper;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerRequest;
import org.openorb.util.RepoIDHelper;

public class BOA
extends org.omg.CORBA.BOA
implements ObjectAdapter {
    private static final byte[] PREFIX = "BOA".getBytes();
    private static short s_next_adapter = 0;
    private static final Policy[] NO_POLICIES = new Policy[0];
    private ServerManager m_server_manager;
    private ORB m_orb;
    private byte[][] m_aid_parts;
    private byte[] m_aid;
    private int m_next_target;
    private CorbalocService m_corbaloc_service;
    private ComponentSet m_comp_set;
    private Map m_targets = new HashMap();
    private Logger m_logger;
    static /* synthetic */ Class class$org$openorb$adapter$boa$BOA;

    public BOA(ServerManager serverManager) {
        this.m_server_manager = serverManager;
        this.m_orb = serverManager.orb();
        this.m_aid_parts = new byte[2][];
        this.m_aid_parts[0] = PREFIX;
        Class clazz = class$org$openorb$adapter$boa$BOA == null ? (class$org$openorb$adapter$boa$BOA = BOA.class$("org.openorb.adapter.boa.BOA")) : class$org$openorb$adapter$boa$BOA;
        synchronized (clazz) {
            this.m_aid_parts[1] = new byte[2];
            this.m_aid_parts[1][0] = (byte)(s_next_adapter >>> 8);
            this.m_aid_parts[1][0] = (byte)s_next_adapter;
            s_next_adapter = (short)(s_next_adapter + 1);
        }
        byte[][] byArrayArray = new byte[this.m_aid_parts.length + 1][];
        System.arraycopy(this.m_aid_parts, 0, byArrayArray, 0, this.m_aid_parts.length);
        byArrayArray[this.m_aid_parts.length] = new byte[0];
        this.m_aid = serverManager.create_cacheable_object_key(true, byArrayArray);
        serverManager.register_adapter(this.m_aid, this);
    }

    public void connect(ObjectImpl objectImpl) {
        this.connect(objectImpl, false);
    }

    public void connect(ObjectImpl objectImpl, boolean bl) {
        BOAEntry bOAEntry;
        try {
            if (objectImpl._get_delegate() != null) {
                return;
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            // empty catch block
        }
        byte[] byArray = this.m_aid;
        synchronized (byArray) {
            bOAEntry = new BOAEntry(this.m_aid, this.m_next_target++);
        }
        bOAEntry.setState(bl);
        bOAEntry.setTarget(objectImpl);
        byte[][] byArrayArray = new byte[][]{this.m_aid_parts[0], this.m_aid_parts[1], new byte[4]};
        int n = bOAEntry.getId();
        byArrayArray[2] = bOAEntry.getObjectID();
        byte[] byArray2 = this.m_server_manager.create_cacheable_object_key(false, byArrayArray);
        if (this.m_comp_set == null) {
            this.m_comp_set = new ComponentSet(this.m_orb, null, null);
            this.m_comp_set.interception_point();
        }
        IOR iOR = IORUtil.construct_ior(objectImpl._ids()[0], byArray2, this.m_comp_set, this.m_server_manager.get_protocol_ids(), this.m_orb);
        Delegate delegate = new Delegate(this.m_orb, iOR);
        objectImpl._set_delegate(delegate);
        Map map = this.m_targets;
        synchronized (map) {
            this.m_targets.put(new Integer(bOAEntry.getId()), bOAEntry);
        }
    }

    public void connect(ObjectImpl objectImpl, String string) {
        if (this.m_corbaloc_service == null) {
            try {
                this.m_corbaloc_service = CorbalocServiceHelper.narrow(this.m_orb.resolve_initial_references("CorbalocService"));
            }
            catch (InvalidName invalidName) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Could not resolve CorbalocService.", invalidName);
                }
                throw new INITIALIZE("Could not resolve CorbalocService (" + invalidName + ")");
            }
        }
        this.connect(objectImpl);
        this.m_corbaloc_service.put(string, objectImpl);
    }

    public void forward(ObjectImpl objectImpl, ObjectImpl objectImpl2) {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry bOAEntry = this.find_entry(objectImpl);
            if (bOAEntry != null) {
                objectImpl._set_delegate(objectImpl2._get_delegate());
                bOAEntry.setTarget(objectImpl2);
            }
        }
    }

    public void disconnect(ObjectImpl objectImpl) {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry bOAEntry = this.find_entry(objectImpl);
            if (bOAEntry != null) {
                this.m_targets.remove(new Integer(bOAEntry.getId()));
            }
        }
    }

    public void obj_is_ready(ObjectImpl objectImpl) {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry bOAEntry = this.find_entry(objectImpl);
            if (bOAEntry != null) {
                bOAEntry.activate();
            }
        }
    }

    public void deactivate_obj(ObjectImpl objectImpl) {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry bOAEntry = this.find_entry(objectImpl);
            if (bOAEntry != null) {
                bOAEntry.deactivate();
            }
        }
    }

    public void impl_is_ready() {
        this.m_server_manager.register_adapter(this.m_aid, this);
        this.m_orb.run();
    }

    public void deactivate_impl() {
        this.m_server_manager.unregister_adapter(this.m_aid);
    }

    public int cache_priority() {
        return 0;
    }

    public boolean single_threaded() {
        return false;
    }

    public void etherealize(boolean bl) {
    }

    public ServerManager.AdapterManager getAdapterManager() {
        return null;
    }

    public ObjectAdapter find_adapter(byte[] byArray) throws AdapterDestroyedException {
        Map map = this.m_targets;
        synchronized (map) {
            if (this.find_entry(byArray) == null) {
                ObjectAdapter objectAdapter = null;
                return objectAdapter;
            }
        }
        return this;
    }

    public byte[] adapter_id(byte[] byArray) {
        Map map = this.m_targets;
        synchronized (map) {
            if (this.find_entry(byArray) == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
        }
        return this.m_aid;
    }

    public byte[] object_id(byte[] byArray) {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry bOAEntry = this.find_entry(byArray);
            if (bOAEntry == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray3 = bOAEntry.getObjectID();
            return byArray3;
        }
    }

    public Policy[] get_server_policies(int[] nArray) {
        return NO_POLICIES;
    }

    public boolean forced_marshal(byte[] byArray) throws AdapterDestroyedException {
        return false;
    }

    public ServantObject servant_preinvoke(byte[] byArray, String string, Class clazz) throws ForwardRequest, AdapterDestroyedException {
        ServantObject servantObject = new ServantObject();
        servantObject.servant = this.find_target(byArray);
        return servantObject;
    }

    public void servant_postinvoke(byte[] byArray, ServantObject servantObject) {
    }

    public boolean locate(byte[] byArray) throws ForwardRequest, AdapterDestroyedException {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry bOAEntry = this.find_entry(byArray);
            boolean bl = bOAEntry != null && bOAEntry.getState();
            return bl;
        }
    }

    public boolean is_a(byte[] byArray, String string) throws ForwardRequest, AdapterDestroyedException {
        BOAEntry bOAEntry;
        Map map = this.m_targets;
        synchronized (map) {
            bOAEntry = this.find_entry(byArray);
            if (bOAEntry == null) {
                this.find_target(byArray);
            }
        }
        return bOAEntry.targetIsA(string);
    }

    public Object get_interface_def(byte[] byArray) throws ForwardRequest, AdapterDestroyedException {
        String string;
        Map map = this.m_targets;
        synchronized (map) {
            string = this.find_target(byArray)._ids()[0];
        }
        return this.get_interface_def(string);
    }

    private Object get_interface_def(String string) {
        Repository repository;
        Object object;
        try {
            object = this.m_orb.resolve_initial_references("InterfaceRepository");
        }
        catch (InvalidName invalidName) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Could not resolve InterfaceRepository.", invalidName);
            }
            throw new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO);
        }
        if (object == null) {
            throw new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO);
        }
        try {
            repository = RepositoryHelper.narrow(object);
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Could not narrow obj to type Repository.", bAD_PARAM);
            }
            throw new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO);
        }
        Contained contained = repository.lookup_id(string);
        if (contained == null) {
            throw new INTF_REPOS(1146056720, CompletionStatus.COMPLETED_NO);
        }
        return contained;
    }

    public DomainManager[] get_domain_managers(byte[] byArray) throws ForwardRequest, AdapterDestroyedException {
        BOAEntry bOAEntry;
        Map map = this.m_targets;
        synchronized (map) {
            bOAEntry = this.find_entry(byArray);
            if (bOAEntry == null) {
                this.find_target(byArray);
            }
        }
        return this.lookup_domain_managers(bOAEntry);
    }

    private DomainManager[] lookup_domain_managers(BOAEntry bOAEntry) {
        return new DomainManager[0];
    }

    public Object get_component(byte[] byArray) throws ForwardRequest, AdapterDestroyedException {
        return this.target_get_component(this.find_target(byArray));
    }

    private Object target_get_component(ObjectImpl objectImpl) {
        throw new NO_IMPLEMENT();
    }

    public TargetInfo predispatch(ServerRequest serverRequest) throws ForwardRequest, AdapterDestroyedException {
        BOAEntry bOAEntry;
        Map map = this.m_targets;
        synchronized (map) {
            bOAEntry = this.find_entry(serverRequest.object_key());
            if (bOAEntry == null) {
                this.find_target(serverRequest.object_key());
            }
        }
        return bOAEntry;
    }

    public void dispatch(ServerRequest serverRequest, TargetInfo targetInfo) {
        ObjectImpl objectImpl;
        if (serverRequest.is_locate()) {
            return;
        }
        String string = serverRequest.operation();
        if (string.charAt(0) == '_') {
            if (string.equals("_is_a")) {
                String string2 = serverRequest.argument_stream().read_string();
                serverRequest.createReply().write_boolean(targetInfo.targetIsA(string2));
                return;
            }
            if (string.equals("_get_domain_managers")) {
                serverRequest.argument_stream();
                DomainManagersListHelper.write(serverRequest.createReply(), this.lookup_domain_managers((BOAEntry)targetInfo));
                return;
            }
            if (string.equals("_interface")) {
                serverRequest.argument_stream();
                serverRequest.createReply().write_Object(this.get_interface_def(targetInfo.getRepositoryID()));
                return;
            }
            if (string.equals("_non_existent") || string.equals("_not_existent")) {
                serverRequest.argument_stream();
                serverRequest.createReply().write_boolean(false);
            } else if (string.equals("_component")) {
                serverRequest.argument_stream();
                serverRequest.createReply().write_Object(this.target_get_component(((BOAEntry)targetInfo).getTarget()));
                return;
            }
        }
        if ((objectImpl = ((BOAEntry)targetInfo).getTarget()) instanceof InvokeHandler) {
            ((InvokeHandler)((java.lang.Object)objectImpl))._invoke(string, serverRequest.argument_stream(), serverRequest);
        } else if (objectImpl instanceof DynamicImplementation) {
            org.openorb.CORBA.dsi.ServerRequest serverRequest2 = new org.openorb.CORBA.dsi.ServerRequest(serverRequest);
            ((DynamicImplementation)objectImpl).invoke(serverRequest2);
            if (serverRequest.state() == 3) {
                serverRequest2.set_result(this.m_orb.create_any());
            }
        }
    }

    public void cancel_dispatch(ServerRequest serverRequest, TargetInfo targetInfo) {
    }

    private ObjectImpl find_target(byte[] byArray) {
        Map map = this.m_targets;
        synchronized (map) {
            byte[][] byArray2 = this.m_server_manager.extract_cacheable_object_key(byArray);
            if (this.m_aid_parts.length != byArray2.length - 1) {
                throw new OBJ_ADAPTER(0, CompletionStatus.COMPLETED_NO);
            }
            int n = 0;
            while (n < this.m_aid_parts.length) {
                if (!Arrays.equals(this.m_aid_parts[n], byArray2[n])) {
                    throw new OBJ_ADAPTER(0, CompletionStatus.COMPLETED_NO);
                }
                ++n;
            }
            byte[] byArray3 = byArray2[byArray2.length - 1];
            Integer n2 = new Integer((byArray3[0] & 0xFF) << 24 | (byArray3[1] & 0xFF) << 16 | (byArray3[2] & 0xFF) << 8 | byArray3[3] & 0xFF);
            BOAEntry bOAEntry = (BOAEntry)this.m_targets.get(n2);
            if (bOAEntry == null || !bOAEntry.getState()) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            ObjectImpl objectImpl = bOAEntry.getTarget();
            return objectImpl;
        }
    }

    private BOAEntry find_entry(byte[] byArray) {
        byte[][] byArray2 = this.m_server_manager.extract_cacheable_object_key(byArray);
        if (byArray2.length != this.m_aid_parts.length + 1) {
            return null;
        }
        int n = 0;
        while (n < this.m_aid_parts.length) {
            if (!Arrays.equals(this.m_aid_parts[n], byArray2[n])) {
                return null;
            }
            ++n;
        }
        byte[] byArray3 = byArray2[this.m_aid_parts.length];
        Integer n2 = new Integer((byArray3[0] & 0xFF) << 24 | (byArray3[1] & 0xFF) << 16 | (byArray3[2] & 0xFF) << 8 | byArray3[3] & 0xFF);
        return (BOAEntry)this.m_targets.get(n2);
    }

    private BOAEntry find_entry(ObjectImpl objectImpl) {
        Iterator iterator = this.m_targets.values().iterator();
        while (iterator.hasNext()) {
            BOAEntry bOAEntry = (BOAEntry)iterator.next();
            if (bOAEntry.getTarget() != objectImpl) continue;
            return bOAEntry;
        }
        return null;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class BOAEntry
    implements TargetInfo {
        private byte[] m_adapter_id;
        private byte[] m_object_id;
        private int m_id;
        private boolean m_active;
        private ObjectImpl m_target;

        BOAEntry(byte[] byArray, int n) {
            this.m_id = n;
            this.m_object_id = new byte[4];
            this.m_object_id[0] = (byte)(n >>> 24);
            this.m_object_id[1] = (byte)(n >>> 16);
            this.m_object_id[2] = (byte)(n >>> 8);
            this.m_object_id[3] = (byte)n;
            this.m_adapter_id = byArray;
        }

        public int getId() {
            return this.m_id;
        }

        public boolean getState() {
            return this.m_active;
        }

        public void setState(boolean bl) {
            this.m_active = bl;
        }

        public void activate() {
            this.m_active = true;
        }

        public void deactivate() {
            this.m_active = false;
        }

        public ObjectImpl getTarget() {
            return this.m_target;
        }

        public void setTarget(ObjectImpl objectImpl) {
            this.m_target = objectImpl;
        }

        public String getRepositoryID() {
            return this.m_target._ids()[0];
        }

        public boolean targetIsA(String string) {
            java.lang.Object object = RepoIDHelper.createIsATest(string);
            if (object.equals("IDL:omg.org/CORBA/Object:1.0")) {
                return true;
            }
            String[] stringArray = this.m_target._ids();
            int n = 0;
            while (n < stringArray.length) {
                if (object.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
            return this.m_target._is_a(string);
        }

        public byte[] getAdapterID() {
            return this.m_adapter_id;
        }

        public byte[] getObjectID() {
            return this.m_object_id;
        }
    }
}

