/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.ListIterator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.openorb.iiop.CodeSet;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.io.HexPrintStream;
import org.openorb.util.Trace;

public class CodeSetDatabaseInitializer
implements LogEnabled,
Initializable,
Disposable {
    private static Object s_sync_table = new Object();
    private static HashMap s_name_to_id = null;
    private CodeSetComponentInfo m_clientCodeSets;
    private CodeSetComponentInfo m_serverCodeSets;
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public void initialize() {
        if (s_name_to_id == null) {
            Object object = s_sync_table;
            synchronized (object) {
                s_name_to_id = new HashMap();
                CodeSetDatabase.populateNameToIdMap(s_name_to_id);
            }
        }
        this.m_serverCodeSets = this.initCodeSets(true);
        this.m_clientCodeSets = this.initCodeSets(false);
    }

    public void dispose() {
        this.m_clientCodeSets = null;
        this.m_serverCodeSets = null;
        this.m_logger = null;
    }

    public CodeSetComponentInfo getClientCodeSets() {
        return this.m_clientCodeSets;
    }

    public CodeSetComponentInfo getServerCodeSets() {
        return this.m_serverCodeSets;
    }

    private CodeSetComponentInfo initCodeSets(boolean bl) {
        Object object;
        String string = System.getProperty("file.encoding");
        int n = 0;
        int n2 = 0;
        try {
            object = CodeSetDatabase.canonicalize(string);
            ArrayList arrayList = (ArrayList)s_name_to_id.get(((String)object).toUpperCase());
            if (arrayList == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("No codesets found for system encoding '" + string + "' (canonicalized to '" + (String)object + "').");
                }
            } else {
                n = (Integer)arrayList.get(0);
                n2 = CodeSetDatabase.getAlignmentFromId(n);
                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug((bl ? "Server" : "Client") + "NativeCodeSet=" + string + " ( id=0x" + HexPrintStream.toHex(n) + ", align=" + n2 + " )");
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "Error while canonicalizing the system encoding '" + string + "'.";
            this.getLogger().error(string2);
        }
        if (n == 0 || n2 > 1) {
            n = 0x5010001;
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Can't find '" + string + "' in codeset database. Using fallback char data codeset " + CodeSetDatabase.getNameFromId(n) + ".");
            }
        } else if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug("Using char data codeset '" + CodeSetDatabase.getNameFromId(n) + "'.");
        }
        object = new CodeSetComponent(n, this.allCompatCodeSets(n, true, bl));
        int n3 = 65568;
        if (((CodeSetComponent)object).native_code_set != n3) {
            int n4 = 0;
            while (n4 < ((CodeSetComponent)object).conversion_code_sets.length) {
                if (n3 == ((CodeSetComponent)object).conversion_code_sets[n4]) {
                    n3 = 0;
                    break;
                }
                ++n4;
            }
            if (n3 != 0) {
                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug("Adding '" + CodeSetDatabase.getNameFromId(n3) + "' to the list of conversion codesets for char data.");
                }
                int[] nArray = new int[((CodeSetComponent)object).conversion_code_sets.length + 1];
                System.arraycopy(((CodeSetComponent)object).conversion_code_sets, 0, nArray, 0, ((CodeSetComponent)object).conversion_code_sets.length);
                nArray[((CodeSetComponent)object).conversion_code_sets.length] = n3;
                ((CodeSetComponent)object).conversion_code_sets = nArray;
            }
        }
        n = 65801;
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug("Using wchar data codeset '" + CodeSetDatabase.getNameFromId(n) + "'.");
        }
        CodeSetComponent codeSetComponent = new CodeSetComponent(n, this.allCompatCodeSets(n, false, bl));
        return new CodeSetComponentInfo((CodeSetComponent)object, codeSetComponent);
    }

    private int[] allCompatCodeSets(int n, boolean bl, boolean bl2) {
        Object object;
        int n2;
        int[] nArray;
        CodeSet codeSet = CodeSetDatabase.getCodeSetFromId(n);
        if (codeSet == null) {
            return new int[0];
        }
        short[] sArray = codeSet.getCharsets();
        if (sArray.length == 1) {
            Object object2;
            int[] nArray2 = CodeSetDatabase.getCodeSetsFromCharset(sArray[0]);
            int[] nArray3 = new int[nArray2.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < nArray2.length) {
                object2 = CodeSetDatabase.getCodeSetFromId(nArray2[n4]);
                if (!(bl2 && !((CodeSet)object2).forServer() || ((CodeSet)object2).getName() == null || ((CodeSet)object2).getCharsets().length != 1 || bl && ((CodeSet)object2).getAlignment() > 1 || ((CodeSet)object2).getId() == n)) {
                    nArray3[n3++] = ((CodeSet)object2).getId();
                }
                ++n4;
            }
            if (n3 < nArray3.length) {
                object2 = new int[n3];
                System.arraycopy(nArray3, 0, object2, 0, n3);
                return object2;
            }
            return nArray3;
        }
        ArrayList[] arrayListArray = new ArrayList[sArray.length - 1];
        int n5 = 0;
        while (n5 < arrayListArray.length) {
            arrayListArray[n5] = new ArrayList();
            ++n5;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(codeSet);
        int n6 = 0;
        int n7 = 0;
        while (n7 < sArray.length) {
            nArray = CodeSetDatabase.getCodeSetsFromCharset(sArray[0]);
            CodeSet codeSet2 = CodeSetDatabase.getCodeSetFromId(nArray[n7]);
            n2 = 0;
            while (n2 < nArray.length) {
                object = CodeSetDatabase.getCodeSetFromId(nArray[n2]);
                if (!(bl2 && !codeSet2.forServer() || codeSet2.getName() == null || bl && ((CodeSet)object).getAlignment() > 1 || !hashSet.add(object))) {
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    while (n9 < codeSet.getCharsets().length && n9 < codeSet2.getCharsets().length) {
                        if (codeSet.getCharsets()[n9] == codeSet2.getCharsets()[n10]) {
                            ++n8;
                            ++n10;
                        } else if (codeSet.getCharsets()[n9] < codeSet2.getCharsets()[n10]) {
                            ++n7;
                        } else {
                            ++n2;
                        }
                        ++n9;
                    }
                    if (n8 >= 2) {
                        arrayListArray[arrayListArray.length - n8 + 2].add(new Integer(((CodeSet)object).getId()));
                        ++n6;
                    }
                }
                ++n2;
            }
            ++n7;
        }
        nArray = new int[n6];
        int n11 = 0;
        n2 = 0;
        while (n2 < arrayListArray.length) {
            object = ((AbstractList)arrayListArray[n2]).iterator();
            while (object.hasNext()) {
                nArray[n11++] = (Integer)object.next();
            }
            ++n2;
        }
        return nArray;
    }

    private static final void usage() {
        System.err.println("usage: java org.openorb.iiop.CodeSetDatabase <database file> [-i]");
        System.err.println();
        System.err.println("  This program converts a codeset registry obtained from");
        System.err.println("  ftp://ftp.opengroup.org/pub/code_set_registry into a class");
        System.err.println("  org.openorb.iiop.CodeSetDatabase, which is used to initialize the");
        System.err.println("  codeset database.");
        System.err.println("  <database file>   OSF registry file.");
        System.err.println("  -i                turns on interactive mode.");
    }

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length < 1 && stringArray.length > 2) {
            CodeSetDatabaseInitializer.usage();
            return;
        }
        boolean bl = false;
        if (stringArray.length == 2) {
            System.out.println("Starting in interactive mode...");
            bl = true;
        } else {
            System.out.println("Starting in bulk mode...");
        }
        File file2 = new File(stringArray[0]);
        if (!file2.isFile() || !file2.canRead()) {
            System.err.println("Cannot open \"" + stringArray[0] + "\" for reading.");
            System.exit(1);
        }
        if ((file = new File("CodeSetDatabase.java")).exists() && !file.isFile()) {
            System.err.println("Unable to overwrite non-file CodeSetDatabase.java");
            return;
        }
        try {
            Object object;
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            if (file.isFile() && bl) {
                System.out.print("Overwrite CodeSetDatabase.java? (yes): ");
                System.out.flush();
                if (bufferedReader.readLine().length() != 0) {
                    return;
                }
            }
            BufferedReader bufferedReader2 = new BufferedReader(new FileReader(file2));
            Hashtable<Integer, CodeSet> hashtable = new Hashtable<Integer, CodeSet>();
            Hashtable<String, ArrayList<Integer>> hashtable2 = new Hashtable<String, ArrayList<Integer>>();
            Hashtable<Short, ArrayList<Integer>> hashtable3 = new Hashtable<Short, ArrayList<Integer>>();
            Hashtable<Integer, Boolean> hashtable4 = new Hashtable<Integer, Boolean>();
            while ((string = bufferedReader2.readLine()) != null) {
                boolean bl2;
                if (!string.equals("start")) continue;
                System.out.println();
                System.out.println("-----------------------------------------------------------------------");
                string = bufferedReader2.readLine();
                System.out.println(string);
                object = string.substring("Short Description\t".length());
                string = bufferedReader2.readLine();
                System.out.println(string);
                int n = Integer.parseInt(string.substring("Registered Value\t0x".length()), 16);
                string = bufferedReader2.readLine();
                System.out.println(string);
                ArrayList<Short> arrayList = new ArrayList<Short>();
                int n2 = string.indexOf("0x") - 1;
                int n3 = string.indexOf(58, n2);
                while (n3 >= 0) {
                    arrayList.add(Short.decode(string.substring(n2 + 1, n3)));
                    n2 = n3;
                    n3 = string.indexOf(58, n2 + 1);
                }
                arrayList.add(Short.decode(string.substring(n2 + 1)));
                short[] sArray = new short[arrayList.size()];
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    sArray[n4] = (Short)arrayList.get(n4);
                    ++n4;
                }
                string = bufferedReader2.readLine();
                System.out.println(string);
                int n5 = Integer.parseInt(string.substring("Max Bytes per Character\t".length()));
                while (!(string = bufferedReader2.readLine()).equals("end")) {
                    System.out.println(string);
                }
                System.out.println();
                CodeSet codeSet = CodeSetDatabase.getCodeSetFromId(n);
                boolean bl3 = false;
                String string2 = null;
                String string3 = null;
                int n6 = -1;
                if (codeSet != null && codeSet.getAlignment() >= 0) {
                    block33: {
                        string2 = codeSet.getName();
                        n6 = codeSet.getAlignment();
                        try {
                            string3 = CodeSetDatabase.canonicalize(codeSet.getName());
                            if (bl) {
                                System.out.print("Reuse old? encoding=\"" + codeSet.getName() + "\" align=" + codeSet.getAlignment() + " (yes): ");
                                if (bufferedReader.readLine().length() == 0) {
                                    hashtable4.put(new Integer(n), Boolean.TRUE);
                                } else {
                                    hashtable4.put(new Integer(n), Boolean.FALSE);
                                }
                            } else {
                                hashtable4.put(new Integer(n), Boolean.TRUE);
                            }
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            if (!bl) break block33;
                            System.out.print("Reuse old? unknown encoding=\"" + codeSet.getName() + "\" align=" + codeSet.getAlignment() + " (yes): ");
                            if (bufferedReader.readLine().length() == 0) {
                                hashtable4.put(new Integer(n), Boolean.TRUE);
                            }
                            hashtable4.put(new Integer(n), Boolean.FALSE);
                        }
                    }
                    System.out.flush();
                }
                Boolean bl4 = (Boolean)hashtable4.get(new Integer(n));
                if (bl && bl4 == null) {
                    block34: {
                        while (true) {
                            System.out.print("Encoding name (blank to skip): ");
                            System.out.flush();
                            string2 = bufferedReader.readLine();
                            if (string2.length() == 0) break block34;
                            try {
                                string3 = CodeSetDatabase.canonicalize(string2);
                                System.out.println("Canonical name: \"" + string3 + "\"");
                                System.out.print("Store encoding? (yes): ");
                                System.out.flush();
                                n6 = CodeSetDatabaseInitializer.discoverWidth(n5, string2, -1, bufferedReader);
                                if (bufferedReader.readLine().length() == 0 && n6 != 0) break;
                                hashtable4.put(new Integer(n), Boolean.TRUE);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                System.out.print("Unsupported encoding.Use anyhow? (yes),(a)gain,no: ");
                                System.out.flush();
                                string = bufferedReader.readLine();
                                if (string.startsWith("a")) continue;
                                n6 = CodeSetDatabaseInitializer.discoverWidth(n5, string2, -1, bufferedReader);
                                if (bufferedReader.readLine().length() != 0 || n6 == 0) {
                                    hashtable4.put(new Integer(n), Boolean.TRUE);
                                    break;
                                }
                                hashtable4.put(new Integer(n), Boolean.FALSE);
                            }
                            break;
                        }
                        System.out.print("Use encoding in server profiles? (no): ");
                        System.out.flush();
                        bl3 = bufferedReader.readLine().length() != 0;
                    }
                    System.out.println();
                    codeSet = new CodeSet((String)object, n, sArray, n5, CodeSetDatabase.canonicalize(string2), string2, n6, bl3);
                }
                boolean bl5 = bl2 = bl4 != null ? bl4 : false;
                if (bl2) {
                    System.out.println("##### Adding the entry...");
                    hashtable.put(new Integer(n), codeSet);
                    ArrayList arrayList2 = null;
                    int n7 = 0;
                    while (n7 < sArray.length) {
                        arrayList2 = (ArrayList)hashtable3.get(new Short(sArray[n7]));
                        if (arrayList2 != null) {
                            arrayList2.add(new Integer(n));
                        } else {
                            arrayList2 = new ArrayList();
                            arrayList2.add(new Integer(n));
                            hashtable3.put(new Short(sArray[n7]), arrayList2);
                        }
                        ++n7;
                    }
                    arrayList2 = (ArrayList)hashtable2.get(string3);
                    if (arrayList2 != null) {
                        arrayList2.add(new Integer(n));
                    } else {
                        arrayList2 = new ArrayList();
                        arrayList2.add(new Integer(n));
                        hashtable2.put(string3, arrayList2);
                    }
                } else {
                    System.out.println("##### Skipping the entry...");
                }
                System.out.println("-----------------------------------------------------------------------");
                System.out.println();
            }
            object = new PrintWriter(new FileWriter(file));
            CodeSetDatabaseInitializer.printDBToFile((PrintWriter)object, hashtable, hashtable2, hashtable3);
        }
        catch (IOException iOException) {
            System.err.println("IO Exception occoured");
        }
    }

    private static void printDBToFile(PrintWriter printWriter, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) throws UnsupportedEncodingException {
        Object object;
        Enumeration enumeration;
        Enumeration enumeration2;
        Enumeration enumeration3;
        Enumeration enumeration4;
        Object object2;
        Object object3;
        Comparator comparator = Collections.reverseOrder();
        printWriter.println("/*");
        printWriter.println("* Copyright (C) The Community OpenORB Project. All rights reserved.");
        printWriter.println("*");
        printWriter.println("* This software is published under the terms of The OpenORB Community Software");
        printWriter.println("* License version 1.0, a copy of which has been included with this distribution");
        printWriter.println("* in the LICENSE.txt file.");
        printWriter.println("*/");
        printWriter.println();
        printWriter.println("package org.openorb.iiop;");
        printWriter.println();
        printWriter.println("/** CodeSetDatabase.java");
        printWriter.println(" * This class has been automatically generated on " + new Date() + ".");
        printWriter.println(" * Use 'java org.openorb.iiop.CodeSetDatabaseInitializer src/main/org/openorb/iiop/cs_registry1_2h.txt'");
        printWriter.println(" * to generate it. DO NOT MODIFY MANUALLY !!!");
        printWriter.println(" *");
        printWriter.println(" * @author The CodeSetDatabaseInitializer tool.");
        printWriter.println(" */");
        printWriter.println("public class CodeSetDatabase");
        printWriter.println("{");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Convert an encoding name into it's canonical Java name.");
        printWriter.println("     */");
        printWriter.println("    public static String canonicalize( String encoding )");
        printWriter.println("        throws java.io.UnsupportedEncodingException");
        printWriter.println("    {");
        printWriter.println("        // Use this way to get the canonical encoding name.");
        printWriter.println("        // Internally the sun.io.Converters and");
        printWriter.println("        // sun.io.CharacterEncoding are used to convert the");
        printWriter.println("        // name. If we use these classes directly");
        printWriter.println("        // we would limit the number of supported JDKs to the");
        printWriter.println("        // Sun JDKs only. It isn't the most efficient way to");
        printWriter.println("        // create an OutputStreamWriter just for doing a String");
        printWriter.println("        // conversion, but JDKs before 1.4 provide no other ");
        printWriter.println("        // to get the canonical name.");
        printWriter.println("        java.io.OutputStreamWriter osw = new java.io.OutputStreamWriter( System.out, encoding );");
        printWriter.println("        return osw.getEncoding();");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Populates the map between canonical codeset names");
        printWriter.println("     * and an ArrayList of codeset ids.");
        printWriter.println("     */");
        printWriter.println("    public static void populateNameToIdMap( java.util.HashMap map )");
        printWriter.println("    {");
        printWriter.println("        java.util.ArrayList al = null;");
        Enumeration enumeration5 = hashtable2.keys();
        while (enumeration5.hasMoreElements()) {
            object3 = (String)enumeration5.nextElement();
            printWriter.println();
            object2 = (ArrayList)hashtable2.get(object3);
            Collections.sort(object2, comparator);
            enumeration4 = ((AbstractList)object2).listIterator();
            printWriter.println("        al = new java.util.ArrayList();");
            while (enumeration4.hasNext()) {
                printWriter.println("        al.add( new Integer( 0x" + HexPrintStream.toHex((Integer)enumeration4.next()) + " ) );");
            }
            printWriter.println("        map.put( \"" + CodeSetDatabase.canonicalize((String)object3).toUpperCase() + "\", al );");
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Return a CodeSet object for an OSF registry codeset id.");
        printWriter.println("     *");
        printWriter.println("     * @param id An OSF charset and codeset registry id.");
        printWriter.println("     * @return A CodeSet object.");
        printWriter.println("     */");
        printWriter.println("    public static CodeSet getCodeSetFromId( int id )");
        printWriter.println("    {");
        printWriter.println("        switch( id )");
        printWriter.println("        {");
        object3 = hashtable.keys();
        while (object3.hasMoreElements()) {
            object2 = (Integer)object3.nextElement();
            enumeration4 = (CodeSet)hashtable.get(object2);
            printWriter.println("            case 0x" + HexPrintStream.toHex((Integer)object2) + ":");
            printWriter.println("              return new CodeSet( " + enumeration4 + " );");
        }
        printWriter.println("            default:");
        printWriter.println("                return null;");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Return the alignment for an OSF registry codeset id.");
        printWriter.println("     * This method replaces the method CodeSet.getAlignmentFromId()");
        printWriter.println("     * and moves the functionality to the time when the class");
        printWriter.println("     * CodeSetDatabase is created from the OSF charset and");
        printWriter.println("     * codeset registry file.");
        printWriter.println("     *");
        printWriter.println("     * @param id An OSF charset and codeset registry id.");
        printWriter.println("     * @return The aligment for the specified codeset");
        printWriter.println("     * <ul>");
        printWriter.println("     * <li><code>-1</code>When the codeset id doesn't exist or the");
        printWriter.println("     * maximum size is 1, i.e.");
        printWriter.println("     * the codeset is a byte-oriented single-byte codeset</li>");
        printWriter.println("     * <li><code>0</code> When it is a byte-oriented multi-byte");
        printWriter.println("     * codeset</li>");
        printWriter.println("     * <li><code>&gt;= 1</code> When it is a fixed-length");
        printWriter.println("     * non-byte-oriented codeset (e.g. 2 for UCS codesets)</li>");
        printWriter.println("     * </ul>");
        printWriter.println("     */");
        printWriter.println("    public static int getAlignmentFromId( int id )");
        printWriter.println("    {");
        printWriter.println("        switch( id )");
        printWriter.println("        {");
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            enumeration4 = (Integer)object2.nextElement();
            enumeration3 = (CodeSet)hashtable.get(enumeration4);
            printWriter.println("            case 0x" + HexPrintStream.toHex((Integer)((Object)enumeration4)) + ":");
            printWriter.println("                return " + ((CodeSet)((Object)enumeration3)).getAlignment() + ";");
        }
        printWriter.println("            default:");
        printWriter.println("                return -1;");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Returns the name of a OSF charset and codeset registry entry.");
        printWriter.println("     *");
        printWriter.println("     * @param id An OSF charset and codeset registry id.");
        printWriter.println("     * @return The name of the codeset.");
        printWriter.println("     */");
        printWriter.println("    public static String getNameFromId( int id )");
        printWriter.println("    {");
        printWriter.println("        switch( id )");
        printWriter.println("        {");
        enumeration4 = hashtable.keys();
        while (enumeration4.hasMoreElements()) {
            enumeration3 = (Integer)enumeration4.nextElement();
            enumeration2 = (CodeSet)hashtable.get(enumeration3);
            printWriter.println("            case 0x" + HexPrintStream.toHex((Integer)((Object)enumeration3)) + ":");
            printWriter.println("                return \"" + ((CodeSet)((Object)enumeration2)).getName() + "\";");
        }
        printWriter.println("            default:");
        printWriter.println("                return null;");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Returns the canonical Java name of a OSF charset");
        printWriter.println("     * and codeset registry entry.");
        printWriter.println("     *");
        printWriter.println("     * @param id An OSF charset and codeset registry id.");
        printWriter.println("     * @return The name of the codeset.");
        printWriter.println("     */");
        printWriter.println("    public static String getCanonicalNameFromId( int id )");
        printWriter.println("    {");
        printWriter.println("        switch( id )");
        printWriter.println("        {");
        enumeration3 = hashtable.keys();
        while (enumeration3.hasMoreElements()) {
            enumeration2 = (Integer)enumeration3.nextElement();
            enumeration = (CodeSet)hashtable.get(enumeration2);
            printWriter.println("            case 0x" + HexPrintStream.toHex((Integer)((Object)enumeration2)) + ":");
            printWriter.println("                return \"" + CodeSetDatabase.canonicalize(((CodeSet)((Object)enumeration)).getName()) + "\";");
        }
        printWriter.println("            default:");
        printWriter.println("                return null;");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Returns the description of a OSF charset and codeset");
        printWriter.println("     * registry entry.");
        printWriter.println("     *");
        printWriter.println("     * @param id An OSF charset and codeset registry id.");
        printWriter.println("     * @return The OSF description of the codeset.");
        printWriter.println("     */");
        printWriter.println("    public static String getDescriptionFromId( int id )");
        printWriter.println("    {");
        printWriter.println("        switch( id )");
        printWriter.println("        {");
        enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            enumeration = (Integer)enumeration2.nextElement();
            object = (CodeSet)hashtable.get(enumeration);
            printWriter.println("            case 0x" + HexPrintStream.toHex((Integer)((Object)enumeration)) + ":");
            printWriter.println("                return \"" + ((CodeSet)object).getDescription() + "\";");
        }
        printWriter.println("            default:");
        printWriter.println("                return null;");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Return an array of CodeSet objects that support the");
        printWriter.println("     * specified charset.");
        printWriter.println("     *");
        printWriter.println("     * @param id An OSF charset registry id.");
        printWriter.println("     * @return An array of codeset ids supporting the charset.");
        printWriter.println("     */");
        printWriter.println("    public static int[] getCodeSetsFromCharset( short charset )");
        printWriter.println("    {");
        printWriter.println("        switch( charset )");
        printWriter.println("        {");
        enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            object = (Short)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable3.get(object);
            Collections.sort(arrayList, comparator);
            ListIterator listIterator = ((AbstractList)arrayList).listIterator();
            printWriter.println("            case 0x" + HexPrintStream.toHex((Short)object) + ":");
            printWriter.println("                return new int[] {");
            while (listIterator.hasNext()) {
                Integer n = (Integer)listIterator.next();
                printWriter.println("                    0x" + HexPrintStream.toHex(n) + (listIterator.hasNext() ? ", " : ""));
            }
            printWriter.println("                };");
        }
        printWriter.println("            default:");
        printWriter.println("                return null;");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println("}");
        printWriter.flush();
    }

    private static int discoverWidth(int n, String string, int n2, BufferedReader bufferedReader) throws IOException {
        if (n == 1) {
            return 1;
        }
        if (string == null) {
            System.out.print("Codeset width? 1, 2, 4, prefixed, (cancel): ");
            System.out.flush();
            String string2 = bufferedReader.readLine();
            if (string2.equals("1")) {
                return 1;
            }
            if (string2.equals("2")) {
                return 2;
            }
            if (string2.equals("4")) {
                return 4;
            }
            if (string2.startsWith("p")) {
                return 0;
            }
            return -1;
        }
        while (true) {
            switch (n2) {
                case 0: {
                    System.out.print("Codeset width? 1, 2, 4, (prefixed), guess, RETURN: ");
                    break;
                }
                case 1: {
                    System.out.print("Codeset width? (1), 2, 4, prefixed, guess, RETURN: ");
                    break;
                }
                case 2: {
                    System.out.print("Codeset width? 1, (2), 4, prefixed, guess, RETURN: ");
                    break;
                }
                case 4: {
                    System.out.print("Codeset width? 1, 2, (4), prefixed, guess, RETURN: ");
                    break;
                }
                default: {
                    System.out.print("Codeset width? 1, 2, 4, prefixed, (guess), RETURN: ");
                }
            }
            String string3 = bufferedReader.readLine();
            if (string3.length() == 0) {
                if (n2 != -1) {
                    return n2;
                }
            } else {
                if (string3.equals("1")) {
                    return 1;
                }
                if (string3.equals("2")) {
                    return 2;
                }
                if (string3.equals("4")) {
                    return 4;
                }
                if (string3.startsWith("p")) {
                    return 0;
                }
                if (!string3.startsWith("g")) {
                    return -1;
                }
            }
            System.out.println("Guessing char width");
            int[] nArray = new int[n * 2 + 1];
            char c = '\u0000';
            while (c < '\uffff') {
                try {
                    int n3 = String.valueOf(c).getBytes(string).length;
                    nArray[n3] = nArray[n3] + 1;
                }
                catch (Error error) {
                    nArray[0] = nArray[0] + 1;
                }
                c = (char)(c + '\u0001');
            }
            int n4 = 0;
            while (n4 < nArray.length) {
                if (n4 == 0) {
                    System.out.println("" + nArray[n4] + " Errors.");
                } else if (nArray[n4] > 0) {
                    System.out.println(nArray[n4] + " of length " + n4);
                }
                ++n4;
            }
            System.out.println("String \"aa\" is length " + "aa".getBytes(string).length);
            if (nArray[1] == 0) continue;
            n2 = nArray[2] != 0 ? 0 : 1;
        }
    }
}

