/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.openorb.io.StorageBuffer;
import org.openorb.net.Address;
import org.openorb.net.Transport;
import org.openorb.net.TransportAssociationHolder;
import org.openorb.util.ExceptionTool;

public class IIOPTransport
implements Transport {
    private static final long MAX_CLOSE_LINGER = 1000L;
    private final boolean m_socketNoDelay;
    private final boolean m_boostRecvPriority;
    private final int m_sendBufferSize;
    private final int m_receiveBufferSize;
    private final int m_bufferedOutputStreamSize;
    private Logger m_logger;
    private InetAddress m_host = null;
    private int m_port = -1;
    private String m_connection_string;
    private Socket m_socket;
    private InputStream m_in_stream;
    private OutputStream m_out_stream;
    private byte[] m_header = null;
    private boolean m_message_error = false;
    private boolean m_remote_close = false;
    private int m_minor_version = 0;
    private boolean m_open = false;
    private static final byte[][] MESSAGE_ERROR = new byte[][]{{71, 73, 79, 80, 1, 0, 0, 6, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 1, 0, 6, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 2, 0, 6, 0, 0, 0, 0}};
    private static final byte[][] CLOSE_CONNECTION = new byte[][]{{71, 73, 79, 80, 1, 0, 0, 5, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 1, 0, 5, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 2, 0, 5, 0, 0, 0, 0}};

    public IIOPTransport(InetAddress inetAddress, int n, Logger logger) {
        this(inetAddress, n, logger, true, true, 0, 0, 0);
    }

    public IIOPTransport(InetAddress inetAddress, int n, Logger logger, boolean bl, boolean bl2, int n2, int n3, int n4) {
        this.m_host = inetAddress;
        this.m_port = n;
        this.m_logger = logger;
        this.m_socketNoDelay = bl;
        this.m_boostRecvPriority = bl2;
        this.m_sendBufferSize = n2;
        this.m_receiveBufferSize = n3;
        this.m_bufferedOutputStreamSize = n4;
        this.m_connection_string = this.m_host.getHostName() + ":" + this.m_port;
    }

    public IIOPTransport(Socket socket, int n, Logger logger) {
        this(socket, n, logger, true, true, 0, 0, 0);
    }

    public IIOPTransport(Socket socket, int n, Logger logger, boolean bl, boolean bl2, int n2, int n3, int n4) {
        this.m_socket = socket;
        this.m_port = n;
        this.m_logger = logger;
        this.m_socketNoDelay = bl;
        this.m_boostRecvPriority = bl2;
        this.m_sendBufferSize = n2;
        this.m_receiveBufferSize = n3;
        this.m_bufferedOutputStreamSize = n4;
        try {
            if (0 < this.m_sendBufferSize) {
                this.m_socket.setSendBufferSize(this.m_sendBufferSize);
            }
            if (0 < this.m_receiveBufferSize) {
                this.m_socket.setReceiveBufferSize(this.m_receiveBufferSize);
            }
            this.m_socket.setTcpNoDelay(this.m_socketNoDelay);
            this.m_in_stream = this.m_socket.getInputStream();
            this.m_out_stream = this.wrapOutputStream(this.m_socket.getOutputStream());
        }
        catch (IOException iOException) {
            this.m_socket = null;
            this.getLogger().error("IOException getting input and output streams.", iOException);
            throw ExceptionTool.initCause(new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO), (Throwable)iOException);
        }
        this.m_open = true;
        this.m_connection_string = n + " (" + this.m_socket.getLocalPort() + " <- " + this.m_socket.getInetAddress().getHostName() + ":" + this.m_socket.getPort() + ")";
    }

    private OutputStream wrapOutputStream(OutputStream outputStream) {
        if (0 == this.m_bufferedOutputStreamSize) {
            return outputStream;
        }
        return new BufferedOutputStream(outputStream, this.m_bufferedOutputStreamSize);
    }

    public void open() {
        if (this.m_host == null) {
            throw new BAD_INV_ORDER();
        }
        if (this.m_open) {
            return;
        }
        this.m_message_error = false;
        this.m_remote_close = false;
        try {
            this.m_socket = this.createSocket(this.m_host, this.m_port);
            if (0 < this.m_sendBufferSize) {
                this.m_socket.setSendBufferSize(this.m_sendBufferSize);
            }
            if (0 < this.m_receiveBufferSize) {
                this.m_socket.setReceiveBufferSize(this.m_receiveBufferSize);
            }
            this.m_socket.setTcpNoDelay(this.m_socketNoDelay);
            this.m_in_stream = this.m_socket.getInputStream();
            this.m_out_stream = this.wrapOutputStream(this.m_socket.getOutputStream());
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this.getLogger().error("No route to host. Check your network.", noRouteToHostException);
            throw ExceptionTool.initCause(new COMM_FAILURE("No route to host. Check your network (" + noRouteToHostException + ")", 1146056969, CompletionStatus.COMPLETED_NO), (Throwable)noRouteToHostException);
        }
        catch (ConnectException connectException) {
            throw ExceptionTool.initCause(new COMM_FAILURE("Cannot connect to target (" + connectException + ")", 1146056970, CompletionStatus.COMPLETED_NO), (Throwable)connectException);
        }
        catch (IOException iOException) {
            this.getLogger().error("IOException during connect.", iOException);
            throw ExceptionTool.initCause(new COMM_FAILURE("IOException during connect (" + iOException + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)iOException);
        }
        this.m_open = true;
        this.m_connection_string = this.m_host.getHostName() + ":" + this.m_port + " (" + this.m_socket.getLocalPort() + " -> " + this.m_socket.getPort() + ")";
    }

    protected Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return new Socket(inetAddress, n);
    }

    public void close() {
        if (this.m_open) {
            boolean bl = Thread.interrupted();
            if (!this.m_remote_close) {
                try {
                    this.writeCloseMessage();
                    try {
                        this.m_socket.getClass().getMethod("shutdownOutput", null).invoke((Object)this.m_socket, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.m_message_error || this.m_minor_version == 2 || this.m_host == null) {
                        StorageBuffer storageBuffer;
                        TransportAssociationHolder transportAssociationHolder = new TransportAssociationHolder();
                        do {
                            transportAssociationHolder.setValue(null);
                            storageBuffer = this.recvMessage(1000, transportAssociationHolder);
                            boolean bl2 = bl = Thread.interrupted() || bl;
                        } while (storageBuffer != null);
                    }
                }
                catch (SystemException systemException) {
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            this.m_open = false;
            try {
                this.m_socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
            this.m_connection_string = this.m_host != null ? this.m_host.getHostName() + ":" + this.m_port : Integer.toString(this.m_port);
        }
    }

    protected void writeCloseMessage() {
        if (this.m_message_error) {
            this.write(MESSAGE_ERROR[this.m_minor_version], 0, 12);
        } else if (this.m_minor_version == 2 || this.m_host == null) {
            this.write(CLOSE_CONNECTION[this.m_minor_version], 0, 12);
        }
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public void sendMessage(StorageBuffer storageBuffer, Object object) {
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            storageBuffer.writeTo(this.m_out_stream);
            this.m_out_stream.flush();
        }
        catch (IOException iOException) {
            this.getLogger().error("IOException while writing to output stream.", iOException);
            throw ExceptionTool.initCause(new COMM_FAILURE("IOException while writing to output stream."), (Throwable)iOException);
        }
    }

    protected void write(byte[] byArray, int n, int n2) {
        InterruptedIOException interruptedIOException2;
        boolean bl = Thread.interrupted();
        do {
            try {
                this.m_out_stream.write(byArray, n, n2);
                break;
            }
            catch (InterruptedIOException interruptedIOException2) {
                bl = true;
                n += interruptedIOException2.bytesTransferred;
            }
            catch (IOException iOException) {
                throw ExceptionTool.initCause(new COMM_FAILURE(), (Throwable)iOException);
            }
        } while ((n2 -= interruptedIOException2.bytesTransferred) > 0);
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StorageBuffer recvMessage(int n, TransportAssociationHolder transportAssociationHolder) throws EOFException {
        StorageBuffer storageBuffer;
        Thread thread;
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        if (null == this.m_header) {
            this.m_header = new byte[12];
        }
        if (null == transportAssociationHolder.getValue()) {
            transportAssociationHolder.setValue(TransportAssociationHolder.EMPTY_ASSOCIATION);
        }
        if ((thread = Thread.currentThread()).isInterrupted()) {
            return null;
        }
        int n2 = thread.getPriority();
        if (this.m_boostRecvPriority) {
            thread.setPriority(10);
        }
        try {
            if (!this.readMagic(n, this.m_header, 0)) {
                StorageBuffer storageBuffer2 = null;
                Object var10_7 = null;
                if (!this.m_boostRecvPriority) return storageBuffer2;
                thread.setPriority(n2);
                return storageBuffer2;
            }
            boolean bl = Thread.interrupted();
            this.read(this.m_header, 4, 8);
            int n3 = this.checkGIOPHeader(this.m_header, 0);
            bl = bl || Thread.interrupted();
            StorageBuffer storageBuffer3 = this.readBuffer(this.m_header, 0, 12, n3 + 12);
            if (bl) {
                thread.interrupt();
            }
            storageBuffer = storageBuffer3;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (!this.m_boostRecvPriority) throw throwable;
            thread.setPriority(n2);
            throw throwable;
        }
        Object var10_8 = null;
        if (!this.m_boostRecvPriority) return storageBuffer;
        thread.setPriority(n2);
        return storageBuffer;
    }

    public void setMessageError() {
        this.m_message_error = true;
    }

    public boolean isMessageError() {
        return this.m_message_error;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean readMagic(int var1_1, byte[] var2_2, int var3_3) throws EOFException {
        block31: {
            if (!this.m_open) {
                throw new COMM_FAILURE("Transport is closed");
            }
            try {
                block28: {
                    var5_4 = false;
                    try {
                        if (var1_1 > 0) {
                            this.m_socket.setSoTimeout(var1_1);
                        }
                        var4_6 = this.m_in_stream.read(var2_2, var3_3, 4);
                        var10_7 = null;
                        ** if (var1_1 <= 0) goto lbl-1000
                    }
                    catch (Throwable var9_20) {
                        var10_10 = null;
                        if (var1_1 > 0) {
                            try {
                                this.m_socket.setSoTimeout(0);
                            }
                            catch (IOException var11_14) {
                                // empty catch block
                            }
                        }
                        throw var9_20;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.m_socket.setSoTimeout(0);
                        }
                        catch (IOException var11_11) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block28;
                        catch (InterruptedIOException var6_15) {
                            if (var1_1 > 0 && var6_15.getMessage().equals("Read timed out")) {
                                var7_17 = false;
                                var10_8 = null;
                                if (var1_1 > 0) {
                                    try {
                                        this.m_socket.setSoTimeout(0);
                                    }
                                    catch (IOException var11_12) {
                                        // empty catch block
                                    }
                                }
                                return var7_17;
                            }
                            var4_6 = var6_15.bytesTransferred;
                            if (var4_6 == 0) {
                                Thread.currentThread().interrupt();
                                var8_19 = false;
                                var10_9 = null;
                                if (var1_1 > 0) {
                                    try {
                                        this.m_socket.setSoTimeout(0);
                                    }
                                    catch (IOException var11_13) {
                                        // empty catch block
                                    }
                                }
                                return var8_19;
                            }
                            var5_4 = true;
                            var10_7 = null;
                            if (var1_1 > 0) {
                                try {
                                    this.m_socket.setSoTimeout(0);
                                }
                                catch (IOException var11_11) {}
                            }
                        }
                    }
                }
                if (var4_6 == 0) {
                    return false;
                }
                if (var4_6 == 4) {
                    return true;
                }
                if (var4_6 <= 0) break block31;
                var6_16 = var4_6;
                while (var6_16 < 4) {
                    try {
                        var4_6 = this.m_in_stream.read(var2_2, var3_3 + var6_16, 4 - var6_16);
                        if (var4_6 < 0) {
                            throw new COMM_FAILURE("Unexpected end of stream", 1146056973, CompletionStatus.COMPLETED_MAYBE);
                        }
                    }
                    catch (InterruptedIOException var7_18) {
                        var4_6 = var7_18.bytesTransferred;
                        var5_4 = true;
                    }
                    var6_16 += var4_6;
                }
                if (var5_4) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            catch (IOException var5_5) {
                throw ExceptionTool.initCause(new COMM_FAILURE("IOException while reading from input stream (" + var5_5 + ")", 1146056972, CompletionStatus.COMPLETED_MAYBE), (Throwable)var5_5);
            }
        }
        throw new EOFException();
    }

    protected int checkGIOPHeader(byte[] byArray, int n) throws EOFException {
        if (byArray[n + 0] != 71 || byArray[n + 1] != 73 || byArray[n + 2] != 79 || byArray[n + 3] != 80 || byArray[n + 4] != 1 || byArray[n + 5] > 2) {
            this.m_message_error = true;
            throw new COMM_FAILURE("Bad magic", 1146056974, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.m_minor_version < byArray[n + 5]) {
            this.m_minor_version = byArray[n + 5];
        }
        switch (byArray[n + 7]) {
            case 5: {
                this.m_remote_close = true;
                throw new EOFException("CloseConnection message received from peer.");
            }
            case 6: {
                this.m_remote_close = true;
                throw new COMM_FAILURE("Message Error recieved from remote", 1146056974, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        boolean bl = (byArray[n + 6] & 1) == 1;
        return (byArray[n + 8] & 0xFF) << (bl ? 0 : 24) | (byArray[n + 9] & 0xFF) << (bl ? 8 : 16) | (byArray[n + 10] & 0xFF) << (bl ? 16 : 8) | (byArray[n + 11] & 0xFF) << (bl ? 24 : 0);
    }

    protected final void read(byte[] byArray, int n, int n2) {
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            boolean bl = false;
            while (n2 > 0) {
                int n3;
                try {
                    n3 = this.m_in_stream.read(byArray, n, n2);
                    if (n3 < 0) {
                        throw new COMM_FAILURE("Unexpected end of stream", 1146056973, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    bl = true;
                    n3 = interruptedIOException.bytesTransferred;
                }
                n += n3;
                n2 -= n3;
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException iOException) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("IOException while reading from input stream.", iOException);
            }
            throw new COMM_FAILURE("IOException while reading from input stream", 1146056972, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    protected StorageBuffer readBuffer(byte[] byArray, int n, int n2, int n3) {
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            return new StorageBuffer(byArray, n, n2, this.m_in_stream, n3);
        }
        catch (EOFException eOFException) {
            this.getLogger().error("Unexpected end of stream.", eOFException);
            throw ExceptionTool.initCause(new COMM_FAILURE("Unexpected end of stream (" + eOFException + ")", 1146056973, CompletionStatus.COMPLETED_MAYBE), (Throwable)eOFException);
        }
        catch (IOException iOException) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("IOException while reading from input stream.", iOException);
            }
            throw ExceptionTool.initCause(new COMM_FAILURE("IOException while reading from input stream (" + iOException + ")", 1146056972, CompletionStatus.COMPLETED_MAYBE), (Throwable)iOException);
        }
    }

    public boolean establishAssociation(Address address, TransportAssociationHolder transportAssociationHolder) {
        transportAssociationHolder.setValue(TransportAssociationHolder.EMPTY_ASSOCIATION);
        return true;
    }

    public String toString() {
        return "(iiop) " + this.getConnString();
    }

    protected String getConnString() {
        return this.m_connection_string;
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

