/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.math.BigDecimal;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.CORBA.typecode.TypeCodeBase;
import org.openorb.io.ExtendedInputStream;
import org.openorb.io.ExtendedOutputStream;
import org.openorb.io.TypeCodeValueBoxHelper;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public final class StreamHelper {
    public static final void handle_union_content(InputStream inputStream, OutputStream outputStream, TypeCode typeCode, TypeCode typeCode2) throws BadKind, Bounds {
        switch (typeCode2.kind().value()) {
            case 8: {
                boolean bl = inputStream.read_boolean();
                outputStream.write_boolean(bl);
                int n = typeCode.default_index();
                int n2 = 0;
                while (n2 < typeCode.member_count()) {
                    if (n2 != n && typeCode.member_label(n2).extract_boolean() == bl) {
                        StreamHelper.copy_stream(typeCode.member_type(n2), inputStream, outputStream);
                        return;
                    }
                    ++n2;
                }
                if (n < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(typeCode.member_type(n), inputStream, outputStream);
                return;
            }
            case 9: {
                char c = inputStream.read_char();
                outputStream.write_char(c);
                int n = typeCode.default_index();
                int n3 = 0;
                while (n3 < typeCode.member_count()) {
                    if (n3 != n && typeCode.member_label(n3).extract_char() == c) {
                        StreamHelper.copy_stream(typeCode.member_type(n3), inputStream, outputStream);
                        return;
                    }
                    ++n3;
                }
                if (n < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(typeCode.member_type(n), inputStream, outputStream);
                return;
            }
            case 26: {
                char c = inputStream.read_wchar();
                outputStream.write_wchar(c);
                int n = typeCode.default_index();
                int n4 = 0;
                while (n4 < typeCode.member_count()) {
                    if (n4 != n && typeCode.member_label(n4).extract_wchar() == c) {
                        StreamHelper.copy_stream(typeCode.member_type(n4), inputStream, outputStream);
                        return;
                    }
                    ++n4;
                }
                if (n < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(typeCode.member_type(n), inputStream, outputStream);
                return;
            }
            case 2: {
                short s = inputStream.read_short();
                outputStream.write_short(s);
                int n = typeCode.default_index();
                int n5 = 0;
                while (n5 < typeCode.member_count()) {
                    if (n5 != n && typeCode.member_label(n5).extract_short() == s) {
                        StreamHelper.copy_stream(typeCode.member_type(n5), inputStream, outputStream);
                        return;
                    }
                    ++n5;
                }
                if (n < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(typeCode.member_type(n), inputStream, outputStream);
                return;
            }
            case 4: {
                short s = inputStream.read_ushort();
                outputStream.write_ushort(s);
                int n = typeCode.default_index();
                int n6 = 0;
                while (n6 < typeCode.member_count()) {
                    if (n6 != n && typeCode.member_label(n6).extract_ushort() == s) {
                        StreamHelper.copy_stream(typeCode.member_type(n6), inputStream, outputStream);
                        return;
                    }
                    ++n6;
                }
                if (n < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(typeCode.member_type(n), inputStream, outputStream);
                return;
            }
            case 3: {
                int n = inputStream.read_long();
                outputStream.write_long(n);
                int n7 = typeCode.default_index();
                int n8 = 0;
                while (n8 < typeCode.member_count()) {
                    if (n8 != n7 && typeCode.member_label(n8).extract_long() == n) {
                        StreamHelper.copy_stream(typeCode.member_type(n8), inputStream, outputStream);
                        return;
                    }
                    ++n8;
                }
                if (n7 < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(typeCode.member_type(n7), inputStream, outputStream);
                return;
            }
            case 5: 
            case 17: {
                int n = inputStream.read_ulong();
                outputStream.write_ulong(n);
                int n9 = typeCode.default_index();
                int n10 = 0;
                while (n10 < typeCode.member_count()) {
                    if (n10 != n9 && typeCode.member_label(n10).extract_ulong() == n) {
                        StreamHelper.copy_stream(typeCode.member_type(n10), inputStream, outputStream);
                        return;
                    }
                    ++n10;
                }
                if (n9 < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(typeCode.member_type(n9), inputStream, outputStream);
                return;
            }
            case 23: {
                long l = inputStream.read_longlong();
                outputStream.write_longlong(l);
                int n = typeCode.default_index();
                int n11 = 0;
                while (n11 < typeCode.member_count()) {
                    if (n11 != n && typeCode.member_label(n11).extract_longlong() == l) {
                        StreamHelper.copy_stream(typeCode.member_type(n11), inputStream, outputStream);
                        return;
                    }
                    ++n11;
                }
                if (n < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(typeCode.member_type(n), inputStream, outputStream);
                return;
            }
            case 24: {
                long l = inputStream.read_ulonglong();
                outputStream.write_ulonglong(l);
                int n = typeCode.default_index();
                int n12 = 0;
                while (n12 < typeCode.member_count()) {
                    if (n12 != n && typeCode.member_label(n12).extract_ulonglong() == l) {
                        StreamHelper.copy_stream(typeCode.member_type(n12), inputStream, outputStream);
                        return;
                    }
                    ++n12;
                }
                if (n < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(typeCode.member_type(n), inputStream, outputStream);
                return;
            }
        }
        Trace.signalIllegalCondition(null, "Unexpected union discriminator type kind().value()==" + typeCode2.kind().value() + ".");
    }

    public static final void handle_array_content(InputStream inputStream, OutputStream outputStream, TypeCode typeCode, int n) throws BadKind, Bounds {
        switch (typeCode.kind().value()) {
            case 0: 
            case 1: {
                return;
            }
            case 2: {
                short[] sArray = new short[n];
                inputStream.read_short_array(sArray, 0, n);
                outputStream.write_short_array(sArray, 0, n);
                return;
            }
            case 4: {
                short[] sArray = new short[n];
                inputStream.read_ushort_array(sArray, 0, n);
                outputStream.write_ushort_array(sArray, 0, n);
                return;
            }
            case 3: {
                int[] nArray = new int[n];
                inputStream.read_long_array(nArray, 0, n);
                outputStream.write_long_array(nArray, 0, n);
                return;
            }
            case 5: {
                int[] nArray = new int[n];
                inputStream.read_ulong_array(nArray, 0, n);
                outputStream.write_ulong_array(nArray, 0, n);
                return;
            }
            case 6: {
                float[] fArray = new float[n];
                inputStream.read_float_array(fArray, 0, n);
                outputStream.write_float_array(fArray, 0, n);
                return;
            }
            case 7: {
                double[] dArray = new double[n];
                inputStream.read_double_array(dArray, 0, n);
                outputStream.write_double_array(dArray, 0, n);
                return;
            }
            case 8: {
                boolean[] blArray = new boolean[n];
                inputStream.read_boolean_array(blArray, 0, n);
                outputStream.write_boolean_array(blArray, 0, n);
                return;
            }
            case 9: {
                char[] cArray = new char[n];
                inputStream.read_char_array(cArray, 0, n);
                outputStream.write_char_array(cArray, 0, n);
                return;
            }
            case 10: {
                byte[] byArray = new byte[n];
                inputStream.read_octet_array(byArray, 0, n);
                outputStream.write_octet_array(byArray, 0, n);
                return;
            }
            case 11: {
                int n2 = 0;
                while (n2 < n) {
                    outputStream.write_any(inputStream.read_any());
                    ++n2;
                }
                return;
            }
            case 12: {
                int n3 = 0;
                while (n3 < n) {
                    outputStream.write_TypeCode(inputStream.read_TypeCode());
                    ++n3;
                }
                return;
            }
            case 13: {
                int n4 = 0;
                while (n4 < n) {
                    outputStream.write_Principal(inputStream.read_Principal());
                    ++n4;
                }
                return;
            }
            case 14: {
                int n5 = 0;
                while (n5 < n) {
                    outputStream.write_Object(inputStream.read_Object());
                    ++n5;
                }
                return;
            }
            case 17: {
                int n6 = 0;
                while (n6 < n) {
                    outputStream.write_ulong(inputStream.read_ulong());
                    ++n6;
                }
                return;
            }
            case 18: {
                int n7 = 0;
                while (n7 < n) {
                    outputStream.write_string(inputStream.read_string());
                    ++n7;
                }
                return;
            }
            case 23: {
                long[] lArray = new long[n];
                inputStream.read_longlong_array(lArray, 0, n);
                outputStream.write_longlong_array(lArray, 0, n);
                return;
            }
            case 24: {
                long[] lArray = new long[n];
                inputStream.read_ulonglong_array(lArray, 0, n);
                outputStream.write_ulonglong_array(lArray, 0, n);
                return;
            }
            case 25: {
                throw new NO_IMPLEMENT();
            }
            case 26: {
                char[] cArray = new char[n];
                inputStream.read_wchar_array(cArray, 0, n);
                outputStream.write_wchar_array(cArray, 0, n);
                return;
            }
            case 27: {
                int n8 = 0;
                while (n8 < n) {
                    outputStream.write_wstring(inputStream.read_wstring());
                    ++n8;
                }
                return;
            }
            case 28: {
                int n9 = 0;
                while (n9 < n) {
                    outputStream.write_fixed(inputStream.read_fixed());
                    ++n9;
                }
                return;
            }
            case 29: 
            case 30: {
                int n10 = 0;
                while (n10 < n) {
                    outputStream.write_value(inputStream.read_value());
                    ++n10;
                }
                return;
            }
            case 32: {
                int n11 = 0;
                while (n11 < n) {
                    outputStream.write_abstract_interface(inputStream.read_abstract_interface());
                    ++n11;
                }
                return;
            }
            case 15: 
            case 22: {
                int n12 = 0;
                while (n12 < n) {
                    int n13 = 0;
                    while (n13 < typeCode.member_count()) {
                        StreamHelper.copy_stream(typeCode.member_type(n13), inputStream, outputStream);
                        ++n13;
                    }
                    ++n12;
                }
                return;
            }
            case 16: 
            case 19: 
            case 20: {
                int n14 = 0;
                while (n14 < n) {
                    StreamHelper.copy_stream(typeCode, inputStream, outputStream);
                    ++n14;
                }
                return;
            }
        }
        Trace.signalIllegalCondition(null, "Unexpected array content type kind().value()==" + typeCode.kind().value() + ".");
    }

    public static void copy_stream(TypeCode typeCode, InputStream inputStream, OutputStream outputStream) {
        try {
            typeCode = TypeCodeBase._base_type(typeCode);
            switch (typeCode.kind().value()) {
                case 0: 
                case 1: {
                    return;
                }
                case 2: {
                    outputStream.write_short(inputStream.read_short());
                    return;
                }
                case 3: {
                    outputStream.write_long(inputStream.read_long());
                    return;
                }
                case 4: {
                    outputStream.write_ushort(inputStream.read_ushort());
                    return;
                }
                case 5: {
                    outputStream.write_ulong(inputStream.read_ulong());
                    return;
                }
                case 6: {
                    outputStream.write_float(inputStream.read_float());
                    return;
                }
                case 7: {
                    outputStream.write_double(inputStream.read_double());
                    return;
                }
                case 8: {
                    outputStream.write_boolean(inputStream.read_boolean());
                    return;
                }
                case 9: {
                    outputStream.write_char(inputStream.read_char());
                    return;
                }
                case 10: {
                    outputStream.write_octet(inputStream.read_octet());
                    return;
                }
                case 11: {
                    outputStream.write_any(inputStream.read_any());
                    return;
                }
                case 12: {
                    outputStream.write_TypeCode(inputStream.read_TypeCode());
                    return;
                }
                case 13: {
                    outputStream.write_Principal(inputStream.read_Principal());
                    return;
                }
                case 14: {
                    outputStream.write_Object(inputStream.read_Object());
                    return;
                }
                case 22: {
                    outputStream.write_string(inputStream.read_string());
                }
                case 15: {
                    int n = 0;
                    while (n < typeCode.member_count()) {
                        StreamHelper.copy_stream(typeCode.member_type(n), inputStream, outputStream);
                        ++n;
                    }
                    return;
                }
                case 17: {
                    outputStream.write_ulong(inputStream.read_ulong());
                    return;
                }
                case 18: {
                    outputStream.write_string(inputStream.read_string());
                    return;
                }
                case 23: {
                    outputStream.write_longlong(inputStream.read_longlong());
                    return;
                }
                case 24: {
                    outputStream.write_ulonglong(inputStream.read_ulonglong());
                    return;
                }
                case 25: {
                    throw new NO_IMPLEMENT();
                }
                case 26: {
                    outputStream.write_wchar(inputStream.read_wchar());
                    return;
                }
                case 27: {
                    outputStream.write_wstring(inputStream.read_wstring());
                    return;
                }
                case 28: {
                    BigDecimal bigDecimal = inputStream instanceof ExtendedInputStream ? ((ExtendedInputStream)((Object)inputStream)).read_fixed(typeCode) : inputStream.read_fixed();
                    if (outputStream instanceof ExtendedOutputStream) {
                        ((ExtendedOutputStream)((Object)outputStream)).write_fixed(bigDecimal, typeCode);
                    } else {
                        outputStream.write_fixed(bigDecimal);
                    }
                    return;
                }
                case 29: {
                    outputStream.write_value(inputStream.read_value());
                    return;
                }
                case 30: {
                    BoxedValueHelper boxedValueHelper = null;
                    String string = typeCode.id();
                    try {
                        String string2 = RepoIDHelper.idToClass(string, 2);
                        boxedValueHelper = (BoxedValueHelper)Thread.currentThread().getContextClassLoader().loadClass(string2).newInstance();
                    }
                    catch (Exception exception) {
                        boxedValueHelper = new TypeCodeValueBoxHelper(((ExtendedOutputStream)((Object)outputStream)).orb(), typeCode);
                    }
                    outputStream.write_value(inputStream.read_value(boxedValueHelper), boxedValueHelper);
                    return;
                }
                case 32: {
                    outputStream.write_abstract_interface(inputStream.read_abstract_interface());
                    return;
                }
                case 19: 
                case 20: {
                    int n = typeCode.length();
                    if (typeCode.kind() == TCKind.tk_sequence) {
                        int n2 = inputStream.read_ulong();
                        if (n != 0 && n2 > n) {
                            throw new MARSHAL("Sequence length out of bounds", 1146056722, CompletionStatus.COMPLETED_MAYBE);
                        }
                        n = n2;
                        outputStream.write_ulong(n);
                    }
                    TypeCode typeCode2 = TypeCodeBase._base_type(typeCode.content_type());
                    StreamHelper.handle_array_content(inputStream, outputStream, typeCode2, n);
                    return;
                }
                case 16: {
                    TypeCode typeCode3 = TypeCodeBase._base_type(typeCode.discriminator_type());
                    StreamHelper.handle_union_content(inputStream, outputStream, typeCode, typeCode3);
                    return;
                }
            }
            Trace.signalIllegalCondition(null, "Unexpected type kind().value()==" + typeCode.kind().value() + ".");
        }
        catch (BadKind badKind) {
            throw new CascadingRuntimeException("Unexpected BadKind exception during value copy", badKind);
        }
        catch (Bounds bounds) {
            throw new CascadingRuntimeException("Unexpected Bounds exception during value copy", bounds);
        }
    }
}

