/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

public final class CharacterCache {
    private static final Character MIN_VALUE = new Character('\u0000');
    private static final Character MAX_VALUE = new Character('\uffff');
    private static final Character[] CACHE_BLOCK = new Character[95];
    private static final char BLOCK_MIN = ' ';
    private static final char BLOCK_MAX = '~';

    private CharacterCache() {
    }

    public static Character getCharacter(char c) {
        if (' ' <= c && c <= '~') {
            return CACHE_BLOCK[c - 32];
        }
        return '\u0000' == c ? MIN_VALUE : ('\uffff' == c ? MAX_VALUE : new Character(c));
    }

    static {
        char c = ' ';
        while (c <= '~') {
            CharacterCache.CACHE_BLOCK[c - 32] = new Character(c);
            c = (char)(c + '\u0001');
        }
    }
}

