/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.util.NamingUtils;

public class ContextUtilities {
    private ORB m_orb;
    private Logger m_logger = null;
    private NamingContextExt m_initalContext;

    public ContextUtilities(ORB oRB) {
        this.m_orb = oRB;
    }

    public NamingContextExt getInitialContext() {
        if (this.m_initalContext != null) {
            return this.m_initalContext;
        }
        try {
            Object object = this.m_orb.resolve_initial_references("NameService");
            this.m_initalContext = NamingContextExtHelper.narrow(object);
            return this.m_initalContext;
        }
        catch (InvalidName invalidName) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("InvalidName NameService!", invalidName);
            }
            return null;
        }
    }

    public boolean bind(String string, Object object) {
        try {
            if (string.indexOf("/") != -1 || string.indexOf(".") != -1) {
                return this.full_bind(string, object);
            }
            NameComponent[] nameComponentArray = NamingUtils.to_name(string);
            this.getInitialContext().bind(nameComponentArray, object);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean rebind(String string, Object object) {
        try {
            if (string.indexOf("/") != -1 || string.indexOf(".") != -1) {
                return this.full_rebind(string, object, this.getInitialContext());
            }
            NameComponent[] nameComponentArray = NamingUtils.to_name(string);
            this.getInitialContext().rebind(nameComponentArray, object);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Object resolve(String string) {
        try {
            if (string.indexOf("/") == -1 && string.indexOf(".") == -1) {
                NameComponent[] nameComponentArray = NamingUtils.to_name(string);
                return this.getInitialContext().resolve(nameComponentArray);
            }
            NameComponent[] nameComponentArray = this.getInitialContext().to_name(string);
            return this.getInitialContext().resolve(nameComponentArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean full_rebind(String string, Object object, NamingContextExt namingContextExt) {
        try {
            NameComponent[] nameComponentArray;
            NameComponent[] nameComponentArray2 = NamingUtils.to_name(string);
            NamingContext namingContext = namingContextExt;
            boolean bl = false;
            int n = 0;
            while (n < nameComponentArray2.length - 1) {
                nameComponentArray = nameComponentArray2[n];
                if (bl) {
                    namingContext = this.createNewContext(namingContext, (NameComponent)nameComponentArray);
                } else {
                    try {
                        NameComponent[] nameComponentArray3 = new NameComponent[]{nameComponentArray};
                        Object object2 = namingContext.resolve(nameComponentArray3);
                        namingContext = NamingContextHelper.narrow(object2);
                    }
                    catch (NotFound notFound) {
                        namingContext = this.createNewContext(namingContext, (NameComponent)nameComponentArray);
                        bl = true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                ++n;
            }
            nameComponentArray = new NameComponent[]{nameComponentArray2[nameComponentArray2.length - 1]};
            namingContext.rebind(nameComponentArray, object);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean full_bind(String string, Object object) {
        try {
            NameComponent[] nameComponentArray;
            NameComponent[] nameComponentArray2 = NamingUtils.to_name(string);
            NamingContext namingContext = this.getInitialContext();
            boolean bl = false;
            int n = 0;
            while (n < nameComponentArray2.length - 1) {
                nameComponentArray = nameComponentArray2[n];
                if (bl) {
                    namingContext = this.createNewContext(namingContext, (NameComponent)nameComponentArray);
                } else {
                    try {
                        NameComponent[] nameComponentArray3 = new NameComponent[]{nameComponentArray};
                        Object object2 = namingContext.resolve(nameComponentArray3);
                        namingContext = NamingContextHelper.narrow(object2);
                    }
                    catch (NotFound notFound) {
                        namingContext = this.createNewContext(namingContext, (NameComponent)nameComponentArray);
                        bl = true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                ++n;
            }
            nameComponentArray = new NameComponent[]{nameComponentArray2[nameComponentArray2.length - 1]};
            namingContext.bind(nameComponentArray, object);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private NamingContext createNewContext(NamingContext namingContext, NameComponent nameComponent) {
        try {
            NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
            return namingContext.bind_new_context(nameComponentArray);
        }
        catch (Exception exception) {
            return this.getInitialContext();
        }
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }
}

