/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class CreateORBProperties {
    private static void printUsage() {
        System.err.println("Usage: java org.openorb.util.CreateORBProperties [Options]");
        System.err.println("Options:");
        System.err.println("  --force             Overwrite the properties file.");
        System.err.println("  --pwd               Write to current working dir rather than");
        System.err.println("                      ${java.home}/lib.");
        System.err.println("  --config <URL|File> Specify a default URL or filename for the");
        System.err.println("                      OpenORB config file.");
        System.err.println("                      This automatically sets the force option.");
        System.err.println("  --rmi               In addition to the normal properties,");
        System.err.println("                      also add the RMIoverIIOP properies.");
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-rmi") || stringArray[n].equals("--rmi")) {
                bl = true;
            } else if (stringArray[n].equals("-force") || stringArray[n].equals("--force")) {
                bl2 = true;
            } else if (stringArray[n].equals("-pwd") || stringArray[n].equals("--pwd")) {
                bl3 = true;
            } else if (stringArray[n].equals("-config") || stringArray[n].equals("--config")) {
                if (stringArray.length < n + 1 || stringArray[n + 1].startsWith("-")) {
                    CreateORBProperties.printUsage();
                    System.exit(0);
                }
                bl2 = true;
                string = stringArray[++n];
            } else if (stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                CreateORBProperties.printUsage();
                System.exit(0);
            } else {
                CreateORBProperties.printUsage();
                System.exit(1);
            }
            ++n;
        }
        File file = null;
        if (!bl3) {
            object = "";
            try {
                object = System.getProperty("java.home");
            }
            catch (SecurityException securityException) {
                System.err.println("Unable to read the java.home property, access denied");
                System.exit(1);
            }
            file = new File((String)object, "lib");
            if (!file.exists()) {
                System.err.println("Directory \"" + file + "\" does not exist.");
                System.exit(1);
            }
            if (!file.isDirectory()) {
                System.err.println("File \"" + file + "\" is not a directory.");
                System.exit(1);
            }
        }
        object = new File(file, "orb.properties");
        if (!bl2 && ((File)object).exists()) {
            System.err.println("File \"" + object + "\" exists.");
            System.exit(1);
        }
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream((File)object));
        }
        catch (IOException iOException) {
            System.err.println("Can't create orb.properties file \"" + file + "\".");
            System.exit(1);
        }
        printStream.println("org.omg.CORBA.ORBClass=org.openorb.CORBA.ORB");
        printStream.println("org.omg.CORBA.ORBSingletonClass=org.openorb.CORBA.ORBSingleton");
        if (bl) {
            printStream.println("javax.rmi.CORBA.StubClass=org.openorb.rmi.system.StubDelegateImpl");
            printStream.println("javax.rmi.CORBA.UtilClass=org.openorb.rmi.system.UtilDelegateImpl");
            printStream.println("javax.rmi.CORBA.PortableRemoteObjectClass=org.openorb.rmi.system.PortableRemoteObjectDelegateImpl");
        }
        if (string != null) {
            printStream.println("openorb.config=" + string);
        }
        printStream.close();
        if (printStream.checkError()) {
            System.err.println("Error while writing orb.properties file \"" + file + "\".");
            System.exit(1);
        }
    }
}

