/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class ConfigurationUtil {
    public static String list(Configuration config) {
        StringBuffer buffer = new StringBuffer();
        ConfigurationUtil.list(buffer, "  ", config);
        buffer.append("\n");
        return buffer.toString();
    }

    private static void list(StringBuffer buffer, String lead, Configuration config) {
        Configuration[] children;
        buffer.append("\n" + lead + "<" + config.getName());
        String[] names = config.getAttributeNames();
        if (names.length > 0) {
            int i = 0;
            while (i < names.length) {
                buffer.append(" " + names[i] + "=\"" + config.getAttribute(names[i], "???") + "\"");
                ++i;
            }
        }
        if ((children = config.getChildren()).length > 0) {
            buffer.append(">");
            int j = 0;
            while (j < children.length) {
                ConfigurationUtil.list(buffer, lead + "  ", children[j]);
                ++j;
            }
            buffer.append("\n" + lead + "</" + config.getName() + ">");
        } else if (config.getValue(null) != null) {
            buffer.append(">...</" + config.getName() + ">");
        } else {
            buffer.append("/>");
        }
    }

    public static Configuration[] match(Configuration config, String element, String attribute) {
        return ConfigurationUtil.match(config, element, attribute, null);
    }

    public static Configuration[] match(Configuration config, String element, String attribute, String value) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        Configuration[] children = config.getChildren(element);
        int i = 0;
        while (i < children.length) {
            if (null == attribute) {
                list.add(children[i]);
            } else {
                String v = children[i].getAttribute(attribute, null);
                if (v != null && (value == null || v.equals(value))) {
                    list.add(children[i]);
                }
            }
            ++i;
        }
        return list.toArray(new Configuration[list.size()]);
    }

    public static Configuration matchFirstOccurance(Configuration config, String element, String attribute, String value) {
        return ConfigurationUtil.matchFirstOccurance(config, element, attribute, value, true);
    }

    public static Configuration matchFirstOccurance(Configuration config, String element, String attribute, String value, boolean create) {
        Configuration[] children = config.getChildren(element);
        int i = 0;
        while (i < children.length) {
            String v = children[i].getAttribute(attribute, null);
            if (v != null && (value == null || v.equals(value))) {
                return children[i];
            }
            ++i;
        }
        return create ? new DefaultConfiguration(element, null) : null;
    }

    public static Configuration branch(Configuration config, String name) {
        DefaultConfiguration c = ConfigurationUtil.createNew(config, name);
        String[] attributes = config.getAttributeNames();
        Configuration[] kids = config.getChildren();
        c.setValue(config.getValue(null));
        int i = 0;
        while (i < attributes.length) {
            try {
                c.setAttribute(attributes[i], config.getAttribute(attributes[i]));
            }
            catch (ConfigurationException e) {
                throw new CascadingRuntimeException("Configuration is missing advertised attribute", (Throwable)e);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < kids.length) {
            c.addChild(kids[i2]);
            ++i2;
        }
        c.makeReadOnly();
        return c;
    }

    private static DefaultConfiguration createNew(Configuration config, String name) {
        if (config instanceof AbstractConfiguration) {
            try {
                return new DefaultConfiguration(name, config.getLocation(), config.getNamespace(), "");
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
        }
        return new DefaultConfiguration(name, config.getLocation());
    }

    public static boolean equals(Configuration c1, Configuration c2) {
        return c1.getName().equals(c2.getName()) && ConfigurationUtil.isValueEquals(c1, c2) && ConfigurationUtil.isAttributesEqual(c1, c2) && ConfigurationUtil.isChildrenEqual(c1, c2);
    }

    private static boolean isChildrenEqual(Configuration c1, Configuration c2) {
        ArrayList<Configuration> kids2;
        Configuration[] kids1 = c1.getChildren();
        if (kids1.length != (kids2 = new ArrayList<Configuration>(Arrays.asList(c2.getChildren()))).size()) {
            return false;
        }
        int i = 0;
        while (i < kids1.length) {
            if (!ConfigurationUtil.isMatchingChild(kids1[i], kids2)) {
                return false;
            }
            ++i;
        }
        return kids2.isEmpty();
    }

    private static boolean isMatchingChild(Configuration c, ArrayList matchAgainst) {
        Iterator i = matchAgainst.iterator();
        while (i.hasNext()) {
            if (!ConfigurationUtil.equals(c, (Configuration)i.next())) continue;
            i.remove();
            return true;
        }
        return false;
    }

    private static boolean isAttributesEqual(Configuration c1, Configuration c2) {
        String[] attr = c1.getAttributeNames();
        if (attr.length != c2.getAttributeNames().length) {
            return false;
        }
        int i = 0;
        while (i < attr.length) {
            try {
                if (!c1.getAttribute(attr[i]).equals(c2.getAttribute(attr[i], null))) {
                    return false;
                }
            }
            catch (ConfigurationException e) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isValueEquals(Configuration c1, Configuration c2) {
        String value1 = c1.getValue(null);
        String value2 = c2.getValue(null);
        return value1 == null && value2 == null || value1 != null && value1.equals(value2);
    }
}

