/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.dynany;

import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.NameDynAnyPair;
import org.omg.DynamicAny.NameValuePair;
import org.openorb.CORBA.Any;
import org.openorb.CORBA.dynany.DynAnyImpl;
import org.openorb.CORBA.typecode.TypeCodeBase;

class DynStructImpl
extends DynAnyImpl
implements DynStruct {
    private int m_current;
    private DynAny[] m_members;
    private final TypeCode m_baseType;

    public DynStructImpl(DynAnyFactory dynAnyFactory, ORB oRB, TypeCode typeCode) {
        super(dynAnyFactory, oRB);
        this.m_type = typeCode;
        this.m_baseType = ((TypeCodeBase)this.m_type)._base_type();
        this.m_members = this.create_dyn_any_graph(typeCode);
        if (this.m_members.length == 0) {
            this.invalidateCurrent();
        } else {
            this.rewind();
        }
    }

    public void assign(DynAny dynAny) throws TypeMismatch {
        if (!dynAny.type().equivalent(this.m_type)) {
            throw new TypeMismatch();
        }
        this.m_members = ((DynStructImpl)dynAny).copy_dyn_any_graph(((DynStructImpl)dynAny).m_members);
    }

    public void from_any(org.omg.CORBA.Any any) throws InvalidValue, TypeMismatch {
        if (!any.type().equivalent(this.m_type)) {
            throw new TypeMismatch();
        }
        InputStream inputStream = any.create_input_stream();
        this.stream_to_dyn_any_graph(this.m_members, inputStream);
    }

    public org.omg.CORBA.Any to_any() {
        org.omg.CORBA.Any any = this.m_orb.create_any();
        any.type(this.m_type);
        OutputStream outputStream = any.create_output_stream();
        this.dyn_any_graph_to_stream(this.m_members, outputStream);
        return any;
    }

    public void destroy() {
        this.m_members = null;
        System.gc();
    }

    public DynAny copy() {
        DynStructImpl dynStructImpl = new DynStructImpl(this.m_factory, this.m_orb, this.m_type);
        try {
            dynStructImpl.assign(this);
        }
        catch (TypeMismatch typeMismatch) {
            this.handleTypeMismatchException(typeMismatch);
        }
        return dynStructImpl;
    }

    public DynAny current_component() throws TypeMismatch {
        if (this.m_members.length == 0) {
            throw new TypeMismatch();
        }
        if (this.m_current == -1) {
            return null;
        }
        return this.m_members[this.m_current];
    }

    public boolean next() {
        ++this.m_current;
        if (this.m_current < this.m_members.length) {
            if (this.m_members[this.m_current] != null) {
                this.m_any = (Any)this.m_members[this.m_current].to_any();
            }
            return true;
        }
        this.invalidateCurrent();
        return false;
    }

    public boolean seek(int n) {
        if (n < 0) {
            this.invalidateCurrent();
            return false;
        }
        if (n < this.m_members.length) {
            this.m_current = n;
            if (this.m_members[this.m_current] != null) {
                this.m_any = (Any)this.m_members[this.m_current].to_any();
            }
            return true;
        }
        this.invalidateCurrent();
        return false;
    }

    public void rewind() {
        this.seek(0);
    }

    public int component_count() {
        return this.m_members.length;
    }

    public String current_member_name() throws InvalidValue, TypeMismatch {
        if (this.m_current < 0 || this.m_current >= this.m_members.length) {
            throw new InvalidValue();
        }
        try {
            return this.m_baseType.member_name(this.m_current);
        }
        catch (BadKind badKind) {
            this.handleBadKindException(badKind);
        }
        catch (Bounds bounds) {
            this.handleBoundsException(bounds);
        }
        throw new IllegalStateException();
    }

    public TCKind current_member_kind() throws InvalidValue, TypeMismatch {
        if (this.m_current < 0 || this.m_current >= this.m_members.length) {
            throw new InvalidValue();
        }
        try {
            return this.m_baseType.member_type(this.m_current).kind();
        }
        catch (BadKind badKind) {
            this.handleBadKindException(badKind);
        }
        catch (Bounds bounds) {
            this.handleBoundsException(bounds);
        }
        throw new IllegalStateException();
    }

    public NameValuePair[] get_members() {
        NameValuePair[] nameValuePairArray = new NameValuePair[this.m_members.length];
        try {
            int n = 0;
            while (n < this.m_members.length) {
                nameValuePairArray[n] = new NameValuePair();
                nameValuePairArray[n].id = this.m_baseType.member_name(n);
                nameValuePairArray[n].value = this.m_members[n].to_any();
                ++n;
            }
        }
        catch (BadKind badKind) {
            this.handleBadKindException(badKind);
        }
        catch (Bounds bounds) {
            this.handleBoundsException(bounds);
        }
        return nameValuePairArray;
    }

    public void set_members(NameValuePair[] nameValuePairArray) throws InvalidValue, TypeMismatch {
        if (nameValuePairArray.length != this.m_members.length) {
            throw new InvalidValue();
        }
        if (nameValuePairArray.length == 0) {
            this.invalidateCurrent();
        } else {
            this.rewind();
        }
        try {
            int n = 0;
            while (n < this.m_baseType.member_count()) {
                if (nameValuePairArray[n].id.equals("") ? !nameValuePairArray[n].value.type().equivalent(this.m_baseType.member_type(n)) : !this.m_baseType.member_name(n).equals(nameValuePairArray[n].id)) {
                    throw new TypeMismatch();
                }
                this.m_members[n].from_any(nameValuePairArray[n].value);
                ++n;
            }
        }
        catch (BadKind badKind) {
            this.handleBadKindException(badKind);
        }
        catch (Bounds bounds) {
            this.handleBoundsException(bounds);
        }
    }

    public NameDynAnyPair[] get_members_as_dyn_any() {
        NameDynAnyPair[] nameDynAnyPairArray = new NameDynAnyPair[this.m_members.length];
        try {
            int n = 0;
            while (n < this.m_members.length) {
                nameDynAnyPairArray[n] = new NameDynAnyPair();
                nameDynAnyPairArray[n].id = this.m_baseType.member_name(n);
                nameDynAnyPairArray[n].value = this.m_members[n];
                ++n;
            }
        }
        catch (BadKind badKind) {
            this.handleBadKindException(badKind);
        }
        catch (Bounds bounds) {
            this.handleBoundsException(bounds);
        }
        return nameDynAnyPairArray;
    }

    public void set_members_as_dyn_any(NameDynAnyPair[] nameDynAnyPairArray) throws TypeMismatch, InvalidValue {
        if (nameDynAnyPairArray.length != this.m_members.length) {
            throw new InvalidValue();
        }
        if (nameDynAnyPairArray.length == 0) {
            this.invalidateCurrent();
        } else {
            this.rewind();
        }
        try {
            int n = 0;
            while (n < this.m_baseType.member_count()) {
                if (nameDynAnyPairArray[n].id.equals("") ? !nameDynAnyPairArray[n].value.type().equivalent(this.m_baseType.member_type(n)) : !this.m_baseType.member_name(n).equals(nameDynAnyPairArray[n].id)) {
                    throw new TypeMismatch();
                }
                this.m_members[n] = nameDynAnyPairArray[n].value;
                ++n;
            }
        }
        catch (BadKind badKind) {
            this.handleBadKindException(badKind);
        }
        catch (Bounds bounds) {
            this.handleBoundsException(bounds);
        }
    }

    private void invalidateCurrent() {
        this.m_current = -1;
        this.m_any = null;
    }

    private final void handleBadKindException(BadKind badKind) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("BadKind", badKind);
        }
        throw new INTERNAL(1330446336, CompletionStatus.COMPLETED_MAYBE);
    }

    private final void handleBoundsException(Bounds bounds) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("Bounds", bounds);
        }
        throw new INTERNAL(1330446336, CompletionStatus.COMPLETED_MAYBE);
    }

    private final void handleTypeMismatchException(TypeMismatch typeMismatch) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("TypeMismatch", typeMismatch);
        }
        throw new INTERNAL(1330446336, CompletionStatus.COMPLETED_MAYBE);
    }
}

