/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.poa;

import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdAssignmentPolicyValueHelper;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValueHelper;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValueHelper;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.LifespanPolicyValueHelper;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.RequestProcessingPolicyValueHelper;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValueHelper;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;
import org.omg.PortableServer.ThreadPolicyValueHelper;

class PolicyFactoryImpl
extends LocalObject
implements PolicyFactory {
    private static PolicyFactoryImpl s_instance = null;
    private static ThreadPolicyImpl[] s_pol_thread = null;
    private static LifespanPolicyImpl[] s_pol_lifespan = null;
    private static IdUniquenessPolicyImpl[] s_pol_id_uniqueness = null;
    private static IdAssignmentPolicyImpl[] s_pol_id_assignment = null;
    private static ServantRetentionPolicyImpl[] s_pol_servant_retention = null;
    private static RequestProcessingPolicyImpl[] s_pol_request_processing = null;
    private static ImplicitActivationPolicyImpl[] s_pol_implicit_activation = null;

    private PolicyFactoryImpl() {
    }

    public static PolicyFactoryImpl getInstance() {
        if (s_instance == null) {
            s_instance = new PolicyFactoryImpl();
        }
        return s_instance;
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        switch (n) {
            case 16: {
                if (!any.type().equal(ThreadPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_thread_policy(ThreadPolicyValueHelper.extract(any).value());
            }
            case 17: {
                if (!any.type().equal(LifespanPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_lifespan_policy(LifespanPolicyValueHelper.extract(any).value());
            }
            case 18: {
                if (!any.type().equal(IdUniquenessPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_id_uniqueness_policy(IdUniquenessPolicyValueHelper.extract(any).value());
            }
            case 19: {
                if (!any.type().equal(IdAssignmentPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_id_assignment_policy(IdAssignmentPolicyValueHelper.extract(any).value());
            }
            case 21: {
                if (!any.type().equal(ServantRetentionPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_servant_retention_policy(ServantRetentionPolicyValueHelper.extract(any).value());
            }
            case 22: {
                if (!any.type().equal(RequestProcessingPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_request_processing_policy(RequestProcessingPolicyValueHelper.extract(any).value());
            }
            case 20: {
                if (!any.type().equal(ImplicitActivationPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_implicit_activation_policy(ImplicitActivationPolicyValueHelper.extract(any).value());
            }
        }
        throw new PolicyError(0);
    }

    synchronized ThreadPolicy create_thread_policy(int n) {
        if (s_pol_thread == null) {
            s_pol_thread = new ThreadPolicyImpl[2];
        }
        if (s_pol_thread[n] == null) {
            PolicyFactoryImpl.s_pol_thread[n] = new ThreadPolicyImpl(n);
        }
        return s_pol_thread[n];
    }

    synchronized LifespanPolicy create_lifespan_policy(int n) {
        if (s_pol_lifespan == null) {
            s_pol_lifespan = new LifespanPolicyImpl[2];
        }
        if (s_pol_lifespan[n] == null) {
            PolicyFactoryImpl.s_pol_lifespan[n] = new LifespanPolicyImpl(n);
        }
        return s_pol_lifespan[n];
    }

    synchronized IdUniquenessPolicy create_id_uniqueness_policy(int n) {
        if (s_pol_id_uniqueness == null) {
            s_pol_id_uniqueness = new IdUniquenessPolicyImpl[2];
        }
        if (s_pol_id_uniqueness[n] == null) {
            PolicyFactoryImpl.s_pol_id_uniqueness[n] = new IdUniquenessPolicyImpl(n);
        }
        return s_pol_id_uniqueness[n];
    }

    synchronized IdAssignmentPolicy create_id_assignment_policy(int n) {
        if (s_pol_id_assignment == null) {
            s_pol_id_assignment = new IdAssignmentPolicyImpl[2];
        }
        if (s_pol_id_assignment[n] == null) {
            PolicyFactoryImpl.s_pol_id_assignment[n] = new IdAssignmentPolicyImpl(n);
        }
        return s_pol_id_assignment[n];
    }

    synchronized ServantRetentionPolicy create_servant_retention_policy(int n) {
        if (s_pol_servant_retention == null) {
            s_pol_servant_retention = new ServantRetentionPolicyImpl[2];
        }
        if (s_pol_servant_retention[n] == null) {
            PolicyFactoryImpl.s_pol_servant_retention[n] = new ServantRetentionPolicyImpl(n);
        }
        return s_pol_servant_retention[n];
    }

    synchronized RequestProcessingPolicy create_request_processing_policy(int n) {
        if (s_pol_request_processing == null) {
            s_pol_request_processing = new RequestProcessingPolicyImpl[3];
        }
        if (s_pol_request_processing[n] == null) {
            PolicyFactoryImpl.s_pol_request_processing[n] = new RequestProcessingPolicyImpl(n);
        }
        return s_pol_request_processing[n];
    }

    synchronized ImplicitActivationPolicy create_implicit_activation_policy(int n) {
        if (s_pol_implicit_activation == null) {
            s_pol_implicit_activation = new ImplicitActivationPolicyImpl[2];
        }
        if (s_pol_implicit_activation[n] == null) {
            PolicyFactoryImpl.s_pol_implicit_activation[n] = new ImplicitActivationPolicyImpl(n);
        }
        return s_pol_implicit_activation[n];
    }

    private static class ImplicitActivationPolicyImpl
    extends LocalObject
    implements ImplicitActivationPolicy {
        private ImplicitActivationPolicyValue m_value;

        ImplicitActivationPolicyImpl(int n) {
            this.m_value = ImplicitActivationPolicyValue.from_int(n);
        }

        public ImplicitActivationPolicyValue value() {
            return this.m_value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 20;
        }
    }

    private static class RequestProcessingPolicyImpl
    extends LocalObject
    implements RequestProcessingPolicy {
        private RequestProcessingPolicyValue m_value;

        RequestProcessingPolicyImpl(int n) {
            this.m_value = RequestProcessingPolicyValue.from_int(n);
        }

        public RequestProcessingPolicyValue value() {
            return this.m_value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 22;
        }
    }

    private static class ServantRetentionPolicyImpl
    extends LocalObject
    implements ServantRetentionPolicy {
        private ServantRetentionPolicyValue m_value;

        ServantRetentionPolicyImpl(int n) {
            this.m_value = ServantRetentionPolicyValue.from_int(n);
        }

        public ServantRetentionPolicyValue value() {
            return this.m_value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 21;
        }
    }

    private static class IdAssignmentPolicyImpl
    extends LocalObject
    implements IdAssignmentPolicy {
        private IdAssignmentPolicyValue m_value;

        IdAssignmentPolicyImpl(int n) {
            this.m_value = IdAssignmentPolicyValue.from_int(n);
        }

        public IdAssignmentPolicyValue value() {
            return this.m_value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 19;
        }
    }

    private static class IdUniquenessPolicyImpl
    extends LocalObject
    implements IdUniquenessPolicy {
        private IdUniquenessPolicyValue m_value;

        IdUniquenessPolicyImpl(int n) {
            this.m_value = IdUniquenessPolicyValue.from_int(n);
        }

        public IdUniquenessPolicyValue value() {
            return this.m_value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 18;
        }
    }

    private static class LifespanPolicyImpl
    extends LocalObject
    implements LifespanPolicy {
        private LifespanPolicyValue m_value;

        LifespanPolicyImpl(int n) {
            this.m_value = LifespanPolicyValue.from_int(n);
        }

        public LifespanPolicyValue value() {
            return this.m_value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 17;
        }
    }

    private static class ThreadPolicyImpl
    extends LocalObject
    implements ThreadPolicy {
        private ThreadPolicyValue m_value;

        ThreadPolicyImpl(int n) {
            this.m_value = ThreadPolicyValue.from_int(n);
        }

        public ThreadPolicyValue value() {
            return this.m_value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 16;
        }
    }
}

