/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import org.openorb.iiop.CodeSetDatabase;
import org.openorb.io.HexPrintStream;

public final class CodeSet {
    private final int m_id;
    private final String m_canonical;
    private final String m_name;
    private final String m_description;
    private final short[] m_charsets;
    private final int m_maxSize;
    private final int m_alignment;
    private final boolean m_server;

    public CodeSet(String string, int n, short[] sArray, int n2, String string2, String string3, int n3, boolean bl) {
        this.m_description = string;
        this.m_id = n;
        this.m_charsets = sArray;
        this.m_maxSize = n2;
        this.m_canonical = string2;
        this.m_name = string3;
        this.m_alignment = n3;
        this.m_server = bl;
    }

    public int getId() {
        return this.m_id;
    }

    public String getCanonicalName() {
        return this.m_canonical;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public short[] getCharsets() {
        return this.m_charsets;
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public int getAlignment() {
        return this.m_alignment;
    }

    public boolean forServer() {
        return this.m_server;
    }

    public String toString() {
        String string = "\"" + this.m_description + "\", 0x" + HexPrintStream.toHex(this.m_id) + ", new short [] { ";
        int n = 0;
        while (n < this.m_charsets.length) {
            string = string + "0x" + HexPrintStream.toHex(this.m_charsets[n]);
            if (n < this.m_charsets.length - 1) {
                string = string + ", ";
            }
            ++n;
        }
        string = string + " } ," + this.m_maxSize + ", \"" + this.m_canonical + "\", \"" + this.m_name + "\", " + this.m_alignment + ", " + this.m_server;
        return string;
    }

    public boolean isCompatibleTo(CodeSet codeSet) {
        return CodeSet.compatible(this, codeSet);
    }

    public static boolean compatible(int n, int n2) {
        CodeSet codeSet = CodeSetDatabase.getCodeSetFromId(n);
        CodeSet codeSet2 = CodeSetDatabase.getCodeSetFromId(n2);
        if (codeSet == null || codeSet2 == null) {
            return false;
        }
        return CodeSet.compatible(codeSet, codeSet2);
    }

    public static boolean compatible(CodeSet codeSet, CodeSet codeSet2) {
        if (codeSet.getCharsets().length >= 1) {
            return codeSet2.getCharsets().length == 1 && codeSet.getCharsets()[0] == codeSet2.getCharsets()[0];
        }
        if (codeSet2.getCharsets().length == 1) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n < codeSet.getCharsets().length && n2 < codeSet2.getCharsets().length) {
            if (codeSet.getCharsets()[n] == codeSet2.getCharsets()[n2]) {
                if (bl) {
                    return true;
                }
                bl = true;
                ++n;
                ++n2;
                continue;
            }
            if (codeSet.getCharsets()[n] < codeSet2.getCharsets()[n2]) {
                ++n;
                continue;
            }
            ++n2;
        }
        return false;
    }
}

