/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HexPrintStream
extends FilterOutputStream {
    public static final int FORMAT_SIMPLE = 0;
    public static final int FORMAT_HEXONLY = 1;
    public static final int FORMAT_MIXED = 2;
    public static final int FORMAT_MIXED_TWOLINE = 3;
    private byte[] m_store = null;
    private int m_stoff;
    private int m_format;
    private byte[] m_hexbuf = null;
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();

    public HexPrintStream(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public HexPrintStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.setFormat(n);
    }

    public void write(int n) throws IOException {
        if (this.m_store == null) {
            this.m_store = new byte[0];
            this.m_store[0] = (byte)n;
            this.m_stoff = 1;
            this.flush();
            this.m_store = null;
        } else {
            this.m_store[++this.m_stoff] = (byte)n;
            if (this.m_stoff >= this.m_store.length) {
                this.flush();
            }
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.m_store == null) {
            if (n == 0) {
                this.m_store = byArray;
            } else {
                this.m_store = new byte[n2];
                System.arraycopy(byArray, n, this.m_store, 0, n2);
            }
            this.m_stoff = n2;
            this.flush();
            this.m_store = null;
            return;
        }
        if (n2 < this.m_store.length - this.m_stoff) {
            System.arraycopy(byArray, n, this.m_store, this.m_stoff, n2);
            this.m_stoff += n2;
            return;
        }
        if (this.m_stoff > 0) {
            System.arraycopy(byArray, n, this.m_store, this.m_stoff, this.m_store.length - this.m_stoff);
            n += this.m_store.length - this.m_stoff;
            n2 -= this.m_store.length - this.m_stoff;
            this.m_stoff = this.m_store.length;
            this.flush();
        }
        while (n2 >= this.m_store.length) {
            System.arraycopy(byArray, n, this.m_store, 0, this.m_store.length);
            n += this.m_store.length;
            n2 -= this.m_store.length;
            this.m_stoff = this.m_store.length;
            this.flush();
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.m_store, 0, n2);
            this.m_stoff = n2;
        }
    }

    public void flush() throws IOException {
        int n;
        int n2;
        if (this.m_stoff == 0) {
            return;
        }
        if (this.m_hexbuf == null || this.m_hexbuf.length < this.m_stoff * 2) {
            this.m_hexbuf = new byte[this.m_stoff * 2];
        }
        int n3 = 0;
        while (n3 < this.m_stoff) {
            n2 = this.m_store[n3] & 0xF;
            n = this.m_store[n3] >>> 4 & 0xF;
            this.m_hexbuf[n3 * 2] = n < 10 ? (byte)(48 + n) : (byte)(65 + n - 10);
            this.m_hexbuf[n3 * 2 + 1] = n2 < 10 ? (byte)(48 + n2) : (byte)(65 + n2 - 10);
            ++n3;
        }
        switch (this.m_format) {
            case 0: {
                this.out.write(this.m_hexbuf, 0, 2 * this.m_stoff);
                break;
            }
            case 2: {
                n2 = 0;
                while (n2 < this.m_stoff) {
                    if (Character.isISOControl((char)(this.m_store[n2] & 0x7F))) {
                        this.m_store[n2] = 46;
                    }
                    ++n2;
                }
                n = this.m_stoff;
                while (n < this.m_store.length) {
                    this.m_store[n] = 32;
                    ++n;
                }
                this.out.write(this.m_store, 0, 8);
                this.out.write(32);
                this.out.write(this.m_store, 8, 8);
                this.out.write(32);
                this.out.write(32);
            }
            case 1: {
                int n4 = 0;
                while (n4 < this.m_stoff - 3) {
                    this.out.write(this.m_hexbuf, n4 * 2, 8);
                    this.out.write(32);
                    n4 += 4;
                }
                if (this.m_stoff % 4 != 0) {
                    this.out.write(this.m_hexbuf, this.m_stoff / 4 * 8, this.m_stoff % 4 * 2);
                }
                this.out.write(LINE_SEPARATOR);
                break;
            }
            case 3: {
                int n5 = 0;
                while (n5 < this.m_stoff) {
                    if (Character.isISOControl((char)(this.m_store[n5] & 0x7F))) {
                        this.out.write(45);
                        this.out.write(45);
                    } else {
                        this.out.write(this.m_store[n5]);
                        this.out.write(32);
                    }
                    if ((n5 + 1) % 4 == 0) {
                        this.out.write(32);
                    }
                    ++n5;
                }
                this.out.write(LINE_SEPARATOR);
                int n6 = 0;
                while (n6 < this.m_stoff - 3) {
                    this.out.write(this.m_hexbuf, n6 * 2, 8);
                    this.out.write(32);
                    n6 += 4;
                }
                if (this.m_stoff % 4 != 0) {
                    this.out.write(this.m_hexbuf, this.m_stoff / 4 * 8, this.m_stoff % 4 * 2);
                }
                this.out.write(LINE_SEPARATOR);
            }
        }
        this.m_stoff = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public int getFormat() {
        return this.m_format;
    }

    public void setFormat(int n) {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_format = n;
        switch (n) {
            case 0: {
                this.m_store = null;
                break;
            }
            case 2: {
                this.m_store = new byte[16];
                break;
            }
            case 1: 
            case 3: {
                this.m_store = new byte[32];
            }
        }
    }

    public static String toHex(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        char[] cArray = new char[8];
        int n2 = 0;
        while (n2 < 4) {
            int n3 = byArray[n2] & 0xF;
            int n4 = byArray[n2] >>> 4 & 0xF;
            cArray[n2 * 2] = n4 < 10 ? (char)(48 + n4) : (char)(65 + n4 - 10);
            cArray[n2 * 2 + 1] = n3 < 10 ? (char)(48 + n3) : (char)(65 + n3 - 10);
            ++n2;
        }
        return new String(cArray);
    }

    public static String toHex(short s) {
        byte[] byArray = new byte[]{(byte)(s >>> 8), (byte)s};
        char[] cArray = new char[4];
        int n = 0;
        while (n < 2) {
            int n2 = byArray[n] & 0xF;
            int n3 = byArray[n] >>> 4 & 0xF;
            cArray[n * 2] = n3 < 10 ? (char)(48 + n3) : (char)(65 + n3 - 10);
            cArray[n * 2 + 1] = n2 < 10 ? (char)(48 + n2) : (char)(65 + n2 - 10);
            ++n;
        }
        return new String(cArray);
    }

    public static String toHex(byte by) {
        byte[] byArray = new byte[]{by};
        char[] cArray = new char[2];
        int n = byArray[0] & 0xF;
        int n2 = byArray[0] >>> 4 & 0xF;
        cArray[0] = n2 < 10 ? (char)(48 + n2) : (char)(65 + n2 - 10);
        cArray[1] = n < 10 ? (char)(48 + n) : (char)(65 + n - 10);
        return new String(cArray);
    }

    private static boolean isPrintable(byte by) {
        switch (Character.getType((char)by)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            byte[] byArray = new byte[256];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = (byte)n;
                ++n;
            }
            HexPrintStream hexPrintStream = new HexPrintStream(System.out);
            int n2 = 0;
            while (n2 < 4) {
                hexPrintStream.setFormat(n2);
                hexPrintStream.write(byArray);
                System.out.println();
                ++n2;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

