/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.CORBA.DataInputStream;
import org.openorb.CORBA.DataOutputStream;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.io.ExtendedInputStream;
import org.openorb.io.ListOutputStream;
import org.openorb.io.TypeCodeValueBoxHelper;
import org.openorb.util.ExceptionTool;
import org.openorb.util.RepoIDHelper;

public class ListInputStream
extends InputStream
implements ExtendedInputStream {
    private List m_source;
    private ListIterator m_iter = null;
    private int m_iter_pos = 0;
    private int m_mark_pos = 0;
    private ORB m_orb;
    private Logger m_logger = null;

    public ListInputStream(ORB oRB, List list) {
        this.m_source = list;
        this.m_orb = oRB;
    }

    public ORB orb() {
        return this.m_orb;
    }

    public String get_codebase() {
        return null;
    }

    private List getSource() {
        return this.m_source;
    }

    private List getSourceTail() {
        return this.m_source.subList(this.m_iter_pos, this.m_source.size());
    }

    private int getIndex() {
        return this.m_iter_pos;
    }

    private void setIndex(int n) {
        if (n > this.m_source.size() || n < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.m_iter_pos = n;
        this.m_iter = null;
    }

    public int getSourceSize() {
        return this.m_source.size();
    }

    public int skip() {
        throw new NO_IMPLEMENT();
    }

    public int available() {
        throw new NO_IMPLEMENT();
    }

    public boolean markAvailable() {
        return true;
    }

    public void mark(int n) {
        this.m_mark_pos = this.m_iter_pos;
    }

    public void reset() {
        this.m_iter_pos = this.m_mark_pos;
        this.m_iter = null;
    }

    private SystemException reportBufferPositionOfFormatProblem(Throwable throwable) {
        this.getLogger().error("Buffer position or format problem.", throwable);
        return ExceptionTool.initCause(new MARSHAL("Buffer position or format problem (" + throwable + ")", 1146056728, CompletionStatus.COMPLETED_MAYBE), throwable);
    }

    private SystemException reportOverreadListStream(Throwable throwable) {
        this.getLogger().warn("Overread on list stream.", throwable);
        return ExceptionTool.initCause(new MARSHAL("Overread on list stream (" + throwable + ")", 1146056726, CompletionStatus.COMPLETED_MAYBE), throwable);
    }

    /*
     * Loose catch block
     */
    private java.lang.Object next() {
        while (true) {
            try {
                if (this.m_iter == null) {
                    this.m_iter = this.m_source.listIterator(this.m_iter_pos);
                }
                java.lang.Object e = this.m_iter.next();
                ++this.m_iter_pos;
                return e;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.getLogger().warn("error in next()", concurrentModificationException);
                this.m_iter = null;
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw this.reportOverreadListStream(noSuchElementException);
            }
            break;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.reportOverreadListStream(indexOutOfBoundsException);
        }
    }

    private java.lang.Object peek() {
        try {
            return this.m_source.get(this.m_iter_pos);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw this.reportOverreadListStream(noSuchElementException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.reportOverreadListStream(indexOutOfBoundsException);
        }
    }

    TypeCodeValueBoxHelper read_value_box() {
        try {
            if ((TCKind)this.next() != TCKind.tk_value_box) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (TypeCodeValueBoxHelper)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    private void read_array(java.lang.Object object, int n, int n2, TCKind tCKind) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != tCKind) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.getLength() != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.getContents(), arrayBlock.getOffset(), object, n, n2);
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw this.reportBufferPositionOfFormatProblem(arrayStoreException);
        }
    }

    private SystemException reportTypeMismatch() {
        return new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
    }

    public boolean read_boolean() {
        try {
            if ((TCKind)this.next() != TCKind.tk_boolean) {
                throw this.reportTypeMismatch();
            }
            return (Boolean)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_boolean_array(boolean[] blArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(blArray, n, n2, TCKind.tk_boolean);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                blArray[n + n3] = this.read_boolean();
                ++n3;
            }
        }
    }

    public byte read_octet() {
        try {
            if ((TCKind)this.next() != TCKind.tk_octet) {
                throw this.reportTypeMismatch();
            }
            return (Byte)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_octet_array(byte[] byArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(byArray, n, n2, TCKind.tk_octet);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                byArray[n + n3] = this.read_octet();
                ++n3;
            }
        }
    }

    public short read_short() {
        try {
            if ((TCKind)this.next() != TCKind.tk_short) {
                throw this.reportTypeMismatch();
            }
            return (Short)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_short_array(short[] sArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(sArray, n, n2, TCKind.tk_short);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                sArray[n + n3] = this.read_short();
                ++n3;
            }
        }
    }

    public short read_ushort() {
        try {
            if ((TCKind)this.next() != TCKind.tk_ushort) {
                throw this.reportTypeMismatch();
            }
            return (Short)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_ushort_array(short[] sArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(sArray, n, n2, TCKind.tk_ushort);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                sArray[n + n3] = this.read_ushort();
                ++n3;
            }
        }
    }

    public int read_long() {
        try {
            TCKind tCKind = (TCKind)this.next();
            if (tCKind != TCKind.tk_ulong) {
                throw this.reportTypeMismatch();
            }
            return (Integer)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_long_array(int[] nArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(nArray, n, n2, TCKind.tk_long);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                nArray[n + n3] = this.read_long();
                ++n3;
            }
        }
    }

    public int read_ulong() {
        try {
            TCKind tCKind = (TCKind)this.next();
            if (tCKind != TCKind.tk_ulong) {
                throw this.reportTypeMismatch();
            }
            return (Integer)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_ulong_array(int[] nArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(nArray, n, n2, TCKind.tk_ulong);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                nArray[n + n3] = this.read_ulong();
                ++n3;
            }
        }
    }

    public long read_longlong() {
        try {
            if ((TCKind)this.next() != TCKind.tk_longlong) {
                throw this.reportTypeMismatch();
            }
            return (Long)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_longlong_array(long[] lArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(lArray, n, n2, TCKind.tk_longlong);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                lArray[n + n3] = this.read_longlong();
                ++n3;
            }
        }
    }

    public long read_ulonglong() {
        try {
            if ((TCKind)this.next() != TCKind.tk_ulonglong) {
                throw this.reportTypeMismatch();
            }
            return (Long)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_ulonglong_array(long[] lArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(lArray, n, n2, TCKind.tk_ulonglong);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                lArray[n + n3] = this.read_ulonglong();
                ++n3;
            }
        }
    }

    public char read_char() {
        try {
            if ((TCKind)this.next() != TCKind.tk_char) {
                throw this.reportTypeMismatch();
            }
            return ((Character)this.next()).charValue();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_char_array(char[] cArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(cArray, n, n2, TCKind.tk_char);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                cArray[n + n3] = this.read_char();
                ++n3;
            }
        }
    }

    public char read_wchar() {
        try {
            if ((TCKind)this.next() != TCKind.tk_wchar) {
                throw this.reportTypeMismatch();
            }
            return ((Character)this.next()).charValue();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_wchar_array(char[] cArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(cArray, n, n2, TCKind.tk_wchar);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                cArray[n + n3] = this.read_wchar();
                ++n3;
            }
        }
    }

    public float read_float() {
        try {
            if ((TCKind)this.next() != TCKind.tk_float) {
                throw this.reportTypeMismatch();
            }
            return ((Float)this.next()).floatValue();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_float_array(float[] fArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(fArray, n, n2, TCKind.tk_float);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                fArray[n + n3] = this.read_float();
                ++n3;
            }
        }
    }

    public double read_double() {
        try {
            if ((TCKind)this.next() != TCKind.tk_double) {
                throw this.reportTypeMismatch();
            }
            return (Double)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public void read_double_array(double[] dArray, int n, int n2) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dArray, n, n2, TCKind.tk_double);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                dArray[n + n3] = this.read_double();
                ++n3;
            }
        }
    }

    public String read_string() {
        try {
            if ((TCKind)this.next() != TCKind.tk_string) {
                throw this.reportTypeMismatch();
            }
            return (String)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public String read_wstring() {
        try {
            if ((TCKind)this.next() != TCKind.tk_wstring) {
                throw this.reportTypeMismatch();
            }
            return (String)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public Object read_Object() {
        try {
            if ((TCKind)this.next() != TCKind.tk_objref) {
                throw this.reportTypeMismatch();
            }
            return (Object)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public Object read_Object(Class clazz) {
        ObjectImpl objectImpl;
        java.lang.Object object;
        try {
            if ((TCKind)this.next() != TCKind.tk_objref) {
                throw this.reportTypeMismatch();
            }
            object = this.next();
            if (object == null || clazz.isInstance(object)) {
                return (Object)object;
            }
            objectImpl = (ObjectImpl)object;
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
        try {
            object = (ObjectImpl)clazz.newInstance();
        }
        catch (Exception exception) {
            this.getLogger().error("Bad object type.", exception);
            throw ExceptionTool.initCause(new BAD_PARAM("Bad object type (" + exception + ")", 1146056711, CompletionStatus.COMPLETED_MAYBE), (Throwable)exception);
        }
        ((ObjectImpl)object)._set_delegate(objectImpl._get_delegate());
        return object;
    }

    public TypeCode read_TypeCode() {
        try {
            if ((TCKind)this.next() != TCKind.tk_TypeCode) {
                throw this.reportTypeMismatch();
            }
            return (TypeCode)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public Any read_any() {
        try {
            TCKind tCKind = (TCKind)this.next();
            if (tCKind == TCKind.tk_any) {
                return (Any)this.next();
            }
            if (tCKind == TCKind.tk_TypeCode) {
                Any any = this.m_orb.create_any();
                any.read_value(this, (TypeCode)this.next());
                return any;
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public Context read_Context() {
        java.lang.Object object;
        NVList nVList = this.m_orb.create_list(0);
        int n = this.read_ulong() / 2;
        int n2 = 0;
        while (n2 < n) {
            object = this.m_orb.create_any();
            String string = this.read_string();
            ((Any)object).insert_string(this.read_string());
            nVList.add_value(string, (Any)object, 0);
            ++n2;
        }
        object = new org.openorb.CORBA.dii.Context("", null, this.m_orb);
        ((Context)object).set_values(nVList);
        return object;
    }

    public Principal read_Principal() {
        try {
            if ((TCKind)this.next() != TCKind.tk_Principal) {
                throw this.reportTypeMismatch();
            }
            return (Principal)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public BigDecimal read_fixed() {
        try {
            if ((TCKind)this.next() != TCKind.tk_fixed) {
                throw this.reportTypeMismatch();
            }
            return (BigDecimal)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public BigDecimal read_fixed(TypeCode typeCode) {
        try {
            return this.read_fixed(typeCode.fixed_digits(), typeCode.fixed_scale());
        }
        catch (BadKind badKind) {
            this.getLogger().error("Type mismatch with fixed type.", badKind);
            throw ExceptionTool.initCause(new BAD_PARAM("Type mismatch with fixed type (" + badKind + ")", 1146056712, CompletionStatus.COMPLETED_MAYBE), (Throwable)badKind);
        }
    }

    public BigDecimal read_fixed(short s, short s2) {
        BigDecimal bigDecimal;
        try {
            if ((TCKind)this.next() != TCKind.tk_fixed) {
                throw this.reportTypeMismatch();
            }
            bigDecimal = (BigDecimal)this.next();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
        String string = bigDecimal.toString();
        int n = string.length();
        if (string.charAt(0) == '-') {
            --n;
        }
        if (string.indexOf(46) >= 0) {
            --n;
        }
        if (n > s) {
            throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
        }
        if (bigDecimal.scale() != s2) {
            throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
        }
        return bigDecimal;
    }

    public Serializable read_value() {
        try {
            TCKind tCKind = (TCKind)this.next();
            if (tCKind == TCKind.tk_value) {
                return (Serializable)this.next();
            }
            if (tCKind == TCKind.tk_value_box) {
                BoxedValueHelper boxedValueHelper = (BoxedValueHelper)this.next();
                return boxedValueHelper.read_value(this);
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    private SystemException reportBadObjectType() {
        return new BAD_PARAM("Bad object type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
    }

    public Serializable read_value(String string) {
        try {
            TCKind tCKind = (TCKind)this.next();
            if (tCKind == TCKind.tk_value) {
                Serializable serializable = (Serializable)this.next();
                if (serializable != null) {
                    Class<?> clazz = null;
                    try {
                        clazz = Thread.currentThread().getContextClassLoader().loadClass(RepoIDHelper.idToClass(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (clazz != null && !clazz.isInstance(serializable)) {
                        throw this.reportBadObjectType();
                    }
                }
                return serializable;
            }
            if (tCKind == TCKind.tk_value_box) {
                BoxedValueHelper boxedValueHelper = (BoxedValueHelper)this.next();
                if (!boxedValueHelper.get_id().equals(string)) {
                    throw this.reportBadObjectType();
                }
                return boxedValueHelper.read_value(this);
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public Serializable read_value(Class clazz) {
        Serializable serializable;
        block5: {
            try {
                TCKind tCKind = (TCKind)this.next();
                if (tCKind == TCKind.tk_value) {
                    serializable = (Serializable)this.next();
                    break block5;
                }
                if (tCKind == TCKind.tk_value_box) {
                    BoxedValueHelper boxedValueHelper = (BoxedValueHelper)this.next();
                    serializable = boxedValueHelper.read_value(this);
                    break block5;
                }
                throw this.reportTypeMismatch();
            }
            catch (ClassCastException classCastException) {
                throw this.reportBufferPositionOfFormatProblem(classCastException);
            }
        }
        if (clazz != null && serializable != null && !clazz.isInstance(serializable)) {
            throw this.reportBadObjectType();
        }
        return serializable;
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        try {
            if ((TCKind)this.next() != TCKind.tk_value_box) {
                throw this.reportTypeMismatch();
            }
            BoxedValueHelper boxedValueHelper2 = (BoxedValueHelper)this.next();
            if (!boxedValueHelper2.get_id().equals(boxedValueHelper.get_id())) {
                throw new BAD_PARAM("Bad factory type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
            }
            return boxedValueHelper.read_value(this);
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public Serializable read_value(Serializable serializable) {
        try {
            if ((TCKind)this.next() != TCKind.tk_value) {
                throw this.reportTypeMismatch();
            }
            if (serializable instanceof CustomValue) {
                CustomValue customValue = (CustomValue)this.next();
                CustomValue customValue2 = (CustomValue)serializable;
                if (!customValue._truncatable_ids()[0].equals(customValue2._truncatable_ids()[0])) {
                    throw new BAD_PARAM("Bad target type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
                }
                OutputStream outputStream = (OutputStream)this.m_orb.create_output_stream();
                customValue.marshal(new DataOutputStream(outputStream));
                customValue2.unmarshal(new DataInputStream(outputStream.create_input_stream()));
                return customValue2;
            }
            if (serializable instanceof StreamableValue) {
                StreamableValue streamableValue = (StreamableValue)this.next();
                StreamableValue streamableValue2 = (StreamableValue)serializable;
                String[] stringArray = streamableValue._truncatable_ids();
                String string = streamableValue2._truncatable_ids()[0];
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(string)) {
                        stringArray = null;
                        break;
                    }
                    ++n;
                }
                if (stringArray != null) {
                    throw new BAD_PARAM("Bad target type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
                }
                OutputStream outputStream = (OutputStream)this.m_orb.create_output_stream();
                streamableValue._write(outputStream);
                streamableValue2._read(outputStream.create_input_stream());
                return streamableValue2;
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public java.lang.Object read_abstract_interface() {
        try {
            if ((TCKind)this.next() != TCKind.tk_abstract_interface) {
                throw this.reportTypeMismatch();
            }
            TCKind tCKind = (TCKind)this.peek();
            if (tCKind == TCKind.tk_objref) {
                return this.read_Object();
            }
            if (tCKind == TCKind.tk_value) {
                return this.read_value();
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        try {
            if ((TCKind)this.next() != TCKind.tk_abstract_interface) {
                throw this.reportTypeMismatch();
            }
            TCKind tCKind = (TCKind)this.peek();
            if (tCKind == TCKind.tk_objref) {
                return this.read_Object(clazz);
            }
            if (tCKind == TCKind.tk_value) {
                return this.read_value(clazz);
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException classCastException) {
            throw this.reportBufferPositionOfFormatProblem(classCastException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(java.lang.Object object) {
        boolean bl;
        ListInputStream listInputStream;
        block25: {
            boolean bl2;
            block16: {
                boolean bl3;
                block24: {
                    boolean bl4;
                    block23: {
                        boolean bl5;
                        block22: {
                            boolean bl6;
                            block21: {
                                boolean bl7;
                                block20: {
                                    boolean bl8;
                                    block19: {
                                        boolean bl9;
                                        block18: {
                                            boolean bl10;
                                            block17: {
                                                if (object instanceof OutputStream) {
                                                    return this.equals(((OutputStream)object).create_input_stream());
                                                }
                                                if (!(object instanceof ListInputStream)) {
                                                    return false;
                                                }
                                                listInputStream = (ListInputStream)object;
                                                if (this.m_source.size() - this.m_iter_pos != listInputStream.m_source.size() - listInputStream.m_iter_pos) {
                                                    return false;
                                                }
                                                this.mark(0);
                                                listInputStream.mark(0);
                                                try {
                                                    block15: {
                                                        while (true) {
                                                            ListOutputStream listOutputStream;
                                                            ListOutputStream listOutputStream2;
                                                            java.lang.Object object2;
                                                            if (this.m_iter_pos >= this.m_source.size()) {
                                                                if (!listInputStream.m_iter.hasNext()) break block15;
                                                                bl2 = false;
                                                                break block16;
                                                            }
                                                            java.lang.Object object3 = this.next();
                                                            if (object3 == null != ((object2 = listInputStream.next()) == null)) {
                                                                boolean bl11 = false;
                                                                java.lang.Object var12_10 = null;
                                                                this.reset();
                                                                listInputStream.reset();
                                                                return bl11;
                                                            }
                                                            if (object3 == null || object3 == object2) continue;
                                                            if (object3 instanceof Object) {
                                                                if (!(object2 instanceof Object)) {
                                                                    bl10 = false;
                                                                    break block17;
                                                                }
                                                                if (((Object)object3)._is_equivalent((Object)object2)) continue;
                                                                bl9 = false;
                                                                break block18;
                                                            }
                                                            if (!object3.getClass().isInstance(object2)) {
                                                                bl8 = false;
                                                                break block19;
                                                            }
                                                            if (object3 instanceof BoxedValueHelper) continue;
                                                            if (object3 instanceof StreamableValue) {
                                                                if (!(object2 instanceof StreamableValue)) {
                                                                    bl7 = false;
                                                                    break block20;
                                                                }
                                                                listOutputStream2 = new ListOutputStream(this.m_orb);
                                                                listOutputStream = new ListOutputStream(this.m_orb);
                                                                ((StreamableValue)object3)._write(listOutputStream2);
                                                                ((StreamableValue)object2)._write(listOutputStream);
                                                                if (listOutputStream2.create_input_stream().equals(listOutputStream.create_input_stream())) continue;
                                                                bl6 = false;
                                                                break block21;
                                                            }
                                                            if (object3 instanceof CustomValue) {
                                                                if (!(object2 instanceof CustomValue)) {
                                                                    bl5 = false;
                                                                    break block22;
                                                                }
                                                                listOutputStream2 = new ListOutputStream(this.m_orb);
                                                                listOutputStream = new ListOutputStream(this.m_orb);
                                                                ((CustomValue)object3).marshal(new DataOutputStream(listOutputStream2));
                                                                ((CustomValue)object2).marshal(new DataOutputStream(listOutputStream));
                                                                if (listOutputStream2.create_input_stream().equals(listOutputStream.create_input_stream())) continue;
                                                                bl4 = false;
                                                                break block23;
                                                            }
                                                            if (!object3.equals(object2)) break;
                                                        }
                                                        bl3 = false;
                                                        break block24;
                                                    }
                                                    bl = true;
                                                    break block25;
                                                }
                                                catch (Throwable throwable) {
                                                    java.lang.Object var12_21 = null;
                                                    this.reset();
                                                    listInputStream.reset();
                                                    throw throwable;
                                                }
                                            }
                                            java.lang.Object var12_11 = null;
                                            this.reset();
                                            listInputStream.reset();
                                            return bl10;
                                        }
                                        java.lang.Object var12_12 = null;
                                        this.reset();
                                        listInputStream.reset();
                                        return bl9;
                                    }
                                    java.lang.Object var12_13 = null;
                                    this.reset();
                                    listInputStream.reset();
                                    return bl8;
                                }
                                java.lang.Object var12_14 = null;
                                this.reset();
                                listInputStream.reset();
                                return bl7;
                            }
                            java.lang.Object var12_15 = null;
                            this.reset();
                            listInputStream.reset();
                            return bl6;
                        }
                        java.lang.Object var12_16 = null;
                        this.reset();
                        listInputStream.reset();
                        return bl5;
                    }
                    java.lang.Object var12_17 = null;
                    this.reset();
                    listInputStream.reset();
                    return bl4;
                }
                java.lang.Object var12_18 = null;
                this.reset();
                listInputStream.reset();
                return bl3;
            }
            java.lang.Object var12_19 = null;
            this.reset();
            listInputStream.reset();
            return bl2;
        }
        java.lang.Object var12_20 = null;
        this.reset();
        listInputStream.reset();
        return bl;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }
}

