/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.CurrentImpl;
import org.openorb.PI.RequestCallback;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.adapter.TargetInfo;
import org.openorb.net.ServerChannel;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerRequest;
import org.openorb.util.Trace;

public abstract class AbstractServerRequest
extends LocalObject
implements ServerRequest {
    private org.omg.CORBA.ORB m_orb;
    private ServerManager m_server_manager;
    private ServerChannel m_channel;
    private java.lang.Object m_transport_association;
    private int m_request_id;
    private byte[] m_object_key;
    private String m_operation;
    private byte m_sync_scope;
    private ServiceContext[] m_request_service_contexts;
    private InputStream m_argument_stream;
    private CurrentImpl m_pi_current;
    private CurrentOperations m_rs_pi_curr_entry;
    private CurrentOperations m_ts_pi_curr_entry;
    private Map m_service_contexts = new HashMap();
    private org.openorb.PI.ServerManager m_interceptor_manager = null;
    private RequestCallback m_callback = null;
    private java.lang.Object m_sync_state = new java.lang.Object();
    private volatile int m_state = -1;
    private short m_reply_status = Short.MIN_VALUE;
    private ObjectAdapter m_adapter = null;
    private TargetInfo m_target;
    private OutputStream m_reply_stream;
    private Object m_forward_reference;
    private IOR m_forward_reference_ior;
    private SystemException m_sending_system_exception;
    private Any m_sending_system_exception_any = null;
    private String m_sending_system_exception_id;
    private Logger m_logger = null;
    private static final short REPLY_STATUS_UNSET = Short.MIN_VALUE;

    public AbstractServerRequest(ServerManager serverManager, ServerChannel serverChannel, java.lang.Object object, int n, InputStream inputStream, byte[] byArray, String string, byte by, ServiceContext[] serviceContextArray) {
        this.init_one(serverManager, serverChannel, object, n, inputStream);
        this.init(byArray, string, by, serviceContextArray);
    }

    public AbstractServerRequest(ServerManager serverManager, ServerChannel serverChannel, java.lang.Object object, int n, InputStream inputStream) {
        this.init_one(serverManager, serverChannel, object, n, inputStream);
    }

    private void init_one(ServerManager serverManager, ServerChannel serverChannel, java.lang.Object object, int n, InputStream inputStream) {
        this.m_server_manager = serverManager;
        this.m_channel = serverChannel;
        this.m_transport_association = object;
        this.m_request_id = n;
        this.m_argument_stream = inputStream;
        this.m_orb = this.m_server_manager.orb();
        this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        this.m_pi_current = ((ORB)this.m_orb).getPICurrent();
    }

    public void init(byte[] byArray, String string, byte by, ServiceContext[] serviceContextArray) {
        if (this.m_state >= 0) {
            Trace.signalIllegalCondition(this.getLogger(), "Invalid state.");
        }
        this.m_object_key = byArray;
        this.m_operation = string;
        this.m_sync_scope = by;
        this.m_request_service_contexts = serviceContextArray;
        if (this.m_operation != null) {
            this.m_interceptor_manager = (org.openorb.PI.ServerManager)((ORB)this.m_orb).getFeature("ServerInterceptorManager");
            if (this.m_interceptor_manager != null) {
                this.m_callback = new RequestCallback(){

                    public void reply_system_exception(SystemException systemException) {
                        AbstractServerRequest.this.handle_system_exception(systemException);
                    }

                    public void reply_runtime_exception(RuntimeException runtimeException) {
                        AbstractServerRequest.this.handle_runtime_exception(runtimeException);
                    }

                    public void reply_error(Error error) {
                        AbstractServerRequest.this.handle_error(error);
                    }

                    public void reply_location_forward(Object object, boolean bl) {
                        AbstractServerRequest.this.handle_location_forward(object, bl);
                    }
                };
            }
        }
        this.m_state = 0;
    }

    public AbstractServerRequest(ServerManager serverManager, ServerChannel serverChannel, java.lang.Object object, int n, byte[] byArray) {
        this.init_one(serverManager, serverChannel, object, n, null);
        this.init(byArray, null, (byte)3, null);
    }

    public AbstractServerRequest(ServerManager serverManager, ServerChannel serverChannel, java.lang.Object object, int n) {
        this.init_one(serverManager, serverChannel, object, n, null);
    }

    public void init(byte[] byArray) {
        this.init(byArray, null, (byte)3, null);
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public ServerChannel channel() {
        return this.m_channel;
    }

    public java.lang.Object get_transport_association() {
        return this.m_transport_association;
    }

    public boolean checkRequestTransportAssoc(java.lang.Object object) {
        return this.m_transport_association.equals(object);
    }

    public int state() {
        return this.m_state;
    }

    protected CompletionStatus state_completion_status() {
        switch (this.m_state) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                return CompletionStatus.COMPLETED_NO;
            }
            case 3: {
                return CompletionStatus.COMPLETED_MAYBE;
            }
            case 4: 
            case 5: {
                return CompletionStatus.COMPLETED_YES;
            }
        }
        Trace.signalIllegalCondition(this.getLogger(), "Wrong state of the state machine.");
        return null;
    }

    public boolean is_locate() {
        return this.m_operation == null;
    }

    public byte[] object_key() {
        return this.m_object_key;
    }

    public int request_id() {
        return this.m_request_id;
    }

    public boolean equals(java.lang.Object object) {
        if (object instanceof Integer) {
            return this.m_request_id == (Integer)object;
        }
        if (object instanceof ServerRequest) {
            ServerRequest serverRequest = (ServerRequest)object;
            return this.m_request_id == serverRequest.request_id() && this.m_channel == serverRequest.channel();
        }
        return false;
    }

    public String operation() {
        return this.m_operation;
    }

    public boolean response_expected() {
        return this.m_sync_scope == 3;
    }

    public short sync_scope() {
        return this.m_sync_scope;
    }

    public Parameter[] arguments() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public TypeCode[] exceptions() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public String[] contexts() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public String[] operation_context() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public Any result() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public Any get_slot(int n) throws InvalidSlot {
        java.lang.Object object;
        if (this.m_rs_pi_curr_entry == null) {
            object = this.m_sync_state;
            synchronized (object) {
                if (this.m_rs_pi_curr_entry == null) {
                    this.m_rs_pi_curr_entry = this.m_pi_current.create();
                }
            }
        }
        object = this.m_rs_pi_curr_entry;
        synchronized (object) {
            Any any = this.m_rs_pi_curr_entry.get_slot(n);
            return any;
        }
    }

    public void set_slot(int n, Any any) throws InvalidSlot {
        java.lang.Object object;
        if (this.m_rs_pi_curr_entry == null) {
            object = this.m_sync_state;
            synchronized (object) {
                if (this.m_rs_pi_curr_entry == null) {
                    this.m_rs_pi_curr_entry = this.m_pi_current.create();
                }
            }
        }
        object = this.m_rs_pi_curr_entry;
        synchronized (object) {
            this.m_rs_pi_curr_entry.set_slot(n, any);
        }
    }

    public ServiceContext get_request_service_context(int n) {
        int n2 = 0;
        while (n2 < this.m_request_service_contexts.length) {
            if (this.m_request_service_contexts[n2].context_id == n) {
                return this.m_request_service_contexts[n2];
            }
            ++n2;
        }
        throw new BAD_PARAM(1330446359, this.state_completion_status());
    }

    public void client_cancel() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 5) {
                return;
            }
            if (this.m_sync_scope != 3) {
                switch (this.m_state) {
                    case 3: 
                    case 4: {
                        return;
                    }
                }
            }
            this.handle_system_exception(new TRANSIENT(1330446338, this.state_completion_status()));
            if (this.m_state != 0 && this.m_interceptor_manager != null) {
                this.m_interceptor_manager.send_exception(this, this.m_callback);
                this.m_interceptor_manager = null;
            }
            this.m_state = 5;
            if (this.m_target != null) {
                this.m_adapter.cancel_dispatch(this, this.m_target);
            }
            this.release_request();
        }
    }

    public void server_cancel(Throwable throwable) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 5) {
                return;
            }
            if (throwable instanceof SystemException) {
                SystemException systemException = (SystemException)throwable;
                systemException.completed = this.state_completion_status();
                this.handle_system_exception(systemException);
            } else if (throwable instanceof RuntimeException) {
                this.handle_runtime_exception((RuntimeException)throwable);
            } else if (throwable instanceof Error) {
                this.handle_error((Error)throwable);
            } else {
                this.handle_unknown_throwable(throwable);
            }
            if (this.m_target != null) {
                this.m_adapter.cancel_dispatch(this, this.m_target);
            }
            this.complete_request();
        }
    }

    public int begin_request() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 0) {
                if (this.m_interceptor_manager != null) {
                    this.m_interceptor_manager.receive_request_service_contexts(this, this.m_callback);
                    if (this.m_reply_status != Short.MIN_VALUE) {
                        this.m_interceptor_manager = null;
                        this.complete_request();
                        int n = this.m_state;
                        return n;
                    }
                }
                this.m_state = 1;
                this.m_ts_pi_curr_entry = this.m_pi_current.copy(this.m_rs_pi_curr_entry);
            }
            this.m_pi_current.set(this.m_ts_pi_curr_entry);
        }
        return this.m_state;
    }

    public int adapter(ObjectAdapter objectAdapter) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.m_state) {
                case 1: {
                    this.m_adapter = objectAdapter;
                    this.m_state = 2;
                }
                case 5: {
                    int n = this.m_state;
                    return n;
                }
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    public ObjectAdapter adapter() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_adapter == null) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            ObjectAdapter objectAdapter = this.m_adapter;
            return objectAdapter;
        }
    }

    public Policy get_server_policy(int n) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_adapter == null) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            int[] nArray = new int[]{n};
            Policy[] policyArray = this.m_adapter.get_server_policies(nArray);
            if (policyArray.length >= 1) {
                Policy policy = policyArray[0];
                return policy;
            }
            throw new INV_POLICY(1330446337, this.state_completion_status());
        }
    }

    public byte[] adapter_id() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_target == null) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            byte[] byArray = this.m_target.getAdapterID();
            return byArray;
        }
    }

    public byte[] object_id() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_target == null) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            byte[] byArray = this.m_target.getObjectID();
            return byArray;
        }
    }

    public String target_most_derived_interface() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_target == null) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            String string = this.m_target.getRepositoryID();
            return string;
        }
    }

    public boolean target_is_a(String string) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_target == null) {
                throw new BAD_INV_ORDER(1330446350, this.state_completion_status());
            }
            boolean bl = this.m_target.targetIsA(string);
            return bl;
        }
    }

    public void dispatch() throws AdapterDestroyedException {
        int n;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.m_state) {
                case 5: {
                    return;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
                }
            }
            try {
                this.m_target = this.m_adapter.predispatch(this);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                this.m_state = 1;
                throw adapterDestroyedException;
            }
            catch (ForwardRequest forwardRequest) {
                this.handle_location_forward(forwardRequest.forward, false);
            }
            catch (SystemException systemException) {
                systemException.completed = CompletionStatus.COMPLETED_NO;
                this.handle_system_exception(systemException);
            }
            catch (Error error) {
                this.handle_error(error);
            }
            catch (RuntimeException runtimeException) {
                this.handle_runtime_exception(runtimeException);
            }
            if (this.m_reply_status != Short.MIN_VALUE) {
                this.complete_request();
                return;
            }
            if (this.m_interceptor_manager != null) {
                this.m_interceptor_manager.receive_request(this, this.m_callback);
                if (this.m_reply_status != Short.MIN_VALUE) {
                    this.m_interceptor_manager = null;
                    this.m_adapter.cancel_dispatch(this, this.m_target);
                    this.complete_request();
                    return;
                }
            }
            this.m_rs_pi_curr_entry = this.m_ts_pi_curr_entry;
            switch (this.m_sync_scope) {
                case 0: {
                    this.release_request();
                    break;
                }
                case 1: 
                case 2: {
                    try {
                        this.m_reply_stream = this.begin_marshal_reply();
                        this.complete_reply(this.m_reply_stream);
                    }
                    catch (SystemException systemException) {
                        systemException.completed = CompletionStatus.COMPLETED_NO;
                        this.handle_system_exception(systemException);
                    }
                    catch (Error error) {
                        this.handle_error(error);
                    }
                    catch (RuntimeException runtimeException) {
                        this.handle_runtime_exception(runtimeException);
                    }
                    this.release_request();
                    if (this.m_reply_status == Short.MIN_VALUE) break;
                    this.m_state = 5;
                    this.m_adapter.cancel_dispatch(this, this.m_target);
                    if (this.m_interceptor_manager != null) {
                        this.m_interceptor_manager.send_exception(this, this.m_callback);
                    }
                    return;
                }
            }
            this.m_state = 3;
        }
        Throwable throwable = null;
        try {
            this.m_adapter.dispatch(this, this.m_target);
            n = 0;
        }
        catch (SystemException systemException) {
            throwable = systemException;
            n = 1;
        }
        catch (Error error) {
            throwable = error;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
            n = 3;
        }
        java.lang.Object object2 = this.m_sync_state;
        synchronized (object2) {
            if (this.m_state == 5) {
                return;
            }
            switch (n) {
                case 0: {
                    if (this.m_state != 3) break;
                    if (this.is_locate()) {
                        this.m_reply_status = (short)-1;
                        break;
                    }
                    if (this.m_sync_scope == 3) {
                        try {
                            this.createReply();
                        }
                        catch (SystemException systemException) {
                            systemException.completed = CompletionStatus.COMPLETED_YES;
                            this.handle_system_exception(systemException);
                        }
                        catch (Error error) {
                            this.handle_error(error);
                        }
                        catch (RuntimeException runtimeException) {
                            this.handle_runtime_exception(runtimeException);
                        }
                        break;
                    }
                    this.m_reply_status = 0;
                    break;
                }
                case 1: {
                    if (this.m_state == 4) {
                        throwable.completed = CompletionStatus.COMPLETED_YES;
                    }
                    this.handle_system_exception((SystemException)throwable);
                    break;
                }
                case 2: {
                    this.handle_error((Error)throwable);
                    break;
                }
                case 3: {
                    this.handle_runtime_exception((RuntimeException)throwable);
                }
            }
            this.complete_request();
        }
    }

    public InputStream argument_stream() {
        return this.m_argument_stream;
    }

    public void add_reply_service_context(ServiceContext serviceContext, boolean bl) {
        Integer n = new Integer(serviceContext.context_id);
        Map map = this.m_service_contexts;
        synchronized (map) {
            if (!bl && this.m_service_contexts.containsKey(n)) {
                throw new BAD_INV_ORDER(1330446347, this.state_completion_status());
            }
            this.m_service_contexts.put(n, serviceContext);
        }
    }

    public ServiceContext get_reply_service_context(int n) {
        ServiceContext serviceContext = null;
        Map map = this.m_service_contexts;
        synchronized (map) {
            serviceContext = (ServiceContext)this.m_service_contexts.get(new Integer(n));
        }
        if (serviceContext == null) {
            throw new BAD_PARAM(1330446359, this.state_completion_status());
        }
        return serviceContext;
    }

    public ServiceContext[] get_reply_service_contexts() {
        Map map = this.m_service_contexts;
        synchronized (map) {
            ServiceContext[] serviceContextArray = this.m_service_contexts.values().toArray(new ServiceContext[this.m_service_contexts.size()]);
            return serviceContextArray;
        }
    }

    public short reply_status() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_reply_status == Short.MIN_VALUE) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            short s = this.m_reply_status;
            return s;
        }
    }

    public Object forward_reference() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.reply_status()) {
                case 3: {
                    Object object2 = this.m_forward_reference;
                    return object2;
                }
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    public IOR forward_reference_ior() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.reply_status()) {
                case 3: {
                    if (this.m_forward_reference_ior == null) {
                        this.m_forward_reference_ior = ((Delegate)((ObjectImpl)this.m_forward_reference)._get_delegate()).ior();
                    }
                    IOR iOR = this.m_forward_reference_ior;
                    return iOR;
                }
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    public Any sending_exception() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.reply_status()) {
                case 1: {
                    if (this.m_sending_system_exception_any == null) {
                        this.m_sending_system_exception_any = this.m_orb.create_any();
                        SystemExceptionHelper.insert(this.m_sending_system_exception_any, this.m_sending_system_exception);
                    }
                    Any any = this.m_sending_system_exception_any;
                    return any;
                }
                case 2: {
                    throw new NO_RESOURCES(1330446337, this.state_completion_status());
                }
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    public SystemException sending_system_exception() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.reply_status() == 1) {
                SystemException systemException = this.m_sending_system_exception;
                return systemException;
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    public String sending_system_exception_id() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.reply_status() == 1) {
                String string = this.m_sending_system_exception_id;
                return string;
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    private void handle_system_exception(SystemException systemException) {
        this.m_sending_system_exception_any = null;
        this.m_sending_system_exception = systemException;
        this.m_sending_system_exception_id = SystemExceptionHelper.id(systemException);
        this.m_reply_status = 1;
    }

    private void handle_error(Error error) {
        if (error instanceof ThreadDeath) {
            throw error;
        }
        if (error instanceof OutOfMemoryError) {
            this.handle_system_exception(new NO_MEMORY(0, this.state_completion_status()));
        } else if (error instanceof StackOverflowError) {
            this.handle_system_exception(new NO_RESOURCES(0, this.state_completion_status()));
        } else {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Intercepted in AbstractServerRequest", error);
            }
            UnknownException unknownException = new UnknownException(error);
            unknownException.completed = this.state_completion_status();
            this.handle_system_exception(unknownException);
        }
    }

    private void handle_runtime_exception(RuntimeException runtimeException) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("Handle runtime exception", runtimeException);
        }
        UnknownException unknownException = new UnknownException(runtimeException);
        unknownException.completed = this.state_completion_status();
        this.handle_system_exception(unknownException);
    }

    private void handle_unknown_throwable(Throwable throwable) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("Handle runtime exception", throwable);
        }
        UnknownException unknownException = new UnknownException(throwable);
        unknownException.completed = this.state_completion_status();
        this.handle_system_exception(unknownException);
    }

    private void handle_location_forward(Object object, boolean bl) {
        this.m_forward_reference = object;
        this.m_forward_reference_ior = null;
        this.m_reply_status = (short)3;
    }

    public OutputStream createReply() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.is_locate()) {
                throw new BAD_INV_ORDER(1146056709, this.state_completion_status());
            }
            if (this.m_reply_status == 1) {
                throw this.m_sending_system_exception;
            }
            if (this.m_sync_scope != 3) {
                OutputStream outputStream = this.m_orb.create_output_stream();
                return outputStream;
            }
            this.m_reply_status = 0;
            if (this.m_interceptor_manager != null) {
                this.m_interceptor_manager.send_reply(this, this.m_callback);
                this.m_interceptor_manager = null;
                if (this.m_reply_status == 1) {
                    throw this.m_sending_system_exception;
                }
            }
            this.m_state = 4;
            OutputStream outputStream = this.m_reply_stream = this.begin_marshal_reply();
            return outputStream;
        }
    }

    public OutputStream createExceptionReply() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.is_locate()) {
                throw new BAD_INV_ORDER(1146056709, this.state_completion_status());
            }
            if (this.m_state == 5 || this.m_sync_scope != 3) {
                if (this.m_reply_status == 1) {
                    throw this.m_sending_system_exception;
                }
                OutputStream outputStream = this.m_orb.create_output_stream();
                return outputStream;
            }
            this.m_reply_status = (short)2;
            if (this.m_interceptor_manager != null) {
                this.m_interceptor_manager.send_exception(this, this.m_callback);
                this.m_interceptor_manager = null;
                if (this.m_reply_status == 1) {
                    throw this.m_sending_system_exception;
                }
            }
            this.m_state = 4;
            OutputStream outputStream = this.m_reply_stream = this.begin_marshal_user_exception();
            return outputStream;
        }
    }

    private void complete_request() {
        block24: {
            if (this.m_reply_status == Short.MIN_VALUE) {
                Trace.signalIllegalCondition(this.getLogger(), "Completing request without setting reply status.");
            }
            if (this.m_state != 0 && this.m_interceptor_manager != null) {
                switch (this.m_reply_status) {
                    case 0: {
                        this.m_interceptor_manager.send_reply(this, this.m_callback);
                        break;
                    }
                    case 1: {
                        this.m_interceptor_manager.send_exception(this, this.m_callback);
                        break;
                    }
                    case 3: {
                        this.m_interceptor_manager.send_other(this, this.m_callback);
                    }
                }
            }
            switch (this.m_sync_scope) {
                case 1: 
                case 2: {
                    if (this.m_state < 3) break;
                }
                case 0: {
                    this.m_state = 5;
                    return;
                }
            }
            try {
                switch (this.m_reply_status) {
                    case -1: {
                        this.marshal_locate_reply(true);
                        break;
                    }
                    case -2: {
                        this.marshal_locate_reply(false);
                        break;
                    }
                    case 0: 
                    case 2: {
                        this.complete_reply(this.m_reply_stream);
                        break;
                    }
                    case 1: {
                        this.marshal_system_exception(this.m_sending_system_exception_id, this.m_sending_system_exception);
                        break;
                    }
                    case 3: {
                        this.marshal_forward_request(this.m_forward_reference, false);
                    }
                }
            }
            catch (SystemException systemException) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Transport failure while replying to request: ", systemException);
                }
            }
            catch (Error error) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Java error while replying to request", error);
                }
            }
            catch (RuntimeException runtimeException) {
                if (!this.getLogger().isErrorEnabled()) break block24;
                this.getLogger().error("Java runtime exception while replying to request", runtimeException);
            }
        }
        this.m_state = 5;
        this.release_request();
    }

    protected abstract void marshal_system_exception(String var1, SystemException var2);

    protected abstract void marshal_forward_request(Object var1, boolean var2);

    protected abstract void marshal_locate_reply(boolean var1);

    protected abstract OutputStream begin_marshal_reply();

    protected abstract OutputStream begin_marshal_user_exception();

    protected abstract void complete_reply(OutputStream var1);

    protected abstract void release_request();

    protected Logger getLogger() {
        return this.m_logger;
    }
}

