/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.IOP.IOR;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORB;
import org.openorb.net.Address;
import org.openorb.net.ClientBinding;
import org.openorb.net.ClientChannel;
import org.openorb.net.ClientManager;
import org.openorb.net.ClientProtocol;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerManager;
import org.openorb.policy.ProfilePriorityPolicy;
import org.openorb.policy.ProfilePriorityPolicyHelper;

public class ClientManagerImpl
implements ClientManager {
    private static final int DEFAULT_PAUSE_TIME = 120000;
    private static ThreadGroup s_static_work_threads;
    private org.omg.CORBA.ORB m_orb;
    private Map m_protocols = new HashMap();
    private Map m_channels = new HashMap();
    private ServerManager m_server_manager;
    private java.lang.Object m_sync_state = new java.lang.Object();
    private boolean m_shutdown = false;
    private int m_pause;
    private ThreadGroup m_root_group;
    private boolean m_use_static_thread_group = false;
    private ThreadGroup m_work_threads;
    private Thread m_channel_reaper;

    public ClientManagerImpl(org.omg.CORBA.ORB oRB) {
        this(oRB, null);
    }

    public ClientManagerImpl(org.omg.CORBA.ORB oRB, ServerManager serverManager) {
        this.m_orb = oRB;
        this.m_server_manager = serverManager;
        this.m_root_group = Thread.currentThread().getThreadGroup();
        this.m_pause = ((ORB)oRB).getLoader().getIntProperty("openorb.client.reapPauseDelay", 120000);
        this.m_use_static_thread_group = ((ORB)oRB).getLoader().getBooleanProperty("openorb.useStaticThreadGroup", false);
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public ServerManager getServerManager() {
        return this.m_server_manager;
    }

    public ClientBinding[] create_bindings(Object object, IOR iOR) {
        int n = iOR.profiles.length;
        IORAddressingInfo iORAddressingInfo = new IORAddressingInfo(0, iOR);
        Delegate delegate = (Delegate)((ObjectImpl)object)._get_delegate();
        ProfilePriorityPolicy profilePriorityPolicy = ProfilePriorityPolicyHelper.narrow(delegate.get_client_policy(object, 1146057217));
        ArrayList<ClientBinding> arrayList = new ArrayList<ClientBinding>(8);
        int n2 = 0;
        while (n2 < n) {
            ClientProtocol clientProtocol;
            int n3;
            int n4 = iOR.profiles[n2].tag;
            int n5 = n3 = profilePriorityPolicy == null ? 8 : (int)profilePriorityPolicy.find_priority(n4);
            if (n3 != -1 && (clientProtocol = (ClientProtocol)this.m_protocols.get(new Integer(n4))) != null) {
                iORAddressingInfo.selected_profile_index = n2;
                Address[] addressArray = clientProtocol.createAddresses(iORAddressingInfo);
                int n6 = 0;
                while (n6 < addressArray.length) {
                    ClientBinding clientBinding = clientProtocol.createBinding(addressArray[n6]);
                    clientBinding.setPriority(clientBinding.getPriority() & 0xFFFF0FFF | n3 << 12 & 0xF000);
                    arrayList.add(clientBinding);
                    ++n6;
                }
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            throw new INV_OBJREF();
        }
        ClientBinding[] clientBindingArray = new ClientBinding[arrayList.size()];
        clientBindingArray = arrayList.toArray(clientBindingArray);
        return clientBindingArray;
    }

    public void register_protocol(int n, ClientProtocol clientProtocol) {
        this.m_protocols.put(new Integer(n), clientProtocol);
    }

    public boolean register_channel(ClientChannel clientChannel) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_shutdown) {
                boolean bl = false;
                return bl;
            }
            Map map = this.m_channels;
            synchronized (map) {
                if (this.m_channels.containsKey(clientChannel)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.m_work_threads == null || this.m_work_threads.isDestroyed()) {
                    if (this.m_use_static_thread_group) {
                        if (s_static_work_threads == null || s_static_work_threads.isDestroyed()) {
                            s_static_work_threads = new ThreadGroup(this.m_root_group, "Client IO");
                        }
                        this.m_work_threads = s_static_work_threads;
                    } else {
                        this.m_work_threads = new ThreadGroup(this.m_root_group, "Client IO");
                    }
                }
                if (this.m_channel_reaper == null && this.m_pause > 0) {
                    this.m_channel_reaper = new Thread(this.m_work_threads, new Runnable(){

                        public void run() {
                            ClientManagerImpl.this.channel_reaper();
                        }
                    }, "Channel Reaper");
                    this.m_channel_reaper.setDaemon(true);
                    this.m_channel_reaper.start();
                }
                Thread thread = new Thread(this.m_work_threads, new ChannelRecvRunnable(clientChannel), "Receive Worker for " + clientChannel.toString());
                thread.setDaemon(true);
                thread.start();
                this.m_channels.put(clientChannel, thread);
                boolean bl = true;
                return bl;
            }
        }
    }

    public void unregister_channel(ClientChannel clientChannel) {
        Thread thread;
        Map map = this.m_channels;
        synchronized (map) {
            thread = (Thread)this.m_channels.remove(clientChannel);
        }
        if (thread != null) {
            Thread thread2 = Thread.currentThread();
            thread.interrupt();
            while (thread != thread2 && thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdown(boolean bl, boolean bl2) {
        boolean bl3 = false;
        Thread thread = null;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (!this.m_shutdown) {
                this.m_shutdown = true;
                bl3 = true;
                if (this.m_channel_reaper != null) {
                    this.m_channel_reaper.interrupt();
                    thread = this.m_channel_reaper;
                }
            }
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (bl3) {
            ClientChannel[] clientChannelArray;
            Map map = this.m_channels;
            synchronized (map) {
                clientChannelArray = new ClientChannel[this.m_channels.size()];
                this.m_channels.keySet().toArray(clientChannelArray);
            }
            int n = 0;
            while (n < clientChannelArray.length) {
                clientChannelArray[n].close(bl2, new BAD_INV_ORDER(1330446340, CompletionStatus.COMPLETED_MAYBE));
                ++n;
            }
        }
        if (!this.m_use_static_thread_group && this.m_work_threads != null) {
            this.m_work_threads.setDaemon(true);
            try {
                this.m_work_threads.destroy();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    private void channel_reaper() {
        int n = RequestIDAllocator.get_request_id();
        ClientChannel[] clientChannelArray = null;
        while (!this.m_shutdown) {
            try {
                Thread.sleep(this.m_pause);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            Map map = this.m_channels;
            synchronized (map) {
                if (this.m_channels.isEmpty()) {
                    this.m_channel_reaper = null;
                    break;
                }
                if (clientChannelArray == null || clientChannelArray.length < this.m_channels.size()) {
                    clientChannelArray = new ClientChannel[this.m_channels.size()];
                }
                clientChannelArray = this.m_channels.keySet().toArray(clientChannelArray);
            }
            int n2 = 0;
            while (n2 < clientChannelArray.length && clientChannelArray[n2] != null) {
                if (clientChannelArray[n2].state() == 0x11000000 && clientChannelArray[n2].channel_age() < n) {
                    clientChannelArray[n2].pause();
                }
                clientChannelArray[n2] = null;
                ++n2;
            }
            n = RequestIDAllocator.get_request_id();
        }
    }

    private class ChannelRecvRunnable
    implements Runnable {
        private ClientChannel m_chan;

        public ChannelRecvRunnable(ClientChannel clientChannel) {
            this.m_chan = clientChannel;
        }

        public void run() {
            this.m_chan.run_recv();
        }
    }
}

