/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContext;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ObjectStub;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.ClientManager;
import org.openorb.PI.RequestCallback;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.io.LocalOutputStream;
import org.openorb.net.AbstractClientRequest;
import org.openorb.net.Address;
import org.openorb.net.LocalServerRequest;
import org.openorb.net.ServerManager;
import org.openorb.util.Trace;

public class LocalClientRequest
extends AbstractClientRequest {
    private int m_request_id = 0;
    private Object m_target = null;
    private byte m_sync_scope = (byte)-1;
    private LocalServerRequest m_server_request = null;
    private InputStream m_reply_stream = null;
    private Address[] m_adresses;
    private ServerManager m_serverManager = null;
    private int m_reply_status;
    private ServiceContext[] m_reply_service_contexts;
    private boolean m_response_expected;
    private String m_operation;
    private ClientManager m_client_manager = null;
    private RequestCallback m_callback = null;
    private java.lang.Object m_sync_state = new java.lang.Object();
    private int m_state = 0;
    private OutputStream m_request_stream;
    private InputStream m_response_stream;
    private boolean m_response_arrived = false;
    private boolean m_last_response_arrived = false;
    private Object m_forward_reference = null;
    private IOR m_forward_reference_ior;
    private SystemException m_received_exception;
    private Any m_received_exception_any = null;
    private String m_received_exception_id;
    private static final short REPLY_STATUS_UNSET = Short.MIN_VALUE;

    public LocalClientRequest(org.omg.CORBA.ORB oRB, int n, Object object, String string, boolean bl, Address[] addressArray) {
        super(n, object, addressArray[0], object, null);
        this.m_request_id = n;
        this.m_adresses = addressArray;
        this.m_operation = string;
        this.m_target = object;
        this.m_response_expected = bl;
        this.m_serverManager = (ServerManager)((ORB)oRB).getFeature("ServerCPCManager");
        this.m_request_stream = new LocalOutputStream();
        this.m_sync_scope = (byte)(this.m_response_expected ? 3 : 2);
        this.m_client_manager = (ClientManager)((ORB)this.orb()).getFeature("ClientInterceptorManager");
        if (this.m_client_manager != null) {
            this.m_callback = new LocalRequestCallback();
        }
    }

    public int state() {
        return this.m_state;
    }

    public boolean is_request() {
        return this.m_operation != null;
    }

    public boolean is_locate() {
        return this.m_operation == null;
    }

    public boolean is_poll() {
        return false;
    }

    public short sync_scope() {
        return this.m_sync_scope;
    }

    public boolean response_expected() {
        return this.m_response_expected;
    }

    public String operation() {
        return this.m_operation == null ? "" : this.m_operation;
    }

    public boolean cancel(SystemException systemException) {
        if (this.m_state == 4) {
            return false;
        }
        systemException.completed = CompletionStatus.COMPLETED_YES;
        this.handle_system_exception(systemException);
        return true;
    }

    public OutputStream begin_marshal() {
        return this.m_request_stream;
    }

    public int send_request() {
        InputStream inputStream = this.m_request_stream.create_input_stream();
        byte[] byArray = this.m_adresses[0].getTargetAddress((short)0).object_key();
        ServiceContext[] serviceContextArray = this.get_request_service_contexts();
        this.m_server_request = new LocalServerRequest(this.m_serverManager, this.m_target, this.m_request_id, inputStream, byArray, this.m_operation, this.m_sync_scope, serviceContextArray);
        this.m_server_request.begin_request();
        this.m_server_request.adapter(this.m_serverManager.find_adapter(byArray));
        try {
            this.m_server_request.dispatch();
        }
        catch (SystemException systemException) {
            this.m_state = 4;
            systemException.completed = CompletionStatus.COMPLETED_NO;
            this.handle_system_exception(systemException);
            if (this.m_client_manager != null) {
                this.m_client_manager.receive_exception(this, this.m_callback);
                this.m_client_manager = null;
            }
            return this.m_state;
        }
        catch (AdapterDestroyedException adapterDestroyedException) {
            Trace.signalIllegalCondition(this.getLogger(), "AdapterDestroyed on local object.");
        }
        this.m_reply_stream = this.m_server_request.getReplyStream().create_input_stream();
        if (this.m_server_request.is_reply_exception()) {
            this.m_received_exception_id = this.m_reply_stream.read_string();
            try {
                this.m_reply_stream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_state = 2;
        return this.m_state;
    }

    public boolean poll_response() {
        switch (this.m_state) {
            case 2: {
                return this.m_response_arrived;
            }
            case 0: 
            case 1: {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            case 3: 
            case 4: {
                return true;
            }
        }
        Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
        return false;
    }

    public InputStream receive_response() {
        return this.m_server_request.getReplyStream().create_input_stream();
    }

    private void handle_system_exception(SystemException systemException) {
        this.m_received_exception_any = null;
        this.m_received_exception = systemException;
        this.m_received_exception_id = SystemExceptionHelper.id(systemException);
        this.m_reply_status = 1;
    }

    private void handle_location_forward(Object object, boolean bl) {
        this.m_forward_reference = object;
        this.m_forward_reference_ior = null;
        this.m_reply_status = 3;
    }

    /*
     * Unable to fully structure code
     */
    public int wait_for_response(long var1_1) {
        var3_2 = this.m_sync_state;
        synchronized (var3_2) {
            switch (this.m_state) {
                case 2: {
                    break;
                }
                case 4: {
                    var4_3 = this.m_state;
                    return var4_3;
                }
                default: {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                }
            }
            this.m_response_arrived = false;
            switch (this.m_reply_status) {
                case 0: {
                    if (this.m_last_response_arrived) break;
                    var5_4 = this.m_state = 3;
                    return var5_4;
                }
                case 2: {
                    this.m_response_stream.mark(0);
                    this.m_received_exception_id = this.m_response_stream.read_string();
                    try {
                        this.m_response_stream.reset();
                    }
                    catch (IOException var5_5) {
                        if (!this.getLogger().isErrorEnabled()) ** GOTO lbl28
                        this.getLogger().error("Error while resetting RequestStream.", var5_5);
                    }
lbl28:
                    // 3 sources

                    if (this.m_last_response_arrived) break;
                    var5_6 = this.m_state = 3;
                    return var5_6;
                }
                case 1: {
                    this.m_received_exception_id = this.m_response_stream.read_string();
                    this.m_received_exception = SystemExceptionHelper.create(this.m_received_exception_id, "Server Exception", this.m_response_stream.read_ulong(), CompletionStatus.from_int(this.m_response_stream.read_ulong()));
                    this.m_received_exception_any = null;
                    break;
                }
                case 3: {
                    this.m_forward_reference_ior = IORHelper.read(this.m_response_stream);
                    this.m_forward_reference = null;
                }
                case -2: 
                case -1: 
                case 4: {
                    break;
                }
                default: {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                }
            }
            if (!this.m_last_response_arrived) {
                Trace.signalIllegalCondition(this.getLogger(), "Last response arrived.");
            }
            this.m_state = 3;
            this.lastReplyMessage();
            var5_7 = this.m_state;
            return var5_7;
        }
    }

    private void lastReplyMessage() {
        SystemException systemException = this.m_received_exception;
        boolean bl = false;
        this.m_last_response_arrived = true;
        if (this.m_state == 2) {
            if (systemException == null) {
                return;
            }
            bl = true;
        }
        this.m_state = 4;
        if (systemException != null) {
            this.handle_system_exception(systemException);
        }
        if (this.m_client_manager != null) {
            switch (this.m_reply_status) {
                case 0: {
                    this.m_client_manager.receive_reply(this, this.m_callback);
                    break;
                }
                case 1: 
                case 2: {
                    this.m_client_manager.receive_exception(this, this.m_callback);
                    break;
                }
                case 3: 
                case 4: {
                    this.m_client_manager.receive_other(this, this.m_callback);
                    break;
                }
                case -2: 
                case -1: {
                    break;
                }
                default: {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                }
            }
        }
        this.m_response_arrived = true;
    }

    public short reply_status() {
        if (this.m_server_request.is_reply_exception()) {
            return 2;
        }
        return 0;
    }

    public ServiceContext get_reply_service_context(int n) {
        if (this.m_reply_service_contexts == null) {
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
        switch (this.m_state) {
            case 3: 
            case 4: {
                int n2 = 0;
                while (n2 < this.m_reply_service_contexts.length) {
                    if (this.m_reply_service_contexts[n2].context_id == n) {
                        return this.m_reply_service_contexts[n2];
                    }
                    ++n2;
                }
                throw new BAD_PARAM(1330446359, this.state_completion_status());
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public Object forward_reference() {
        switch (this.reply_status()) {
            case 3: {
                if (this.m_forward_reference == null) {
                    this.m_forward_reference = new ObjectStub(this.orb(), this.m_forward_reference_ior);
                }
                return this.m_forward_reference;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public IOR forward_reference_ior() {
        switch (this.reply_status()) {
            case 3: {
                if (this.m_forward_reference_ior == null) {
                    if (this.m_forward_reference == null || !(this.m_forward_reference instanceof ObjectImpl)) {
                        throw new INTERNAL("Forward object is unknown type");
                    }
                    Delegate delegate = ((ObjectImpl)this.m_forward_reference)._get_delegate();
                    if (delegate == null || !(delegate instanceof org.openorb.CORBA.Delegate)) {
                        throw new INTERNAL("Object delegate is unknown type");
                    }
                    this.m_forward_reference_ior = ((org.openorb.CORBA.Delegate)delegate).ior();
                }
                return this.m_forward_reference_ior;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public SystemException received_system_exception() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.reply_status() == 1) {
                SystemException systemException = this.m_received_exception;
                return systemException;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public Any received_exception() {
        switch (this.reply_status()) {
            case 1: {
                if (this.m_received_exception_any == null) {
                    this.m_received_exception_any = this.orb().create_any();
                    SystemExceptionHelper.insert(this.m_received_exception_any, this.m_received_exception);
                }
                return this.m_received_exception_any;
            }
            case 2: {
                throw new NO_RESOURCES(1330446337, this.state_completion_status());
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public String received_exception_id() {
        switch (this.reply_status()) {
            case 1: 
            case 2: {
                return this.m_received_exception_id;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    protected void finalize() throws Throwable {
        this.cancel(new TIMEOUT());
    }

    private class LocalRequestCallback
    implements RequestCallback {
        private LocalRequestCallback() {
        }

        public void reply_system_exception(SystemException systemException) {
            LocalClientRequest.this.handle_system_exception(systemException);
        }

        public void reply_location_forward(Object object, boolean bl) {
            LocalClientRequest.this.handle_location_forward(object, bl);
        }

        public void reply_runtime_exception(RuntimeException runtimeException) {
            UnknownException unknownException = new UnknownException(runtimeException);
            unknownException.completed = LocalClientRequest.this.state_completion_status();
            LocalClientRequest.this.handle_system_exception(unknownException);
        }

        public void reply_error(Error error) {
            if (error instanceof ThreadDeath) {
                throw error;
            }
            if (error instanceof OutOfMemoryError) {
                LocalClientRequest.this.handle_system_exception(new NO_MEMORY());
            } else if (error instanceof StackOverflowError) {
                LocalClientRequest.this.handle_system_exception(new NO_RESOURCES("Stack Overflow", 1146056983, LocalClientRequest.this.state_completion_status()));
            } else {
                UnknownException unknownException = new UnknownException(error);
                unknownException.completed = LocalClientRequest.this.state_completion_status();
                LocalClientRequest.this.handle_system_exception(unknownException);
            }
        }
    }
}

