/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.io.UnsupportedEncodingException;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerChannel;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerProtocol;
import org.openorb.net.ServerRequest;
import org.openorb.util.ExceptionTool;
import org.openorb.util.MergeStack;
import org.openorb.util.Trace;

public class ServerManagerImpl
implements ServerManager {
    private static final byte SEP_VAL = -2;
    private static final byte ESC_VAL = -3;
    private static final byte FLAG_PUID = 1;
    private byte[] m_process_uid;
    private byte[] m_server_uid;
    private org.omg.CORBA.ORB m_orb;
    private ThreadGroup m_root_group;
    private final Object m_sync_io = new Object();
    private ThreadGroup m_io_threads;
    private static ThreadGroup s_static_io_threads;
    private boolean m_use_static_thread_group;
    private Object[] m_protocol_profile_ids = new Object[0];
    private Map m_protocol_to_worker = new HashMap();
    private Map m_channels = new HashMap();
    private Thread m_channel_reaper = null;
    private int m_channel_closing_time;
    private static final int DEFAULT_CLOSE_TIME = 600000;
    private Object m_sync_state = new Object();
    private volatile boolean m_shutdown = false;
    private volatile boolean m_running = false;
    private volatile boolean m_io_complete = false;
    private ObjectAdapter m_default_adapter = null;
    private Map m_adapter_cache = new HashMap();
    private volatile int m_active_requests = 0;
    private volatile int m_holding_requests = 0;
    private Object m_sync_queue = new Object();
    private MergeStack m_requests = new MergeStack();
    private int m_tp_max_active_requests = 0;
    private int m_tp_previous_max_active_requests = 0;
    private int m_max_queue_size = 0;
    private int m_max_mgr_held_requests = 0;
    private Thread m_single_thread = null;
    private MergeStack m_waiting_requests = new MergeStack();
    private int m_thread_pool_size = 0;
    private Set m_server_threads = new HashSet();
    private boolean m_allow_pool = false;
    private ThreadGroup m_pool_threads;
    private static ThreadGroup s_static_pool_threads;
    private Thread[] m_pool_thread_array = new Thread[10];
    private int m_max_thread_pool_size = 5;
    private int m_min_thread_pool_size = 1;
    private int m_opt_thread_pool_size = 0;
    private Logger m_logger;
    private static final int POOL_ID_WAIT = -1;
    private static final int POOL_ID_NO_WAIT = -2;

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    private static SystemException createQueueFullException() {
        return new TRANSIENT(1146056705, CompletionStatus.COMPLETED_NO);
    }

    private static SystemException createDiscardException() {
        return new TRANSIENT(1330446337, CompletionStatus.COMPLETED_NO);
    }

    private static SystemException createInactiveException() {
        return new OBJ_ADAPTER(1330446337, CompletionStatus.COMPLETED_NO);
    }

    private static SystemException createDestroyedException() {
        return new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
    }

    private static SystemException createShutdownException() {
        return new BAD_INV_ORDER(1330446340, CompletionStatus.COMPLETED_NO);
    }

    public ServerManagerImpl(org.omg.CORBA.ORB oRB) {
        this.m_orb = oRB;
        this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        ORBLoader oRBLoader = ((ORB)oRB).getLoader();
        try {
            byte[] byArray = oRBLoader.getStringProperty("openorb.server.alias", "").getBytes("UTF-8");
            this.m_server_uid = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, this.m_server_uid, 0, byArray.length);
            this.m_server_uid[byArray.length] = -2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Encoding not supported.", unsupportedEncodingException);
            throw ExceptionTool.initCause(new INITIALIZE("Encoding not supported (" + unsupportedEncodingException + ")"), (Throwable)unsupportedEncodingException);
        }
        this.m_max_queue_size = oRBLoader.getIntProperty("openorb.server.maxQueueSize", Integer.MAX_VALUE);
        this.m_max_mgr_held_requests = oRBLoader.getIntProperty("openorb.server.maxManagerHeldRequests", Integer.MAX_VALUE);
        this.m_min_thread_pool_size = oRBLoader.getIntProperty("openorb.server.minThreadPoolSize", 1);
        this.m_max_thread_pool_size = oRBLoader.getIntProperty("openorb.server.maxThreadPoolSize", 10);
        this.m_root_group = Thread.currentThread().getThreadGroup();
        long l = System.currentTimeMillis();
        this.m_process_uid = new byte[8];
        this.m_process_uid[7] = (byte)(l >>> 56);
        this.m_process_uid[6] = (byte)(l >>> 48);
        this.m_process_uid[5] = (byte)(l >>> 40);
        this.m_process_uid[4] = (byte)(l >>> 32);
        this.m_process_uid[3] = (byte)(l >>> 24);
        this.m_process_uid[2] = (byte)(l >>> 16);
        this.m_process_uid[1] = (byte)(l >>> 8);
        this.m_process_uid[0] = (byte)l;
        this.m_channel_closing_time = oRBLoader.getIntProperty("openorb.server.reapCloseDelay", 600000);
        this.m_use_static_thread_group = oRBLoader.getBooleanProperty("openorb.useStaticThreadGroup", false);
    }

    public void setThreadPoolLimits(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid thread pool size range");
        }
        Object object = this.m_sync_state;
        synchronized (object) {
            this.m_min_thread_pool_size = n;
            this.m_max_thread_pool_size = n2;
        }
    }

    public void setMaxQueueSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid max queue size");
        }
        Object object = this.m_sync_state;
        synchronized (object) {
            this.m_max_queue_size = n;
        }
    }

    public void setMaxManagerHeldRequests(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid max held requests");
        }
        Object object = this.m_sync_state;
        synchronized (object) {
            this.m_max_mgr_held_requests = n;
        }
    }

    public byte[] create_cacheable_object_key(boolean bl, byte[][] byArray) {
        int n;
        int n2 = 4 + (bl ? this.m_server_uid.length : this.m_process_uid.length) + byArray.length - 1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            n2 += byArray[n4].length;
            int n5 = 0;
            while (n5 < byArray[n4].length) {
                switch (byArray[n4][n5]) {
                    case -3: 
                    case -2: {
                        ++n3;
                    }
                }
                ++n5;
            }
            ++n4;
        }
        byte[] byArray2 = new byte[n2 += n3];
        byArray2[0] = 0;
        byArray2[1] = 79;
        byArray2[2] = 79;
        if (bl) {
            byArray2[3] = 0;
            System.arraycopy(this.m_server_uid, 0, byArray2, 4, this.m_server_uid.length);
            n = 4 + this.m_server_uid.length;
        } else {
            byArray2[3] = 1;
            System.arraycopy(this.m_process_uid, 0, byArray2, 4, this.m_process_uid.length);
            n = 4 + this.m_process_uid.length;
        }
        int n6 = 0;
        while (n6 < byArray.length && n3 > 0) {
            int n7 = 0;
            while (n7 < byArray[n6].length) {
                switch (byArray[n6][n7]) {
                    case -3: 
                    case -2: {
                        byArray2[n++] = -3;
                        --n3;
                    }
                }
                byArray2[n] = byArray[n6][n7];
                ++n7;
                ++n;
            }
            if (n < byArray2.length) {
                byArray2[n++] = -2;
            }
            ++n6;
        }
        while (n6 < byArray.length) {
            System.arraycopy(byArray[n6], 0, byArray2, n, byArray[n6].length);
            if ((n += byArray[n6].length) < byArray2.length) {
                byArray2[n++] = -2;
            }
            ++n6;
        }
        return byArray2;
    }

    public byte[][] extract_cacheable_object_key(byte[] byArray) {
        int[] nArray = this.find_object_key_offsets(byArray);
        if (nArray == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[nArray.length][];
        int n = byArray.length;
        int n2 = byArrayArray.length - 1;
        while (n2 >= 0) {
            int n3 = nArray[n2];
            int n4 = 0;
            int n5 = n3;
            while (n5 < n) {
                if (byArray[n5] == -3) {
                    ++n5;
                    ++n4;
                }
                ++n5;
            }
            byArrayArray[n2] = new byte[n - n3 - n4];
            if (n4 == 0) {
                System.arraycopy(byArray, n3, byArrayArray[n2], 0, n - n3);
            } else {
                int n6 = n3;
                int n7 = 0;
                while (n6 < n) {
                    if (byArray[n6] == -3) {
                        ++n6;
                    }
                    byArrayArray[n2][n7] = byArray[n6];
                    ++n6;
                    ++n7;
                }
            }
            n = n3 - 1;
            --n2;
        }
        return byArrayArray;
    }

    private int[] find_object_key_offsets(byte[] byArray) {
        if (!this.is_local_cacheable_object_key(byArray)) {
            return null;
        }
        int n = 4;
        n = (byArray[3] & 1) == 1 ? (n += this.m_process_uid.length) : (n += this.m_server_uid.length);
        int n2 = 1;
        int n3 = n;
        while (n3 < byArray.length) {
            switch (byArray[n3]) {
                case -2: {
                    ++n2;
                    break;
                }
                case -3: {
                    ++n3;
                }
            }
            ++n3;
        }
        int[] nArray = new int[n2];
        nArray[0] = n;
        int n4 = 1;
        int n5 = n;
        while (n5 < byArray.length && n4 < nArray.length) {
            switch (byArray[n5]) {
                case -2: {
                    nArray[n4++] = n5 + 1;
                    break;
                }
                case -3: {
                    ++n5;
                }
            }
            ++n5;
        }
        return nArray;
    }

    public boolean is_cacheable_object_key(byte[] byArray) {
        return byArray.length >= 4 && byArray[0] == 0 && byArray[1] == 79 && byArray[2] == 79;
    }

    public boolean is_suid_object_key(byte[] byArray) {
        return byArray.length >= 4 && (byArray[3] & 1) == 0;
    }

    public boolean is_local_cacheable_object_key(byte[] byArray) {
        if (!this.is_cacheable_object_key(byArray)) {
            return false;
        }
        if ((byArray[3] & 1) == 1) {
            if (byArray.length - 4 < this.m_process_uid.length) {
                return false;
            }
            int n = 0;
            while (n < this.m_process_uid.length) {
                if (byArray[n + 4] != this.m_process_uid[n]) {
                    return false;
                }
                ++n;
            }
        } else {
            if (byArray.length - 4 < this.m_server_uid.length) {
                return false;
            }
            int n = 0;
            while (n < this.m_server_uid.length) {
                if (byArray[n + 4] != this.m_server_uid[n]) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public void register_protocol(int n, ServerProtocol serverProtocol) {
        if (serverProtocol == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.m_protocol_profile_ids.length) {
            if (this.m_protocol_profile_ids[n2] == serverProtocol && n == (Integer)this.m_protocol_profile_ids[n2 + 1]) {
                return;
            }
            ++n2;
        }
        Object[] objectArray = new Object[this.m_protocol_profile_ids.length + 2];
        System.arraycopy(this.m_protocol_profile_ids, 0, objectArray, 0, this.m_protocol_profile_ids.length);
        objectArray[this.m_protocol_profile_ids.length] = serverProtocol;
        objectArray[this.m_protocol_profile_ids.length + 1] = new Integer(n);
        this.m_protocol_profile_ids = objectArray;
    }

    public Object[] get_protocol_ids() {
        return this.m_protocol_profile_ids;
    }

    public void protocol_listening(ServerProtocol serverProtocol) {
        Object object = this.m_sync_io;
        synchronized (object) {
            if (this.m_shutdown) {
                return;
            }
            if (this.m_io_threads == null || this.m_io_threads.isDestroyed()) {
                if (this.m_use_static_thread_group) {
                    if (s_static_io_threads == null || s_static_io_threads.isDestroyed()) {
                        s_static_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                    }
                    this.m_io_threads = s_static_io_threads;
                } else {
                    this.m_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                }
            }
            Thread thread = new Thread(this.m_io_threads, new ProtocolRunner(serverProtocol), "Worker for " + serverProtocol.toString());
            thread.setDaemon(true);
            thread.start();
            this.m_protocol_to_worker.put(serverProtocol, thread);
        }
    }

    public void protocol_not_listening(ServerProtocol serverProtocol, boolean bl) {
        Thread thread;
        Object object = this.m_sync_io;
        synchronized (object) {
            if (bl) {
                thread = (Thread)this.m_protocol_to_worker.get(serverProtocol);
                if (thread != null) {
                    this.m_protocol_to_worker.put(serverProtocol, null);
                }
            } else {
                thread = (Thread)this.m_protocol_to_worker.remove(serverProtocol);
            }
        }
        if (thread != null) {
            Thread thread2 = Thread.currentThread();
            thread.interrupt();
            while (thread != thread2 && thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void register_channel(ServerChannel serverChannel) {
        Object object = this.m_sync_io;
        synchronized (object) {
            if (this.m_shutdown) {
                return;
            }
            if (this.m_channels.containsKey(serverChannel)) {
                return;
            }
            if (this.m_io_threads == null || this.m_io_threads.isDestroyed()) {
                if (this.m_use_static_thread_group) {
                    if (s_static_io_threads == null || s_static_io_threads.isDestroyed()) {
                        s_static_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                    }
                    this.m_io_threads = s_static_io_threads;
                } else {
                    this.m_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                }
            }
            Thread thread = new Thread(this.m_io_threads, new ChannelRecvRunner(serverChannel), "Receive Worker for " + serverChannel.toString());
            thread.setDaemon(true);
            thread.start();
            this.m_channels.put(serverChannel, thread);
        }
    }

    public void unregister_channel(ServerChannel serverChannel) {
        Thread thread;
        Object object = this.m_sync_io;
        synchronized (object) {
            thread = (Thread)this.m_channels.remove(serverChannel);
        }
        if (thread != null) {
            Thread thread2 = Thread.currentThread();
            thread.interrupt();
            while (thread != thread2 && thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void channel_reaper() {
        int n = RequestIDAllocator.get_request_id();
        ServerChannel[] serverChannelArray = new ServerChannel[]{};
        while (!this.m_shutdown) {
            try {
                Thread.sleep(this.m_channel_closing_time);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (this.m_shutdown) {
                return;
            }
            Object object = this.m_sync_queue;
            synchronized (object) {
                this.m_tp_previous_max_active_requests = this.m_tp_max_active_requests;
                this.m_tp_max_active_requests = this.m_active_requests;
                this.recalcOptThreadPoolSize();
                if (this.m_opt_thread_pool_size < this.m_thread_pool_size) {
                    this.m_sync_queue.notifyAll();
                }
            }
            Object object2 = this.m_sync_io;
            synchronized (object2) {
                if (this.m_channels.isEmpty()) {
                    continue;
                }
                serverChannelArray = this.m_channels.keySet().toArray(serverChannelArray);
            }
            int n2 = 0;
            while (n2 < serverChannelArray.length && serverChannelArray[n2] != null) {
                if (serverChannelArray[n2].channel_age() < n) {
                    serverChannelArray[n2].soft_close(false);
                }
                ++n2;
            }
            n = RequestIDAllocator.get_request_id();
        }
    }

    public ObjectAdapter find_adapter(byte[] byArray) {
        return this.find_adapter(byArray, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectAdapter find_adapter(byte[] var1_1, ServerRequest var2_2) {
        block52: {
            block51: {
                block47: {
                    if (!this.is_cacheable_object_key(var1_1)) {
                        return this.m_default_adapter;
                    }
                    if (!this.is_local_cacheable_object_key(var1_1)) {
                        if (var2_2 == null) return null;
                        var2_2.server_cancel(new OBJECT_NOT_EXIST(1330446338, CompletionStatus.COMPLETED_NO));
                        return null;
                    }
                    var3_3 = this.find_object_key_offsets(var1_1);
                    var4_4 = new ProgressiveAIDKey(var1_1, var3_3);
                    block22: while (true) {
                        var5_5 = null;
                        var6_6 = this.m_sync_state;
                        synchronized (var6_6) {
                            var4_4.useHash(var3_3.length - 1);
                            var5_5 = (AdapterValue)this.m_adapter_cache.get(var4_4);
                            if (var5_5 != null) {
                                var5_5.IncHits();
                                return var5_5.adapter();
                            }
                            var7_8 = var3_3.length - 2;
                            while (true) {
                                if (var7_8 < 0 || var5_5 != null) {
                                    // MONITOREXIT @DISABLED, blocks:[38, 22, 23, 8] lbl22 : MonitorExitStatement: MONITOREXIT : var6_6
                                    if (var5_5 != null) break;
                                    if (var2_2 == null) return null;
                                    var2_2.server_cancel(new OBJECT_NOT_EXIST(1330446338, CompletionStatus.COMPLETED_NO));
                                    return null;
                                }
                                var4_4.useHash(var7_8);
                                var5_5 = (AdapterValue)this.m_adapter_cache.get(var4_4);
                                --var7_8;
                            }
                        }
                        var7_7 = var5_5.adapter();
                        if (var7_7.object_id(var1_1) != null) {
                            var5_5.IncHits();
                            return var7_7;
                        }
                        var8_9 = false;
                        var9_10 = false;
                        try {
                            block48: {
                                do {
                                    block50: {
                                        var10_11 = null;
                                        if (var2_2 != null) {
                                            if (!var8_9 && var7_7.single_threaded()) {
                                                var11_13 = this.m_sync_queue;
                                                synchronized (var11_13) {
                                                    if (this.m_single_thread == Thread.currentThread()) {
                                                        var8_9 = true;
                                                    } else if (this.m_single_thread == null) {
                                                        this.m_single_thread = Thread.currentThread();
                                                        var9_10 = true;
                                                        var8_9 = true;
                                                    } else {
                                                        this.m_waiting_requests.addLast(var2_2);
                                                        ++this.m_holding_requests;
                                                        var12_14 = null;
                                                        // MONITOREXIT @DISABLED, blocks:[32, 1, 34, 36, 22, 24, 10, 46] lbl56 : MonitorExitStatement: MONITOREXIT : var11_13
                                                        var23_23 = null;
                                                        if (var9_10 == false) return var12_14;
                                                        var24_24 = this.m_sync_queue;
                                                        break block22;
                                                    }
                                                }
                                            }
                                            if ((var10_11 = (AdapterManagerImpl)var7_7.getAdapterManager()) != null && !var10_11.begin_request(var2_2)) {
                                                var12_14 = null;
                                                break block47;
                                            }
                                        }
                                        try {
                                            try {
                                                var7_7 = var7_7.find_adapter(var1_1);
                                            }
                                            catch (AdapterDestroyedException var11_12) {
                                                var12_14 = var11_12.getAdapterID();
                                                var13_15 = this.find_object_key_offsets(var12_14);
                                                var14_16 = var13_15[var13_15.length - 1];
                                                var15_17 = new AdapterValue(var12_14, var14_16, var11_12.getObjectAdapter());
                                                var16_18 = this.m_sync_state;
                                                synchronized (var16_18) {
                                                    var15_17 = (AdapterValue)this.m_adapter_cache.get(var15_17);
                                                    if (var15_17 == null) {
                                                        // MONITOREXIT @DISABLED, blocks:[1, 18, 3, 22, 24, 44, 14] lbl80 : MonitorExitStatement: MONITOREXIT : var16_18
                                                        var21_22 = null;
                                                        if (var10_11 != null) {
                                                            var10_11.complete_request(var2_2);
                                                        }
                                                        break block48;
                                                    }
                                                    if (var2_2 != null) {
                                                        if (var15_17.getDestroyRequests() == null) {
                                                            var15_17.setDestroyRequests(new MergeStack());
                                                        }
                                                        var15_17.getDestroyRequests().addLast(var2_2);
                                                        ++this.m_holding_requests;
                                                        var17_20 = null;
                                                        // MONITOREXIT @DISABLED, blocks:[1, 18, 3, 22, 24, 14, 31] lbl92 : MonitorExitStatement: MONITOREXIT : var16_18
                                                        var21_22 = null;
                                                        if (var10_11 != null) {
                                                            var10_11.complete_request(var2_2);
                                                        }
                                                        var23_23 = null;
                                                        if (var9_10 == false) return var17_20;
                                                        var24_24 = this.m_sync_queue;
                                                        synchronized (var24_24) {
                                                            this.m_single_thread = null;
                                                            return var17_20;
                                                        }
                                                    }
                                                    var15_17.setWaitingForDestroy(true);
                                                    var17_19 = false;
                                                    ** break block49
                                                }
                                            }
                                            var21_22 = null;
                                            if (var10_11 != null) {
                                                var10_11.complete_request(var2_2);
                                            }
                                            break block50;
lbl-1000:
                                            // 1 sources

                                            {
                                                while (true) {
                                                    if (!var15_17.getWaitingForDestroy()) {
                                                        if (var17_19) {
                                                            Thread.currentThread().interrupt();
                                                        }
                                                        break;
                                                    }
                                                    try {
                                                        this.m_sync_state.wait();
                                                    }
                                                    catch (InterruptedException var18_21) {
                                                        var17_19 = true;
                                                    }
                                                }
                                            }
                                            var21_22 = null;
                                            if (var10_11 == null) break block48;
                                            var10_11.complete_request(var2_2);
                                            break block48;
                                        }
                                        catch (Throwable var20_25) {
                                            var21_22 = null;
                                            if (var10_11 == null) throw var20_25;
                                            var10_11.complete_request(var2_2);
                                            throw var20_25;
                                        }
                                    }
                                    if (var7_7 != null) continue;
                                    if (var2_2 != null) {
                                        var2_2.server_cancel(new OBJECT_NOT_EXIST(1330446338, CompletionStatus.COMPLETED_NO));
                                    }
                                    var11_13 = null;
                                    break block51;
                                } while (var7_7.object_id(var1_1) == null);
                                var11_13 = var7_7;
                                break block52;
                            }
                            var23_23 = null;
                            if (!var9_10) continue;
                            var24_24 = this.m_sync_queue;
                            synchronized (var24_24) {
                                this.m_single_thread = null;
                            }
                        }
                        catch (Throwable var22_26) {
                            var23_23 = null;
                            if (var9_10 == false) throw var22_26;
                            var24_24 = this.m_sync_queue;
                            synchronized (var24_24) {
                                this.m_single_thread = null;
                                throw var22_26;
                            }
                        }
                    }
                    synchronized (var24_24) {
                        this.m_single_thread = null;
                        return var12_14;
                    }
                }
                var23_23 = null;
                if (var9_10 == false) return var12_14;
                var24_24 = this.m_sync_queue;
                synchronized (var24_24) {
                    this.m_single_thread = null;
                    return var12_14;
                }
            }
            var23_23 = null;
            if (var9_10 == false) return var11_13;
            var24_24 = this.m_sync_queue;
            synchronized (var24_24) {
                this.m_single_thread = null;
                return var11_13;
            }
        }
        var23_23 = null;
        if (var9_10 == false) return var11_13;
        var24_24 = this.m_sync_queue;
        synchronized (var24_24) {
            this.m_single_thread = null;
            return var11_13;
        }
    }

    public void register_adapter(byte[] byArray, ObjectAdapter objectAdapter) {
        if (byArray.length == 0) {
            if (this.m_default_adapter == null) {
                this.m_default_adapter = objectAdapter;
            }
            return;
        }
        if (!this.is_local_cacheable_object_key(byArray)) {
            throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
        }
        int n = this.find_object_key_offsets(byArray)[0];
        AdapterValue adapterValue = new AdapterValue(byArray, n, objectAdapter);
        AdapterManagerImpl adapterManagerImpl = (AdapterManagerImpl)objectAdapter.getAdapterManager();
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_adapter_cache.containsKey(adapterValue)) {
                return;
            }
            if (adapterManagerImpl != null) {
                adapterManagerImpl.addManagedAdapter(objectAdapter);
            }
            this.m_adapter_cache.put(adapterValue, adapterValue);
        }
    }

    public void unregister_adapter(byte[] byArray) {
        if (byArray.length == 0) {
            this.m_default_adapter = null;
            return;
        }
        if (!this.is_local_cacheable_object_key(byArray)) {
            throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
        }
        int n = this.find_object_key_offsets(byArray)[0];
        AdapterValue adapterValue = new AdapterValue(byArray, n, null);
        Object object = this.m_sync_state;
        synchronized (object) {
            adapterValue = (AdapterValue)this.m_adapter_cache.remove(adapterValue);
            if (adapterValue == null) {
                return;
            }
            if (adapterValue.getWaitingForDestroy()) {
                adapterValue.setWaitingForDestroy(false);
                this.m_sync_state.notifyAll();
            }
        }
        AdapterManagerImpl adapterManagerImpl = (AdapterManagerImpl)adapterValue.adapter().getAdapterManager();
        if (adapterManagerImpl != null) {
            adapterManagerImpl.removeManagedAdapter(adapterValue.adapter());
        }
        if (adapterValue.getDestroyRequests() != null && !adapterValue.getDestroyRequests().isEmpty()) {
            Object object2 = this.m_sync_queue;
            synchronized (object2) {
                this.m_active_requests += adapterValue.getDestroyRequests().size();
                this.m_holding_requests -= adapterValue.getDestroyRequests().size();
                this.m_requests.append(adapterValue.getDestroyRequests());
                this.m_sync_queue.notifyAll();
            }
        }
    }

    public ServerManager.AdapterManager create_adapter_manager() {
        return new AdapterManagerImpl();
    }

    public void enqueue_request(ServerRequest serverRequest) {
        if (this.m_shutdown) {
            serverRequest.server_cancel(ServerManagerImpl.createShutdownException());
        }
        Object object = this.m_sync_queue;
        synchronized (object) {
            if (this.m_max_queue_size == 0 || this.m_active_requests < this.m_max_queue_size) {
                ++this.m_active_requests;
                this.m_requests.addLast(serverRequest);
                this.m_sync_queue.notify();
                if (this.m_active_requests > this.m_tp_max_active_requests) {
                    this.m_tp_max_active_requests = this.m_active_requests;
                    this.recalcOptThreadPoolSize();
                }
                if (this.m_thread_pool_size < this.m_min_thread_pool_size) {
                    this.extend_thread_pool(this.m_min_thread_pool_size - this.m_thread_pool_size);
                } else if (this.m_thread_pool_size < this.m_max_thread_pool_size && this.m_active_requests > this.m_thread_pool_size) {
                    this.extend_thread_pool(1);
                }
                return;
            }
        }
        serverRequest.server_cancel(ServerManagerImpl.createQueueFullException());
    }

    private void recalcOptThreadPoolSize() {
        this.m_opt_thread_pool_size = this.m_tp_previous_max_active_requests > this.m_tp_max_active_requests ? (this.m_tp_max_active_requests + this.m_tp_previous_max_active_requests) / 2 : this.m_tp_max_active_requests * 11 / 10;
    }

    public boolean work_pending() {
        if (this.m_shutdown) {
            return false;
        }
        if (!this.m_running) {
            Object object = this.m_sync_io;
            synchronized (object) {
                boolean bl = !this.m_channels.isEmpty();
                return bl;
            }
        }
        Object object = this.m_sync_queue;
        synchronized (object) {
            boolean bl = !this.m_requests.isEmpty();
            return bl;
        }
    }

    public boolean serve_request(boolean bl) {
        if (!this.m_running) {
            this.startup(false, false);
        }
        return this.thread_pool_main(bl ? -1 : -2);
    }

    private boolean thread_pool_main(int n) {
        Thread thread = Thread.currentThread();
        if (n < 0) {
            Object object = this.m_sync_queue;
            synchronized (object) {
                this.m_server_threads.add(thread);
            }
        }
        boolean bl = false;
        while (true) {
            ServerRequest serverRequest = null;
            Object object = this.m_sync_queue;
            synchronized (object) {
                block21: {
                    while (true) {
                        if (bl) {
                            --this.m_active_requests;
                        }
                        if (this.m_shutdown || bl && n < 0 || n >= this.m_opt_thread_pool_size && n >= this.m_min_thread_pool_size) {
                            if (n >= 0) {
                                this.m_pool_thread_array[n] = null;
                                --this.m_thread_pool_size;
                                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                                    this.getLogger().debug("(ServerManager) Thread pool shrunk to " + this.m_thread_pool_size);
                                }
                            }
                            if (this.m_single_thread == thread) {
                                this.m_single_thread = null;
                            }
                            this.m_server_threads.remove(thread);
                            if (this.m_shutdown && this.m_server_threads.isEmpty()) {
                                this.m_sync_queue.notifyAll();
                            }
                            boolean bl2 = bl;
                            return bl2;
                        }
                        bl = false;
                        if (!(this.m_waiting_requests.isEmpty() || this.m_single_thread != null && this.m_single_thread != thread)) {
                            if (this.m_single_thread != thread) {
                                this.m_single_thread = thread;
                            }
                            serverRequest = (ServerRequest)this.m_waiting_requests.removeFirst();
                            ++this.m_active_requests;
                            --this.m_holding_requests;
                            break block21;
                        }
                        if (this.m_single_thread == thread) {
                            this.m_single_thread = null;
                        }
                        if (!this.m_requests.isEmpty() || n == -2) break;
                        try {
                            this.m_sync_queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            this.m_server_threads.remove(thread);
                            if (this.m_shutdown && this.m_server_threads.isEmpty()) {
                                this.m_sync_queue.notifyAll();
                            }
                            boolean bl3 = false;
                            return bl3;
                        }
                    }
                    serverRequest = (ServerRequest)this.m_requests.removeFirst();
                }
            }
            this.serve_request(serverRequest);
            bl = true;
        }
    }

    private void serve_request(ServerRequest serverRequest) {
        int n = serverRequest.begin_request();
        while (true) {
            Object var12_11;
            Object object;
            ObjectAdapter objectAdapter;
            switch (n) {
                case 1: {
                    objectAdapter = this.find_adapter(serverRequest.object_key(), serverRequest);
                    if (objectAdapter != null && (n = serverRequest.adapter(objectAdapter)) != 5) break;
                    return;
                }
                case 5: {
                    return;
                }
                default: {
                    objectAdapter = serverRequest.adapter();
                }
            }
            if (n != 2) {
                throw Trace.signalIllegalCondition(this.getLogger(), "state != ServerRequest.STATE_QUEUED");
            }
            if (objectAdapter.single_threaded()) {
                object = this.m_sync_queue;
                synchronized (object) {
                    if (this.m_single_thread == null) {
                        this.m_single_thread = Thread.currentThread();
                    } else if (this.m_single_thread != Thread.currentThread()) {
                        this.m_waiting_requests.addLast(serverRequest);
                        ++this.m_holding_requests;
                        return;
                    }
                }
            }
            if ((object = (AdapterManagerImpl)objectAdapter.getAdapterManager()) != null && !((AdapterManagerImpl)object).begin_request(serverRequest)) {
                return;
            }
            try {
                try {
                    serverRequest.dispatch();
                }
                catch (AdapterDestroyedException adapterDestroyedException) {
                    byte[] byArray = adapterDestroyedException.getAdapterID();
                    if (objectAdapter != adapterDestroyedException.getObjectAdapter()) {
                        Trace.signalIllegalCondition(this.getLogger(), "Adapters do not match.");
                    }
                    int[] nArray = this.find_object_key_offsets(byArray);
                    AdapterValue adapterValue = new AdapterValue(byArray, nArray[0], objectAdapter);
                    Object object2 = this.m_sync_state;
                    synchronized (object2) {
                        adapterValue = (AdapterValue)this.m_adapter_cache.get(adapterValue);
                        if (adapterValue != null && adapterValue.adapter() == objectAdapter) {
                            if (adapterValue.getDestroyRequests() == null) {
                                adapterValue.setDestroyRequests(new MergeStack());
                            }
                            adapterValue.getDestroyRequests().addLast(serverRequest);
                            ++this.m_holding_requests;
                            // MONITOREXIT @DISABLED, blocks:[1, 18, 3, 5, 11, 14] lbl57 : MonitorExitStatement: MONITOREXIT : var9_10
                            var12_11 = null;
                            if (object != null) {
                                ((AdapterManagerImpl)object).complete_request(serverRequest);
                            }
                            return;
                        }
                    }
                    var12_11 = null;
                    if (object == null) continue;
                    ((AdapterManagerImpl)object).complete_request(serverRequest);
                    continue;
                }
                var12_11 = null;
                if (object == null) break;
                ((AdapterManagerImpl)object).complete_request(serverRequest);
                break;
            }
            catch (Throwable throwable) {
                var12_11 = null;
                if (object != null) {
                    ((AdapterManagerImpl)object).complete_request(serverRequest);
                }
                throw throwable;
            }
        }
    }

    private boolean is_server_thread() {
        Object object = this.m_sync_state;
        synchronized (object) {
            boolean bl = this.m_server_threads.contains(Thread.currentThread());
            return bl;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void extend_thread_pool(int var1_1) {
        if (this.m_pool_threads == null || this.m_pool_threads.isDestroyed()) {
            if (this.m_use_static_thread_group) {
                if (ServerManagerImpl.s_static_pool_threads == null || ServerManagerImpl.s_static_pool_threads.isDestroyed()) {
                    ServerManagerImpl.s_static_pool_threads = new ThreadGroup(this.m_root_group, "Server Threads");
                }
                this.m_pool_threads = ServerManagerImpl.s_static_pool_threads;
            } else {
                this.m_pool_threads = new ThreadGroup(this.m_root_group, "Server Threads");
            }
        }
        if (this.m_pool_thread_array.length < this.m_thread_pool_size + var1_1) {
            var2_2 = new Thread[this.m_thread_pool_size + var1_1];
            System.arraycopy(this.m_pool_thread_array, 0, var2_2, 0, this.m_pool_thread_array.length);
            this.m_pool_thread_array = var2_2;
        }
        this.m_thread_pool_size += var1_1;
        var2_3 = 0;
        var3_4 = 0;
        ** GOTO lbl28
        {
            ++var2_3;
            do {
                if (this.m_pool_thread_array[var2_3] != null) continue block0;
                this.m_pool_thread_array[var2_3] = new PoolThread(this.m_pool_threads, var2_3);
                this.m_server_threads.add(this.m_pool_thread_array[var2_3]);
                this.m_pool_thread_array[var2_3].setDaemon(true);
                this.m_pool_thread_array[var2_3].start();
                ++var2_3;
                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug("ServerManager Thread pool grew to " + this.m_thread_pool_size);
                }
                ++var3_4;
lbl28:
                // 2 sources

            } while (var3_4 < var1_1);
        }
    }

    private boolean wait_for_startup() {
        if (!this.m_running) {
            Object object = this.m_sync_state;
            synchronized (object) {
                while (!this.m_running) {
                    if (this.m_shutdown) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        this.m_sync_state.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        return true;
    }

    public void startup(boolean bl, boolean bl2) {
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_shutdown) {
                return;
            }
            if (!this.m_running) {
                this.m_running = true;
                this.m_allow_pool = bl2;
                if (this.m_io_threads == null || this.m_io_threads.isDestroyed()) {
                    if (this.m_use_static_thread_group) {
                        if (s_static_io_threads == null || s_static_io_threads.isDestroyed()) {
                            s_static_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                        }
                        this.m_io_threads = s_static_io_threads;
                    } else {
                        this.m_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                    }
                }
                if (this.m_channel_closing_time > 0) {
                    this.m_channel_reaper = new Thread(this.m_io_threads, new Runnable(){

                        public void run() {
                            ServerManagerImpl.this.channel_reaper();
                        }
                    }, "Channel Reaper");
                    this.m_channel_reaper.setDaemon(true);
                    this.m_channel_reaper.start();
                }
                this.m_sync_state.notifyAll();
            } else if (bl2 && !this.m_allow_pool) {
                this.m_allow_pool = true;
                if (this.m_opt_thread_pool_size < this.m_min_thread_pool_size) {
                    this.extend_thread_pool(this.m_opt_thread_pool_size);
                } else if (this.m_opt_thread_pool_size < this.m_max_thread_pool_size) {
                    this.extend_thread_pool(this.m_opt_thread_pool_size);
                } else {
                    this.extend_thread_pool(this.m_max_thread_pool_size);
                }
            }
            if (bl) {
                try {
                    while (this.m_running) {
                        this.m_sync_state.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdown(boolean bl) {
        ORBLoader oRBLoader;
        Object object;
        ServerChannel[] serverChannelArray;
        ServerProtocol[] serverProtocolArray;
        if (!bl) {
            Object object2 = this.m_sync_state;
            synchronized (object2) {
                if (this.m_shutdown) {
                    return;
                }
                Thread thread = new Thread(this.m_root_group, new Runnable(){

                    public void run() {
                        ServerManagerImpl.this.shutdown(true);
                    }
                }, "ORB shutdown thread");
                thread.setDaemon(true);
                thread.start();
                while (!this.m_io_complete) {
                    try {
                        this.m_sync_state.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return;
        }
        if (this.is_server_thread()) {
            throw new BAD_INV_ORDER(1330446339, CompletionStatus.COMPLETED_MAYBE);
        }
        boolean bl2 = false;
        Object object3 = this.m_sync_state;
        synchronized (object3) {
            Object object4 = this.m_sync_io;
            synchronized (object4) {
                if (this.m_shutdown) {
                    return;
                }
                this.m_shutdown = true;
                serverProtocolArray = new ServerProtocol[this.m_protocol_to_worker.size()];
                serverProtocolArray = this.m_protocol_to_worker.keySet().toArray(serverProtocolArray);
            }
            if (this.m_channel_reaper != null) {
                this.m_channel_reaper.interrupt();
            }
        }
        int n = 0;
        while (n < serverProtocolArray.length) {
            if (serverProtocolArray[n] != null) {
                serverProtocolArray[n].close();
            }
            ++n;
        }
        Object object5 = this.m_sync_state;
        synchronized (object5) {
            this.m_io_complete = true;
            this.m_sync_state.notifyAll();
        }
        Object object6 = this.m_sync_queue;
        synchronized (object6) {
            this.m_sync_queue.notifyAll();
            while (!this.m_server_threads.isEmpty()) {
                try {
                    this.m_sync_queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
            }
        }
        Object object7 = this.m_sync_state;
        synchronized (object7) {
            while (!this.m_waiting_requests.isEmpty()) {
                serverChannelArray = (ServerRequest)this.m_waiting_requests.removeFirst();
                serverChannelArray.server_cancel(ServerManagerImpl.createShutdownException());
                --this.m_holding_requests;
            }
            while (!this.m_requests.isEmpty()) {
                serverChannelArray = (ServerRequest)this.m_requests.removeFirst();
                serverChannelArray.server_cancel(ServerManagerImpl.createShutdownException());
                --this.m_active_requests;
            }
            serverChannelArray = this.m_adapter_cache.values().iterator();
            while (serverChannelArray.hasNext()) {
                object = (AdapterValue)serverChannelArray.next();
                AdapterManagerImpl adapterManagerImpl = (AdapterManagerImpl)((AdapterValue)object).adapter().getAdapterManager();
                if (adapterManagerImpl != null && adapterManagerImpl.m_state == State.HOLDING) {
                    if (adapterManagerImpl.m_hold_requests != null) {
                        while (!adapterManagerImpl.m_hold_requests.isEmpty()) {
                            ServerRequest serverRequest = (ServerRequest)adapterManagerImpl.m_hold_requests.removeFirst();
                            serverRequest.server_cancel(ServerManagerImpl.createShutdownException());
                            --this.m_holding_requests;
                        }
                    }
                    adapterManagerImpl.m_state = State.INACTIVE;
                }
                ((AdapterValue)object).adapter().etherealize(true);
            }
            if (this.m_active_requests != 0) {
                Trace.signalIllegalCondition(this.getLogger(), "Active requests not empty.");
            }
            if (this.m_holding_requests != 0) {
                Trace.signalIllegalCondition(this.getLogger(), "Holding requests not empty.");
            }
        }
        if (this.m_channel_reaper != null) {
            try {
                this.m_channel_reaper.join();
                this.m_channel_reaper = null;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
            }
        }
        object = this.m_sync_io;
        synchronized (object) {
            serverChannelArray = new ServerChannel[this.m_channels.size()];
            serverChannelArray = this.m_channels.keySet().toArray(serverChannelArray);
        }
        int n2 = 0;
        while (n2 < serverChannelArray.length) {
            serverChannelArray[n2].soft_close(true);
            ++n2;
        }
        Object object8 = this.m_sync_state;
        synchronized (object8) {
            this.m_running = false;
            this.m_sync_state.notifyAll();
        }
        if (!this.m_use_static_thread_group) {
            if (this.m_io_threads != null) {
                this.m_io_threads.setDaemon(true);
                try {
                    this.m_io_threads.destroy();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
            }
            if (this.m_pool_threads != null) {
                this.m_pool_threads.setDaemon(true);
                try {
                    this.m_pool_threads.destroy();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
            }
        }
        if ((oRBLoader = ((ORB)this.m_orb).getLoader()) instanceof Disposable) {
            ((Disposable)((Object)oRBLoader)).dispose();
        }
        if (bl2) {
            Thread.currentThread().interrupt();
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    private static class AdapterValue {
        private byte[] m_aid;
        private int m_hash;
        private int m_offset;
        private ObjectAdapter m_adapter;
        private int m_priority;
        private int m_hits = 0;
        private MergeStack m_destroy_requests;
        private boolean m_waiting_for_destroy = false;

        public AdapterValue(byte[] byArray, int n, ObjectAdapter objectAdapter) {
            this.m_aid = byArray;
            this.m_offset = n;
            this.m_hash = 0;
            int n2 = n;
            while (n2 < this.m_aid.length) {
                this.m_hash = 31 * this.m_hash + (this.m_aid[n2] & 0xFF);
                ++n2;
            }
            this.m_adapter = objectAdapter;
            this.m_priority = this.m_adapter != null ? this.m_adapter.cache_priority() : -1;
        }

        public boolean is_cacheable_object_key() {
            return this.m_offset != 0;
        }

        public int hashCode() {
            return this.m_hash;
        }

        public int offset() {
            return this.m_offset;
        }

        public byte[] aid() {
            return this.m_aid;
        }

        public int hits() {
            return this.m_hits;
        }

        public void IncHits() {
            ++this.m_hits;
        }

        public ObjectAdapter adapter() {
            return this.m_adapter;
        }

        public MergeStack getDestroyRequests() {
            return this.m_destroy_requests;
        }

        public void setDestroyRequests(MergeStack mergeStack) {
            this.m_destroy_requests = mergeStack;
        }

        public boolean getWaitingForDestroy() {
            return this.m_waiting_for_destroy;
        }

        public void setWaitingForDestroy(boolean bl) {
            this.m_waiting_for_destroy = bl;
        }

        public boolean equals(Object object) {
            if (object instanceof AdapterValue) {
                AdapterValue adapterValue = (AdapterValue)object;
                if (adapterValue.m_hash != this.m_hash || adapterValue.m_offset != this.m_offset || adapterValue.m_aid.length != this.m_aid.length) {
                    return false;
                }
                int n = this.m_aid.length - 1;
                while (n >= 0) {
                    if (this.m_aid[n] != adapterValue.m_aid[n]) {
                        return false;
                    }
                    --n;
                }
                return true;
            }
            if (object instanceof ProgressiveAIDKey) {
                int n;
                ProgressiveAIDKey progressiveAIDKey = (ProgressiveAIDKey)object;
                if (progressiveAIDKey.hashCode() != this.m_hash) {
                    return false;
                }
                if (this.m_offset == 0 != (progressiveAIDKey.offsets()[0] == 0)) {
                    return false;
                }
                int n2 = n = progressiveAIDKey.hashTo() == progressiveAIDKey.offsets().length - 1 ? progressiveAIDKey.aid().length : progressiveAIDKey.offsets()[progressiveAIDKey.hashTo() + 1];
                if (n - progressiveAIDKey.offsets()[0] != this.m_aid.length - this.m_offset) {
                    return false;
                }
                int n3 = this.m_aid.length;
                --n;
                --n3;
                while (n3 >= this.m_offset) {
                    if (progressiveAIDKey.aid()[n] != this.m_aid[n3]) {
                        return false;
                    }
                    --n;
                    --n3;
                }
                return true;
            }
            return false;
        }
    }

    private static class ProgressiveAIDKey {
        private byte[] m_aid;
        private int[] m_offsets;
        private int[] m_hashes;
        private int m_hash;
        private int m_hash_to;

        public ProgressiveAIDKey(byte[] byArray, int[] nArray) {
            this.m_aid = byArray;
            this.m_offsets = nArray;
            this.m_hashes = new int[this.m_offsets.length];
            this.m_hash = 0;
            int n = 0;
            while (n < this.m_hashes.length) {
                int n2 = this.m_offsets[n];
                int n3 = n + 1 < this.m_hashes.length ? this.m_offsets[n + 1] : this.m_aid.length;
                int n4 = n2;
                while (n4 < n3) {
                    this.m_hash = 31 * this.m_hash + (this.m_aid[n4] & 0xFF);
                    ++n4;
                }
                this.m_hashes[n] = this.m_hash;
                ++n;
            }
            this.m_hash_to = this.m_offsets.length - 1;
        }

        public boolean is_cacheable_object_key() {
            return this.m_offsets[0] != 0;
        }

        public int hashCode() {
            return this.m_hash;
        }

        public int hashTo() {
            return this.m_hash_to;
        }

        public int[] offsets() {
            return this.m_offsets;
        }

        public byte[] aid() {
            return this.m_aid;
        }

        public int useHash(int n) {
            this.m_hash_to = n;
            this.m_hash = n == -1 ? 0 : this.m_hashes[n];
            return this.m_hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof AdapterValue) {
                int n;
                AdapterValue adapterValue = (AdapterValue)object;
                if (adapterValue.offset() == 0 != (this.m_offsets[0] == 0)) {
                    return false;
                }
                if (adapterValue.hashCode() != this.m_hash) {
                    return false;
                }
                int n2 = n = this.m_hash_to == this.m_offsets.length - 1 ? this.m_aid.length : this.m_offsets[this.m_hash_to + 1];
                if (n - this.m_offsets[0] != adapterValue.aid().length - adapterValue.offset()) {
                    return false;
                }
                int n3 = adapterValue.aid().length;
                --n;
                --n3;
                while (n3 >= adapterValue.offset()) {
                    if (this.m_aid[n] != adapterValue.aid()[n3]) {
                        return false;
                    }
                    --n;
                    --n3;
                }
                return true;
            }
            if (object instanceof ProgressiveAIDKey) {
                ProgressiveAIDKey progressiveAIDKey = (ProgressiveAIDKey)object;
                if (progressiveAIDKey.m_offsets[0] == 0 != (this.m_offsets[0] == 0)) {
                    return false;
                }
                if (progressiveAIDKey.m_hash_to != this.m_hash_to) {
                    return false;
                }
                int n = this.m_hash_to;
                while (n >= 0) {
                    if (progressiveAIDKey.m_hashes[n] != this.m_hashes[n] || progressiveAIDKey.m_offsets[n] - progressiveAIDKey.m_offsets[0] != this.m_offsets[n] - this.m_offsets[0]) {
                        return false;
                    }
                    --n;
                }
                int n4 = this.m_hash_to == this.m_offsets.length - 1 ? this.m_aid.length : this.m_offsets[this.m_hash_to + 1];
                int n5 = progressiveAIDKey.m_hash_to == progressiveAIDKey.m_offsets.length - 1 ? progressiveAIDKey.m_aid.length : progressiveAIDKey.m_offsets[progressiveAIDKey.m_hash_to + 1];
                --n4;
                --n5;
                while (n4 >= this.m_offsets[0]) {
                    if (this.m_aid[n4] != progressiveAIDKey.m_aid[n5]) {
                        return false;
                    }
                    --n4;
                    --n5;
                }
                return true;
            }
            return false;
        }
    }

    public class AdapterManagerImpl
    extends LocalObject
    implements POAManager,
    ServerManager.AdapterManager {
        private Set m_managed_adapters = new HashSet();
        private State m_state = State.HOLDING;
        private int m_managed_active_requests = 0;
        private MergeStack m_hold_requests;
        private boolean m_etherealize;
        private int m_max_manager_held_requests_override = ServerManagerImpl.access$500(ServerManagerImpl.this);

        AdapterManagerImpl() {
        }

        public void setMaxManagerHeldRequests(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.m_max_manager_held_requests_override = n;
        }

        public synchronized State get_state() {
            return this.m_state;
        }

        public void deactivate(boolean bl, boolean bl2) throws AdapterInactive {
            IDLEntity iDLEntity;
            if (bl2 && ServerManagerImpl.this.is_server_thread()) {
                throw new BAD_INV_ORDER(1330446342, CompletionStatus.COMPLETED_NO);
            }
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                if (this.m_state == State.INACTIVE) {
                    if (this.m_managed_active_requests == 0) {
                        throw new AdapterInactive();
                    }
                    if (bl2) {
                        this.wait_for_complete();
                    }
                    return;
                }
                this.m_state = State.INACTIVE;
                if (!bl2 && bl && this.m_managed_active_requests > 0) {
                    this.m_etherealize = true;
                    bl = false;
                }
                if (bl2 && this.m_managed_active_requests == 0) {
                    bl2 = false;
                }
            }
            if (this.m_hold_requests != null) {
                while (!this.m_hold_requests.isEmpty()) {
                    iDLEntity = (ServerRequest)this.m_hold_requests.removeFirst();
                    iDLEntity.server_cancel(ServerManagerImpl.createInactiveException());
                }
                ServerManagerImpl.this.m_holding_requests -= this.m_hold_requests.size();
            }
            if (bl2 || bl) {
                iDLEntity = this;
                synchronized (iDLEntity) {
                    if (bl2) {
                        this.wait_for_complete();
                    }
                    if (bl) {
                        this.complete_deactivate();
                    }
                }
            }
        }

        private void complete_deactivate() {
            ObjectAdapter[] objectAdapterArray = new ObjectAdapter[this.m_managed_adapters.size()];
            this.m_managed_adapters.toArray(objectAdapterArray);
            int n = 0;
            while (n < objectAdapterArray.length) {
                objectAdapterArray[n].etherealize(true);
                ++n;
            }
        }

        private void wait_for_complete() {
            try {
                while (this.m_managed_active_requests > 0 && this.m_state != State.ACTIVE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void discard_requests(boolean bl) throws AdapterInactive {
            IDLEntity iDLEntity;
            if (bl && ServerManagerImpl.this.is_server_thread()) {
                throw new BAD_INV_ORDER(1330446342, CompletionStatus.COMPLETED_NO);
            }
            AbstractCollection abstractCollection = null;
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                switch (this.m_state.value()) {
                    case 3: {
                        throw new AdapterInactive();
                    }
                    case 0: {
                        if (this.m_hold_requests == null || this.m_hold_requests.isEmpty()) break;
                        abstractCollection = this.m_hold_requests;
                        this.m_hold_requests = null;
                        break;
                    }
                }
                this.m_state = State.DISCARDING;
                if (abstractCollection == null || abstractCollection.isEmpty()) {
                    if (!bl) return;
                    this.wait_for_complete();
                    return;
                }
            }
            while (!abstractCollection.isEmpty()) {
                iDLEntity = (ServerRequest)((MergeStack)abstractCollection).removeFirst();
                iDLEntity.server_cancel(ServerManagerImpl.createDiscardException());
                --ServerManagerImpl.this.m_holding_requests;
            }
            if (!bl) return;
            iDLEntity = this;
            synchronized (iDLEntity) {
                this.wait_for_complete();
                return;
            }
        }

        public void hold_requests(boolean bl) throws AdapterInactive {
            if (bl && ServerManagerImpl.this.is_server_thread()) {
                throw new BAD_INV_ORDER(1330446342, CompletionStatus.COMPLETED_NO);
            }
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                if (this.m_state == State.INACTIVE) {
                    throw new AdapterInactive();
                }
                this.m_state = State.HOLDING;
                if (bl) {
                    this.wait_for_complete();
                }
            }
        }

        public void activate() throws AdapterInactive {
            MergeStack mergeStack = null;
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                switch (this.m_state.value()) {
                    case 3: {
                        throw new AdapterInactive();
                    }
                    case 1: {
                        return;
                    }
                    case 0: {
                        mergeStack = this.m_hold_requests;
                        this.m_hold_requests = null;
                    }
                }
                this.m_state = State.ACTIVE;
                this.notifyAll();
            }
            if (mergeStack != null && !mergeStack.isEmpty()) {
                Object object = ServerManagerImpl.this.m_sync_queue;
                synchronized (object) {
                    ServerManagerImpl.this.m_holding_requests -= mergeStack.size();
                    ServerManagerImpl.this.m_active_requests += mergeStack.size();
                    ServerManagerImpl.this.m_requests.append(mergeStack);
                    ServerManagerImpl.this.m_sync_queue.notifyAll();
                }
            }
        }

        boolean begin_request(ServerRequest serverRequest) {
            SystemException systemException = null;
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                switch (this.m_state.value()) {
                    case 1: {
                        ++this.m_managed_active_requests;
                        boolean bl = true;
                        return bl;
                    }
                    case 0: {
                        if (this.m_hold_requests == null || this.m_hold_requests.size() < (this.m_max_manager_held_requests_override < ServerManagerImpl.this.m_max_mgr_held_requests ? this.m_max_manager_held_requests_override : ServerManagerImpl.this.m_max_mgr_held_requests)) {
                            if (this.m_hold_requests == null) {
                                this.m_hold_requests = new MergeStack();
                            }
                            this.m_hold_requests.addLast(serverRequest);
                            ++ServerManagerImpl.this.m_holding_requests;
                            boolean bl = false;
                            return bl;
                        }
                    }
                    case 2: {
                        systemException = ServerManagerImpl.createDiscardException();
                        break;
                    }
                    case 3: {
                        systemException = ServerManagerImpl.createInactiveException();
                    }
                }
            }
            serverRequest.server_cancel(systemException);
            return false;
        }

        void complete_request(ServerRequest serverRequest) {
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                if (--this.m_managed_active_requests == 0) {
                    if (this.m_etherealize) {
                        this.complete_deactivate();
                    }
                    this.notifyAll();
                }
            }
        }

        synchronized void addManagedAdapter(ObjectAdapter objectAdapter) {
            this.m_managed_adapters.add(objectAdapter);
        }

        synchronized void removeManagedAdapter(ObjectAdapter objectAdapter) {
            this.m_managed_adapters.remove(objectAdapter);
        }
    }

    private class PoolThread
    extends Thread {
        private int m_id;

        private PoolThread(ThreadGroup threadGroup, int n) {
            super(threadGroup, "Thread pool thread #" + n);
            this.m_id = n;
        }

        public void run() {
            ServerManagerImpl.this.thread_pool_main(this.m_id);
        }
    }

    private class ChannelRecvRunner
    implements Runnable {
        private ServerChannel m_server_channel;

        public ChannelRecvRunner(ServerChannel serverChannel) {
            this.m_server_channel = serverChannel;
        }

        public void run() {
            if (ServerManagerImpl.this.wait_for_startup()) {
                this.m_server_channel.run_recv();
            }
        }
    }

    private class ProtocolRunner
    implements Runnable {
        private ServerProtocol m_server_protocol;

        public ProtocolRunner(ServerProtocol serverProtocol) {
            this.m_server_protocol = serverProtocol;
        }

        public void run() {
            if (ServerManagerImpl.this.wait_for_startup()) {
                this.m_server_protocol.run_listen();
            }
        }
    }
}

