/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.CORBA;

import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.UserException;
import org.omg.CORBA.ValueMember;
import org.openorb.test.CORBA.CORBATestCase;

public class TypeCodeTest
extends CORBATestCase {
    private ORB m_orb;
    private Any m_any;
    static /* synthetic */ Class class$org$openorb$test$CORBA$TypeCodeTest;

    public TypeCodeTest(String string) {
        super(string);
    }

    public void setUp() {
        super.setUp();
        this.m_orb = this.getORB();
        this.m_any = this.m_orb.create_any();
    }

    public void testTCPrimative() throws UserException {
        TypeCode typeCode = this.m_orb.get_primitive_tc(TCKind.tk_char);
        this.doTests(typeCode);
    }

    public void testTCString() throws UserException {
        TypeCode typeCode = this.m_orb.create_string_tc(1);
        this.doTests(typeCode);
    }

    public void testTCAlias() throws UserException {
        TypeCode typeCode = this.m_orb.create_alias_tc("IDL:Dummy:1.0", "ReallyDummy", this.m_orb.create_string_tc(1));
        this.doTests(typeCode);
    }

    public void testTCArray() throws UserException {
        TypeCode typeCode = this.m_orb.create_array_tc(3, this.m_orb.create_wstring_tc(1));
        this.doTests(typeCode);
    }

    public void testTCEnum() throws UserException {
        TypeCode typeCode = this.m_orb.create_enum_tc("IDL:Dummy:1.0", "ReallyDummy", new String[0]);
        this.doTests(typeCode);
    }

    public void testTCFixed() throws UserException {
        TypeCode typeCode = this.m_orb.create_fixed_tc((short)5, (short)2);
        this.doTests(typeCode);
    }

    public void testTCObject() throws UserException {
        TypeCode typeCode = this.m_orb.get_primitive_tc(TCKind.tk_objref);
        this.doTests(typeCode);
    }

    public void testTCStruct() throws UserException {
        TypeCode typeCode = this.m_orb.create_struct_tc("IDL:Dummy:1.0", "ReallyDummy", new StructMember[0]);
        this.doTests(typeCode);
    }

    public void testTCUnion() throws UserException {
        TypeCode typeCode = this.m_orb.create_union_tc("IDL:Dummy:1.0", "ReallyDummy", this.m_orb.get_primitive_tc(TCKind.tk_short), new UnionMember[0]);
        this.doTests(typeCode);
    }

    public void testTCValue() throws UserException {
        TypeCode typeCode = this.m_orb.create_value_tc("IDL:Dummy:1.0", "ReallyDummy", (short)0, this.m_orb.get_primitive_tc(TCKind.tk_null), new ValueMember[0]);
        this.doTests(typeCode);
    }

    public void testTCRecursive() throws UserException {
        TypeCode typeCode = this.m_orb.create_recursive_tc("IDL:Dummy:1.0");
        TypeCode typeCode2 = this.m_orb.create_sequence_tc(1, typeCode);
        StructMember[] structMemberArray = new StructMember[]{new StructMember("backref", typeCode2, null)};
        TypeCode typeCode3 = this.m_orb.create_struct_tc("IDL:Dummy:1.0", "ReallyDummy", structMemberArray);
        Assert.assertTrue("Recursive typecode not properly formed", typeCode2.content_type() == typeCode3);
        typeCode.hashCode();
        typeCode.equals(typeCode);
        try {
            typeCode.equivalent(this.m_orb.get_primitive_tc(TCKind.tk_char));
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
            // empty catch block
        }
        try {
            typeCode.equal(this.m_orb.get_primitive_tc(TCKind.tk_char));
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
            // empty catch block
        }
        try {
            typeCode.get_compact_typecode();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
            // empty catch block
        }
        try {
            typeCode.id();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.name();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        try {
            typeCode.length();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        try {
            typeCode.member_count();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        try {
            typeCode.member_name(0);
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        catch (Bounds bounds) {
            Assert.fail("Unexpected exception caught: " + bounds);
        }
        try {
            typeCode.member_type(0);
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        catch (Bounds bounds) {
            Assert.fail("Unexpected exception caught: " + bounds);
        }
        try {
            typeCode.member_label(0);
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        catch (Bounds bounds) {
            Assert.fail("Unexpected exception caught: " + bounds);
        }
        try {
            typeCode.default_index();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        try {
            typeCode.discriminator_type();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        try {
            typeCode.content_type();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        try {
            typeCode.fixed_digits();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        try {
            typeCode.fixed_scale();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        try {
            typeCode.type_modifier();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        try {
            typeCode.member_visibility(0);
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
        try {
            typeCode.concrete_base_type();
            Assert.fail("expected exception");
        }
        catch (BAD_TYPECODE bAD_TYPECODE) {
        }
        catch (BadKind badKind) {
            Assert.fail("Unexpected exception caught: " + badKind);
        }
    }

    private void doTests(TypeCode typeCode) throws UserException {
        typeCode.equivalent(this.m_orb.get_primitive_tc(TCKind.tk_char));
        typeCode.equal(this.m_orb.get_primitive_tc(TCKind.tk_char));
        typeCode.get_compact_typecode();
        typeCode.hashCode();
        try {
            typeCode.id();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.name();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.length();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.member_count();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.member_name(0);
        }
        catch (BadKind badKind) {
        }
        catch (Bounds bounds) {
            // empty catch block
        }
        try {
            typeCode.member_type(0);
        }
        catch (BadKind badKind) {
        }
        catch (Bounds bounds) {
            // empty catch block
        }
        try {
            typeCode.member_label(0);
        }
        catch (BadKind badKind) {
        }
        catch (Bounds bounds) {
            // empty catch block
        }
        try {
            typeCode.default_index();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.discriminator_type();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.content_type();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.fixed_digits();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.fixed_scale();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.type_modifier();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        try {
            typeCode.member_visibility(0);
        }
        catch (BadKind badKind) {
        }
        catch (Bounds bounds) {
            // empty catch block
        }
        try {
            typeCode.concrete_base_type();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$CORBA$TypeCodeTest == null ? (class$org$openorb$test$CORBA$TypeCodeTest = TypeCodeTest.class$("org.openorb.test.CORBA.TypeCodeTest")) : class$org$openorb$test$CORBA$TypeCodeTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

