/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.configuration.merged;

import java.util.HashSet;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.excalibur.configuration.ConfigurationUtil;

public class ConfigurationMerger {
    public static Configuration merge(Configuration layer, Configuration base) throws ConfigurationException {
        DefaultConfiguration merged = new DefaultConfiguration(base.getName(), "Merged [layer: " + layer.getLocation() + ", base: " + base.getLocation() + "]");
        ConfigurationMerger.copyAttributes(base, merged);
        ConfigurationMerger.copyAttributes(layer, merged);
        ConfigurationMerger.mergeChildren(layer, base, merged);
        merged.setValue(ConfigurationMerger.getValue(layer, base));
        merged.makeReadOnly();
        return merged;
    }

    private static void mergeChildren(Configuration layer, Configuration base, DefaultConfiguration merged) throws ConfigurationException {
        Configuration[] lc = layer.getChildren();
        Configuration[] bc = base.getChildren();
        HashSet<Configuration> baseUsed = new HashSet<Configuration>();
        int i = 0;
        while (i < lc.length) {
            Configuration mergeWith = ConfigurationMerger.getMergePartner(lc[i], layer, base);
            if (null == mergeWith) {
                merged.addChild(lc[i]);
            } else {
                merged.addChild(ConfigurationMerger.merge(lc[i], mergeWith));
                baseUsed.add(mergeWith);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < bc.length) {
            if (!baseUsed.contains(bc[i2])) {
                merged.addChild(bc[i2]);
            }
            ++i2;
        }
    }

    private static Configuration getMergePartner(Configuration toMerge, Configuration layer, Configuration base) throws ConfigurationException {
        if (toMerge.getAttributeAsBoolean("excalibur-configuration:merge", false)) {
            String keyAttribute = toMerge.getAttribute("excalibur-configuration:key-attribute", null);
            String keyvalue = keyAttribute == null ? null : toMerge.getAttribute(keyAttribute);
            Configuration[] layerKids = ConfigurationUtil.match(layer, toMerge.getName(), keyAttribute, keyvalue);
            Configuration[] baseKids = ConfigurationUtil.match(base, toMerge.getName(), keyAttribute, keyvalue);
            if (layerKids.length == 1 && baseKids.length == 1) {
                return baseKids[0];
            }
            throw new ConfigurationException("Unable to merge configuration item, multiple matches on child or base [name: " + toMerge.getName() + "]");
        }
        return null;
    }

    private static String getValue(Configuration layer, Configuration base) {
        try {
            return layer.getValue();
        }
        catch (ConfigurationException e) {
            return base.getValue(null);
        }
    }

    private static void copyAttributes(Configuration source, DefaultConfiguration dest) throws ConfigurationException {
        String[] names = source.getAttributeNames();
        int i = 0;
        while (i < names.length) {
            if (!names[i].startsWith("excalibur-configuration:")) {
                dest.setAttribute(names[i], source.getAttribute(names[i]));
            }
            ++i;
        }
    }
}

