/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.administration.net;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.JMSException;
import org.exolab.jms.administration.AdminConnection;
import org.exolab.jms.administration.JmsAdminServerIfc;
import org.exolab.jms.client.net.SharedORB;
import org.exolab.jms.net.orb.ORB;
import org.exolab.jms.net.proxy.Proxy;
import org.exolab.jms.net.registry.Registry;
import org.exolab.jms.server.net.RemoteJmsAdminConnectionIfc;
import org.exolab.jms.server.net.RemoteJmsAdminServerIfc;

public class JmsAdminConnectionImpl
implements JmsAdminServerIfc,
AdminConnection {
    private RemoteJmsAdminConnectionIfc _connection;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JmsAdminConnectionImpl(String url, String username, String password) throws JMSException {
        Registry registry;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.exolab.jms.net.orb.provider.uri", url);
        if (username != null) {
            properties.put("org.exolab.jms.net.orb.security.principal", username);
        }
        if (password != null) {
            properties.put("org.exolab.jms.net.orb.security.credentials", password);
        }
        try {
            ORB orb = SharedORB.getInstance();
            registry = orb.getRegistry(properties);
        }
        catch (RemoteException exception) {
            JMSException error = new JMSException("Failed to get registry service for URL: " + url);
            error.setLinkedException((Exception)exception);
            throw error;
        }
        RemoteJmsAdminServerIfc admin = null;
        try {
            try {
                admin = (RemoteJmsAdminServerIfc)registry.lookup("admin");
                this._connection = admin.createConnection(username, password);
            }
            catch (NotBoundException exception) {
                throw new JMSException("Administration server is not bound in the registry for URL: " + url);
            }
            catch (RemoteException exception) {
                JMSException error = new JMSException("Failed to lookup OpenJMS administration server at URL: " + url);
                error.setLinkedException((Exception)exception);
                throw error;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (admin instanceof Proxy) {
                ((Proxy)admin).disposeProxy();
            }
            if (!(registry instanceof Proxy)) throw throwable;
            ((Proxy)registry).disposeProxy();
            throw throwable;
        }
        if (admin instanceof Proxy) {
            ((Proxy)admin).disposeProxy();
        }
        if (!(registry instanceof Proxy)) return;
        ((Proxy)registry).disposeProxy();
    }

    public boolean addDurableConsumer(String topic, String name) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.addDurableConsumer(topic, name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean removeDurableConsumer(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.removeDurableConsumer(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean durableConsumerExists(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.durableConsumerExists(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public Vector getDurableConsumers(String topic) throws JMSException {
        Vector result = null;
        try {
            result = this._connection.getDurableConsumers(topic);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean unregisterConsumer(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.unregisterConsumer(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean isConnected(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.isConnected(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean addDestination(String destination, Boolean queue) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.addDestination(destination, queue);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean removeDestination(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.removeDestination(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean destinationExists(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.destinationExists(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public Vector getAllDestinations() throws JMSException {
        Vector result = null;
        try {
            result = this._connection.getAllDestinations();
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public int getDurableConsumerMessageCount(String topic, String name) throws JMSException {
        int result = 0;
        try {
            result = this._connection.getDurableConsumerMessageCount(topic, name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public int getQueueMessageCount(String queue) throws JMSException {
        int result = 0;
        try {
            result = this._connection.getQueueMessageCount(queue);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public int purgeMessages() throws JMSException {
        int result = 0;
        try {
            result = this._connection.purgeMessages();
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public void stopServer() throws JMSException {
        try {
            this._connection.stopServer();
        }
        catch (Exception exception) {
            this.raise(exception);
        }
    }

    public void close() {
        if (this._connection instanceof Proxy) {
            ((Proxy)this._connection).disposeProxy();
            this._connection = null;
        }
    }

    public boolean addUser(String username, String password) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.addUser(username, password);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public Vector getAllUsers() throws JMSException {
        Vector result = null;
        try {
            result = this._connection.getAllUsers();
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean removeUser(String username) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.removeUser(username);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean changePassword(String username, String password) throws JMSException {
        boolean result = false;
        try {
            result = this._connection.changePassword(username, password);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    private void raise(Exception exception) throws JMSException {
        if (exception instanceof JMSException) {
            throw (JMSException)exception;
        }
        JMSException error = new JMSException(exception.getMessage());
        error.setLinkedException(exception);
        throw error;
    }
}

