/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsSession;

class JmsConnectionConsumer
implements ConnectionConsumer,
MessageListener {
    private Session _session;
    private MessageConsumer _consumer;
    private ServerSessionPool _pool;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$JmsConnectionConsumer == null ? (class$org$exolab$jms$client$JmsConnectionConsumer = JmsConnectionConsumer.class$("org.exolab.jms.client.JmsConnectionConsumer")) : class$org$exolab$jms$client$JmsConnectionConsumer));
    static /* synthetic */ Class class$org$exolab$jms$client$JmsConnectionConsumer;

    public JmsConnectionConsumer(Connection connection, Destination destination, ServerSessionPool pool, String selector, int maxMessages) throws JMSException {
        this(connection, destination, null, pool, selector, maxMessages);
    }

    public JmsConnectionConsumer(Connection connection, Destination destination, String subscriptionName, ServerSessionPool pool, String selector, int maxMessages) throws JMSException {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 'destination' is null");
        }
        if (pool == null) {
            throw new IllegalArgumentException("Argument 'pool' is null");
        }
        if (maxMessages <= 0) {
            throw new IllegalArgumentException("Argument 'maxMessages' must be > 0");
        }
        this._pool = pool;
        this._session = connection.createSession(false, 2);
        this._consumer = subscriptionName == null ? this._session.createConsumer(destination, selector, false) : this._session.createDurableSubscriber((Topic)destination, subscriptionName, selector, false);
        this._consumer.setMessageListener((MessageListener)this);
    }

    public ServerSessionPool getServerSessionPool() {
        return this._pool;
    }

    public void close() throws JMSException {
        try {
            this._consumer.close();
            this._session.close();
            Object var2_1 = null;
            this._pool = null;
            this._consumer = null;
            this._session = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._pool = null;
            this._consumer = null;
            this._session = null;
            throw throwable;
        }
    }

    public void onMessage(Message message) {
        try {
            ServerSession serverSession = this._pool.getServerSession();
            JmsSession session = (JmsSession)serverSession.getSession();
            message.acknowledge();
            session.addMessage(message);
            serverSession.start();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

