/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.exolab.jms.client.JmsConnection;
import org.exolab.jms.client.JmsQueueConnection;
import org.exolab.jms.client.JmsServerStubIfc;
import org.exolab.jms.client.JmsTopicConnection;

public class JmsConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
ExceptionListener,
Externalizable,
Referenceable {
    private String _className;
    private Map _properties;
    private Map _environment;
    private JmsServerStubIfc _proxy;
    private List _connections = new ArrayList();
    private static final long serialVersionUID = 3L;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$exolab$jms$client$JmsConnectionFactoryBuilder;
    static /* synthetic */ Class class$org$exolab$jms$client$JmsConnectionFactory;

    public JmsConnectionFactory() {
    }

    public JmsConnectionFactory(String className, Map properties, Map environment) {
        if (className == null) {
            throw new IllegalArgumentException("Argument 'className' is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Argument 'properties' is null");
        }
        this._className = className;
        this._properties = properties;
        this._environment = environment;
    }

    public synchronized JmsServerStubIfc getProxy() throws JMSException {
        if (this._proxy == null) {
            try {
                Class[] argTypes = new Class[]{class$java$util$Map == null ? (class$java$util$Map = JmsConnectionFactory.class$("java.util.Map")) : class$java$util$Map, class$java$util$Map == null ? (class$java$util$Map = JmsConnectionFactory.class$("java.util.Map")) : class$java$util$Map};
                Object[] args = new Object[]{this._properties, this._environment};
                Class<?> factoryClass = Class.forName(this._className);
                Constructor<?> constructor = factoryClass.getDeclaredConstructor(argTypes);
                this._proxy = (JmsServerStubIfc)constructor.newInstance(args);
                this._proxy.setExceptionListener(this);
            }
            catch (InvocationTargetException exception) {
                if (exception.getTargetException() != null) {
                    throw new JMSException("Failed to create proxy: " + exception.getTargetException());
                }
                throw new JMSException("Failed to create proxy: " + exception);
            }
            catch (Exception exception) {
                throw new JMSException("Failed to create proxy: " + exception);
            }
        }
        return this._proxy;
    }

    public void onException(JMSException exception) {
        JmsConnection[] connections = this.getConnections();
        int i = 0;
        while (i < connections.length) {
            JmsConnection connection = connections[i];
            connection.notifyExceptionListener(exception);
            ++i;
        }
        JmsConnectionFactory jmsConnectionFactory = this;
        synchronized (jmsConnectionFactory) {
            this._connections.clear();
            this._proxy = null;
        }
    }

    public Reference getReference() {
        Reference reference = new Reference(this.getClass().getName(), new StringRefAddr("serverClass", this._className), (class$org$exolab$jms$client$JmsConnectionFactoryBuilder == null ? (class$org$exolab$jms$client$JmsConnectionFactoryBuilder = JmsConnectionFactory.class$("org.exolab.jms.client.JmsConnectionFactoryBuilder")) : class$org$exolab$jms$client$JmsConnectionFactoryBuilder).getName(), null);
        Iterator iterator = this._properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            reference.add(new StringRefAddr(key, value));
        }
        return reference;
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(3L);
        stream.writeObject(this._className);
        stream.writeObject(this._properties);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 3L) {
            throw new IOException((class$org$exolab$jms$client$JmsConnectionFactory == null ? (class$org$exolab$jms$client$JmsConnectionFactory = JmsConnectionFactory.class$("org.exolab.jms.client.JmsConnectionFactory")) : class$org$exolab$jms$client$JmsConnectionFactory).getName() + " with version " + version + " is not supported.");
        }
        this._className = (String)stream.readObject();
        this._properties = (Map)stream.readObject();
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        JmsConnection connection = new JmsConnection(this, null, userName, password);
        this.addConnection(connection);
        return connection;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        JmsQueueConnection connection = new JmsQueueConnection(this, null, userName, password);
        this.addConnection(connection);
        return connection;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        JmsTopicConnection connection = new JmsTopicConnection(this, null, userName, password);
        this.addConnection(connection);
        return connection;
    }

    protected synchronized void addConnection(JmsConnection connection) {
        this._connections.add(connection);
    }

    protected synchronized void removeConnection(JmsConnection connection) {
        this._connections.remove(connection);
    }

    protected synchronized JmsConnection[] getConnections() {
        return this._connections.toArray(new JmsConnection[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

