/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.Destination;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.exolab.jms.message.DestinationImpl;

public abstract class JmsDestination
extends DestinationImpl
implements Destination,
Externalizable,
Referenceable {
    private boolean persistent_ = false;
    static final String TEMP_QUEUE_PREFIX = "tempqueue:";
    static final String TEMP_TOPIC_PREFIX = "temptopic:";
    static final long serialVersionUID = 1L;

    public JmsDestination() {
    }

    protected JmsDestination(String name) {
        super(name);
    }

    public String getName() {
        return this.getDestination();
    }

    public void setPersistent(boolean flag) {
        this.persistent_ = flag;
    }

    public boolean getPersistent() {
        return this.persistent_;
    }

    public String toString() {
        return this.getDestination() + "-" + this.persistent_;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(1L);
        stream.writeBoolean(this.persistent_);
        super.writeExternal(stream);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 1L) {
            throw new IOException("JmsDestination with version " + version + " is not supported.");
        }
        this.persistent_ = stream.readBoolean();
        super.readExternal(stream);
    }

    public boolean isTemporaryDestination() {
        boolean result = false;
        if (this.getDestination().startsWith(TEMP_QUEUE_PREFIX) || this.getDestination().startsWith(TEMP_TOPIC_PREFIX)) {
            result = true;
        }
        return result;
    }

    public static boolean isTemporaryDestination(DestinationImpl destination) {
        boolean result = false;
        if (destination.getDestination().startsWith(TEMP_QUEUE_PREFIX) || destination.getDestination().startsWith(TEMP_TOPIC_PREFIX)) {
            result = true;
        }
        return result;
    }

    public abstract Reference getReference() throws NamingException;
}

