/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.rmi.RemoteException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsSession;
import org.exolab.jms.message.MessageImpl;

class JmsMessageConsumer
implements JmsMessageListener,
MessageConsumer {
    private JmsSession _session = null;
    private final long _consumerId;
    private final Destination _destination;
    private MessageListener _listener = null;
    private String _selector = null;
    private volatile boolean _closed = false;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$JmsMessageConsumer == null ? (class$org$exolab$jms$client$JmsMessageConsumer = JmsMessageConsumer.class$("org.exolab.jms.client.JmsMessageConsumer")) : class$org$exolab$jms$client$JmsMessageConsumer));
    static /* synthetic */ Class class$org$exolab$jms$client$JmsMessageConsumer;

    public JmsMessageConsumer(JmsSession session, long consumerId, Destination destination, String selector) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 'session' is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 'destination' is null");
        }
        this._session = session;
        this._consumerId = consumerId;
        this._destination = destination;
        this._selector = selector;
    }

    public String getMessageSelector() {
        return this._selector;
    }

    public MessageListener getMessageListener() {
        return this._listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (listener != null) {
            if (this._listener == null) {
                this._listener = listener;
                this._session.setMessageListener(this);
            } else {
                this._listener = listener;
            }
        } else if (this._listener != null) {
            this._session.removeMessageListener(this);
            this._listener = listener;
        }
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    public Message receive(long timeout) throws JMSException {
        this.checkReceive();
        return this._session.receive(this._consumerId, timeout);
    }

    public Message receiveNoWait() throws JMSException {
        this.checkReceive();
        return this._session.receiveNoWait(this._consumerId);
    }

    public synchronized void close() throws JMSException {
        if (!this._closed) {
            try {
                this._closed = true;
                this._session.removeConsumer(this);
                this.notifyAll();
                Object var2_1 = null;
                this._listener = null;
                this._session = null;
                this._selector = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this._listener = null;
                this._session = null;
                this._selector = null;
                throw throwable;
            }
        }
    }

    public boolean onMessage(MessageImpl message) {
        boolean delivered = false;
        try {
            if (this._listener != null) {
                this._listener.onMessage((Message)message);
                delivered = true;
            } else {
                _log.error((Object)"NessageListener no longer registered");
            }
        }
        catch (Throwable exception) {
            _log.error((Object)"MessageListener threw exception", exception);
        }
        return delivered;
    }

    public void onMessageAvailable() throws RemoteException {
    }

    protected Destination getDestination() {
        return this._destination;
    }

    protected long getConsumerId() {
        return this._consumerId;
    }

    protected JmsSession getSession() {
        return this._session;
    }

    private void checkReceive() throws JMSException {
        if (this._listener != null) {
            throw new JMSException("Can't receive when listener defined");
        }
        if (this._closed) {
            throw new JMSException("Can't receive when session closed");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

