/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsConnection;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsMessageConsumer;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsMessageProducer;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsQueueBrowser;
import org.exolab.jms.client.JmsTemporaryDestination;
import org.exolab.jms.client.JmsTemporaryQueue;
import org.exolab.jms.client.JmsTemporaryTopic;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.client.JmsTopicSubscriber;
import org.exolab.jms.message.BytesMessageImpl;
import org.exolab.jms.message.MapMessageImpl;
import org.exolab.jms.message.MessageConverter;
import org.exolab.jms.message.MessageConverterFactory;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.message.MessageSessionIfc;
import org.exolab.jms.message.ObjectMessageImpl;
import org.exolab.jms.message.StreamMessageImpl;
import org.exolab.jms.message.TextMessageImpl;
import org.exolab.jms.server.ServerSession;

class JmsSession
implements Session,
JmsMessageListener,
MessageSessionIfc {
    private JmsConnection _connection;
    private ServerSession _session = null;
    private volatile boolean _closed = false;
    private boolean _closing = false;
    private final Object _closeLock = new Object();
    private boolean _stopped = true;
    private final int _ackMode;
    private HashMap _consumers = new HashMap();
    private List _producers = new ArrayList();
    private List _messagesToSend = new ArrayList();
    private MessageListener _listener = null;
    private Vector _messageCache = new Vector();
    private final Object _receiveLock = new Object();
    private long _blockingConsumer = -1L;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$JmsSession == null ? (class$org$exolab$jms$client$JmsSession = JmsSession.class$("org.exolab.jms.client.JmsSession")) : class$org$exolab$jms$client$JmsSession));
    static /* synthetic */ Class class$org$exolab$jms$client$JmsSession;

    public JmsSession(JmsConnection connection, boolean transacted, int ackMode) throws JMSException {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        this._connection = connection;
        this._ackMode = transacted ? 0 : ackMode;
        this._session = connection.getServerConnection().createSession(this._ackMode, transacted);
        this._session.setMessageListener(this);
        if (!connection.isStopped()) {
            this.start();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.ensureOpen();
        return new BytesMessageImpl();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.ensureOpen();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.ensureOpen();
        return new MessageImpl();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.ensureOpen();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.ensureOpen();
        ObjectMessageImpl result = new ObjectMessageImpl();
        result.setObject(object);
        return result;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.ensureOpen();
        return new StreamMessageImpl();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.ensureOpen();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.ensureOpen();
        TextMessageImpl result = new TextMessageImpl();
        result.setText(text);
        return result;
    }

    public boolean getTransacted() throws JMSException {
        this.ensureOpen();
        return this._ackMode == 0;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.ensureOpen();
        return this._ackMode;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.ensureOpen();
        return new JmsMessageProducer(this, destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        long consumerId = this.allocateConsumer(destination, messageSelector, noLocal);
        JmsMessageConsumer consumer = new JmsMessageConsumer(this, consumerId, destination, messageSelector);
        this.addConsumer(consumer);
        return consumer;
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.ensureOpen();
        if (queueName == null || queueName.length() <= 0) {
            throw new JMSException("Cannot create a queue with null or empty name");
        }
        JmsQueue queue = new JmsQueue(queueName);
        return queue;
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.ensureOpen();
        if (topicName == null || topicName.length() <= 0) {
            throw new JMSException("Invalid or null topic name specified");
        }
        JmsTopic topic = new JmsTopic(topicName);
        return topic;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.ensureOpen();
        if (topic == null) {
            throw new InvalidDestinationException("Cannot create durable subscriber: argument 'topic' is  null");
        }
        if (name == null || name.trim().length() == 0) {
            throw new JMSException("Invalid subscription name specified");
        }
        if (((JmsTopic)topic).isTemporaryDestination()) {
            throw new InvalidDestinationException("Cannot create a durable subscriber for a temporary topic");
        }
        long consumerId = this._session.createDurableConsumer((JmsTopic)topic, name, messageSelector, noLocal);
        JmsTopicSubscriber subscriber = new JmsTopicSubscriber(this, consumerId, topic, messageSelector, noLocal);
        this.addConsumer(subscriber);
        return subscriber;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.ensureOpen();
        if (!(queue instanceof JmsQueue)) {
            throw new InvalidDestinationException("Cannot create QueueBrowser for destination=" + queue);
        }
        JmsQueue dest = (JmsQueue)queue;
        if (!this.checkForValidTemporaryDestination(dest)) {
            throw new InvalidDestinationException("Cannot create a queue browser for a temporary queue that is not bound to this connection");
        }
        long consumerId = this._session.createBrowser(dest, messageSelector);
        JmsQueueBrowser browser = new JmsQueueBrowser(this, consumerId, queue, messageSelector);
        this.addConsumer(browser);
        return browser;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.ensureOpen();
        return JmsTemporaryQueue.create(this.getConnection());
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.ensureOpen();
        return JmsTemporaryTopic.create(this.getConnection());
    }

    public void unsubscribe(String name) throws JMSException {
        this.ensureOpen();
        this._session.unsubscribe(name);
    }

    public void commit() throws JMSException {
        this.ensureOpen();
        this.ensureTransactional();
        this.getServerSession().send(this._messagesToSend);
        this._messagesToSend.clear();
        this.getServerSession().commit();
    }

    public void rollback() throws JMSException {
        this.ensureOpen();
        this.ensureTransactional();
        this._messagesToSend.clear();
        this.getServerSession().rollback();
    }

    public void close() throws JMSException {
        boolean closing;
        Object object = this._closeLock;
        synchronized (object) {
            closing = this._closing;
            this._closing = true;
        }
        if (!closing) {
            this.stop();
            Object object2 = this._receiveLock;
            synchronized (object2) {
                this._receiveLock.notifyAll();
            }
            this._closed = true;
            JmsMessageProducer[] producers = this._producers.toArray(new JmsMessageProducer[0]);
            int i = 0;
            while (i < producers.length) {
                JmsMessageProducer producer = producers[i];
                producer.close();
                ++i;
            }
            JmsMessageConsumer[] consumers = this._consumers.values().toArray(new JmsMessageConsumer[0]);
            int i2 = 0;
            while (i2 < consumers.length) {
                JmsMessageConsumer consumer = consumers[i2];
                consumer.close();
                ++i2;
            }
            this._connection.removeSession(this);
            this._connection = null;
            this._messagesToSend.clear();
            this.getServerSession().close();
            this._session = null;
        }
    }

    public void recover() throws JMSException {
        this.ensureOpen();
        if (this.getTransacted()) {
            throw new IllegalStateException("Cannot recover from a transacted session");
        }
        this.getServerSession().recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.ensureOpen();
        return this._listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.ensureOpen();
        this._listener = listener;
    }

    public void run() {
        try {
            try {
                while (!this._messageCache.isEmpty()) {
                    Message message = (Message)this._messageCache.remove(0);
                    this._listener.onMessage(message);
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Error in the Session.run()", (Throwable)exception);
                Object var3_4 = null;
                this._messageCache.clear();
            }
            Object var3_3 = null;
            this._messageCache.clear();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this._messageCache.clear();
            throw throwable;
        }
    }

    public void setMessageListener(JmsMessageConsumer listener) throws JMSException {
        this.ensureOpen();
        this.setAsynchronous(listener.getConsumerId(), true);
    }

    public void removeMessageListener(JmsMessageConsumer listener) throws JMSException {
        this.ensureOpen();
        this.setAsynchronous(listener.getConsumerId(), false);
    }

    public void start() throws JMSException {
        this.ensureOpen();
        Object object = this._closeLock;
        synchronized (object) {
            if (this._stopped && !this._closing) {
                this.getServerSession().start();
                this._stopped = false;
            }
        }
    }

    public void stop() throws JMSException {
        this.ensureOpen();
        Object object = this._closeLock;
        synchronized (object) {
            if (!this._stopped) {
                this.getServerSession().stop();
                this._stopped = true;
            }
        }
    }

    public void acknowledgeMessage(Message message) throws JMSException {
        this.ensureOpen();
        if (this._ackMode == 2) {
            MessageImpl impl = (MessageImpl)message;
            this.getServerSession().acknowledgeMessage(impl.getConsumerId(), impl.getAckMessageID());
        }
    }

    public void setAsynchronous(long consumerId, boolean enable) throws JMSException {
        this.ensureOpen();
        this.getServerSession().setAsynchronous(consumerId, enable);
    }

    public boolean onMessage(MessageImpl message) {
        boolean delivered = false;
        message.setJMSXRcvTimestamp(System.currentTimeMillis());
        long consumerId = message.getConsumerId();
        JmsMessageConsumer consumer = (JmsMessageConsumer)this._consumers.get(new Long(consumerId));
        message.setSession(this);
        if (consumer != null) {
            if (this._listener != null) {
                try {
                    this._listener.onMessage((Message)message);
                    delivered = true;
                }
                catch (Throwable exception) {
                    _log.error((Object)"MessageListener threw exception", exception);
                }
            } else {
                delivered = consumer.onMessage(message);
            }
        } else {
            _log.error((Object)"Received a message for an inactive consumer");
        }
        return delivered;
    }

    public void onMessageAvailable() {
        this.notifyConsumer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageImpl receive(long consumerId, long timeout) throws JMSException {
        MessageImpl message = null;
        this.ensureOpen();
        Object object = this._receiveLock;
        synchronized (object) {
            if (this._blockingConsumer != -1L) {
                throw new IllegalStateException("Session cannot be accessed concurrently");
            }
            this._blockingConsumer = consumerId;
            long start = timeout != 0L ? System.currentTimeMillis() : 0L;
            try {
                while (message == null && !this.isClosed()) {
                    message = timeout == 0L ? this.getServerSession().receive(consumerId, 0L) : this.getServerSession().receive(consumerId, timeout);
                    if (message != null || this.isClosed()) continue;
                    try {
                        if (timeout == 0L) {
                            this._receiveLock.wait();
                            continue;
                        }
                        long elapsed = System.currentTimeMillis() - start;
                        if (elapsed >= timeout) break;
                        this._receiveLock.wait(timeout -= elapsed);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                if (message != null) {
                    message.setSession(this);
                    if (this._ackMode == 1 || this._ackMode == 3) {
                        this.getServerSession().acknowledgeMessage(message.getConsumerId(), message.getMessageId().toString());
                    }
                }
                Object var12_8 = null;
                this._blockingConsumer = -1L;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                this._blockingConsumer = -1L;
                throw throwable;
            }
            return message;
        }
    }

    public MessageImpl receiveNoWait(long consumerId) throws JMSException {
        this.ensureOpen();
        MessageImpl message = this.getServerSession().receiveNoWait(consumerId);
        if (message != null) {
            message.setSession(this);
            if (this._ackMode == 1 || this._ackMode == 3) {
                this.getServerSession().acknowledgeMessage(message.getConsumerId(), message.getMessageId().toString());
            }
        }
        return message;
    }

    public List browse(long consumerId, int count) throws JMSException {
        this.ensureOpen();
        return this.getServerSession().browse(consumerId, count);
    }

    protected void sendMessage(Message message) throws JMSException {
        if (this.getTransacted()) {
            if (message instanceof MessageImpl) {
                try {
                    message = (Message)((MessageImpl)message).clone();
                }
                catch (CloneNotSupportedException error) {
                    throw new JMSException(error.getMessage());
                }
            } else {
                message = this.convert(message);
            }
            this._messagesToSend.add(message);
        } else {
            if (!(message instanceof MessageImpl)) {
                message = this.convert(message);
            }
            this.getServerSession().send((MessageImpl)message);
        }
    }

    protected ServerSession getServerSession() {
        return this._session;
    }

    protected JmsConnection getConnection() {
        return this._connection;
    }

    protected long allocateConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        this.ensureOpen();
        if (!(destination instanceof JmsDestination)) {
            throw new InvalidDestinationException("Cannot create MessageConsumer for destination=" + destination);
        }
        JmsDestination dest = (JmsDestination)destination;
        if (!this.checkForValidTemporaryDestination(dest)) {
            throw new InvalidDestinationException("Trying to create a MessageConsumer for a temporary destination that is not bound to this connection");
        }
        return this._session.createConsumer(dest, selector, noLocal);
    }

    protected boolean checkForValidTemporaryDestination(JmsDestination destination) {
        boolean result = false;
        if (destination.isTemporaryDestination()) {
            JmsTemporaryDestination temp = (JmsTemporaryDestination)((Object)destination);
            if (temp.validForConnection(this.getConnection())) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    protected void addConsumer(JmsMessageConsumer consumer) {
        this._consumers.put(new Long(consumer.getConsumerId()), consumer);
    }

    protected void removeConsumer(JmsMessageConsumer consumer) throws JMSException {
        long consumerId = consumer.getConsumerId();
        try {
            this._session.closeConsumer(consumerId);
            Object var5_3 = null;
            this._consumers.remove(new Long(consumerId));
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this._consumers.remove(new Long(consumerId));
            throw throwable;
        }
    }

    protected void addProducer(JmsMessageProducer producer) {
        this._producers.add(producer);
    }

    protected void removeProducer(JmsMessageProducer producer) {
        this._producers.remove(producer);
    }

    protected final boolean isClosed() {
        return this._closed;
    }

    protected void addMessage(Message message) {
        this._messageCache.add(message);
    }

    protected void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot perform operation - session has been closed");
        }
    }

    private void ensureTransactional() throws IllegalStateException {
        if (this._ackMode != 0) {
            throw new IllegalStateException("Cannot perform operatiorn - session is not transactional");
        }
    }

    private void notifyConsumer() {
        Object object = this._receiveLock;
        synchronized (object) {
            this._receiveLock.notifyAll();
        }
    }

    private Message convert(Message message) throws JMSException {
        MessageConverter converter = MessageConverterFactory.create(message);
        return converter.convert(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

