/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;
import javax.naming.Reference;
import org.exolab.jms.client.JmsConnection;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTemporaryDestination;
import org.exolab.jms.common.uuid.UUID;

public class JmsTemporaryQueue
extends JmsQueue
implements TemporaryQueue,
JmsTemporaryDestination {
    static final long serialVersionUID = 2L;
    private long _connectionId;
    private transient JmsConnection _connection = null;

    public JmsTemporaryQueue() {
    }

    private JmsTemporaryQueue(JmsConnection connection) {
        super("tempqueue:" + UUID.next());
        this._connection = connection;
        this._connectionId = connection.getConnectionId();
    }

    public void delete() throws JMSException {
        this._connection.deleteTemporaryDestination(this);
    }

    public JmsConnection getOwningConnection() {
        return this._connection;
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    public Reference getReference() {
        return null;
    }

    public boolean validForConnection(JmsConnection connection) {
        boolean result = false;
        if (connection != null && connection.getConnectionId() == this._connectionId) {
            result = true;
        }
        return result;
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(2L);
        stream.writeLong(this._connectionId);
        super.writeExternal(stream);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 2L) {
            throw new IOException("JmsTemporaryQueue with version " + version + " is not supported.");
        }
        this._connectionId = stream.readLong();
        super.readExternal(stream);
    }

    public static TemporaryQueue create(JmsConnection connection) {
        return new JmsTemporaryQueue(connection);
    }
}

