/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.exolab.jms.client.JmsDestination;

public class JmsTopic
extends JmsDestination
implements Topic,
Externalizable,
Referenceable {
    static final long serialVersionUID = 1L;
    public static final String WILDCARD = "*";
    public static final String ALL_WILDCARD = "**";
    public static final String SEPARATOR = ".";
    static /* synthetic */ Class class$org$exolab$jms$client$JmsTopic;
    static /* synthetic */ Class class$org$exolab$jms$client$JmsDestinationFactory;

    public JmsTopic() {
    }

    public JmsTopic(String name) {
        super(name);
    }

    public String getTopicName() throws JMSException {
        return this.getName();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof JmsTopic && ((JmsTopic)object).getName().equals(this.getName())) {
            result = true;
        }
        return result;
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(1L);
        super.writeExternal(stream);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 1L) {
            throw new IOException("JmsTopic with version " + version + " is not supported.");
        }
        super.readExternal(stream);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isWildCard() {
        return JmsTopic.isWildCard(this.getName());
    }

    public static boolean isWildCard(String topic) {
        int pos = topic.indexOf(ALL_WILDCARD);
        if (pos >= 0 && pos != topic.length() - 2) {
            return false;
        }
        pos = topic.indexOf(WILDCARD);
        if (pos >= 0) {
            StringTokenizer tokens = new StringTokenizer(topic, SEPARATOR);
            String token = null;
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (token.indexOf(WILDCARD) < 0 || token.equals(WILDCARD) || token.equals(ALL_WILDCARD)) continue;
                return false;
            }
        }
        return pos >= 0;
    }

    public boolean match(JmsTopic destination) {
        boolean matches = false;
        String topic = destination.getName();
        String wildcard = this.getName();
        if (wildcard.equals(ALL_WILDCARD)) {
            matches = true;
        } else {
            StringTokenizer wildTokens = new StringTokenizer(wildcard, SEPARATOR);
            StringTokenizer topicTokens = new StringTokenizer(topic, SEPARATOR);
            String wildToken = null;
            String topicToken = null;
            int tokenCountDiff = topicTokens.countTokens() - wildTokens.countTokens();
            if (tokenCountDiff == 0 || tokenCountDiff == -1 || tokenCountDiff > 0 && wildcard.indexOf(ALL_WILDCARD) >= 0) {
                while (wildTokens.hasMoreTokens() && topicTokens.hasMoreTokens()) {
                    wildToken = wildTokens.nextToken();
                    topicToken = topicTokens.nextToken();
                    if (wildToken.equals(ALL_WILDCARD)) {
                        matches = true;
                        break;
                    }
                    if (wildToken.equals(WILDCARD)) {
                        matches = true;
                        continue;
                    }
                    if (wildToken.equals(topicToken)) {
                        matches = true;
                        continue;
                    }
                    matches = false;
                    break;
                }
            }
        }
        return matches;
    }

    public Reference getReference() {
        Reference reference = null;
        reference = new Reference((class$org$exolab$jms$client$JmsTopic == null ? (class$org$exolab$jms$client$JmsTopic = JmsTopic.class$("org.exolab.jms.client.JmsTopic")) : class$org$exolab$jms$client$JmsTopic).getName(), new StringRefAddr("name", this.getName()), (class$org$exolab$jms$client$JmsDestinationFactory == null ? (class$org$exolab$jms$client$JmsDestinationFactory = JmsTopic.class$("org.exolab.jms.client.JmsDestinationFactory")) : class$org$exolab$jms$client$JmsDestinationFactory).getName(), null);
        reference.add(new StringRefAddr("persistent", this.getPersistent() ? "true" : "false"));
        return reference;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

