/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.TemporaryQueue;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.exolab.jms.client.JmsSession;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.client.JmsTopicConnection;
import org.exolab.jms.client.JmsTopicPublisher;
import org.exolab.jms.client.JmsTopicSubscriber;

class JmsTopicSession
extends JmsSession
implements TopicSession {
    public JmsTopicSession(JmsTopicConnection connection, boolean transacted, int ackMode) throws JMSException {
        super(connection, transacted, ackMode);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, null, false);
    }

    public synchronized TopicSubscriber createSubscriber(Topic topic, String selector, boolean noLocal) throws JMSException {
        long consumerId = this.allocateConsumer((Destination)topic, selector, noLocal);
        JmsTopicSubscriber subscriber = new JmsTopicSubscriber(this, consumerId, topic, selector, noLocal);
        this.addConsumer(subscriber);
        return subscriber;
    }

    public synchronized TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.ensureOpen();
        if (topic != null && ((JmsTopic)topic).isWildCard()) {
            throw new JMSException("Cannot create a publisher using a wildcard topic");
        }
        JmsTopicPublisher publisher = new JmsTopicPublisher((JmsSession)this, (JmsTopic)topic);
        this.addProducer(publisher);
        return publisher;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw new IllegalStateException("Invalid operation for TopicSession");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new IllegalStateException("Invalid operation for TopicSession");
    }

    public Queue createQueue(String queueName) throws JMSException {
        throw new IllegalStateException("Invalid operation for TopicSession");
    }
}

