/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.HttpConfigurationType;
import org.exolab.jms.config.RmiConfiguration;
import org.exolab.jms.config.ServerConfiguration;
import org.exolab.jms.config.TcpConfigurationType;
import org.exolab.jms.config.types.SchemeType;

public class ConfigHelper {
    public static String getServerURL(SchemeType scheme, Configuration config) {
        String url = null;
        ServerConfiguration server = config.getServerConfiguration();
        if (scheme.equals(SchemeType.TCP)) {
            url = ConfigHelper.getServerURL(scheme, server.getHost(), config.getTcpConfiguration());
        } else if (scheme.equals(SchemeType.TCPS)) {
            url = ConfigHelper.getServerURL(scheme, server.getHost(), config.getTcpsConfiguration());
        } else if (scheme.equals(SchemeType.RMI)) {
            RmiConfiguration rmi = config.getRmiConfiguration();
            url = rmi.getEmbeddedRegistry() ? ConfigHelper.getServerURL(scheme, server.getHost(), rmi) : ConfigHelper.getServerURL(scheme, rmi.getRegistryHost(), rmi);
        } else if (scheme.equals(SchemeType.HTTP)) {
            url = ConfigHelper.getServerURL(scheme, config.getHttpConfiguration());
        } else if (scheme.equals(SchemeType.HTTPS)) {
            url = ConfigHelper.getServerURL(scheme, config.getHttpsConfiguration());
        } else if (scheme.equals(SchemeType.EMBEDDED)) {
            url = "vm:openjms";
        }
        return url;
    }

    public static String getJndiURL(SchemeType scheme, Configuration config) {
        String url = null;
        ServerConfiguration server = config.getServerConfiguration();
        if (scheme.equals(SchemeType.TCP)) {
            url = ConfigHelper.getJndiURL(scheme, server.getHost(), config.getTcpConfiguration());
        } else if (scheme.equals(SchemeType.TCPS)) {
            url = ConfigHelper.getJndiURL(scheme, server.getHost(), config.getTcpsConfiguration());
        } else if (scheme.equals(SchemeType.HTTP)) {
            url = ConfigHelper.getJndiURL(scheme, config.getHttpConfiguration());
        } else if (scheme.equals(SchemeType.HTTPS)) {
            url = ConfigHelper.getJndiURL(scheme, config.getHttpsConfiguration());
        } else if (scheme.equals(SchemeType.RMI)) {
            RmiConfiguration rmi = config.getRmiConfiguration();
            url = rmi.getEmbeddedRegistry() ? ConfigHelper.getJndiURL(scheme, server.getHost(), rmi) : ConfigHelper.getJndiURL(scheme, rmi.getRegistryHost(), rmi);
        } else if (scheme.equals(SchemeType.EMBEDDED)) {
            url = "vm:openjms";
        }
        return url;
    }

    public static String getAdminURL(SchemeType scheme, Configuration config) {
        String url = null;
        ServerConfiguration server = config.getServerConfiguration();
        if (scheme.equals(SchemeType.TCP)) {
            url = ConfigHelper.getAdminURL(scheme, server.getHost(), config.getTcpConfiguration());
        } else if (scheme.equals(SchemeType.TCPS)) {
            url = ConfigHelper.getAdminURL(scheme, server.getHost(), config.getTcpsConfiguration());
        } else if (scheme.equals(SchemeType.RMI)) {
            RmiConfiguration rmi = config.getRmiConfiguration();
            url = rmi.getEmbeddedRegistry() ? ConfigHelper.getAdminURL(scheme, server.getHost(), rmi) : ConfigHelper.getAdminURL(scheme, rmi.getRegistryHost(), rmi);
        } else if (scheme.equals(SchemeType.HTTP)) {
            url = ConfigHelper.getAdminURL(scheme, config.getHttpConfiguration());
        } else if (scheme.equals(SchemeType.HTTPS)) {
            url = ConfigHelper.getAdminURL(scheme, config.getHttpsConfiguration());
        } else if (scheme.equals(SchemeType.EMBEDDED)) {
            url = "vm:openjms";
        }
        return url;
    }

    private static String getServerURL(SchemeType scheme, String host, TcpConfigurationType config) {
        return ConfigHelper.getURL(scheme, host, config.getInternalHost(), config.getPort());
    }

    private static String getServerURL(SchemeType scheme, String host, RmiConfiguration config) {
        return ConfigHelper.getURL(scheme, host, config.getRegistryPort());
    }

    private static String getServerURL(SchemeType scheme, HttpConfigurationType config) {
        return ConfigHelper.getURL(scheme, config.getWebServerHost(), config.getWebServerPort(), config.getServlet());
    }

    private static String getJndiURL(SchemeType scheme, String host, TcpConfigurationType config) {
        int port = config.getJndiPort();
        if (port == 0) {
            port = config.getPort();
        }
        return ConfigHelper.getURL(scheme, host, config.getInternalHost(), port);
    }

    private static String getJndiURL(SchemeType scheme, String host, RmiConfiguration config) {
        return ConfigHelper.getURL(scheme, host, config.getRegistryPort());
    }

    private static String getJndiURL(SchemeType scheme, HttpConfigurationType config) {
        return ConfigHelper.getURL(scheme, config.getWebServerHost(), config.getWebServerPort(), config.getServlet());
    }

    private static String getAdminURL(SchemeType scheme, String host, TcpConfigurationType config) {
        int port = config.getAdminPort();
        if (port == 0) {
            port = config.getPort();
        }
        return ConfigHelper.getURL(scheme, host, config.getInternalHost(), port);
    }

    private static String getAdminURL(SchemeType scheme, String host, RmiConfiguration config) {
        return ConfigHelper.getURL(scheme, host, config.getRegistryPort());
    }

    private static String getAdminURL(SchemeType scheme, HttpConfigurationType config) {
        return ConfigHelper.getURL(scheme, config.getWebServerHost(), config.getWebServerPort(), config.getServlet());
    }

    private static String getURL(SchemeType scheme, String host, int port) {
        return ConfigHelper.getURL(scheme, host, port, "");
    }

    private static String getURL(SchemeType scheme, String host, int port, String path) {
        return ConfigHelper.getURL(scheme.toString(), host, port, path);
    }

    private static String getURL(String scheme, String host, int port, String path) {
        String result = scheme + "://" + ConfigHelper.getHost(host) + ":" + port;
        result = !path.startsWith("/") ? result + "/" + path : result + path;
        return result;
    }

    private static String getURL(SchemeType scheme, String host, String altHost, int port) {
        String url = ConfigHelper.getURL(scheme, host, port);
        if (altHost != null) {
            url = url + "?alt=" + altHost;
        }
        return url;
    }

    private static String getHost(String host) {
        if (host.equals("localhost")) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return host;
    }
}

