/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.exolab.castor.xml.EventProducer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.jms.config.AttributeExpander;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.DefaultConfiguration;
import org.exolab.jms.config.JndiConfigurationFactory;

public final class ConfigurationReader {
    private static final String DEFAULT_CONFIG = "openjms_defaults.xml";
    static /* synthetic */ Class class$org$exolab$jms$config$Configuration;
    static /* synthetic */ Class class$org$exolab$jms$config$DefaultConfiguration;

    private ConfigurationReader() {
    }

    public static Configuration read(String path) throws IOException, MarshalException, ValidationException {
        FileInputStream stream = new FileInputStream(path);
        return ConfigurationReader.read(stream);
    }

    public static Configuration read(InputStream stream) throws IOException, MarshalException, ValidationException {
        Configuration result = null;
        Unmarshaller unmarshaller = new Unmarshaller(class$org$exolab$jms$config$Configuration == null ? (class$org$exolab$jms$config$Configuration = ConfigurationReader.class$("org.exolab.jms.config.Configuration")) : class$org$exolab$jms$config$Configuration);
        InputStreamReader reader = new InputStreamReader(stream);
        AttributeExpander handler = new AttributeExpander(reader);
        result = (Configuration)unmarshaller.unmarshal((EventProducer)handler);
        return ConfigurationReader.setDefaults(result);
    }

    public static Configuration setDefaults(Configuration config) throws IOException, MarshalException, ValidationException {
        DefaultConfiguration defaults = ConfigurationReader.getDefaults();
        if (config.getServerConfiguration() == null) {
            config.setServerConfiguration(defaults.getServerConfiguration());
        }
        if (config.getConnectors() == null) {
            config.setConnectors(defaults.getConnectors());
        }
        if (config.getLoggerConfiguration() == null) {
            config.setLoggerConfiguration(defaults.getLoggerConfiguration());
        }
        if (config.getTcpConfiguration() == null) {
            config.setTcpConfiguration(defaults.getTcpConfiguration());
        }
        if (config.getTcpsConfiguration() == null) {
            config.setTcpsConfiguration(defaults.getTcpsConfiguration());
        }
        if (config.getRmiConfiguration() == null) {
            config.setRmiConfiguration(defaults.getRmiConfiguration());
        }
        if (config.getHttpConfiguration() == null) {
            config.setHttpConfiguration(defaults.getHttpConfiguration());
        }
        if (config.getHttpsConfiguration() == null) {
            config.setHttpsConfiguration(defaults.getHttpsConfiguration());
        }
        if (config.getMessageManagerConfiguration() == null) {
            config.setMessageManagerConfiguration(defaults.getMessageManagerConfiguration());
        }
        if (config.getSchedulerConfiguration() == null) {
            config.setSchedulerConfiguration(defaults.getSchedulerConfiguration());
        }
        if (config.getGarbageCollectionConfiguration() == null) {
            config.setGarbageCollectionConfiguration(defaults.getGarbageCollectionConfiguration());
        }
        if (config.getSecurityConfiguration() == null) {
            config.setSecurityConfiguration(defaults.getSecurityConfiguration());
        }
        if (config.getServerConfiguration().getEmbeddedJNDI()) {
            config.setJndiConfiguration(JndiConfigurationFactory.create(config));
        } else if (config.getJndiConfiguration() == null) {
            throw new ValidationException("JndiConfiguration must be provided when ServerConfiguration/embeddedJNDI is false");
        }
        return config;
    }

    private static DefaultConfiguration getDefaults() throws IOException, MarshalException, ValidationException {
        DefaultConfiguration result = null;
        InputStream source = (class$org$exolab$jms$config$Configuration == null ? (class$org$exolab$jms$config$Configuration = ConfigurationReader.class$("org.exolab.jms.config.Configuration")) : class$org$exolab$jms$config$Configuration).getResourceAsStream(DEFAULT_CONFIG);
        if (source == null) {
            throw new IOException("Failed to find default configuration: openjms_defaults.xml");
        }
        try {
            Unmarshaller stream = new Unmarshaller(class$org$exolab$jms$config$DefaultConfiguration == null ? (class$org$exolab$jms$config$DefaultConfiguration = ConfigurationReader.class$("org.exolab.jms.config.DefaultConfiguration")) : class$org$exolab$jms$config$DefaultConfiguration);
            AttributeExpander handler = new AttributeExpander(new InputStreamReader(source));
            result = (DefaultConfiguration)stream.unmarshal((EventProducer)handler);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                source.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            source.close();
        }
        catch (IOException ignore) {}
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

