/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.events;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.exolab.jms.common.threads.ThreadPoolFactory;
import org.exolab.jms.common.util.OrderedQueue;
import org.exolab.jms.events.Event;
import org.exolab.jms.events.EventManager;
import org.exolab.jms.events.IllegalEventDefinedException;
import org.exolab.jms.service.BasicService;

public class BasicEventManager
extends BasicService
implements EventManager {
    private static final int MAX_THREADS = 5;
    private final HashMap _events = new HashMap();
    private PooledExecutor _pool;
    private final Object _queueSync = new Object();
    private final OrderedQueue _queue = new OrderedQueue(_queueComparator);
    private long _seed;
    private static final Comparator _queueComparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            QueueEntry qe1 = (QueueEntry)obj1;
            QueueEntry qe2 = (QueueEntry)obj2;
            if (qe1.absolute < qe2.absolute) {
                return -1;
            }
            if (qe1.absolute > qe2.absolute) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object that) {
            return this == that;
        }
    };

    public BasicEventManager(ThreadPoolFactory factory) {
        super("BasicEventManager");
        this._pool = factory.create(this.getName(), 5);
    }

    public String registerEvent(Event event, long absolute) throws IllegalEventDefinedException {
        Object object = this._queueSync;
        synchronized (object) {
            QueueEntry entry = new QueueEntry(event, absolute, this.generateId());
            this._queue.add(entry);
            this._events.put(entry.id, entry);
            this._queueSync.notifyAll();
            String string = entry.id;
            return string;
        }
    }

    public String registerEventRelative(Event event, long relative) throws IllegalEventDefinedException {
        return this.registerEvent(event, System.currentTimeMillis() + relative);
    }

    public void unregisterEvent(String id) {
        Object object = this._queueSync;
        synchronized (object) {
            Object obj = this._events.remove(id);
            if (obj == null) {
                return;
            }
            this._queue.remove(obj);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object = this._queueSync;
        synchronized (object) {
            while (!Thread.interrupted()) {
                QueueEntry entry;
                long currentTime = System.currentTimeMillis();
                try {
                    entry = (QueueEntry)this._queue.firstElement();
                }
                catch (NoSuchElementException ex) {
                    try {
                        this._queueSync.wait();
                        continue;
                    }
                    catch (InterruptedException ex1) {
                        break;
                    }
                }
                if (entry.absolute <= currentTime) {
                    try {
                        this._pool.execute((Runnable)entry);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    this._queue.removeFirstElement();
                    this._events.remove(entry.id);
                    continue;
                }
                try {
                    this._queueSync.wait(entry.absolute - currentTime);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
            return;
        }
    }

    private synchronized String generateId() {
        return Long.toString(++this._seed);
    }

    class QueueEntry
    implements Runnable {
        private long absolute;
        private Event event;
        private String id;

        QueueEntry(Event event, long absolute, String id) {
            this.absolute = absolute;
            this.event = event;
            this.id = id;
        }

        public void run() {
            this.event.getEventListener().handleEvent(this.event.getEventType(), this.event.getCallbackObject(), System.currentTimeMillis());
        }
    }
}

