/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndi;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.codehaus.spice.jndikit.RemoteContext;
import org.exolab.jms.net.proxy.Proxy;

class ORBRemoteContext
implements Context {
    private static String REFERENCE_KEY = "NamingProviderReferenceCounter";
    private RemoteContext _context;

    public ORBRemoteContext(RemoteContext context) throws NamingException {
        this._context = context;
        this.reference();
    }

    public Object lookup(Name name) throws NamingException {
        return this.wrap(this._context.lookup(name));
    }

    public Object lookup(String name) throws NamingException {
        return this.wrap(this._context.lookup(name));
    }

    public void bind(Name name, Object obj) throws NamingException {
        this._context.bind(name, obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this._context.bind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this._context.rebind(name, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this._context.rebind(name, obj);
    }

    public void unbind(Name name) throws NamingException {
        this._context.unbind(name);
    }

    public void unbind(String name) throws NamingException {
        this._context.unbind(name);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this._context.rename(oldName, newName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this._context.rename(oldName, newName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this._context.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this._context.list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return new ORBNamingEnumeration(this._context.listBindings(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this._context.listBindings(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this._context.destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this._context.destroySubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return (Context)this.wrap(this._context.createSubcontext(name));
    }

    public Context createSubcontext(String name) throws NamingException {
        return (Context)this.wrap(this._context.createSubcontext(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.wrap(this._context.lookupLink(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.wrap(this._context.lookupLink(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this._context.getNameParser(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this._context.getNameParser(name);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return this._context.composeName(name, prefix);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this._context.composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this._context.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this._context.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this._context.getEnvironment();
    }

    public void close() throws NamingException {
        if (this._context != null) {
            Object provider;
            if (this.dereference() <= 0 && (provider = this.getEnvironment().get("org.codehaus.spice.jndikit.NamingProvider")) instanceof Proxy) {
                ((Proxy)provider).disposeProxy();
            }
            this._context.close();
            this._context = null;
        }
    }

    public String getNameInNamespace() throws NamingException {
        return this._context.getNameInNamespace();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private Object wrap(Object object) throws NamingException {
        if (object instanceof RemoteContext) {
            return new ORBRemoteContext((RemoteContext)object);
        }
        return object;
    }

    private void reference() throws NamingException {
        Ref ref = (Ref)this._context.getEnvironment().get(REFERENCE_KEY);
        if (ref == null) {
            ref = new Ref();
            this._context.addToEnvironment(REFERENCE_KEY, (Object)ref);
        }
        ref.inc();
    }

    private int dereference() throws NamingException {
        Ref ref = (Ref)this._context.getEnvironment().get(REFERENCE_KEY);
        return ref != null ? ref.dec() : 0;
    }

    private static class Ref {
        private int _count;

        private Ref() {
        }

        public synchronized int inc() {
            return ++this._count;
        }

        public synchronized int dec() {
            return --this._count;
        }
    }

    private static class ORBNamingEnumeration
    implements NamingEnumeration {
        private final NamingEnumeration _iterator;

        private ORBNamingEnumeration(NamingEnumeration iterator) {
            this._iterator = iterator;
        }

        public Object next() throws NamingException {
            return this.wrap(this._iterator.next());
        }

        public boolean hasMore() throws NamingException {
            return this._iterator.hasMore();
        }

        public void close() throws NamingException {
            this._iterator.close();
        }

        public boolean hasMoreElements() {
            return this._iterator.hasMoreElements();
        }

        public Object nextElement() {
            try {
                return this.wrap(this._iterator.nextElement());
            }
            catch (NamingException exception) {
                throw new NoSuchElementException(exception.getMessage());
            }
        }

        private Object wrap(Object obj) throws NamingException {
            Binding binding;
            Object bound;
            if (obj instanceof Binding && (bound = (binding = (Binding)obj).getObject()) instanceof RemoteContext) {
                binding.setObject(new ORBRemoteContext((RemoteContext)bound));
            }
            return obj;
        }
    }
}

